/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.db.service;

import com.google.common.collect.Lists;
import com.plusmpm.database.dbspecific.NativeDatabase;
import com.suncode.plugin.plusedoreczenia.db.dao.MessageDao;
import com.suncode.plugin.plusedoreczenia.db.entity.MessageEntity;
import com.suncode.plugin.plusedoreczenia.db.mapper.MessageEntityMapper;
import com.suncode.plugin.plusedoreczenia.db.service.MessageService;
import com.suncode.plugin.plusedoreczenia.dto.Message;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MessageServiceImpl
implements MessageService {
    public static final String DELIMITER = ",";
    @Autowired
    private MessageDao messageDao;

    @Override
    public List<MessageEntity> getAll() {
        return this.messageDao.getAll(new String[0]);
    }

    @Override
    public Optional<MessageEntity> findByMessageId(String messageId) {
        MessageEntity messageEntity = (MessageEntity)this.messageDao.getByField("messageId", messageId, new String[0]);
        return Optional.ofNullable(messageEntity);
    }

    @Override
    public void save(EdorConfig edorConfig, Message message) {
        MessageEntity messageEntity = MessageEntityMapper.toEntity(message, edorConfig);
        this.messageDao.save(messageEntity);
    }

    @Override
    public void save(MessageEntity messageEntity) {
        this.messageDao.save(messageEntity);
    }

    @Override
    public Set<String> findAlreadyProcessedMessages(List<String> messageIds) {
        if (messageIds.isEmpty()) {
            return Collections.emptySet();
        }
        int maxNumberOfInClauseParameters = NativeDatabase.getImplementation().getMaxNumberOfInClauseParameters();
        if (messageIds.size() > maxNumberOfInClauseParameters) {
            List partitions = Lists.partition(messageIds, (int)maxNumberOfInClauseParameters);
            return partitions.stream().map(partition -> {
                HibernateCriteria criteria = HibernateCriteria.forClass(MessageEntity.class);
                criteria.add(Restrictions.in((String)"messageId", (Collection)partition));
                return this.messageDao.findByCriteria(criteria);
            }).flatMap(Collection::stream).map(MessageEntity::getMessageId).collect(Collectors.toSet());
        }
        HibernateCriteria criteria = HibernateCriteria.forClass(MessageEntity.class);
        criteria.add(Restrictions.in((String)"messageId", messageIds));
        return this.messageDao.findByCriteria(criteria).stream().map(MessageEntity::getMessageId).collect(Collectors.toSet());
    }
}

