/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.controller;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.plusedoreczenia.controller.dto.AddressDetailsSearchRequestDto;
import com.suncode.plugin.plusedoreczenia.controller.dto.EDeliverySearchDto;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.CountryCodeEnum;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.ErrorCode;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.SearchEngineError;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.SearchResponse;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.service.ConfigurationService;
import com.suncode.plugin.plusedoreczenia.service.ApiClient;
import com.suncode.plugin.plusedoreczenia.service.EDeliveryService;
import com.suncode.pwfl.search.CountedResult;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/"})
public class EDeliverySearchController {
    private static final Logger log = LoggerFactory.getLogger(EDeliverySearchController.class);
    @Autowired
    private ApiClient apiClient;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private EDeliveryService eDeliveryService;

    @ResponseBody
    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    public void search(@RequestBody EDeliverySearchDto eDeliverySearchDto, HttpServletResponse response) throws IOException {
        try {
            EdorConfig edorConfig = this.configService.readConfigurationFromPCM(eDeliverySearchDto.getEdorConfigId());
            eDeliverySearchDto.getBaeSearch().setSenderEda(edorConfig.getEDeliveryAddress());
            String accessToken = this.apiClient.getAccessToken(edorConfig);
            SearchResponse searchResult = this.apiClient.search(edorConfig, accessToken, eDeliverySearchDto.getBaeSearch());
            this.setSearchResponse(response, 200, searchResult);
        }
        catch (Exception e) {
            this.exceptionHandler(response, e);
        }
    }

    private void setSearchResponse(HttpServletResponse response, int scInternalServerError, Object responseObject) throws IOException {
        response.setStatus(scInternalServerError);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        new ObjectMapper().writeValue((Writer)writer, responseObject);
        writer.flush();
    }

    @ResponseBody
    @RequestMapping(value={"/countryCodes"}, method={RequestMethod.GET})
    public CountedResult<ResponseData> getCountryCodes() {
        List countryList = CountryCodeEnum.stream().map(country -> new ResponseData(country.getValue(), country.getTranslation())).collect(Collectors.toList());
        return new CountedResult((long)countryList.size(), countryList);
    }

    @ResponseBody
    @RequestMapping(value={"/addressDetails"}, method={RequestMethod.POST})
    public void getAddressDetails(@RequestBody AddressDetailsSearchRequestDto addressDetailsSearchRequestDto, HttpServletResponse response) throws IOException {
        try {
            EdorConfig edorConfig = this.configService.readConfigurationFromPCM(addressDetailsSearchRequestDto.getEdorConfigId());
            SearchResponse searchResponse = this.eDeliveryService.getAddressDetails(edorConfig, addressDetailsSearchRequestDto.getAddress());
            this.setSearchResponse(response, 200, searchResponse);
        }
        catch (Exception e) {
            this.exceptionHandler(response, e);
        }
    }

    private void exceptionHandler(HttpServletResponse response, Exception e) throws IOException {
        SearchEngineError searchEngineError;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            log.debug(e.getMessage());
            searchEngineError = (SearchEngineError)objectMapper.readValue(e.getMessage(), SearchEngineError.class);
            this.setSearchResponse(response, 400, searchEngineError);
        }
        catch (Exception mappingException) {
            log.warn("Failed to map errorMessage to SearchEngineError.");
        }
        log.error(e.getMessage(), (Throwable)e);
        searchEngineError = new SearchEngineError();
        ErrorCode errorCode = new ErrorCode();
        errorCode.setMessage(e.getMessage());
        searchEngineError.getErrorCodes().add(errorCode);
        this.setSearchResponse(response, 500, searchEngineError);
    }

    class ResponseData {
        @JsonValue
        private String value;
        @JsonValue
        private String display;

        public String getValue() {
            return this.value;
        }

        public String getDisplay() {
            return this.display;
        }

        @ConstructorProperties(value={"value", "display"})
        public ResponseData(String value, String display) {
            this.value = value;
            this.display = display;
        }
    }
}

