/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia;

import com.suncode.plugin.plusedoreczenia.EdorKeys;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.AddressData;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.AddressTypeEnum;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.BaeSearchData;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.BaeSearchResponse;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.NipStatusEnum;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.OfficialId;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.RecipientEdas;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.SearchResponse;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.TypeWarningEnum;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;

public enum AddressDetailsKeysImpl implements EdorKeys<SearchResponse>
{
    ACTION_KEY_ADDRESS("ACTION_KEY_ADDRESS", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            RecipientEdas eda = AddressDetailsKeysImpl.getRecipientEda(response);
            return eda != null ? eda.getRecipientEda() : null;
        }
    }
    ,
    ACTION_KEY_IS_MAIN_EDA("ACTION_KEY_IS_MAIN_EDA", (Type)Types.BOOLEAN){

        public Boolean getValue(SearchResponse response) {
            RecipientEdas eda = AddressDetailsKeysImpl.getRecipientEda(response);
            return eda != null ? eda.getIsMainEda() : null;
        }
    }
    ,
    ACTION_KEY_ASSIGNMENT_DEGREE("ACTION_KEY_ASSIGNMENT_DEGREE", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            RecipientEdas eda = AddressDetailsKeysImpl.getRecipientEda(response);
            return eda != null ? eda.getAssignmentDegree().getValue() : null;
        }
    }
    ,
    ACTION_KEY_EDA_STATUS("ACTION_KEY_EDA_STATUS", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            RecipientEdas eda = AddressDetailsKeysImpl.getRecipientEda(response);
            return eda != null ? eda.getEdaStatus().getValue() : null;
        }
    }
    ,
    ACTION_KEY_TYPE_WARNING("ACTION_KEY_TYPE_WARNING", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            RecipientEdas eda = AddressDetailsKeysImpl.getRecipientEda(response);
            TypeWarningEnum typeWarning = eda != null ? eda.getTypeWarning() : null;
            return typeWarning != null ? typeWarning.getValue() : null;
        }
    }
    ,
    ACTION_KEY_WARNING("ACTION_KEY_WARNING", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            RecipientEdas eda = AddressDetailsKeysImpl.getRecipientEda(response);
            return eda != null ? eda.getWarning() : null;
        }
    }
    ,
    ACTION_KEY_NIP("ACTION_KEY_NIP", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            BaeSearchData data = AddressDetailsKeysImpl.getBaeSearchData(response);
            return data != null ? AddressDetailsKeysImpl.getIdByRegistry(data.getOfficialIds(), "NIP") : null;
        }
    }
    ,
    ACTION_KEY_REGON("ACTION_KEY_REGON", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            BaeSearchData data = AddressDetailsKeysImpl.getBaeSearchData(response);
            return data != null ? AddressDetailsKeysImpl.getIdByRegistry(data.getOfficialIds(), "REGON") : null;
        }
    }
    ,
    ACTION_KEY_KRS("ACTION_KEY_KRS", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            BaeSearchData data = AddressDetailsKeysImpl.getBaeSearchData(response);
            return data != null ? AddressDetailsKeysImpl.getIdByRegistry(data.getOfficialIds(), "KRS") : null;
        }
    }
    ,
    ACTION_KEY_PESEL("ACTION_KEY_PESEL", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            BaeSearchData data = AddressDetailsKeysImpl.getBaeSearchData(response);
            return data != null ? AddressDetailsKeysImpl.getIdByRegistry(data.getOfficialIds(), "PESEL") : null;
        }
    }
    ,
    ACTION_KEY_UE("ACTION_KEY_UE", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            BaeSearchData data = AddressDetailsKeysImpl.getBaeSearchData(response);
            return data != null ? AddressDetailsKeysImpl.getIdByRegistry(data.getOfficialIds(), "UE") : null;
        }
    }
    ,
    ACTION_KEY_KPP_ID("ACTION_KEY_KPP_ID", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            BaeSearchData data = AddressDetailsKeysImpl.getBaeSearchData(response);
            return data != null ? AddressDetailsKeysImpl.getIdByRegistry(data.getOfficialIds(), "KPPID") : null;
        }
    }
    ,
    ACTION_KEY_NAME("ACTION_KEY_NAME", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            BaeSearchData data = AddressDetailsKeysImpl.getBaeSearchData(response);
            return data != null ? data.getName() : null;
        }
    }
    ,
    ACTION_KEY_SURNAME("ACTION_KEY_SURNAME", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            BaeSearchData data = AddressDetailsKeysImpl.getBaeSearchData(response);
            return data != null ? data.getSurname() : null;
        }
    }
    ,
    ACTION_KEY_PROFESSIONAL_TITLE("ACTION_KEY_PROFESSIONAL_TITLE", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            BaeSearchData data = AddressDetailsKeysImpl.getBaeSearchData(response);
            return data != null ? data.getProfessionalTitle() : null;
        }
    }
    ,
    ACTION_KEY_LEGAL_FORM("ACTION_KEY_LEGAL_FORM", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            BaeSearchData data = AddressDetailsKeysImpl.getBaeSearchData(response);
            return data != null ? data.getLegalForm() : null;
        }
    }
    ,
    ACTION_KEY_IS_PUBLIC("ACTION_KEY_IS_PUBLIC", (Type)Types.BOOLEAN){

        public Boolean getValue(SearchResponse response) {
            BaeSearchData data = AddressDetailsKeysImpl.getBaeSearchData(response);
            return data != null ? data.getIsPublic() : null;
        }
    }
    ,
    ACTION_KEY_ENTITY_NAME("ACTION_KEY_ENTITY_NAME", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            BaeSearchData data = AddressDetailsKeysImpl.getBaeSearchData(response);
            if (data != null) {
                if (data.getEntityName() != null) {
                    return data.getEntityName();
                }
                if (data.getProfessionalTitle() != null) {
                    return data.getProfessionalTitle();
                }
            }
            return null;
        }
    }
    ,
    ACTION_KEY_DESIGNATED_OPERATOR("ACTION_KEY_DESIGNATED_OPERATOR", (Type)Types.BOOLEAN){

        public Boolean getValue(SearchResponse response) {
            BaeSearchData data = AddressDetailsKeysImpl.getBaeSearchData(response);
            return data != null ? data.getDesignatedOperator() : null;
        }
    }
    ,
    ACTION_KEY_NIP_STATUS("ACTION_KEY_NIP_STATUS", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            BaeSearchData data = AddressDetailsKeysImpl.getBaeSearchData(response);
            NipStatusEnum status = data != null ? data.getNipStatus() : null;
            return status != null ? status.getValue() : null;
        }
    }
    ,
    ACTION_KEY_CORRESPONDENCE_COUNTRY_CODE("ACTION_KEY_CORRESPONDENCE_COUNTRY_CODE", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.CORRESPONDENCE);
            return address != null ? address.getCountryCode().getValue() : null;
        }
    }
    ,
    ACTION_KEY_CORRESPONDENCE_STREET("ACTION_KEY_CORRESPONDENCE_STREET", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.CORRESPONDENCE);
            return address != null ? address.getStreet() : null;
        }
    }
    ,
    ACTION_KEY_CORRESPONDENCE_TYPE_OF_STREET("ACTION_KEY_CORRESPONDENCE_TYPE_OF_STREET", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.CORRESPONDENCE);
            return address != null && address.getTypeOfStreet() != null ? address.getTypeOfStreet().getValue() : null;
        }
    }
    ,
    ACTION_KEY_CORRESPONDENCE_POSTAL_CODE("ACTION_KEY_CORRESPONDENCE_POSTAL_CODE", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.CORRESPONDENCE);
            return address != null ? address.getPostalCode() : null;
        }
    }
    ,
    ACTION_KEY_CORRESPONDENCE_CITY("ACTION_KEY_CORRESPONDENCE_CITY", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.CORRESPONDENCE);
            return address != null ? address.getCity() : null;
        }
    }
    ,
    ACTION_KEY_CORRESPONDENCE_BUILDING_NUMBER("ACTION_KEY_CORRESPONDENCE_BUILDING_NUMBER", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.CORRESPONDENCE);
            return address != null ? address.getBuildingNumber() : null;
        }
    }
    ,
    ACTION_KEY_CORRESPONDENCE_FLAT_NUMBER("ACTION_KEY_CORRESPONDENCE_FLAT_NUMBER", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.CORRESPONDENCE);
            return address != null ? address.getFlatNumber() : null;
        }
    }
    ,
    ACTION_KEY_CORRESPONDENCE_POSTAL_OFFICE("ACTION_KEY_CORRESPONDENCE_POSTAL_OFFICE", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.CORRESPONDENCE);
            return address != null ? address.getPostalOffice() : null;
        }
    }
    ,
    ACTION_KEY_CORRESPONDENCE_POST_OFFICE_BOX("ACTION_KEY_CORRESPONDENCE_POST_OFFICE_BOX", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.CORRESPONDENCE);
            return address != null ? address.getPostOfficeBox() : null;
        }
    }
    ,
    ACTION_KEY_CORRESPONDENCE_VOIVODESHIP("ACTION_KEY_CORRESPONDENCE_VOIVODESHIP", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.CORRESPONDENCE);
            return address != null ? address.getVoivodeship() : null;
        }
    }
    ,
    ACTION_KEY_CORRESPONDENCE_DISTRICT("ACTION_KEY_CORRESPONDENCE_DISTRICT", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.CORRESPONDENCE);
            return address != null ? address.getDistrict() : null;
        }
    }
    ,
    ACTION_KEY_CORRESPONDENCE_COMMUNITY("ACTION_KEY_CORRESPONDENCE_COMMUNITY", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.CORRESPONDENCE);
            return address != null ? address.getCommunity() : null;
        }
    }
    ,
    ACTION_KEY_HEADQUARTERS_COUNTRY_CODE("ACTION_KEY_HEADQUARTERS_COUNTRY_CODE", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.HEADQUARTERS);
            return address != null ? address.getCountryCode().getValue() : null;
        }
    }
    ,
    ACTION_KEY_HEADQUARTERS_STREET("ACTION_KEY_HEADQUARTERS_STREET", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.HEADQUARTERS);
            return address != null ? address.getStreet() : null;
        }
    }
    ,
    ACTION_KEY_HEADQUARTERS_TYPE_OF_STREET("ACTION_KEY_HEADQUARTERS_TYPE_OF_STREET", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.HEADQUARTERS);
            return address != null && address.getTypeOfStreet() != null ? address.getTypeOfStreet().getValue() : null;
        }
    }
    ,
    ACTION_KEY_HEADQUARTERS_POSTAL_CODE("ACTION_KEY_HEADQUARTERS_POSTAL_CODE", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.HEADQUARTERS);
            return address != null ? address.getPostalCode() : null;
        }
    }
    ,
    ACTION_KEY_HEADQUARTERS_CITY("ACTION_KEY_HEADQUARTERS_CITY", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.HEADQUARTERS);
            return address != null ? address.getCity() : null;
        }
    }
    ,
    ACTION_KEY_HEADQUARTERS_BUILDING_NUMBER("ACTION_KEY_HEADQUARTERS_BUILDING_NUMBER", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.HEADQUARTERS);
            return address != null ? address.getBuildingNumber() : null;
        }
    }
    ,
    ACTION_KEY_HEADQUARTERS_FLAT_NUMBER("ACTION_KEY_HEADQUARTERS_FLAT_NUMBER", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.HEADQUARTERS);
            return address != null ? address.getFlatNumber() : null;
        }
    }
    ,
    ACTION_KEY_HEADQUARTERS_POSTAL_OFFICE("ACTION_KEY_HEADQUARTERS_POSTAL_OFFICE", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.HEADQUARTERS);
            return address != null ? address.getPostalOffice() : null;
        }
    }
    ,
    ACTION_KEY_HEADQUARTERS_POST_OFFICE_BOX("ACTION_KEY_HEADQUARTERS_POST_OFFICE_BOX", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.HEADQUARTERS);
            return address != null ? address.getPostOfficeBox() : null;
        }
    }
    ,
    ACTION_KEY_HEADQUARTERS_VOIVODESHIP("ACTION_KEY_HEADQUARTERS_VOIVODESHIP", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.HEADQUARTERS);
            return address != null ? address.getVoivodeship() : null;
        }
    }
    ,
    ACTION_KEY_HEADQUARTERS_DISTRICT("ACTION_KEY_HEADQUARTERS_DISTRICT", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.HEADQUARTERS);
            return address != null ? address.getDistrict() : null;
        }
    }
    ,
    ACTION_KEY_HEADQUARTERS_COMMUNITY("ACTION_KEY_HEADQUARTERS_COMMUNITY", (Type)Types.STRING){

        public String getValue(SearchResponse response) {
            AddressData address = AddressDetailsKeysImpl.getAddressByType(response, AddressTypeEnum.HEADQUARTERS);
            return address != null ? address.getCommunity() : null;
        }
    };

    private final String key;
    private final Type<?> type;
    private final Translator t = Translators.get((String)"com.suncode.plugin-plus-edoreczenia");

    private AddressDetailsKeysImpl(String key, Type<?> type) {
        this.key = key;
        this.type = type;
    }

    public static Stream<AddressDetailsKeysImpl> stream() {
        return Stream.of(AddressDetailsKeysImpl.values());
    }

    public static AddressDetailsKeysImpl getByKey(String key) {
        Optional<AddressDetailsKeysImpl> first = AddressDetailsKeysImpl.stream().filter(edorKeys -> edorKeys.getKey().equals(key)).findFirst();
        return first.orElse(null);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Type<?> getType() {
        return this.type;
    }

    public String toString() {
        return this.key;
    }

    @Override
    public String getDescription() {
        return this.t.getMessage("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.context.desc." + this.key);
    }

    private static RecipientEdas getRecipientEda(SearchResponse response) {
        BaeSearchResponse baeSearchResponse;
        List<RecipientEdas> recipientEdas;
        List<BaeSearchResponse> baeSearchResponses = response.getBaeSearchResponses();
        if (CollectionUtils.isNotEmpty(baeSearchResponses) && CollectionUtils.isNotEmpty(recipientEdas = (baeSearchResponse = baeSearchResponses.get(0)).getRecipientEdas())) {
            return recipientEdas.get(0);
        }
        return null;
    }

    private static BaeSearchData getBaeSearchData(SearchResponse response) {
        BaeSearchResponse baeSearchResponse;
        List<BaeSearchData> baeSearchData;
        List<BaeSearchResponse> baeSearchResponses = response.getBaeSearchResponses();
        if (CollectionUtils.isNotEmpty(baeSearchResponses) && CollectionUtils.isNotEmpty(baeSearchData = (baeSearchResponse = baeSearchResponses.get(0)).getBaeSearchData())) {
            return baeSearchData.get(0);
        }
        return null;
    }

    private static String getIdByRegistry(List<OfficialId> ids, String registry) {
        if (CollectionUtils.isNotEmpty(ids)) {
            return ids.stream().filter(id -> registry.equalsIgnoreCase(id.getReferenceRegistry().getValue())).map(OfficialId::getId).findFirst().orElse(null);
        }
        return null;
    }

    private static AddressData getAddressByType(SearchResponse response, AddressTypeEnum addressTypeEnum) {
        List<AddressData> addresses;
        BaeSearchData baeSearchData = AddressDetailsKeysImpl.getBaeSearchData(response);
        if (baeSearchData != null && (addresses = baeSearchData.getAddress()) != null) {
            return addresses.stream().filter(a -> a.getAddressType().stream().anyMatch(t -> t.equals((Object)addressTypeEnum))).findFirst().orElse(null);
        }
        return null;
    }
}

