/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.utils;

import com.suncode.plugin.plusedoreczenia.controller.EdorSystemType;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.lang.NestedCollection;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Date;
import java.util.UUID;

public class TokenUtils {
    private static final int TIME_OFFSET_IN_SECONDS = 30;
    private static final int EXPIRATION_TIME_IN_SECONDS = 1800;

    public static String generateSignedToken(String eDeliveryAddress, String systemName, String privateKey, EdorSystemType systemType) throws NoSuchAlgorithmException, InvalidKeySpecException {
        long currentTimeMillis = System.currentTimeMillis() - 30000L;
        Date currentDate = new Date(currentTimeMillis);
        String issuer = eDeliveryAddress + ".SYSTEM." + systemName.toUpperCase();
        JwtBuilder builder = ((JwtBuilder)((NestedCollection)Jwts.builder().issuedAt(currentDate).notBefore(currentDate).subject(issuer).issuer(issuer).id(UUID.randomUUID().toString()).audience().add((Object)systemType.getAudUrl())).and()).expiration(new Date(currentTimeMillis + 1800000L)).signWith((Key)TokenUtils.parsePrivateKey(privateKey), (SecureDigestAlgorithm)Jwts.SIG.RS256);
        return builder.compact();
    }

    private static PrivateKey parsePrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String pkcs8Pem = privateKey;
        pkcs8Pem = pkcs8Pem.replace("-----BEGIN PRIVATE KEY-----", "");
        pkcs8Pem = pkcs8Pem.replace("-----END PRIVATE KEY-----", "");
        pkcs8Pem = pkcs8Pem.replaceAll("\\s+", "");
        byte[] pkcs8EncodedBytes = Base64.getDecoder().decode(pkcs8Pem);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pkcs8EncodedBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    private TokenUtils() {
    }
}

