/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.utils;

import com.suncode.plugin.plusedoreczenia.dto.Evidence;
import com.suncode.plugin.plusedoreczenia.dto.EvidenceTypeEnum;
import com.suncode.plugin.plusedoreczenia.dto.Label;
import com.suncode.plugin.plusedoreczenia.dto.Message;
import com.suncode.plugin.plusedoreczenia.dto.MessageAddressData;
import com.suncode.plugin.plusedoreczenia.dto.MessageControlData;
import com.suncode.plugin.plusedoreczenia.dto.MessageMetadata;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MessageParserUtils {
    private static final String DELIMITER = ",";

    public static OffsetDateTime getReceiptDate(Message message) {
        OffsetDateTime receiptDateFromMetadata = MessageParserUtils.getIfPresent(message, m -> MessageParserUtils.getIfPresent(m.getMessageMetadata(), MessageMetadata::getReceiptDate));
        if (receiptDateFromMetadata != null) {
            return receiptDateFromMetadata;
        }
        return Optional.ofNullable(MessageParserUtils.getIfPresent(message, Message::getEvidences)).flatMap(evidences -> evidences.stream().filter(e -> EvidenceTypeEnum.E_1.equals((Object)e.getType())).map(Evidence::getEventDate).findFirst()).orElse(null);
    }

    public static String getRecipientsEDeliveryAddresses(MessageMetadata metadata) {
        return Optional.ofNullable(metadata).map(MessageMetadata::getTo).filter(to -> !to.isEmpty()).map(to -> to.stream().map(MessageAddressData::getEDeliveryAddress).collect(Collectors.joining(DELIMITER))).orElse(null);
    }

    public static String getLabels(Message message) {
        return Optional.ofNullable(message.getMessageControlData()).map(MessageControlData::getLabels).filter(labelList -> !labelList.isEmpty()).map(labelList -> labelList.stream().map(Label::getLabel).collect(Collectors.joining(DELIMITER))).orElse(null);
    }

    public static <T, R> R getIfPresent(T obj, Function<T, R> getter) {
        return obj != null ? (R)getter.apply(obj) : null;
    }

    public static Timestamp toSqlTimestamp(OffsetDateTime dateTime) {
        return Optional.ofNullable(dateTime).map(OffsetDateTime::toInstant).map(Timestamp::from).orElse(null);
    }

    private MessageParserUtils() {
    }
}

