/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.service;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.suncode.plugin.plusedoreczenia.controller.EdorSystemType;
import com.suncode.plugin.plusedoreczenia.dto.Evidence;
import com.suncode.plugin.plusedoreczenia.dto.EvidenceTypeEnum;
import com.suncode.plugin.plusedoreczenia.dto.EvidenceWrapper;
import com.suncode.plugin.plusedoreczenia.dto.FileData;
import com.suncode.plugin.plusedoreczenia.dto.FileWrapper;
import com.suncode.plugin.plusedoreczenia.dto.MassageOperationResponseSingleWrapper;
import com.suncode.plugin.plusedoreczenia.dto.MassageOperationResponseSingleWrapperPut;
import com.suncode.plugin.plusedoreczenia.dto.MassageOperationResponseWrapperStatus;
import com.suncode.plugin.plusedoreczenia.dto.Message;
import com.suncode.plugin.plusedoreczenia.dto.MessageInfo;
import com.suncode.plugin.plusedoreczenia.dto.MessageTaskStatus;
import com.suncode.plugin.plusedoreczenia.dto.MessagesWrapper;
import com.suncode.plugin.plusedoreczenia.dto.SendDraft;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.BaeSearch;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.EdaConfirmation;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.SearchResponse;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczenia.service.ApiResponseException;
import com.suncode.plugin.plusedoreczenia.service.dto.TokenDto;
import com.suncode.plugin.plusedoreczenia.utils.TokenUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ApiClient {
    private static final Logger log = LoggerFactory.getLogger(ApiClient.class);
    private static final long MAX_ATTACHMENT_SIZE = 524288000L;
    private final ObjectMapper objectMapper;
    private final OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();

    public ApiClient() {
        JsonFactory jsonFactory = new JsonFactory();
        int maxBase64StringLength = (int)Math.ceil(6.990506666666666E8);
        jsonFactory.setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(maxBase64StringLength).build());
        this.objectMapper = new ObjectMapper(jsonFactory).registerModule((Module)new JavaTimeModule()).setDefaultSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SKIP)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public MessagesWrapper getMessages(EdorConfig edorConfig, String accessToken, Integer offset, Integer limit, String label) throws ApiResponseException, IOException {
        return this.getMessages(edorConfig, accessToken, offset, limit, null, null, null, null, null, null, null, null, null, null, null, label, null, null, null, null);
    }

    public MessagesWrapper getMessages(EdorConfig edorConfig, String accessToken, Integer offset, Integer limit, String label, String format, Boolean opened) throws ApiResponseException, IOException {
        return this.getMessages(edorConfig, accessToken, offset, limit, format, null, null, null, null, null, null, null, null, null, null, label, null, null, null, opened);
    }

    public MessagesWrapper getMessages(EdorConfig edorConfig, String accessToken, Integer offset, Integer limit, String format, String sender, String recipient, String subject, OffsetDateTime submissionDateFrom, OffsetDateTime submissionDateTo, OffsetDateTime eventDateFrom, OffsetDateTime eventDateTo, OffsetDateTime receiptDateFrom, OffsetDateTime receiptDateTo, Boolean attachments, String label, String shippingService, String sortColumn, String sortDirection, Boolean opened) throws ApiResponseException, IOException {
        String path = "/{eDeliveryAddress}/messages".replace("{eDeliveryAddress}", edorConfig.getEDeliveryAddress());
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getUserAgentApiUrl() + path))).newBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("format", format);
        params.put("sender", sender);
        params.put("recipient", recipient);
        params.put("subject", subject);
        params.put("submissionDateFrom", this.formatDateToIso(submissionDateFrom));
        params.put("submissionDateTo", this.formatDateToIso(submissionDateTo));
        params.put("eventDateFrom", this.formatDateToIso(eventDateFrom));
        params.put("eventDateTo", this.formatDateToIso(eventDateTo));
        params.put("receiptDateFrom", this.formatDateToIso(receiptDateFrom));
        params.put("receiptDateTo", this.formatDateToIso(receiptDateTo));
        params.put("attachments", attachments);
        params.put("label", label);
        params.put("shippingService", shippingService);
        params.put("sortColumn", sortColumn);
        params.put("sortDirection", sortDirection);
        params.put("opened", opened);
        params.forEach((key, value) -> this.addQueryParameter(urlBuilder, (String)key, value));
        String url = urlBuilder.build().toString();
        Request request = this.createGetRequest(url, accessToken);
        return this.send(edorConfig, request, new TypeReference<MessagesWrapper>(){});
    }

    public List<Message> getMessage(EdorConfig edorConfig, String accessToken, String messageId, String format) throws ApiResponseException, IOException {
        String path = "/{eDeliveryAddress}/messages/{messageId}".replace("{eDeliveryAddress}", edorConfig.getEDeliveryAddress()).replace("{messageId}", messageId);
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getUserAgentApiUrl() + path))).newBuilder();
        this.addQueryParameter(urlBuilder, "format", format);
        String url = urlBuilder.build().toString();
        Request request = this.createGetRequest(url, accessToken);
        return this.send(edorConfig, request, new TypeReference<List<Message>>(){});
    }

    public EvidenceWrapper getEvidences(EdorConfig edorConfig, String accessToken, String messageId) throws ApiResponseException, IOException {
        return this.getEvidences(edorConfig, accessToken, messageId, null, null, null, null);
    }

    public EvidenceWrapper getEvidences(EdorConfig edorConfig, String accessToken, String messageId, EvidenceTypeEnum type, Boolean downloaded, String sortColumn, String sortDirection) throws ApiResponseException, IOException {
        String path = "/{eDeliveryAddress}/messages/{messageId}/evidences".replace("{eDeliveryAddress}", edorConfig.getEDeliveryAddress()).replace("{messageId}", messageId);
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getUserAgentApiUrl() + path))).newBuilder();
        this.addQueryParameter(urlBuilder, "type", (Object)type);
        this.addQueryParameter(urlBuilder, "downloaded", downloaded);
        this.addQueryParameter(urlBuilder, "sortColumn", sortColumn);
        this.addQueryParameter(urlBuilder, "sortDirection", sortDirection);
        String url = urlBuilder.build().toString();
        Request request = this.createGetRequest(url, accessToken);
        return this.send(edorConfig, request, new TypeReference<EvidenceWrapper>(){});
    }

    public MessageInfo sendMessage(EdorConfig edorConfig, String accessToken, Message message) throws ApiResponseException, IOException {
        String path = "/{eDeliveryAddress}/messages".replace("{eDeliveryAddress}", edorConfig.getEDeliveryAddress());
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getUserAgentApiUrl() + path))).newBuilder();
        String url = urlBuilder.build().toString();
        String messageJson = this.objectMapper.writeValueAsString((Object)message);
        RequestBody body = RequestBody.create((String)messageJson, (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = this.createPostRequest(url, body, accessToken);
        return this.send(edorConfig, request, new TypeReference<MessageInfo>(){});
    }

    public MassageOperationResponseSingleWrapperPut createMessageDraft(EdorConfig edorConfig, String accessToken, Message message) throws ApiResponseException, IOException {
        String path = "/{eDeliveryAddress}/drafts".replace("{eDeliveryAddress}", edorConfig.getEDeliveryAddress());
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getUserAgentApiUrl() + path))).newBuilder();
        String url = urlBuilder.build().toString();
        String messageJson = this.objectMapper.writeValueAsString((Object)message);
        RequestBody body = RequestBody.create((String)messageJson, (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = this.createPostRequest(url, body, accessToken);
        return this.send(edorConfig, request, new TypeReference<MassageOperationResponseSingleWrapperPut>(){});
    }

    public void deleteMessageDraft(EdorConfig edorConfig, String accessToken, String messageId) throws ApiResponseException, IOException {
        String path = "/{eDeliveryAddress}/drafts/{messageId}".replace("{eDeliveryAddress}", edorConfig.getEDeliveryAddress()).replace("{messageId}", messageId);
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getUserAgentApiUrl() + path))).newBuilder();
        String url = urlBuilder.build().toString();
        Request request = new Request.Builder().delete().url(url).addHeader("Authorization", "Bearer " + accessToken).build();
        this.send(edorConfig, request, new TypeReference<List<MassageOperationResponseSingleWrapper>>(){});
    }

    public void createAttachment(EdorConfig edorConfig, String accessToken, String messageId, FileData fileData) throws ApiResponseException, IOException {
        String path = "/{eDeliveryAddress}/drafts/{messageId}/attachments".replace("{eDeliveryAddress}", edorConfig.getEDeliveryAddress()).replace("{messageId}", messageId);
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getUserAgentApiUrl() + path))).newBuilder();
        String url = urlBuilder.build().toString();
        String fileMetadataJson = this.objectMapper.writeValueAsString((Object)fileData);
        RequestBody body = RequestBody.create((String)fileMetadataJson, (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = this.createPostRequest(url, body, accessToken);
        this.send(edorConfig, request, new TypeReference<FileWrapper>(){});
    }

    public MessageInfo sendDraft(EdorConfig edorConfig, String accessToken, SendDraft sendDraft) throws ApiResponseException, IOException {
        String path = "/{eDeliveryAddress}/drafts/send".replace("{eDeliveryAddress}", edorConfig.getEDeliveryAddress());
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getUserAgentApiUrl() + path))).newBuilder();
        String url = urlBuilder.build().toString();
        String sendDraftJson = this.objectMapper.writeValueAsString((Object)sendDraft);
        RequestBody body = RequestBody.create((String)sendDraftJson, (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = this.createPostRequest(url, body, accessToken);
        return this.send(edorConfig, request, new TypeReference<MessageInfo>(){});
    }

    public List<MassageOperationResponseWrapperStatus> checkMessageTaskDetails(EdorConfig edorConfig, String accessToken, String messageTaskId) throws ApiResponseException, IOException {
        String path = "/{eDeliveryAddress}/messages/tasks/{messageTaskId}".replace("{eDeliveryAddress}", edorConfig.getEDeliveryAddress()).replace("{messageTaskId}", messageTaskId);
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getUserAgentApiUrl() + path))).newBuilder();
        String url = urlBuilder.build().toString();
        Request request = this.createGetRequest(url, accessToken);
        return this.send(edorConfig, request, new TypeReference<List<MassageOperationResponseWrapperStatus>>(){});
    }

    public MessageTaskStatus checkMessageTaskStatus(EdorConfig edorConfig, String accessToken, String messageTaskId) throws ApiResponseException, IOException {
        String path = "/{eDeliveryAddress}/messages/tasks/{messageTaskId}/status".replace("{eDeliveryAddress}", edorConfig.getEDeliveryAddress()).replace("{messageTaskId}", messageTaskId);
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getUserAgentApiUrl() + path))).newBuilder();
        String url = urlBuilder.build().toString();
        Request request = this.createGetRequest(url, accessToken);
        return this.send(edorConfig, request, new TypeReference<MessageTaskStatus>(){});
    }

    public SearchResponse search(EdorConfig edorConfig, String accessToken, BaeSearch baeSearch) throws ApiResponseException, IOException {
        String path = "search/bae_search";
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getSearchEngineApiUrl() + path))).newBuilder();
        String url = urlBuilder.build().toString();
        String messageJson = this.objectMapper.writeValueAsString((Object)baeSearch);
        RequestBody body = RequestBody.create((String)messageJson, (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = this.createPostRequest(url, body, accessToken);
        return this.send(edorConfig, request, new TypeReference<SearchResponse>(){});
    }

    public SearchResponse edaConfirmation(EdorConfig edorConfig, String accessToken, EdaConfirmation edaConfirmation) throws ApiResponseException, IOException {
        String path = "search/eda-confirmation";
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getSearchEngineApiUrl() + path))).newBuilder();
        String url = urlBuilder.build().toString();
        String messageJson = this.objectMapper.writeValueAsString((Object)edaConfirmation);
        RequestBody body = RequestBody.create((String)messageJson, (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = this.createPostRequest(url, body, accessToken);
        return this.send(edorConfig, request, new TypeReference<SearchResponse>(){});
    }

    public byte[] getEvidenceFile(EdorConfig edorConfig, String accessToken, Evidence evidence) throws ApiResponseException, IOException {
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getUserAgentApiUrl() + evidence.getExternalData()))).newBuilder();
        String url = urlBuilder.build().toString();
        Request request = this.createGetRequest(url, accessToken);
        return this.send(edorConfig, request, new TypeReference<byte[]>(){});
    }

    public String getAccessToken(EdorConfig edorConfig) throws ApiResponseException, NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        String eDeliveryAddress = edorConfig.getEDeliveryAddress();
        String systemName = edorConfig.getSystemName();
        String signedToken = TokenUtils.generateSignedToken(eDeliveryAddress, systemName, edorConfig.getPrivateKey(), edorConfig.getSystemType());
        FormBody body = new FormBody.Builder().add("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer").add("grant_type", "client_credentials").add("client_assertion", signedToken).build();
        Request request = new Request.Builder().url(edorConfig.getSystemType().getAuthUrl() + eDeliveryAddress).method("POST", (RequestBody)body).addHeader("Connection", "close").addHeader("Content-Type", "application/x-www-form-urlencoded").build();
        return this.send(edorConfig, request, new TypeReference<TokenDto>(){}).getToken();
    }

    private <T> T send(EdorConfig edorConfig, Request request, TypeReference<T> clazz) throws IOException, ApiResponseException {
        if (edorConfig.getSystemType().equals((Object)EdorSystemType.TEST) && StringUtils.isNotEmpty((CharSequence)edorConfig.getTestEnvironmentProxyUrl())) {
            try {
                String originalUrl = request.url().toString();
                if (originalUrl.contains("int-ow.edoreczenia.gov.pl")) {
                    String originalHost = new URI(originalUrl).getHost();
                    String proxyHost = new URI(edorConfig.getTestEnvironmentProxyUrl()).getHost();
                    String modifiedUrl = originalUrl.replace(originalHost, proxyHost);
                    request = request.newBuilder().url(modifiedUrl).build();
                }
            }
            catch (URISyntaxException e) {
                log.error(MessageFormat.format("Could not parse URL. Original: {0}, Proxy: {1}, Error: {2}", request.url(), edorConfig.getTestEnvironmentProxyUrl(), e.getMessage()), (Throwable)e);
            }
        }
        try (Response response = this.httpClient.newCall(request).execute();){
            Object object;
            log.info("Request: {}", (Object)request);
            log.info("Response: {}", (Object)response);
            if (!response.isSuccessful()) {
                throw new ApiResponseException(Objects.requireNonNull(response.body()).string());
            }
            ResponseBody responseBody = Objects.requireNonNull(response.body());
            if (clazz.getType().equals(byte[].class)) {
                object = responseBody.bytes();
                return (T)object;
            }
            object = this.objectMapper.readValue(responseBody.string(), clazz);
            return (T)object;
        }
    }

    private void addQueryParameter(HttpUrl.Builder urlBuilder, String key, Object object) {
        if (object != null) {
            urlBuilder.addQueryParameter(key, String.valueOf(object));
        }
    }

    private String formatDateToIso(OffsetDateTime offsetDateTime) {
        return offsetDateTime != null ? offsetDateTime.withOffsetSameInstant(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) : null;
    }

    private Request createGetRequest(String url, String accessToken) {
        return new Request.Builder().url(url).addHeader("Authorization", "Bearer " + accessToken).addHeader("Accept-Language", "pl,en-US;q=0.7,en;q=0.3").build();
    }

    private Request createPostRequest(String url, RequestBody body, String accessToken) {
        return new Request.Builder().post(body).url(url).addHeader("Authorization", "Bearer " + accessToken).addHeader("Accept-Language", "pl,en-US;q=0.7,en;q=0.3").build();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }
}

