/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.db.mapper;

import com.suncode.plugin.plusedoreczenia.db.entity.MessageEntity;
import com.suncode.plugin.plusedoreczenia.dto.Address;
import com.suncode.plugin.plusedoreczenia.dto.Contributor;
import com.suncode.plugin.plusedoreczenia.dto.Message;
import com.suncode.plugin.plusedoreczenia.dto.MessageAddressData;
import com.suncode.plugin.plusedoreczenia.dto.MessageMetadata;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczenia.utils.MessageParserUtils;
import java.util.Objects;

public class MessageEntityMapper {
    public static MessageEntity toEntity(Message message, EdorConfig edorConfig) {
        MessageMetadata messageMetadata = MessageParserUtils.getIfPresent(message, Message::getMessageMetadata);
        MessageAddressData from = MessageParserUtils.getIfPresent(messageMetadata, MessageMetadata::getFrom);
        Address address = MessageParserUtils.getIfPresent(from, MessageAddressData::getAddress);
        Contributor contributor = MessageParserUtils.getIfPresent(from, MessageAddressData::getContributor);
        return MessageEntity.builder().labels(MessageParserUtils.getLabels(message)).senderEDeliveryAddress(MessageParserUtils.getIfPresent(from, MessageAddressData::getEDeliveryAddress)).senderAddressCountry(MessageParserUtils.getIfPresent(address, Address::getCountry)).senderAddressStreet(MessageParserUtils.getIfPresent(address, Address::getStreet)).senderAddressPostalCode(MessageParserUtils.getIfPresent(address, Address::getPostalCode)).senderAddressCity(MessageParserUtils.getIfPresent(address, Address::getCity)).senderAddressBuildingNumber(MessageParserUtils.getIfPresent(address, Address::getBuildingNumber)).senderAddressHouseNumber(MessageParserUtils.getIfPresent(address, Address::getHouseNumber)).senderFirstName(MessageParserUtils.getIfPresent(contributor, Contributor::getFirstName)).senderLastName(MessageParserUtils.getIfPresent(contributor, Contributor::getLastName)).senderCompanyName(MessageParserUtils.getIfPresent(contributor, Contributor::getCompanyName)).senderCompanyNameContinued(MessageParserUtils.getIfPresent(contributor, Contributor::getCompanyNameContinued)).recipientsEDeliveryAddresses(MessageParserUtils.getRecipientsEDeliveryAddresses(messageMetadata)).subject(MessageParserUtils.getIfPresent(messageMetadata, MessageMetadata::getSubject)).refToMessageId(MessageParserUtils.getIfPresent(messageMetadata, MessageMetadata::getRefToMessageId)).messageId(MessageParserUtils.getIfPresent(messageMetadata, MessageMetadata::getMessageId)).threadId(MessageParserUtils.getIfPresent(messageMetadata, MessageMetadata::getThreadId)).caseId(MessageParserUtils.getIfPresent(messageMetadata, MessageMetadata::getCaseId)).shippingService(MessageParserUtils.getIfPresent(messageMetadata, MessageMetadata::getShippingService)).timestamp(MessageParserUtils.toSqlTimestamp(MessageParserUtils.getIfPresent(messageMetadata, MessageMetadata::getTimestamp))).receiptDate(MessageParserUtils.toSqlTimestamp(MessageParserUtils.getReceiptDate(message))).submissionDate(MessageParserUtils.toSqlTimestamp(MessageParserUtils.getIfPresent(messageMetadata, MessageMetadata::getSubmissionDate))).eventDate(MessageParserUtils.toSqlTimestamp(MessageParserUtils.getIfPresent(messageMetadata, MessageMetadata::getEventDate))).textBody(Objects.toString(MessageParserUtils.getIfPresent(message, Message::getTextBody), "")).pcmConfigId(edorConfig.getConfigId()).build();
    }

    private MessageEntityMapper() {
    }
}

