/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.controller;

import com.plusmpm.util.XpdlPackageManager;
import com.suncode.plugin.plusedoreczenia.controller.dto.ActivityDto;
import com.suncode.plugin.plusedoreczenia.controller.dto.ProcessDto;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/processInfo"})
public class ProcessInfoController {
    @Autowired
    private ProcessService processService;

    @RequestMapping(value={"allProcesses"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ProcessDto> getAllProcesses(@RequestParam(required=false) String query, @RequestParam(required=false, defaultValue="0") Integer start, @RequestParam(required=false, defaultValue="25") Integer limit) {
        List processes = this.processService.getProcessTypesForUser(SessionUtils.getLoggedUserName()).stream().filter(process -> StringUtils.containsIgnoreCase((CharSequence)process.getName(), (CharSequence)query)).sorted(Comparator.comparing(ProcessType::getName)).collect(Collectors.toList());
        List<Object> filteredData = processes.size() >= start ? processes.subList(start, Integer.min(start + limit, processes.size())) : Collections.emptyList();
        List<ProcessDto> response = this.convertToProcessDto(filteredData);
        return new CountedResult((long)processes.size(), response);
    }

    @RequestMapping(value={"/{processDefinitionId}/activities"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ActivityDto> getActivityTypes(@RequestParam(required=false) String query, @RequestParam(required=false, defaultValue="0") Integer start, @RequestParam(required=false, defaultValue="25") Integer limit, @PathVariable String processDefinitionId) {
        Package pack = XpdlPackageManager.getInstance().getPackageByProcessDefinitionId(processDefinitionId);
        WorkflowProcess workflowProcess = pack.getWorkflowProcess(processDefinitionId);
        ArrayList activityDefinitions = workflowProcess.getActivities().toElements();
        List activities = activityDefinitions.stream().filter(activity -> StringUtils.containsIgnoreCase((CharSequence)activity.getName(), (CharSequence)query)).sorted(Comparator.comparing(Activity::getName)).collect(Collectors.toList());
        List<Object> filteredData = activities.size() >= start ? activities.subList(start, Integer.min(start + limit, activities.size())) : Collections.emptyList();
        List<ActivityDto> response = this.convertToActivityDto(filteredData);
        return new CountedResult((long)activities.size(), response);
    }

    private List<ProcessDto> convertToProcessDto(List<ProcessType> data) {
        return data.stream().map(ProcessDto::fromEntity).collect(Collectors.toList());
    }

    private List<ActivityDto> convertToActivityDto(List<Activity> data) {
        return data.stream().map(ActivityDto::fromEntity).collect(Collectors.toList());
    }
}

