/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.scheduledtasks;

import com.suncode.plugin.plusedoreczenia.Categories;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.MessageReceiptDateUpdateResult;
import com.suncode.plugin.plusedoreczenia.service.ProcessingException;
import com.suncode.plugin.plusedoreczenia.service.ProcessingService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.variable.Variable;
import com.suncode.pwfl.workflow.variable.VariableFactory;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
@ScheduledTaskScript(value="dist/plusedoreczenia/scheduledtasks/UpdateDeliveryDate/pwe_dynamic_form.js")
public class UpdateDeliveryDate {
    private static final Logger log = LoggerFactory.getLogger(UpdateDeliveryDate.class);
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private VariableFactory variableFactory;
    @Autowired
    private ProcessingService processingService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("plusedoreczenia.scheduledtasks.UpdateDeliveryDate")).name("plusedoreczenia.scheduledtasks.UpdateDeliveryDate.name")).description("plusedoreczenia.scheduledtasks.UpdateDeliveryDate.desc")).category(new Category[]{Categories.PLUS_E_DORECZENIA})).parameter().id("processDefId").name("plusedoreczenia.scheduledtasks.UpdateDeliveryDate.param.processDefId.name").type((Type)Types.STRING).create()).parameter().id("activityDefId").name("plusedoreczenia.scheduledtasks.UpdateDeliveryDate.param.activityDefId.name").type((Type)Types.STRING).create()).parameter().id("messageIdVariableId").name("plusedoreczenia.scheduledtasks.UpdateDeliveryDate.param.messageIdVariableId.name").description("plusedoreczenia.scheduledtasks.UpdateDeliveryDate.param.messageIdVariableId.desc").type((Type)Types.STRING).create()).parameter().id("receiptDateVariableId").name("plusedoreczenia.scheduledtasks.UpdateDeliveryDate.param.receiptDateVariableId.name").description("plusedoreczenia.scheduledtasks.UpdateDeliveryDate.param.receiptDateVariableId.desc").type((Type)Types.STRING).optional().create()).parameter().id("documentClasses").name("plusedoreczenia.scheduledtasks.UpdateDeliveryDate.param.documentClasses.name").description("plusedoreczenia.scheduledtasks.UpdateDeliveryDate.param.documentClasses.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("receiptDateIndexes").name("plusedoreczenia.scheduledtasks.UpdateDeliveryDate.param.receiptDateIndexes.name").description("plusedoreczenia.scheduledtasks.UpdateDeliveryDate.param.receiptDateIndexes.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("successActionName").name("plusedoreczenia.scheduledtasks.UpdateDeliveryDate.param.successActionName.name").description("plusedoreczenia.scheduledtasks.UpdateDeliveryDate.param.successActionName.desc").type((Type)Types.STRING).create()).parameter().id("errorActionName").name("plusedoreczenia.scheduledtasks.UpdateDeliveryDate.param.errorActionName.name").description("plusedoreczenia.scheduledtasks.UpdateDeliveryDate.param.errorActionName.desc").type((Type)Types.STRING).create();
    }

    public String execute(@Param String processDefId, @Param String activityDefId, @Param String messageIdVariableId, @Param String receiptDateVariableId, @PairedParam(key="documentClasses", value="receiptDateIndexes") Map<String, String> documentClassIndexMap, @Param String successActionName, @Param String errorActionName, org.apache.log4j.Logger taskLog) {
        try {
            List activities = this.activityFinder.findActivities(processDefId, activityDefId, Arrays.asList(ActivityState.RUNNING, ActivityState.NOT_STARTED), new String[0]);
            if (activities.isEmpty()) {
                String noActivitiesFoundMessage = "No activities found.";
                taskLog.info((Object)noActivitiesFoundMessage);
                return noActivitiesFoundMessage;
            }
            taskLog.info((Object)MessageFormat.format("Found {0} activities.", activities.size()));
            int successCount = 0;
            int pendingCount = 0;
            int errorCount = 0;
            for (Activity activity : activities) {
                try {
                    taskLog.info((Object)("Processing activity: processId=" + activity.getProcessId() + ", activityId=" + activity.getActivityId()));
                    MessageReceiptDateUpdateResult result = this.processActivity(activity, messageIdVariableId, receiptDateVariableId, documentClassIndexMap, successActionName, errorActionName, taskLog);
                    switch (result) {
                        case SUCCESS: {
                            ++successCount;
                            break;
                        }
                        case PENDING: {
                            ++pendingCount;
                            break;
                        }
                        case ERROR: {
                            ++errorCount;
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Error processing activity: " + activity.getActivityId(), (Throwable)e);
                    taskLog.error((Object)("Error processing activity: " + activity.getActivityId()), (Throwable)e);
                    ++errorCount;
                }
            }
            String summary = MessageFormat.format("Success: {0}, Pending: {1}, Error: {2}", successCount, pendingCount, errorCount);
            taskLog.info((Object)summary);
            return summary;
        }
        catch (Exception e) {
            log.error("Task failed: " + e.getMessage(), (Throwable)e);
            taskLog.error((Object)("Task failed: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    private MessageReceiptDateUpdateResult processActivity(Activity activity, String messageIdVariableId, String receiptDateVariableId, Map<String, String> documentClassIndexMap, String successActionName, String errorActionName, org.apache.log4j.Logger taskLog) throws ProcessingException {
        String messageId;
        Map activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
        Map activityVariables = this.variableFactory.createVariables(activity.getProcessId(), activity.getActivityId(), activityContext, true);
        Variable messageIdVar = (Variable)activityVariables.get(messageIdVariableId);
        String string = messageId = messageIdVar != null ? (String)messageIdVar.getValue() : null;
        if (StringUtils.isBlank((CharSequence)messageId)) {
            taskLog.error((Object)("Missing messageId in variable: " + messageIdVariableId + " for activity: " + activity.getActivityId()));
            return MessageReceiptDateUpdateResult.ERROR;
        }
        return this.processingService.updateMessageReceiptDate(messageId, receiptDateVariableId, documentClassIndexMap, successActionName, errorActionName, activity, taskLog);
    }
}

