/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.scheduledtasks;

import com.suncode.plugin.plusedoreczenia.Categories;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.UpoFormat;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.UpoType;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.upo.UpoProcessingResultDto;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.upo.UpoStatus;
import com.suncode.plugin.plusedoreczenia.service.ProcessingService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityState;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
@ScheduledTaskScript(value="dist/plusedoreczenia/scheduledtasks/ImportUpoFromEdor/pwe_dynamic_form.js")
public class ImportUpoFromEdor {
    private static final Logger log = LoggerFactory.getLogger(ImportUpoFromEdor.class);
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private ProcessingService processingService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("plusedoreczenia.scheduledtasks.ImportUpoFromEdor")).name("plusedoreczenia.scheduledtasks.ImportUpoFromEdor.name")).description("plusedoreczenia.scheduledtasks.ImportUpoFromEdor.desc")).category(new Category[]{Categories.PLUS_E_DORECZENIA})).parameter().id("upoType").name("plusedoreczenia.scheduledtasks.ImportUpoFromEdor.param.upoType.name").description("plusedoreczenia.scheduledtasks.ImportUpoFromEdor.param.upoType.desc").type((Type)Types.STRING).create()).parameter().id("upoFormat").name("plusedoreczenia.scheduledtasks.ImportUpoFromEdor.param.upoFormat.name").description("plusedoreczenia.scheduledtasks.ImportUpoFromEdor.param.upoFormat.desc").type((Type)Types.STRING).create()).parameter().id("processDefId").name("plusedoreczenia.scheduledtasks.ImportUpoFromEdor.param.processDefId.name").type((Type)Types.STRING).create()).parameter().id("activityDefId").name("plusedoreczenia.scheduledtasks.ImportUpoFromEdor.param.activityDefId.name").type((Type)Types.STRING).create()).parameter().id("actionId").name("plusedoreczenia.scheduledtasks.ImportUpoFromEdor.param.actionId.name").description("plusedoreczenia.scheduledtasks.ImportUpoFromEdor.param.actionId.desc").type((Type)Types.STRING).create()).parameter().id("documentClass").name("plusedoreczenia.scheduledtasks.ImportUpoFromEdor.param.documentClass.name").type((Type)Types.STRING).create()).parameter().id("documentClassIndexForEvidenceType").name("plusedoreczenia.scheduledtasks.ImportUpoFromEdor.param.documentClassIndexForEvidenceType.name").type((Type)Types.STRING).create()).parameter().id("documentClassIndexForMessageId").name("plusedoreczenia.scheduledtasks.ImportUpoFromEdor.param.documentClassIndexForMessageId.name").type((Type)Types.STRING).create()).parameter().id("executeDocumentClassActions").name("plusedoreczenia.scheduledtasks.ImportUpoFromEdor.param.executeDocumentClassActions.name").type((Type)Types.BOOLEAN).create();
    }

    public String execute(@Param String upoType, @Param String upoFormat, @Param String processDefId, @Param String activityDefId, @Param String actionId, @Param String documentClass, @Param String documentClassIndexForEvidenceType, @Param String documentClassIndexForMessageId, @Param Boolean executeDocumentClassActions, org.apache.log4j.Logger taskLog) {
        try {
            List activities = this.activityFinder.findActivities(processDefId, activityDefId, Arrays.asList(ActivityState.RUNNING, ActivityState.NOT_STARTED), new String[0]);
            if (activities.isEmpty()) {
                String noActivitiesFoundMessage = "No activities found.";
                taskLog.info((Object)noActivitiesFoundMessage);
                return noActivitiesFoundMessage;
            }
            taskLog.debug((Object)MessageFormat.format("Found {0} activities.", activities.size()));
            UpoProcessingResultDto upoProcessingResultDto = new UpoProcessingResultDto();
            for (Activity activity : activities) {
                try {
                    UpoStatus upoStatus = this.processingService.downloadUpo(activity, UpoType.valueOf(upoType), UpoFormat.valueOf(upoFormat), actionId, documentClass, documentClassIndexForEvidenceType, documentClassIndexForMessageId, executeDocumentClassActions, taskLog);
                    switch (upoStatus) {
                        case SUCCESS: {
                            upoProcessingResultDto.increaseSuccessesCount();
                            break;
                        }
                        case PENDING: {
                            upoProcessingResultDto.increasePendingCount();
                            break;
                        }
                        case ERROR: {
                            upoProcessingResultDto.increaseFailuresCount();
                        }
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    taskLog.error((Object)e.getMessage());
                    upoProcessingResultDto.increaseFailuresCount();
                }
            }
            String summary = MessageFormat.format("Successes: {0}, Pending: {1}, Errors: {2}", upoProcessingResultDto.getSuccessesCount(), upoProcessingResultDto.getPendingCount(), upoProcessingResultDto.getFailuresCount());
            taskLog.info((Object)summary);
            return summary;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

