/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.scheduledtasks;

import com.google.gson.Gson;
import com.plusmpm.util.FreeDaysHelper;
import com.suncode.plugin.plusedoreczenia.Categories;
import com.suncode.plugin.plusedoreczenia.db.service.MessageService;
import com.suncode.plugin.plusedoreczenia.db.service.MessagesImportLogService;
import com.suncode.plugin.plusedoreczenia.dto.Message;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.service.ConfigurationService;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.DocumentsOrder;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.DownloadedMessagesDto;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.ProcessingResultDto;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.summary.DownloadingSummaryDto;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.summary.ProcessingSummaryDto;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.summary.SummaryDto;
import com.suncode.plugin.plusedoreczenia.service.EDeliveryService;
import com.suncode.plugin.plusedoreczenia.service.ProcessingException;
import com.suncode.plugin.plusedoreczenia.service.ProcessingService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
@ScheduledTaskScript(value="dist/plusedoreczenia/scheduledtasks/ImportMessagesFromEdor/pwe_dynamic_form.js")
public class ImportMessagesFromEdor {
    private static final Logger log = LoggerFactory.getLogger(ImportMessagesFromEdor.class);
    private static final String LAST_PROCESSED_MESSAGE_DATE = "LAST_PROCESSED_MESSAGE_DATE";
    private static final String CURRENT_DATE = "CURRENT_DATE";
    private static final DateTimeFormatter IMPORT_TIMES_FORMATTER = DateTimeFormatter.ofPattern("H:mm");
    private static final int DEFAULT_LOOKUP_DAYS = 30;
    private static final String GLOBAL_SUMMARY_DELIMITER = ". ";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
    private final Gson gson = new Gson();
    @Autowired
    private EDeliveryService eDeliveryService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private MessagesImportLogService messagesImportLogService;
    @Autowired
    private ProcessingService processingService;
    @Autowired
    private ConfigurationService configService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor")).name("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.name")).description("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.desc")).category(new Category[]{Categories.PLUS_E_DORECZENIA})).parameter().id("pcmConfigIds").name("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.pcmConfigIds.name").description("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.pcmConfigIds.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("readFromDate").name("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.readFromDate.name").description("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.readFromDate.desc").type((Type)Types.STRING).create()).parameter().id("attachmentsDocumentClass").name("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.attachmentsDocumentClass.name").description("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.attachmentsDocumentClass.desc").type((Type)Types.STRING).create()).parameter().id("attachmentsDocumentClassIndex").name("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.attachmentsDocumentClassIndex.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("attachmentsDocumentClassParameter").name("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.attachmentsDocumentClassParameter.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("generateFileWithMessage").name("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.generateFileWithMessage.name").description("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.generateFileWithMessage.desc").type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("messageDocumentClass").name("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.messageDocumentClass.name").description("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.messageDocumentClass.desc").type((Type)Types.STRING).optional().create()).parameter().id("messageDocumentClassIndex").name("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.messageDocumentClassIndex.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("messageDocumentClassParameter").name("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.messageDocumentClassParameter.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("orderOfAddingDocuments").name("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.orderOfAddingDocuments.name").description("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.orderOfAddingDocuments.desc").type((Type)Types.STRING).defaultValue((Object)DocumentsOrder.ATTACHMENTS_FIRST.name()).create()).parameter().id("importOnlyOnWorkingDays").name("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.importOnlyOnWorkingDays.name").description("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.importOnlyOnWorkingDays.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("importStartTime").name("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.importStartTime.name").description("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.importStartTime.desc").type((Type)Types.STRING).optional().create()).parameter().id("importEndTime").name("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.importEndTime.name").description("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.param.importEndTime.desc").type((Type)Types.STRING).optional().create();
    }

    public String execute(@Param String[] pcmConfigIds, @Param String readFromDate, @Param String attachmentsDocumentClass, @PairedParam(key="attachmentsDocumentClassIndex", value="attachmentsDocumentClassParameter") Map<String, String> attachmentIndexesAndParams, @Param Boolean generateFileWithMessage, @Param String messageDocumentClass, @PairedParam(key="messageDocumentClassIndex", value="messageDocumentClassParameter") Map<String, String> messageIndexesAndParams, @Param String orderOfAddingDocuments, @Param Boolean importOnlyOnWorkingDays, @Param String importStartTime, @Param String importEndTime, org.apache.log4j.Logger taskLog) {
        try {
            boolean currentTimeInRange;
            long currentTimeEpoch = new Date().getTime();
            if ((StringUtils.isNotBlank((CharSequence)importStartTime) || StringUtils.isNotBlank((CharSequence)importEndTime)) && !(currentTimeInRange = this.isTimeInRange(currentTimeEpoch, importStartTime, importEndTime))) {
                taskLog.info((Object)"Current time is outside the defined range.");
                return "Execution omitted - outside time range";
            }
            if (Boolean.TRUE.equals(importOnlyOnWorkingDays) && FreeDaysHelper.isFreeDay((long)currentTimeEpoch, (boolean)true, (boolean)true)) {
                taskLog.info((Object)"Today is recognized as a non-business day.");
                return "Execution omitted - non-business day";
            }
            ArrayList<String> globalSummary = new ArrayList<String>();
            for (String configId : pcmConfigIds) {
                taskLog.debug((Object)MessageFormat.format("########## {0} ##########", configId));
                taskLog.info((Object)MessageFormat.format("Downloading messages for config=\"{0}\".", configId));
                EdorConfig edorConfig = this.configService.readConfigurationFromPCM(configId);
                String accessToken = this.eDeliveryService.getAccessToken(edorConfig);
                Instant lastProcessedMessageTime = this.messagesImportLogService.getLastProcessedMessageDate(edorConfig.getEDeliveryAddress(), edorConfig.getSystemType(), edorConfig.getSystemName());
                OffsetDateTime readFrom = this.parseReadFromDate(lastProcessedMessageTime, readFromDate);
                DownloadedMessagesDto downloadedMessages = this.processingService.downloadNewMessages(edorConfig, accessToken, readFrom);
                ProcessingResultDto processingResult = new ProcessingResultDto();
                for (Message message : downloadedMessages.getMessages()) {
                    this.processMessage(edorConfig, attachmentsDocumentClass, attachmentIndexesAndParams, generateFileWithMessage, messageDocumentClass, messageIndexesAndParams, orderOfAddingDocuments, processingResult, message, taskLog);
                }
                int failedMessagesCount = downloadedMessages.getFailedMessageIds().size() + processingResult.getFailedMessageIds().size();
                Timestamp latestMessageTimestamp = this.getLatestMessageTimestamp(processingResult);
                String summary = MessageFormat.format("Summary for config \"{0}\": '{' Processed: {1}, Skipped: {2}, Failed: {3} '}'", edorConfig.getConfigId(), processingResult.getProcessedMessages().size(), downloadedMessages.getSkippedMessageIds().size(), failedMessagesCount);
                if (failedMessagesCount == 0 && latestMessageTimestamp != null) {
                    this.messagesImportLogService.save(edorConfig.getSystemType().toString(), latestMessageTimestamp, edorConfig.getEDeliveryAddress(), edorConfig.getSystemName(), summary);
                }
                globalSummary.add(summary);
                taskLog.info((Object)("Details: " + this.createDetailedSummary(configId, downloadedMessages, processingResult)));
                taskLog.debug((Object)MessageFormat.format("########## {0} ##########", configId));
            }
            return String.join((CharSequence)GLOBAL_SUMMARY_DELIMITER, globalSummary);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void processMessage(EdorConfig edorConfig, String attachmentsDocumentClass, Map<String, String> attachmentIndexesAndParams, Boolean generateFileWithMessage, String messageDocumentClass, Map<String, String> messageIndexesAndParams, String orderOfAddingDocuments, ProcessingResultDto processingResult, Message message, org.apache.log4j.Logger taskLog) {
        try {
            this.processingService.processMessage(edorConfig, attachmentsDocumentClass, attachmentIndexesAndParams, generateFileWithMessage, messageDocumentClass, messageIndexesAndParams, DocumentsOrder.valueOf(orderOfAddingDocuments), message);
            taskLog.debug((Object)MessageFormat.format("Processed message with id=\"{0}\"", Objects.requireNonNull(message.getMessageMetadata()).getMessageId()));
            processingResult.getProcessedMessages().add(message);
        }
        catch (ProcessingException e) {
            String messageId = Objects.requireNonNull(message.getMessageMetadata()).getMessageId();
            taskLog.error((Object)MessageFormat.format("Could not process message with id=\"{0}\"", messageId));
            taskLog.error((Object)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            processingResult.getFailedMessageIds().add(messageId);
        }
    }

    @Nullable
    private Timestamp getLatestMessageTimestamp(ProcessingResultDto processingResult) {
        Optional<Message> latestMessage;
        Timestamp latestMessageTimestamp = null;
        List<Message> processedMessages = processingResult.getProcessedMessages();
        if (!processedMessages.isEmpty() && (latestMessage = processedMessages.stream().filter(message -> message.getMessageMetadata() != null).max(Comparator.comparing(message -> message.getMessageMetadata().getTimestamp(), Comparator.nullsLast(Comparator.naturalOrder())))).isPresent()) {
            OffsetDateTime latestMessageTimestampDate = Objects.requireNonNull(latestMessage.get().getMessageMetadata()).getTimestamp();
            latestMessageTimestamp = latestMessageTimestampDate != null ? Timestamp.from(latestMessageTimestampDate.toInstant()) : null;
        }
        return latestMessageTimestamp;
    }

    private OffsetDateTime parseReadFromDate(Instant lastProcessedMessageTime, String readFromDate) throws ParseException {
        OffsetDateTime from;
        if (readFromDate.equals(LAST_PROCESSED_MESSAGE_DATE)) {
            boolean firstTimeExecution;
            boolean bl = firstTimeExecution = lastProcessedMessageTime == null;
            from = firstTimeExecution ? OffsetDateTime.now().minusDays(30L) : lastProcessedMessageTime.atOffset(ZoneOffset.UTC);
        } else {
            from = readFromDate.equals(CURRENT_DATE) ? LocalDate.now(ZoneOffset.UTC).atStartOfDay().atOffset(ZoneOffset.UTC) : this.dateFormat.parse(readFromDate).toInstant().atOffset(ZoneOffset.UTC);
        }
        return from;
    }

    private String createDetailedSummary(String configId, DownloadedMessagesDto downloadedMessages, ProcessingResultDto processingResult) {
        SummaryDto summaryDto = SummaryDto.builder().config(configId).downloading(DownloadingSummaryDto.builder().downloaded(downloadedMessages.getMessages().size()).skipped(downloadedMessages.getSkippedMessageIds().size()).skippedIds(downloadedMessages.getSkippedMessageIds()).failed(downloadedMessages.getFailedMessageIds().size()).failedIds(downloadedMessages.getFailedMessageIds()).build()).processing(ProcessingSummaryDto.builder().processed(processingResult.getProcessedMessages().size()).failed(processingResult.getFailedMessageIds().size()).failedIds(processingResult.getFailedMessageIds()).build()).build();
        return this.gson.toJson((Object)summaryDto);
    }

    private boolean isTimeInRange(long epochTime, String startTime, String endTime) {
        LocalTime endLocalTime;
        LocalTime currentTime = Instant.ofEpochMilli(epochTime).atZone(ZoneId.systemDefault()).toLocalTime();
        LocalTime startLocalTime = this.parseTimeOrSetDefault(startTime, LocalTime.MIN);
        if (startLocalTime.isBefore(endLocalTime = this.parseTimeOrSetDefault(endTime, LocalTime.MAX))) {
            return !(!currentTime.equals(startLocalTime) && !currentTime.isAfter(startLocalTime) || !currentTime.equals(endLocalTime) && !currentTime.isBefore(endLocalTime));
        }
        return currentTime.equals(startLocalTime) || currentTime.isAfter(startLocalTime) || currentTime.equals(endLocalTime) || currentTime.isBefore(endLocalTime);
    }

    private LocalTime parseTimeOrSetDefault(String time, LocalTime defaultValue) {
        LocalTime localTime;
        if (StringUtils.isBlank((CharSequence)time)) {
            localTime = defaultValue;
        } else {
            try {
                localTime = LocalTime.parse(time, IMPORT_TIMES_FORMATTER);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                localTime = defaultValue;
            }
        }
        return localTime;
    }
}

