/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.scheduledtasks;

import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.sending.SentMessageStatus;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.sending.SentMessagesProcessingResultDto;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.sending.SuccessCriteria;
import com.suncode.plugin.plusedoreczenia.service.ProcessingException;
import com.suncode.plugin.plusedoreczenia.service.ProcessingService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityState;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
@ScheduledTaskScript(value="dist/plusedoreczenia/scheduledtasks/CheckMessageStatuses/pwe_dynamic_form.js")
public class CheckMessageStatuses {
    private static final Logger log = LoggerFactory.getLogger(CheckMessageStatuses.class);
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private ProcessingService processingService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("plusedoreczenia.scheduledtasks.CheckMessageStatuses")).name("plusedoreczenia.scheduledtasks.CheckMessageStatuses.name")).description("plusedoreczenia.scheduledtasks.CheckMessageStatuses.desc")).parameter().id("processDefId").name("plusedoreczenia.scheduledtasks.CheckMessageStatuses.param.processDefId.name").type((Type)Types.STRING).create()).parameter().id("activityDefId").name("plusedoreczenia.scheduledtasks.CheckMessageStatuses.param.activityDefId.name").type((Type)Types.STRING).create()).parameter().id("successCriteria").name("plusedoreczenia.scheduledtasks.CheckMessageStatuses.param.successCriteria.name").description("plusedoreczenia.scheduledtasks.CheckMessageStatuses.param.successCriteria.desc").type((Type)Types.STRING).defaultValue((Object)SuccessCriteria.ACCEPTANCE.name()).create()).parameter().id("successActionName").name("plusedoreczenia.scheduledtasks.CheckMessageStatuses.param.successActionName.name").description("plusedoreczenia.scheduledtasks.CheckMessageStatuses.param.successActionName.desc").type((Type)Types.STRING).create()).parameter().id("errorActionName").name("plusedoreczenia.scheduledtasks.CheckMessageStatuses.param.errorActionName.name").description("plusedoreczenia.scheduledtasks.CheckMessageStatuses.param.errorActionName.desc").type((Type)Types.STRING).create()).parameter().id("statusOutputVariable").name("plusedoreczenia.scheduledtasks.CheckMessageStatuses.param.statusOutputVariable.name").type((Type)Types.STRING).optional().create()).parameter().id("messageIdOutputVariable").name("plusedoreczenia.scheduledtasks.CheckMessageStatuses.param.messageIdOutputVariable.name").description("plusedoreczenia.scheduledtasks.CheckMessageStatuses.param.messageIdOutputVariable.desc").type((Type)Types.STRING).optional().create()).parameter().id("receiptDateOutputVariable").name("plusedoreczenia.scheduledtasks.CheckMessageStatuses.param.receiptDateOutputVariable.name").description("plusedoreczenia.scheduledtasks.CheckMessageStatuses.param.receiptDateOutputVariable.desc").type((Type)Types.STRING).optional().create()).parameter().id("threadIdOutputVariable").name("plusedoreczenia.scheduledtasks.CheckMessageStatuses.param.threadIdOutputVariable.name").type((Type)Types.STRING).optional().create();
    }

    public String execute(@Param String processDefId, @Param String activityDefId, @Param String successCriteria, @Param String successActionName, @Param String errorActionName, @Param String statusOutputVariable, @Param String messageIdOutputVariable, @Param String receiptDateOutputVariable, @Param String threadIdOutputVariable, org.apache.log4j.Logger taskLog) {
        try {
            List activities = this.activityFinder.findActivities(processDefId, activityDefId, Arrays.asList(ActivityState.RUNNING, ActivityState.NOT_STARTED), new String[0]);
            taskLog.debug((Object)MessageFormat.format("Found {0} activities.", activities.size()));
            if (activities.isEmpty()) {
                String noActivitiesFound = "No activities found.";
                taskLog.warn((Object)noActivitiesFound);
                return noActivitiesFound;
            }
            SentMessagesProcessingResultDto sentMessagesProcessingResultDto = new SentMessagesProcessingResultDto();
            for (Activity activity : activities) {
                try {
                    SuccessCriteria criteria = SuccessCriteria.valueOf(successCriteria);
                    SentMessageStatus sentMessageStatus = this.processingService.updateSentMessageStatus(successActionName, errorActionName, statusOutputVariable, messageIdOutputVariable, receiptDateOutputVariable, threadIdOutputVariable, criteria, activity, taskLog);
                    switch (sentMessageStatus) {
                        case ERROR: {
                            sentMessagesProcessingResultDto.increaseFailuresCount();
                            break;
                        }
                        case COMPLETED: {
                            sentMessagesProcessingResultDto.increaseSuccessesCount();
                            break;
                        }
                        case PENDING: {
                            sentMessagesProcessingResultDto.increasePendingCount();
                        }
                    }
                }
                catch (ProcessingException e) {
                    taskLog.error((Object)e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                    sentMessagesProcessingResultDto.increaseFailuresCount();
                }
            }
            String summary = MessageFormat.format("Successes: {0}, Pending: {1}, Errors: {2}", sentMessagesProcessingResultDto.getSuccessesCount(), sentMessagesProcessingResultDto.getPendingCount(), sentMessagesProcessingResultDto.getFailuresCount());
            taskLog.info((Object)summary);
            return summary;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

