/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.db.service;

import com.google.common.collect.Lists;
import com.plusmpm.database.dbspecific.NativeDatabase;
import com.suncode.plugin.plusedoreczenia.db.dao.MessageDao;
import com.suncode.plugin.plusedoreczenia.db.entity.MessageEntity;
import com.suncode.plugin.plusedoreczenia.db.service.MessageService;
import com.suncode.plugin.plusedoreczenia.dto.Address;
import com.suncode.plugin.plusedoreczenia.dto.Contributor;
import com.suncode.plugin.plusedoreczenia.dto.Label;
import com.suncode.plugin.plusedoreczenia.dto.Message;
import com.suncode.plugin.plusedoreczenia.dto.MessageAddressData;
import com.suncode.plugin.plusedoreczenia.dto.MessageMetadata;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczenia.utils.MessageParserUtils;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MessageServiceImpl
implements MessageService {
    public static final String DELIMITER = ",";
    @Autowired
    private MessageDao messageDao;

    @Override
    public List<MessageEntity> getAll() {
        return this.messageDao.getAll(new String[0]);
    }

    @Override
    public Optional<MessageEntity> findByMessageId(String messageId) {
        MessageEntity messageEntity = (MessageEntity)this.messageDao.getByField("messageId", messageId, new String[0]);
        return Optional.ofNullable(messageEntity);
    }

    @Override
    public void save(EdorConfig edorConfig, Message message) {
        MessageMetadata messageMetadata = message.getMessageMetadata();
        MessageAddressData from = messageMetadata != null ? messageMetadata.getFrom() : null;
        List<MessageAddressData> to = messageMetadata != null ? messageMetadata.getTo() : null;
        String recipientsEDeliveryAddresses = to != null ? to.stream().map(MessageAddressData::getEDeliveryAddress).collect(Collectors.joining(DELIMITER)) : null;
        String labels = null;
        if (message.getMessageControlData() != null && message.getMessageControlData().getLabels() != null && !message.getMessageControlData().getLabels().isEmpty()) {
            labels = message.getMessageControlData().getLabels().stream().map(Label::getLabel).collect(Collectors.joining(DELIMITER));
        }
        Address address = from != null ? from.getAddress() : null;
        Contributor contributor = from != null ? from.getContributor() : null;
        OffsetDateTime timestamp = messageMetadata != null ? messageMetadata.getTimestamp() : null;
        OffsetDateTime receiptDate = MessageParserUtils.getReceiptDate(message);
        OffsetDateTime submissionDate = messageMetadata != null ? messageMetadata.getSubmissionDate() : null;
        OffsetDateTime eventDate = messageMetadata != null ? messageMetadata.getEventDate() : null;
        MessageEntity messageEntity = MessageEntity.builder().labels(labels).senderEDeliveryAddress(from != null ? from.getEDeliveryAddress() : null).senderAddressCountry(address != null ? address.getCountry() : null).senderAddressStreet(address != null ? address.getStreet() : null).senderAddressPostalCode(address != null ? address.getPostalCode() : null).senderAddressCity(address != null ? address.getCity() : null).senderAddressBuildingNumber(address != null ? address.getBuildingNumber() : null).senderAddressHouseNumber(address != null ? address.getHouseNumber() : null).senderFirstName(contributor != null ? contributor.getFirstName() : null).senderLastName(contributor != null ? contributor.getLastName() : null).senderCompanyName(contributor != null ? contributor.getCompanyName() : null).senderCompanyNameContinued(contributor != null ? contributor.getCompanyNameContinued() : null).recipientsEDeliveryAddresses(recipientsEDeliveryAddresses).subject(messageMetadata != null ? messageMetadata.getSubject() : null).refToMessageId(messageMetadata != null ? messageMetadata.getRefToMessageId() : null).messageId(messageMetadata != null ? messageMetadata.getMessageId() : null).threadId(messageMetadata != null ? messageMetadata.getThreadId() : null).caseId(messageMetadata != null ? messageMetadata.getCaseId() : null).shippingService(messageMetadata != null ? messageMetadata.getShippingService() : null).timestamp(timestamp != null ? Timestamp.from(timestamp.toInstant()) : null).receiptDate(receiptDate != null ? Timestamp.from(receiptDate.toInstant()) : null).submissionDate(submissionDate != null ? Timestamp.from(submissionDate.toInstant()) : null).eventDate(eventDate != null ? Timestamp.from(eventDate.toInstant()) : null).textBody(message.getTextBody()).pcmConfigId(edorConfig.getConfigId()).build();
        this.messageDao.save(messageEntity);
    }

    @Override
    public void save(MessageEntity messageEntity) {
        this.messageDao.save(messageEntity);
    }

    @Override
    public Set<String> findAlreadyProcessedMessages(List<String> messageIds) {
        if (messageIds.isEmpty()) {
            return Collections.emptySet();
        }
        int maxNumberOfInClauseParameters = NativeDatabase.getImplementation().getMaxNumberOfInClauseParameters();
        if (messageIds.size() > maxNumberOfInClauseParameters) {
            List partitions = Lists.partition(messageIds, (int)maxNumberOfInClauseParameters);
            return partitions.stream().map(partition -> {
                HibernateCriteria criteria = HibernateCriteria.forClass(MessageEntity.class);
                criteria.add(Restrictions.in((String)"messageId", (Collection)partition));
                return this.messageDao.findByCriteria(criteria);
            }).flatMap(Collection::stream).map(MessageEntity::getMessageId).collect(Collectors.toSet());
        }
        HibernateCriteria criteria = HibernateCriteria.forClass(MessageEntity.class);
        criteria.add(Restrictions.in((String)"messageId", messageIds));
        return this.messageDao.findByCriteria(criteria).stream().map(MessageEntity::getMessageId).collect(Collectors.toSet());
    }
}

