/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.controller;

import com.suncode.plugin.plusedoreczenia.EdorKeysImpl;
import com.suncode.plugin.plusedoreczenia.PcmKeysImpl;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
public class EdorKeysController {
    private static final Logger log = LoggerFactory.getLogger(EdorKeysController.class);

    @ResponseBody
    @RequestMapping(value={"edorKeys"}, method={RequestMethod.GET})
    public List<Map<String, String>> getEdorKeys() {
        List edorKeys = EdorKeysImpl.stream().sorted(Comparator.comparing(EdorKeysImpl::getDescription)).map(this::edorKeyMap).collect(Collectors.toList());
        List pcmKeys = PcmKeysImpl.stream().sorted(Comparator.comparing(PcmKeysImpl::getDescription)).map(this::pcmKeyMap).collect(Collectors.toList());
        return Stream.concat(edorKeys.stream(), pcmKeys.stream()).collect(Collectors.toList());
    }

    private Map<String, String> edorKeyMap(EdorKeysImpl key) {
        LinkedHashMap<String, String> edorKeyMap = new LinkedHashMap<String, String>();
        edorKeyMap.put("key", key.getKey());
        edorKeyMap.put("type", key.getType().name().toUpperCase());
        edorKeyMap.put("desc", key.getDescription());
        return edorKeyMap;
    }

    private Map<String, String> pcmKeyMap(PcmKeysImpl key) {
        LinkedHashMap<String, String> edorKeyMap = new LinkedHashMap<String, String>();
        edorKeyMap.put("key", key.getKey());
        edorKeyMap.put("type", key.getType().name().toUpperCase());
        edorKeyMap.put("desc", key.getDescription());
        return edorKeyMap;
    }

    @ResponseBody
    @RequestMapping(value={"edorKeysHeaders"}, method={RequestMethod.GET})
    public List<Map<String, String>> getEdorKeysHeaders() {
        List edorKeys = EdorKeysImpl.stream().sorted(Comparator.comparing(EdorKeysImpl::getDescription)).filter(edorKey -> !edorKey.isOpeningMessageRequired()).map(this::edorKeyMap).collect(Collectors.toList());
        List pcmKeys = PcmKeysImpl.stream().sorted(Comparator.comparing(PcmKeysImpl::getDescription)).map(this::pcmKeyMap).collect(Collectors.toList());
        return Stream.concat(edorKeys.stream(), pcmKeys.stream()).collect(Collectors.toList());
    }
}

