/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.db.service;

import com.google.common.collect.Lists;
import com.plusmpm.database.dbspecific.NativeDatabase;
import com.suncode.plugin.plusedoreczenia.db.dao.MessageHeaderDao;
import com.suncode.plugin.plusedoreczenia.db.entity.MessageHeaderEntity;
import com.suncode.plugin.plusedoreczenia.db.service.MessageHeaderService;
import com.suncode.plugin.plusedoreczenia.dto.Address;
import com.suncode.plugin.plusedoreczenia.dto.Contributor;
import com.suncode.plugin.plusedoreczenia.dto.Label;
import com.suncode.plugin.plusedoreczenia.dto.Message;
import com.suncode.plugin.plusedoreczenia.dto.MessageAddressData;
import com.suncode.plugin.plusedoreczenia.dto.MessageMetadata;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MessageHeaderServiceImpl
implements MessageHeaderService {
    public static final String DELIMITER = ",";
    @Autowired
    private MessageHeaderDao messageHeaderDao;

    @Override
    public void save(Message message, String processId, EdorConfig edorConfig) {
        MessageMetadata messageMetadata = message.getMessageMetadata();
        MessageAddressData from = messageMetadata != null ? messageMetadata.getFrom() : null;
        List<MessageAddressData> to = messageMetadata != null ? messageMetadata.getTo() : null;
        String recipientsEDeliveryAddresses = to != null ? to.stream().map(MessageAddressData::getEDeliveryAddress).collect(Collectors.joining(DELIMITER)) : null;
        String labels = null;
        if (message.getMessageControlData() != null && message.getMessageControlData().getLabels() != null && !message.getMessageControlData().getLabels().isEmpty()) {
            labels = message.getMessageControlData().getLabels().stream().map(Label::getLabel).collect(Collectors.joining(DELIMITER));
        }
        Address address = from != null ? from.getAddress() : null;
        Contributor contributor = from != null ? from.getContributor() : null;
        OffsetDateTime timestamp = messageMetadata != null ? messageMetadata.getTimestamp() : null;
        MessageHeaderEntity messageHeaderEntity = MessageHeaderEntity.builder().labels(labels).senderEDeliveryAddress(from != null ? from.getEDeliveryAddress() : null).senderAddressCountry(address != null ? address.getCountry() : null).senderAddressStreet(address != null ? address.getStreet() : null).senderAddressPostalCode(address != null ? address.getPostalCode() : null).senderAddressCity(address != null ? address.getCity() : null).senderAddressBuildingNumber(address != null ? address.getBuildingNumber() : null).senderAddressHouseNumber(address != null ? address.getHouseNumber() : null).senderFirstName(contributor != null ? contributor.getFirstName() : null).senderLastName(contributor != null ? contributor.getLastName() : null).senderCompanyName(contributor != null ? contributor.getCompanyName() : null).senderCompanyNameContinued(contributor != null ? contributor.getCompanyNameContinued() : null).recipientsEDeliveryAddresses(recipientsEDeliveryAddresses).subject(messageMetadata != null ? messageMetadata.getSubject() : null).refToMessageId(messageMetadata != null ? messageMetadata.getRefToMessageId() : null).messageId(messageMetadata != null ? messageMetadata.getMessageId() : null).threadId(messageMetadata != null ? messageMetadata.getThreadId() : null).caseId(messageMetadata != null ? messageMetadata.getCaseId() : null).shippingService(messageMetadata != null ? messageMetadata.getShippingService() : null).timestamp(timestamp != null ? Timestamp.from(timestamp.toInstant()) : null).processId(processId).config(edorConfig.getConfigId()).build();
        this.messageHeaderDao.save(messageHeaderEntity);
    }

    @Override
    public Set<String> findAlreadyDownloadedMessages(List<String> messageIds) {
        if (messageIds.isEmpty()) {
            return Collections.emptySet();
        }
        int maxNumberOfInClauseParameters = NativeDatabase.getImplementation().getMaxNumberOfInClauseParameters();
        if (messageIds.size() > maxNumberOfInClauseParameters) {
            List partitions = Lists.partition(messageIds, (int)maxNumberOfInClauseParameters);
            return partitions.stream().map(partition -> {
                HibernateCriteria criteria = HibernateCriteria.forClass(MessageHeaderEntity.class);
                criteria.add(Restrictions.in((String)"messageId", (Collection)partition));
                return this.messageHeaderDao.findByCriteria(criteria);
            }).flatMap(Collection::stream).map(MessageHeaderEntity::getMessageId).collect(Collectors.toSet());
        }
        HibernateCriteria criteria = HibernateCriteria.forClass(MessageHeaderEntity.class);
        criteria.add(Restrictions.in((String)"messageId", messageIds));
        return this.messageHeaderDao.findByCriteria(criteria).stream().map(MessageHeaderEntity::getMessageId).collect(Collectors.toSet());
    }
}

