/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.autotasks;

import com.google.gson.Gson;
import com.suncode.plugin.plusedoreczenia.Categories;
import com.suncode.plugin.plusedoreczenia.dto.Message;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.service.ConfigurationService;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.DocumentsOrder;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.DownloadedMessagesDto;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.ProcessingResultDto;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.summary.DownloadingSummaryDto;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.summary.ProcessingSummaryDto;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.summary.SummaryDto;
import com.suncode.plugin.plusedoreczenia.service.EDeliveryService;
import com.suncode.plugin.plusedoreczenia.service.ProcessingException;
import com.suncode.plugin.plusedoreczenia.service.ProcessingService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/plusedoreczenia/autotasks/ImportMessagesByIds/pwe_dynamic_form.js")
public class ImportMessagesByIds {
    private static final Logger log = LoggerFactory.getLogger(ImportMessagesByIds.class);
    private final Gson gson = new Gson();
    @Autowired
    private EDeliveryService eDeliveryService;
    @Autowired
    private ProcessingService processingService;
    @Autowired
    private ConfigurationService configurationService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusedoreczenia.autotasks.ImportMessagesByIds")).name("plusedoreczenia.autotasks.ImportMessagesByIds.name")).description("plusedoreczenia.autotasks.ImportMessagesByIds.desc")).category(new Category[]{Categories.PLUS_E_DORECZENIA})).icon((Icon)DivanteIcon.MAIL2)).parameter().id("pcmConfigId").name("plusedoreczenia.autotasks.ImportMessagesByIds.param.pcmConfigId.name").description("plusedoreczenia.autotasks.ImportMessagesByIds.param.pcmConfigId.desc").type((Type)Types.STRING).create()).parameter().id("messageIds").name("plusedoreczenia.autotasks.ImportMessagesByIds.param.messageIds.name").description("plusedoreczenia.autotasks.ImportMessagesByIds.param.messageIds.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("attachmentsDocumentClass").name("plusedoreczenia.autotasks.ImportMessagesByIds.param.attachmentsDocumentClass.name").description("plusedoreczenia.autotasks.ImportMessagesByIds.param.attachmentsDocumentClass.desc").type((Type)Types.STRING).create()).parameter().id("attachmentsDocumentClassIndex").name("plusedoreczenia.autotasks.ImportMessagesByIds.param.attachmentsDocumentClassIndex.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("attachmentsDocumentClassParameter").name("plusedoreczenia.autotasks.ImportMessagesByIds.param.attachmentsDocumentClassParameter.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("generateFileWithMessage").name("plusedoreczenia.autotasks.ImportMessagesByIds.param.generateFileWithMessage.name").description("plusedoreczenia.autotasks.ImportMessagesByIds.param.generateFileWithMessage.desc").type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("messageDocumentClass").name("plusedoreczenia.autotasks.ImportMessagesByIds.param.messageDocumentClass.name").description("plusedoreczenia.autotasks.ImportMessagesByIds.param.messageDocumentClass.desc").type((Type)Types.STRING).optional().create()).parameter().id("messageDocumentClassIndex").name("plusedoreczenia.autotasks.ImportMessagesByIds.param.messageDocumentClassIndex.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("messageDocumentClassParameter").name("plusedoreczenia.autotasks.ImportMessagesByIds.param.messageDocumentClassParameter.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("orderOfAddingDocuments").name("plusedoreczenia.autotasks.ImportMessagesByIds.param.orderOfAddingDocuments.name").description("plusedoreczenia.autotasks.ImportMessagesByIds.param.orderOfAddingDocuments.desc").type((Type)Types.STRING).defaultValue((Object)DocumentsOrder.ATTACHMENTS_FIRST.name()).create();
    }

    public void execute(@Param String pcmConfigId, @Param String[] messageIds, @Param String attachmentsDocumentClass, @PairedParam(key="attachmentsDocumentClassIndex", value="attachmentsDocumentClassParameter") Map<String, String> attachmentIndexesAndParams, @Param Boolean generateFileWithMessage, @Param String messageDocumentClass, @PairedParam(key="messageDocumentClassIndex", value="messageDocumentClassParameter") Map<String, String> messageIndexesAndParams, @Param String orderOfAddingDocuments) {
        EdorConfig edorConfig = this.configurationService.readConfigurationFromPCM(pcmConfigId);
        String accessToken = this.eDeliveryService.getAccessToken(edorConfig);
        DownloadedMessagesDto messageDownloadResult = this.processingService.downloadSelectedMessages(edorConfig, accessToken, Arrays.asList(messageIds));
        ProcessingResultDto processingResult = new ProcessingResultDto();
        for (Message message : messageDownloadResult.getMessages()) {
            try {
                this.processingService.processMessage(edorConfig, attachmentsDocumentClass, attachmentIndexesAndParams, generateFileWithMessage, messageDocumentClass, messageIndexesAndParams, DocumentsOrder.valueOf(orderOfAddingDocuments), message);
                log.info(MessageFormat.format("Successfully processed message with id=\"{0}\"", Objects.requireNonNull(message.getMessageMetadata()).getMessageId()));
                processingResult.getProcessedMessages().add(message);
            }
            catch (ProcessingException e) {
                String messageId = Objects.requireNonNull(message.getMessageMetadata()).getMessageId();
                log.error(MessageFormat.format("Failed to process message with id=\"{0}\"", messageId));
                log.error(e.getMessage(), (Throwable)e);
                processingResult.getFailedMessageIds().add(messageId);
            }
        }
        String summary = this.createDetailedSummary(pcmConfigId, messageDownloadResult, processingResult);
        log.info(summary);
    }

    private String createDetailedSummary(String configId, DownloadedMessagesDto messageDownloadResult, ProcessingResultDto processingResult) {
        SummaryDto summaryDto = SummaryDto.builder().config(configId).downloading(DownloadingSummaryDto.builder().downloaded(messageDownloadResult.getMessages().size()).skipped(messageDownloadResult.getSkippedMessageIds().size()).skippedIds(messageDownloadResult.getSkippedMessageIds()).failed(messageDownloadResult.getFailedMessageIds().size()).failedIds(messageDownloadResult.getFailedMessageIds()).build()).processing(ProcessingSummaryDto.builder().processed(processingResult.getProcessedMessages().size()).failed(processingResult.getFailedMessageIds().size()).failedIds(processingResult.getFailedMessageIds()).build()).build();
        return this.gson.toJson((Object)summaryDto);
    }
}

