/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.suncode.plugin.plusedoreczenia.dto.Evidence;
import com.suncode.plugin.plusedoreczenia.dto.EvidenceWrapper;
import com.suncode.plugin.plusedoreczenia.dto.FileData;
import com.suncode.plugin.plusedoreczenia.dto.FileMetadata;
import com.suncode.plugin.plusedoreczenia.dto.MassageOperationResponseSingleWrapper;
import com.suncode.plugin.plusedoreczenia.dto.MassageOperationResponseSingleWrapperPut;
import com.suncode.plugin.plusedoreczenia.dto.MassageOperationResponseWrapperStatus;
import com.suncode.plugin.plusedoreczenia.dto.Message;
import com.suncode.plugin.plusedoreczenia.dto.MessageInfo;
import com.suncode.plugin.plusedoreczenia.dto.MessageMetadata;
import com.suncode.plugin.plusedoreczenia.dto.MessageTaskStatus;
import com.suncode.plugin.plusedoreczenia.dto.MessagesWrapper;
import com.suncode.plugin.plusedoreczenia.dto.SendDraft;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.EdaConfirmation;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.SearchResponse;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczenia.service.ApiClient;
import com.suncode.plugin.plusedoreczenia.service.EDeliveryException;
import com.suncode.plugin.plusedoreczenia.service.EDeliveryService;
import com.suncode.pwfl.archive.WfFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EDeliveryServiceImpl
implements EDeliveryService {
    private static final Logger log = LoggerFactory.getLogger(EDeliveryServiceImpl.class);
    public static final int MESSAGES_AMOUNT_LIMIT = 100;
    private static final String INBOX_LABEL = "INBOX";
    private static final String FULL_FORMAT = "full";
    private static final String METADATA_FORMAT = "metadata";
    private static final String FULL_EXTENDED_FORMAT = "fullExtended";
    private static final Pattern INVALID_FILENAME_CHARACTERS_PATTERN = Pattern.compile("[~\"#%&*:<>?!/\\\\{}| ]");
    private final Cache<String, SearchResponse> addressDetailsCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(1000L).build();
    @Autowired
    private ApiClient apiClient;

    @Override
    public MessagesWrapper getNewMessages(EdorConfig edorConfig, String accessToken) throws EDeliveryException {
        return this.getNewMessages(edorConfig, accessToken, 0);
    }

    @Override
    public MessagesWrapper getNewMessages(EdorConfig edorConfig, String accessToken, Integer offset) throws EDeliveryException {
        try {
            return this.apiClient.getMessages(edorConfig, accessToken, offset, 100, INBOX_LABEL);
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public MessagesWrapper getUnopenedMessages(EdorConfig edorConfig, String accessToken) throws EDeliveryException {
        return this.getUnopenedMessages(edorConfig, accessToken, 0);
    }

    @Override
    public MessagesWrapper getUnopenedMessages(EdorConfig edorConfig, String accessToken, Integer offset) throws EDeliveryException {
        try {
            return this.apiClient.getMessages(edorConfig, accessToken, offset, 100, INBOX_LABEL, METADATA_FORMAT, false);
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public List<Message> getMessage(EdorConfig edorConfig, String accessToken, String messageId) throws EDeliveryException {
        try {
            return this.apiClient.getMessage(edorConfig, accessToken, messageId, FULL_FORMAT);
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public List<Message> getMessageWithAttachments(EdorConfig edorConfig, String accessToken, String messageId) throws EDeliveryException {
        try {
            List<Message> messageWithAttachments = this.apiClient.getMessage(edorConfig, accessToken, messageId, FULL_EXTENDED_FORMAT);
            messageWithAttachments.forEach(message -> this.ensureMinimalMessageMetadata((Message)message, messageId));
            return messageWithAttachments;
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public MessageInfo sendNewMessage(EdorConfig edorConfig, String accessToken, Message message) throws EDeliveryException {
        try {
            return this.apiClient.sendMessage(edorConfig, accessToken, message);
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public MessageInfo sendNewMessageWithAttachments(EdorConfig edorConfig, String accessToken, Message message, List<WfFile> wfFiles) throws EDeliveryException {
        MassageOperationResponseSingleWrapperPut messageDraft = null;
        try {
            messageDraft = this.apiClient.createMessageDraft(edorConfig, accessToken, message);
            for (WfFile wfFile : wfFiles) {
                Path filePath = Paths.get(wfFile.getFullPath(), new String[0]);
                String fileName = this.sanitizeFileName(wfFile.getFileName());
                FileMetadata fileMetadata = FileMetadata.builder().fileId(UUID.randomUUID()).filename(fileName).contentType(Files.probeContentType(filePath)).build();
                String encodedFileContent = Base64.getMimeEncoder().encodeToString(Files.readAllBytes(filePath)).replaceAll("[\r\n]", "");
                FileData fileData = FileData.builder().fileMetadata(fileMetadata).file(encodedFileContent).build();
                this.apiClient.createAttachment(edorConfig, accessToken, messageDraft.getMessageId(), fileData);
            }
            SendDraft sendDraft = SendDraft.builder().messageId(messageDraft.getMessageId()).build();
            return this.apiClient.sendDraft(edorConfig, accessToken, sendDraft);
        }
        catch (Exception e) {
            if (messageDraft != null) {
                try {
                    this.apiClient.deleteMessageDraft(edorConfig, accessToken, messageDraft.getMessageId());
                }
                catch (Exception ex) {
                    throw new EDeliveryException(ex);
                }
            }
            throw new EDeliveryException(e);
        }
    }

    @Override
    public List<MassageOperationResponseWrapperStatus> checkMessageTaskDetails(EdorConfig edorConfig, String accessToken, String messageTaskId) throws EDeliveryException {
        try {
            return this.apiClient.checkMessageTaskDetails(edorConfig, accessToken, messageTaskId);
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public MessageTaskStatus checkMessageTaskStatus(EdorConfig edorConfig, String accessToken, String messageTaskId) throws EDeliveryException {
        try {
            return this.apiClient.checkMessageTaskStatus(edorConfig, accessToken, messageTaskId);
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public EvidenceWrapper getEvidences(EdorConfig edorConfig, String accessToken, String messageId) throws EDeliveryException {
        try {
            return this.apiClient.getEvidences(edorConfig, accessToken, messageId);
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public byte[] downloadEvidenceFile(EdorConfig edorConfig, String accessToken, Evidence evidence) throws EDeliveryException {
        try {
            return this.apiClient.getEvidenceFile(edorConfig, accessToken, evidence);
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public SearchResponse getAddressDetails(EdorConfig edorConfig, String address) throws EDeliveryException {
        try {
            return (SearchResponse)this.addressDetailsCache.get((Object)address, () -> {
                String accessToken = this.getAccessToken(edorConfig);
                EdaConfirmation edaConfirmation = EdaConfirmation.builder().senderEda(edorConfig.getEDeliveryAddress()).recipientEdas(Collections.singletonList(address)).build();
                try {
                    return this.apiClient.edaConfirmation(edorConfig, accessToken, edaConfirmation);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public List<MassageOperationResponseSingleWrapper> deleteMessages(EdorConfig edorConfig, String accessToken, String[] messageIds) throws EDeliveryException {
        try {
            return this.apiClient.deleteMessages(edorConfig, accessToken, messageIds);
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public List<Message> getMessagesOlderThanDate(EdorConfig edorConfig, String accessToken, OffsetDateTime cutoffDate) throws EDeliveryException {
        try {
            MessagesWrapper messagesWrapper;
            List<Message> messages;
            ArrayList<Message> allMessages = new ArrayList<Message>();
            int offset = 0;
            Integer totalMessages = null;
            String sortDirection = "ASC";
            String sortColumn = "receiptDate";
            while (!CollectionUtils.isEmpty(messages = (messagesWrapper = this.apiClient.getMessages(edorConfig, accessToken, offset, 100, METADATA_FORMAT, null, null, null, null, null, null, null, null, cutoffDate, null, null, null, "receiptDate", "ASC", null)).getMessages())) {
                if (totalMessages == null && messagesWrapper.getTotal() != null) {
                    totalMessages = messagesWrapper.getTotal();
                }
                allMessages.addAll(messages);
                if (messages.size() >= 100 && (totalMessages == null || (offset += messages.size()) < totalMessages)) continue;
                break;
            }
            return allMessages;
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public String getAccessToken(EdorConfig edorConfig) throws EDeliveryException {
        try {
            return this.apiClient.getAccessToken(edorConfig);
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    private void ensureMinimalMessageMetadata(Message message, String messageId) {
        MessageMetadata metadata = message.getMessageMetadata();
        if (metadata == null || metadata.getMessageId() == null) {
            if (metadata == null) {
                metadata = new MessageMetadata();
            }
            if (metadata.getMessageId() == null) {
                metadata.setMessageId(messageId);
            }
            message.setMessageMetadata(metadata);
        }
    }

    private String sanitizeFileName(String fileName) {
        String sanitizedFileName = INVALID_FILENAME_CHARACTERS_PATTERN.matcher(fileName).replaceAll("_");
        return sanitizedFileName.replaceAll("_+", "_");
    }

    public Cache<String, SearchResponse> getAddressDetailsCache() {
        return this.addressDetailsCache;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }
}

