/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.scheduledtasks;

import com.suncode.plugin.plusedoreczenia.Categories;
import com.suncode.plugin.plusedoreczenia.dto.MassageOperationResponseSingleWrapper;
import com.suncode.plugin.plusedoreczenia.dto.Message;
import com.suncode.plugin.plusedoreczenia.dto.MessageMetadata;
import com.suncode.plugin.plusedoreczenia.dto.MessageTypeEnum;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.service.ConfigurationService;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.internal.DeletionResult;
import com.suncode.plugin.plusedoreczenia.service.EDeliveryException;
import com.suncode.plugin.plusedoreczenia.service.EDeliveryService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
@ScheduledTaskScript(value="dist/plusedoreczenia/scheduledtasks/DeleteOldMessages/pwe_dynamic_form.js")
public class DeleteOldMessages {
    private static final Logger log = LoggerFactory.getLogger(DeleteOldMessages.class);
    private static final int MIN_DAYS_TO_KEEP = 7;
    private static final int DELETE_BATCH_MAX_SIZE = 50;
    @Autowired
    private EDeliveryService eDeliveryService;
    @Autowired
    private ConfigurationService configService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("plusedoreczenia.scheduledtasks.DeleteOldMessages")).name("plusedoreczenia.scheduledtasks.DeleteOldMessages.name")).description("plusedoreczenia.scheduledtasks.DeleteOldMessages.desc")).category(new Category[]{Categories.PLUS_E_DORECZENIA})).parameter().id("pcmConfigIds").name("plusedoreczenia.scheduledtasks.DeleteOldMessages.param.pcmConfigIds.name").description("plusedoreczenia.scheduledtasks.DeleteOldMessages.param.pcmConfigIds.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("daysToKeep").name("plusedoreczenia.scheduledtasks.DeleteOldMessages.param.daysToKeep.name").description("plusedoreczenia.scheduledtasks.DeleteOldMessages.param.daysToKeep.desc").type((Type)Types.INTEGER).create();
    }

    public String execute(@Param String[] pcmConfigIds, @Param Integer daysToKeep, org.apache.log4j.Logger taskLog) throws Exception {
        try {
            if (ArrayUtils.isEmpty((Object[])pcmConfigIds)) {
                String error = "No configuration IDs provided";
                taskLog.error((Object)error);
                return error;
            }
            if (daysToKeep == null || daysToKeep < 7) {
                String error = MessageFormat.format("Invalid daysToKeep parameter. Must be at least {0} days.", 7);
                taskLog.error((Object)error);
                return error;
            }
            OffsetDateTime cutoffDate = OffsetDateTime.now(ZoneOffset.UTC).minusDays(daysToKeep.intValue());
            taskLog.info((Object)MessageFormat.format("Deleting messages older than {0}", cutoffDate));
            int totalDeleted = 0;
            int totalFailed = 0;
            for (String configId : pcmConfigIds) {
                taskLog.info((Object)MessageFormat.format("Processing config=\"{0}\"", configId));
                try {
                    List<Message> messages;
                    EdorConfig edorConfig = this.configService.readConfigurationFromPCM(configId);
                    String accessToken = this.eDeliveryService.getAccessToken(edorConfig);
                    try {
                        messages = this.eDeliveryService.getMessagesOlderThanDate(edorConfig, accessToken, cutoffDate);
                    }
                    catch (EDeliveryException e) {
                        String error = MessageFormat.format("Error fetching messages for config \"{0}\": {1}", configId, e.getMessage());
                        taskLog.error((Object)error, (Throwable)e);
                        log.error(MessageFormat.format("Error fetching messages for config \"{0}\"", configId), (Throwable)e);
                        continue;
                    }
                    List<String> messageIds = this.extractMessageIds(messages);
                    if (CollectionUtils.isEmpty(messageIds)) {
                        taskLog.info((Object)MessageFormat.format("No messages to delete for config \"{0}\"", configId));
                        continue;
                    }
                    taskLog.info((Object)MessageFormat.format("Found {0} messages to delete for config \"{1}\"", messageIds.size(), configId));
                    DeletionResult deletionResult = this.deleteMessagesInBatches(edorConfig, accessToken, messageIds, taskLog);
                    String configSummary = MessageFormat.format("Config \"{0}\": Deleted: {1}, Failed: {2}", configId, deletionResult.getDeletedCount(), deletionResult.getFailedCount());
                    taskLog.info((Object)configSummary);
                    totalDeleted += deletionResult.getDeletedCount();
                    totalFailed += deletionResult.getFailedCount();
                }
                catch (Exception e) {
                    String errorMessage = MessageFormat.format("Error processing config \"{0}\": {1}", configId, e.getMessage());
                    taskLog.error((Object)errorMessage, (Throwable)e);
                    log.error(errorMessage, (Throwable)e);
                }
            }
            String finalSummary = MessageFormat.format("Deleted: {0}, Failed: {1}.", totalDeleted, totalFailed);
            taskLog.info((Object)finalSummary);
            return finalSummary;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            throw new AcceptanceException((Throwable)e);
        }
    }

    private List<String> extractMessageIds(List<Message> messages) {
        if (CollectionUtils.isEmpty(messages)) {
            return new ArrayList<String>();
        }
        return messages.stream().filter(m -> m.getMessageControlData() != null && m.getMessageControlData().getMessageType() != MessageTypeEnum.STUB).map(Message::getMessageMetadata).filter(Objects::nonNull).map(MessageMetadata::getMessageId).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private DeletionResult deleteMessagesInBatches(EdorConfig edorConfig, String accessToken, List<String> messageIds, org.apache.log4j.Logger taskLog) {
        int deleted = 0;
        int failed = 0;
        for (int i = 0; i < messageIds.size(); i += 50) {
            int endIndex = Math.min(i + 50, messageIds.size());
            String[] batch = messageIds.subList(i, endIndex).toArray(new String[0]);
            try {
                List<MassageOperationResponseSingleWrapper> deleteResults = this.eDeliveryService.deleteMessages(edorConfig, accessToken, batch);
                Set deletedMessageIds = deleteResults.stream().map(MassageOperationResponseSingleWrapper::getMessageId).filter(Objects::nonNull).collect(Collectors.toSet());
                HashSet<String> requestedMessageIds = new HashSet<String>(Arrays.asList(batch));
                int actuallyDeleted = deletedMessageIds.size();
                int actuallyFailed = requestedMessageIds.size() - actuallyDeleted;
                deleted += actuallyDeleted;
                failed += actuallyFailed;
                if (actuallyFailed > 0) {
                    HashSet<String> failedIds = new HashSet<String>(requestedMessageIds);
                    failedIds.removeAll(deletedMessageIds);
                    String message = MessageFormat.format("Batch deletion: {0} deleted, {1} failed. Failed IDs: {2}", actuallyDeleted, actuallyFailed, String.join((CharSequence)", ", failedIds));
                    taskLog.error((Object)message);
                    log.error(message);
                    continue;
                }
                taskLog.info((Object)MessageFormat.format("Successfully deleted batch of {0} messages", batch.length));
                continue;
            }
            catch (EDeliveryException e) {
                failed += batch.length;
                taskLog.error((Object)MessageFormat.format("Failed to delete batch of {0} messages: {1}", batch.length, e.getMessage()), (Throwable)e);
                log.error(MessageFormat.format("Error deleting messages for config \"{0}\"", edorConfig.getConfigId()), (Throwable)e);
            }
        }
        return new DeletionResult(deleted, failed);
    }
}

