/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.db.service;

import com.google.common.collect.Lists;
import com.plusmpm.database.dbspecific.NativeDatabase;
import com.suncode.plugin.plusedoreczenia.db.dao.MessageHeaderDao;
import com.suncode.plugin.plusedoreczenia.db.entity.MessageHeaderEntity;
import com.suncode.plugin.plusedoreczenia.db.mapper.MessageHeaderMapper;
import com.suncode.plugin.plusedoreczenia.db.service.MessageHeaderService;
import com.suncode.plugin.plusedoreczenia.dto.Message;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MessageHeaderServiceImpl
implements MessageHeaderService {
    @Autowired
    private MessageHeaderDao messageHeaderDao;

    @Override
    public void save(Message message, String processId, EdorConfig edorConfig) {
        MessageHeaderEntity messageHeaderEntity = MessageHeaderMapper.toEntity(message, processId, edorConfig);
        this.messageHeaderDao.save(messageHeaderEntity);
    }

    @Override
    public Set<String> findAlreadyDownloadedMessages(List<String> messageIds) {
        if (messageIds.isEmpty()) {
            return Collections.emptySet();
        }
        int maxNumberOfInClauseParameters = NativeDatabase.getImplementation().getMaxNumberOfInClauseParameters();
        if (messageIds.size() > maxNumberOfInClauseParameters) {
            List partitions = Lists.partition(messageIds, (int)maxNumberOfInClauseParameters);
            return partitions.stream().map(partition -> {
                HibernateCriteria criteria = HibernateCriteria.forClass(MessageHeaderEntity.class);
                criteria.add(Restrictions.in((String)"messageId", (Collection)partition));
                return this.messageHeaderDao.findByCriteria(criteria);
            }).flatMap(Collection::stream).map(MessageHeaderEntity::getMessageId).collect(Collectors.toSet());
        }
        HibernateCriteria criteria = HibernateCriteria.forClass(MessageHeaderEntity.class);
        criteria.add(Restrictions.in((String)"messageId", messageIds));
        return this.messageHeaderDao.findByCriteria(criteria).stream().map(MessageHeaderEntity::getMessageId).collect(Collectors.toSet());
    }
}

