/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.controller.dto;

import com.suncode.pwfl.workflow.process.ProcessType;
import java.beans.ConstructorProperties;

public class ProcessDto {
    private String name;
    private String processDefinitionId;

    public static ProcessDto fromEntity(ProcessType processType) {
        return ProcessDto.builder().name(processType.getName()).processDefinitionId(processType.getProcessDefId()).build();
    }

    @ConstructorProperties(value={"name", "processDefinitionId"})
    ProcessDto(String name, String processDefinitionId) {
        this.name = name;
        this.processDefinitionId = processDefinitionId;
    }

    public static ProcessDtoBuilder builder() {
        return new ProcessDtoBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public static class ProcessDtoBuilder {
        private String name;
        private String processDefinitionId;

        ProcessDtoBuilder() {
        }

        public ProcessDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ProcessDtoBuilder processDefinitionId(String processDefinitionId) {
            this.processDefinitionId = processDefinitionId;
            return this;
        }

        public ProcessDto build() {
            return new ProcessDto(this.name, this.processDefinitionId);
        }

        public String toString() {
            return "ProcessDto.ProcessDtoBuilder(name=" + this.name + ", processDefinitionId=" + this.processDefinitionId + ")";
        }
    }
}

