/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.autotasks;

import com.suncode.plugin.plusedoreczenia.AddressDetailsKeysImpl;
import com.suncode.plugin.plusedoreczenia.Categories;
import com.suncode.plugin.plusedoreczenia.dto.searchengine.SearchResponse;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.service.ConfigurationService;
import com.suncode.plugin.plusedoreczenia.service.EDeliveryService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/plusedoreczenia/autotasks/FindAddressDetailsApp/pwe_dynamic_form.js")
public class FindAddressDetailsApp {
    private static final Logger log = LoggerFactory.getLogger(FindAddressDetailsApp.class);
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private EDeliveryService eDeliveryService;

    @Define
    public void action(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusedoreczenia.autotasks.FindAddressDetailsApp")).name("plusedoreczenia.autotasks.FindAddressDetailsApp.name")).description("plusedoreczenia.autotasks.FindAddressDetailsApp.desc")).icon((Icon)DivanteIcon.SEARCH)).category(new Category[]{Categories.PLUS_E_DORECZENIA})).parameter().id("pcmConfigId").name("plusedoreczenia.autotasks.FindAddressDetailsApp.param.pcmConfigId.name").description("plusedoreczenia.autotasks.FindAddressDetailsApp.param.pcmConfigId.desc").type((Type)Types.STRING).create()).parameter().id("searchedAddress").name("plusedoreczenia.autotasks.FindAddressDetailsApp.param.searchedAddress.name").description("plusedoreczenia.autotasks.FindAddressDetailsApp.param.searchedAddress.desc").type((Type)Types.STRING).create()).parameter().id("variableToSet").name("plusedoreczenia.autotasks.FindAddressDetailsApp.param.variableToSet.name").description("plusedoreczenia.autotasks.FindAddressDetailsApp.param.variableToSet.desc").type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("valueToSet").name("plusedoreczenia.autotasks.FindAddressDetailsApp.param.valueToSet.name").description("plusedoreczenia.autotasks.FindAddressDetailsApp.param.valueToSet.desc").type((Type)Types.STRING_ARRAY).create();
    }

    public void execute(@Param String pcmConfigId, @Param String searchedAddress, @PairedParam(key="variableToSet", value="valueToSet") Map<Variable, String> variableToAddressKeyMap) throws AcceptanceException {
        try {
            EdorConfig edorConfig = this.configService.readConfigurationFromPCM(pcmConfigId);
            SearchResponse searchResponse = this.eDeliveryService.getAddressDetails(edorConfig, searchedAddress);
            for (Map.Entry<Variable, String> variableAddressKeyEntry : variableToAddressKeyMap.entrySet()) {
                Variable variable = variableAddressKeyEntry.getKey();
                String addressKey = variableAddressKeyEntry.getValue();
                AddressDetailsKeysImpl addressDetailsKey = AddressDetailsKeysImpl.getByKey(addressKey);
                if (addressDetailsKey != null) {
                    Object value = addressDetailsKey.getValue(searchResponse);
                    if (value != null) {
                        variable.setValue(variable.getType().convert(value.toString()));
                        continue;
                    }
                    variable.setValue(null);
                    continue;
                }
                log.warn("Unknown AddressDetailsKey: '{}' for variable: '{}'", (Object)addressKey, (Object)variable.getName());
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }
}

