/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.service;

import com.google.common.collect.Iterables;
import com.google.common.io.ByteSource;
import com.plusmpm.util.XpdlPackageManager;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.plusedoreczenia.EdorKeysImpl;
import com.suncode.plugin.plusedoreczenia.PcmKeysImpl;
import com.suncode.plugin.plusedoreczenia.db.entity.MessageEntity;
import com.suncode.plugin.plusedoreczenia.db.entity.SentMessageEntity;
import com.suncode.plugin.plusedoreczenia.db.service.MessageHeaderService;
import com.suncode.plugin.plusedoreczenia.db.service.MessageService;
import com.suncode.plugin.plusedoreczenia.db.service.SentMessageService;
import com.suncode.plugin.plusedoreczenia.dto.Attachment;
import com.suncode.plugin.plusedoreczenia.dto.Evidence;
import com.suncode.plugin.plusedoreczenia.dto.EvidenceTypeEnum;
import com.suncode.plugin.plusedoreczenia.dto.EvidenceWrapper;
import com.suncode.plugin.plusedoreczenia.dto.FileMetadata;
import com.suncode.plugin.plusedoreczenia.dto.MassageOperationResponseWrapperStatus;
import com.suncode.plugin.plusedoreczenia.dto.Message;
import com.suncode.plugin.plusedoreczenia.dto.MessageAddressData;
import com.suncode.plugin.plusedoreczenia.dto.MessageControlData;
import com.suncode.plugin.plusedoreczenia.dto.MessageInfo;
import com.suncode.plugin.plusedoreczenia.dto.MessageMetadata;
import com.suncode.plugin.plusedoreczenia.dto.MessageTaskStatusEnum;
import com.suncode.plugin.plusedoreczenia.dto.MessageTypeEnum;
import com.suncode.plugin.plusedoreczenia.dto.MessagesWrapper;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.service.ConfigurationService;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.DocumentsOrder;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.UpoFormat;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.UpoType;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.DownloadedMessagesDto;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.MessageReceiptDateUpdateResult;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.sending.SentMessageStatus;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.sending.SuccessCriteria;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.upo.UpoStatus;
import com.suncode.plugin.plusedoreczenia.service.EDeliveryException;
import com.suncode.plugin.plusedoreczenia.service.EDeliveryService;
import com.suncode.plugin.plusedoreczenia.service.ProcessingException;
import com.suncode.plugin.plusedoreczenia.service.ProcessingService;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.IndexInfo;
import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.core.type.DateTimeType;
import com.suncode.pwfl.core.type.DateType;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.util.ProcessBuilderDefinition;
import com.suncode.pwfl.workflow.variable.Variable;
import com.suncode.pwfl.workflow.variable.VariableFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Package;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional
public class ProcessingServiceImpl
implements ProcessingService {
    private static final Logger log = LoggerFactory.getLogger(ProcessingServiceImpl.class);
    public static final String ARRAY_VALUES_SEPARATOR = ";";
    private static final DateTimeFormatter CONTEXT_DATE_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static final String UPO_ALREADY_EXISTS = "The UPO document has already been downloaded.";
    private static final String UPO_NOT_GENERATED_YET = "The UPO document has not been generated yet.";
    private static final String ADMIN_USERNAME = "admin";
    @Autowired
    private MessageService messageService;
    @Autowired
    private MessageHeaderService messageHeaderService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private SentMessageService sentMessageService;
    @Autowired
    private EDeliveryService eDeliveryService;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentClassActionService documentClassActionService;
    @Autowired
    private DocumentClassIndexFinder documentClassIndexFinder;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private VariableFactory variableFactory;
    @Autowired
    private ProcessService processService;

    @Override
    public void processMessage(EdorConfig edorConfig, String attachmentsDocumentClass, Map<String, String> attachmentIndexesAndParams, Boolean generateFileWithMessage, String messageDocumentClass, Map<String, String> messageIndexesAndParams, DocumentsOrder orderOfAddingDocuments, Message message) throws ProcessingException {
        try {
            List<Attachment> attachments = message.getAttachments();
            DocumentClass attachmentDocClass = this.documentClassService.getDocumentClass(attachmentsDocumentClass, new String[0]);
            List attachmentIndexes = this.documentClassIndexFinder.findByDocumentClass(attachmentDocClass.getId());
            if (Boolean.FALSE.equals(generateFileWithMessage)) {
                this.addAttachmentsToArchive(edorConfig, attachmentIndexesAndParams, message, attachments, attachmentDocClass, attachmentIndexes);
            } else {
                DocumentClass messageDocClass = this.documentClassService.getDocumentClass(messageDocumentClass, new String[0]);
                List messageDocClassIndexes = this.documentClassIndexFinder.findByDocumentClass(messageDocClass.getId());
                if (orderOfAddingDocuments == DocumentsOrder.ATTACHMENTS_FIRST) {
                    this.addAttachmentsToArchive(edorConfig, attachmentIndexesAndParams, message, attachments, attachmentDocClass, attachmentIndexes);
                    this.addTextMessageAsAttachmentToArchive(edorConfig, messageIndexesAndParams, message, messageDocClass, messageDocClassIndexes);
                } else {
                    this.addTextMessageAsAttachmentToArchive(edorConfig, messageIndexesAndParams, message, messageDocClass, messageDocClassIndexes);
                    this.addAttachmentsToArchive(edorConfig, attachmentIndexesAndParams, message, attachments, attachmentDocClass, attachmentIndexes);
                }
            }
            this.messageService.save(edorConfig, message);
        }
        catch (Exception e) {
            ProcessingException processingException = new ProcessingException(this.getExceptionMessage(e), e);
            log.error(e.getMessage(), (Throwable)e);
            throw processingException;
        }
    }

    @Override
    public void sendNewMessage(EdorConfig edorConfig, Message message, Boolean attachMessageContext, String messageIdForContext, String processId, List<WfFile> attachments) throws ProcessingException {
        try {
            String accessToken = this.eDeliveryService.getAccessToken(edorConfig);
            if (Boolean.TRUE.equals(attachMessageContext)) {
                this.addMessageContext(edorConfig, message, messageIdForContext, accessToken);
            }
            MessageInfo messageInfo = attachments.isEmpty() ? this.eDeliveryService.sendNewMessage(edorConfig, accessToken, message) : this.eDeliveryService.sendNewMessageWithAttachments(edorConfig, accessToken, message, attachments);
            this.sentMessageService.save(message, messageInfo.getMessageTaskId(), processId, edorConfig.getConfigId());
        }
        catch (Exception e) {
            ProcessingException processingException = new ProcessingException(this.getExceptionMessage(e), e);
            log.error(e.getMessage(), (Throwable)e);
            throw processingException;
        }
    }

    private void addMessageContext(EdorConfig edorConfig, Message message, String messageIdForContext, String accessToken) throws ProcessingException {
        Message messageContext;
        try {
            messageContext = this.eDeliveryService.getMessage(edorConfig, accessToken, messageIdForContext).get(0);
        }
        catch (Exception e) {
            throw new ProcessingException(MessageFormat.format("Could not access context for messageId=\"{0}\".", messageIdForContext), e);
        }
        MessageAddressData messageContextFrom = messageContext.getMessageMetadata() != null ? messageContext.getMessageMetadata().getFrom() : null;
        MessageAddressData messageContextTo = messageContext.getMessageMetadata() != null ? (MessageAddressData)Iterables.get((Iterable)Objects.requireNonNull(messageContext.getMessageMetadata().getTo()), (int)0, null) : null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n \n \n -------- Odpowied\u017a na wiadomo\u015b\u0107 -------- \n");
        stringBuilder.append(MessageFormat.format("Od: {0}\n", messageContextFrom != null ? messageContextFrom.getEDeliveryAddress() : null));
        stringBuilder.append(MessageFormat.format("Do: {0}\n", messageContextTo != null ? messageContextTo.getEDeliveryAddress() : null));
        if (messageContext.getMessageMetadata() != null) {
            if (messageContext.getMessageMetadata().getTimestamp() != null) {
                stringBuilder.append(MessageFormat.format("Data wys\u0142ania: {0}\n", messageContext.getMessageMetadata().getTimestamp().format(CONTEXT_DATE_FORMATTER)));
            }
            if (messageContext.getMessageMetadata().getReceiptDate() != null) {
                stringBuilder.append(MessageFormat.format("Data dor\u0119czenia: {0}\n", messageContext.getMessageMetadata().getReceiptDate().format(CONTEXT_DATE_FORMATTER)));
            }
        }
        if (messageContext.getTextBody() != null) {
            stringBuilder.append(messageContext.getTextBody());
        }
        stringBuilder.append("\n------------------------");
        String context = stringBuilder.toString();
        message.setTextBody(message.getTextBody() + context);
    }

    @Override
    public List<MassageOperationResponseWrapperStatus> getStatusOfSentMessages(EdorConfig edorConfig, String messageTaskId) throws ProcessingException {
        try {
            String accessToken = this.eDeliveryService.getAccessToken(edorConfig);
            return this.eDeliveryService.checkMessageTaskDetails(edorConfig, accessToken, messageTaskId);
        }
        catch (Exception e) {
            ProcessingException processingException = new ProcessingException(this.getExceptionMessage(e), e);
            log.error(e.getMessage(), (Throwable)e);
            throw processingException;
        }
    }

    @Override
    public SentMessageStatus updateSentMessageStatus(String successActionName, String errorActionName, String statusOutputVariable, String messageIdOutputVariable, String receiptDateOutputVariable, String threadIdOutputVariable, SuccessCriteria criteria, Activity activity, org.apache.log4j.Logger taskLog) throws ProcessingException {
        try {
            taskLog.debug((Object)MessageFormat.format("Analysing activity \"{0}\".", activity.getActivityId()));
            SentMessageEntity sentMessageEntity = this.sentMessageService.findByProcessId(activity.getProcessId());
            EdorConfig edorConfig = this.configurationService.readConfigurationFromPCM(sentMessageEntity.getPcmConfigId());
            String accessToken = this.eDeliveryService.getAccessToken(edorConfig);
            MessageTaskStatusEnum messageTaskStatus = this.eDeliveryService.checkMessageTaskStatus(edorConfig, accessToken, sentMessageEntity.getMessageTaskId()).getMessageTaskStatus();
            if (messageTaskStatus.equals((Object)MessageTaskStatusEnum.FINISHED)) {
                taskLog.debug((Object)MessageFormat.format("Message task \"{0}\" has been processed.", sentMessageEntity.getMessageTaskId()));
                MassageOperationResponseWrapperStatus messageStatus = this.getStatusOfSentMessages(edorConfig, sentMessageEntity.getMessageTaskId()).get(0);
                String messageId = messageStatus.getMessageId();
                if (StringUtils.isBlank((CharSequence)sentMessageEntity.getMessageId()) && StringUtils.isNotBlank((CharSequence)messageId)) {
                    sentMessageEntity.setMessageId(messageId);
                    this.sentMessageService.update(sentMessageEntity);
                }
                if (StringUtils.isNotBlank((CharSequence)messageStatus.getError())) {
                    String status = MessageFormat.format("{0}: {1}", messageStatus.getError(), messageStatus.getErrorDescription());
                    HashMap<String, Object> contextMap = new HashMap<String, Object>();
                    Map<String, Variable> activityContextVariablesMap = this.getActivityContextVariableMap(activity);
                    this.setContextMapVariable(contextMap, activityContextVariablesMap, statusOutputVariable, status);
                    taskLog.error((Object)MessageFormat.format("Error occurred during processing task \"{0}\". Message could not be sent! Reason: {1}", sentMessageEntity.getMessageTaskId(), status));
                    this.acceptActivity(activity.getProcessId(), activity.getActivityId(), contextMap, errorActionName);
                    return SentMessageStatus.ERROR;
                }
                Message message = this.eDeliveryService.getMessage(edorConfig, accessToken, messageId).get(0);
                boolean successCriteriaMet = this.checkIfSuccessCriteriaMet(message, criteria);
                if (successCriteriaMet) {
                    taskLog.debug((Object)"Success criteria have been met.");
                    MessageControlData messageControlData = Objects.requireNonNull(message.getMessageControlData());
                    if (message.getMessageMetadata() != null) {
                        if (message.getMessageMetadata().getTimestamp() != null) {
                            sentMessageEntity.setTimestamp(Timestamp.from(message.getMessageMetadata().getTimestamp().toInstant()));
                        }
                        if (message.getMessageMetadata().getReceiptDate() != null) {
                            sentMessageEntity.setReceiptDate(Timestamp.from(message.getMessageMetadata().getReceiptDate().toInstant()));
                        }
                        if (message.getMessageMetadata().getThreadId() != null) {
                            sentMessageEntity.setThreadId(message.getMessageMetadata().getThreadId());
                        }
                        if (messageControlData.getStatus() != null) {
                            sentMessageEntity.setStatus(messageControlData.getStatus());
                        }
                        this.sentMessageService.update(sentMessageEntity);
                    }
                    String status = this.getStatusDescription(messageControlData);
                    HashMap<String, Object> contextMap = new HashMap<String, Object>();
                    Map<String, Variable> activityContextVariableMap = this.getActivityContextVariableMap(activity);
                    this.setContextMapVariable(contextMap, activityContextVariableMap, statusOutputVariable, status);
                    this.setContextMapVariable(contextMap, activityContextVariableMap, messageIdOutputVariable, messageId);
                    this.setContextMapVariable(contextMap, activityContextVariableMap, receiptDateOutputVariable, sentMessageEntity.getReceiptDate());
                    this.setContextMapVariable(contextMap, activityContextVariableMap, threadIdOutputVariable, sentMessageEntity.getThreadId());
                    this.acceptActivity(activity.getProcessId(), activity.getActivityId(), contextMap, successActionName);
                    return SentMessageStatus.COMPLETED;
                }
                if (this.checkIfErrorOccurred(message)) {
                    MessageControlData messageControlData = Objects.requireNonNull(message.getMessageControlData());
                    String status = this.getStatusDescription(messageControlData);
                    HashMap<String, Object> contextMap = new HashMap<String, Object>();
                    Map<String, Variable> activityContextVariableMap = this.getActivityContextVariableMap(activity);
                    this.setContextMapVariable(contextMap, activityContextVariableMap, statusOutputVariable, status);
                    this.setContextMapVariable(contextMap, activityContextVariableMap, messageIdOutputVariable, messageId);
                    this.acceptActivity(activity.getProcessId(), activity.getActivityId(), contextMap, errorActionName);
                    String errorDescription = MessageFormat.format("Error occurred after the message \"{0}\" was created. Details: {1}", sentMessageEntity.getMessageId(), status);
                    taskLog.error((Object)errorDescription);
                    log.error(errorDescription);
                    return SentMessageStatus.ERROR;
                }
                taskLog.debug((Object)MessageFormat.format("Message \"{0}\" was accepted, but it has not reached the required success/error criteria yet.", sentMessageEntity.getMessageId()));
                return SentMessageStatus.PENDING;
            }
            taskLog.debug((Object)MessageFormat.format("Message task \"{0}\" has not been processed yet.", sentMessageEntity.getMessageTaskId()));
            return SentMessageStatus.PENDING;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ProcessingException(this.getExceptionMessage(e), e);
        }
    }

    private Map<String, Variable> getActivityContextVariableMap(Activity activity) {
        Map activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
        return this.variableFactory.createVariables(activity.getProcessId(), activity.getActivityId(), activityContext, true);
    }

    @Override
    public UpoStatus downloadUpo(Activity activity, UpoType upoType, UpoFormat upoFormat, String actionId, String documentClass, String documentClassIndexForEvidenceType, String documentClassIndexForMessageId, Boolean executeDocumentClassActions, org.apache.log4j.Logger taskLog) throws ProcessingException {
        try {
            taskLog.debug((Object)MessageFormat.format("Analysing process \"{0}\" and activity \"{1}\".", activity.getProcessId(), activity.getActivityId()));
            SentMessageEntity sentMessageEntity = this.sentMessageService.findByProcessId(activity.getProcessId());
            taskLog.debug((Object)MessageFormat.format("Analysing message \"{0}\".", sentMessageEntity.getMessageId()));
            EdorConfig edorConfig = this.configurationService.readConfigurationFromPCM(sentMessageEntity.getPcmConfigId());
            String accessToken = this.eDeliveryService.getAccessToken(edorConfig);
            if (upoType.equals((Object)UpoType.SUBMISSION) && upoFormat.equals((Object)UpoFormat.PDF)) {
                if (sentMessageEntity.getSubmissionUpoPdfId() != null) {
                    log.error(UPO_ALREADY_EXISTS);
                    taskLog.error((Object)UPO_ALREADY_EXISTS);
                    return UpoStatus.ERROR;
                }
                EvidenceTypeEnum evidenceTypeToDownload = EvidenceTypeEnum.BP_WP;
                Optional<Evidence> evidence = this.findEvidence(sentMessageEntity, edorConfig, accessToken, evidenceTypeToDownload);
                if (!evidence.isPresent()) {
                    taskLog.debug((Object)UPO_NOT_GENERATED_YET);
                    return UpoStatus.PENDING;
                }
                WfDocument addedDocument = this.importUpoDocument(activity, edorConfig, accessToken, documentClassIndexForMessageId, executeDocumentClassActions, evidence.get(), upoFormat, documentClass, documentClassIndexForEvidenceType);
                sentMessageEntity.setSubmissionUpoPdfId(evidence.get().getEvidenceId());
                sentMessageEntity.setSubmissionUpoPdfFileId(addedDocument.getFile().getId());
                this.sentMessageService.update(sentMessageEntity);
                Map activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
                this.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, actionId);
                return UpoStatus.SUCCESS;
            }
            if (upoType.equals((Object)UpoType.SUBMISSION) && upoFormat.equals((Object)UpoFormat.XML)) {
                if (sentMessageEntity.getSubmissionUpoXmlId() != null) {
                    log.error(UPO_ALREADY_EXISTS);
                    taskLog.error((Object)UPO_ALREADY_EXISTS);
                    return UpoStatus.ERROR;
                }
                EvidenceTypeEnum evidenceTypeToDownload = EvidenceTypeEnum.BP_WX;
                Optional<Evidence> evidence = this.findEvidence(sentMessageEntity, edorConfig, accessToken, evidenceTypeToDownload);
                if (!evidence.isPresent()) {
                    taskLog.debug((Object)UPO_NOT_GENERATED_YET);
                    return UpoStatus.PENDING;
                }
                WfDocument addedDocument = this.importUpoDocument(activity, edorConfig, accessToken, documentClassIndexForMessageId, executeDocumentClassActions, evidence.get(), upoFormat, documentClass, documentClassIndexForEvidenceType);
                sentMessageEntity.setSubmissionUpoXmlId(evidence.get().getEvidenceId());
                sentMessageEntity.setSubmissionUpoXmlFileId(addedDocument.getFile().getId());
                this.sentMessageService.update(sentMessageEntity);
                Map activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
                this.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, actionId);
                return UpoStatus.SUCCESS;
            }
            if (upoType.equals((Object)UpoType.DELIVERY) && upoFormat.equals((Object)UpoFormat.PDF)) {
                if (sentMessageEntity.getDeliveryUpoPdfId() != null) {
                    log.error(UPO_ALREADY_EXISTS);
                    taskLog.error((Object)UPO_ALREADY_EXISTS);
                    return UpoStatus.ERROR;
                }
                EvidenceTypeEnum evidenceTypeToDownload = EvidenceTypeEnum.BP_OP;
                Optional<Evidence> evidence = this.findEvidence(sentMessageEntity, edorConfig, accessToken, evidenceTypeToDownload);
                if (!evidence.isPresent()) {
                    taskLog.debug((Object)UPO_NOT_GENERATED_YET);
                    return UpoStatus.PENDING;
                }
                WfDocument addedDocument = this.importUpoDocument(activity, edorConfig, accessToken, documentClassIndexForMessageId, executeDocumentClassActions, evidence.get(), upoFormat, documentClass, documentClassIndexForEvidenceType);
                sentMessageEntity.setDeliveryUpoPdfId(evidence.get().getEvidenceId());
                sentMessageEntity.setDeliveryUpoPdfFileId(addedDocument.getFile().getId());
                this.sentMessageService.update(sentMessageEntity);
                Map activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
                this.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, actionId);
                return UpoStatus.SUCCESS;
            }
            if (upoType.equals((Object)UpoType.DELIVERY) && upoFormat.equals((Object)UpoFormat.XML)) {
                if (sentMessageEntity.getDeliveryUpoXmlId() != null) {
                    log.error(UPO_ALREADY_EXISTS);
                    taskLog.error((Object)UPO_ALREADY_EXISTS);
                    return UpoStatus.ERROR;
                }
                EvidenceTypeEnum evidenceTypeToDownload = EvidenceTypeEnum.BP_OX;
                Optional<Evidence> evidence = this.findEvidence(sentMessageEntity, edorConfig, accessToken, evidenceTypeToDownload);
                if (!evidence.isPresent()) {
                    taskLog.debug((Object)UPO_NOT_GENERATED_YET);
                    return UpoStatus.PENDING;
                }
                WfDocument addedDocument = this.importUpoDocument(activity, edorConfig, accessToken, documentClassIndexForMessageId, executeDocumentClassActions, evidence.get(), upoFormat, documentClass, documentClassIndexForEvidenceType);
                sentMessageEntity.setDeliveryUpoXmlId(evidence.get().getEvidenceId());
                sentMessageEntity.setDeliveryUpoXmlFileId(addedDocument.getFile().getId());
                this.sentMessageService.update(sentMessageEntity);
                Map activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
                this.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, actionId);
                return UpoStatus.SUCCESS;
            }
            String message = "Unknown type and format criteria.";
            log.error(message);
            taskLog.error((Object)message);
            return UpoStatus.ERROR;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ProcessingException(this.getExceptionMessage(e), e);
        }
    }

    private WfDocument importUpoDocument(Activity activity, EdorConfig edorConfig, String accessToken, String documentClassIndexForMessageId, Boolean executeDocumentClassActions, Evidence evidence, UpoFormat upoFormat, String documentClass, String documentClassIndexForEvidenceType) throws IOException, EDeliveryException {
        DocumentClassIndex documentClassIndex;
        DocumentClass docClass = this.documentClassService.getDocumentClass(documentClass, new String[0]);
        List documentClassIndexList = this.documentClassIndexFinder.findByDocumentClass(docClass.getId());
        HashMap<Long, String> indexes = new HashMap<Long, String>();
        if (StringUtils.isNotBlank((CharSequence)documentClassIndexForEvidenceType)) {
            documentClassIndex = this.findDocumentClassIndex(documentClassIndexForEvidenceType, docClass, documentClassIndexList);
            indexes.put(documentClassIndex.getId(), Objects.requireNonNull(evidence.getType()).getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)documentClassIndexForMessageId)) {
            documentClassIndex = this.findDocumentClassIndex(documentClassIndexForMessageId, docClass, documentClassIndexList);
            indexes.put(documentClassIndex.getId(), evidence.getMessageId());
        }
        String filename = MessageFormat.format("{0}.{1}", evidence.getEvidenceId(), upoFormat.toString().toLowerCase(Locale.ROOT));
        byte[] fileContent = this.eDeliveryService.downloadEvidenceFile(edorConfig, accessToken, evidence);
        try (InputStream inputStream = ByteSource.wrap((byte[])fileContent).openStream();){
            DocumentDefinition definition = new DocumentDefinition();
            definition.setDocumentClassId(docClass.getId());
            definition.setFileName(filename);
            definition.setUserName(ADMIN_USERNAME);
            definition.setIndexes(indexes);
            definition.setInputStream(inputStream);
            WfDocument addedDocument = this.documentService.addDocument(definition);
            this.documentService.attachDocumentToProcess(addedDocument, ADMIN_USERNAME, activity.getProcessId(), activity.getActivityId());
            if (Boolean.TRUE.equals(executeDocumentClassActions)) {
                this.documentClassActionService.executeArchiveActions(addedDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
            }
            WfDocument wfDocument = addedDocument;
            return wfDocument;
        }
    }

    private DocumentClassIndex findDocumentClassIndex(String indexName, DocumentClass docClass, List<DocumentClassIndex> documentClassIndexList) {
        return documentClassIndexList.stream().filter(index -> index.getName().equals(indexName)).findFirst().orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("Could not find index \"{0}\" in document class \"{1}\".", indexName, docClass.getName())));
    }

    private Optional<Evidence> findEvidence(SentMessageEntity sentMessageEntity, EdorConfig edorConfig, String accessToken, EvidenceTypeEnum evidenceTypeToDownload) throws EDeliveryException {
        EvidenceWrapper evidences = this.eDeliveryService.getEvidences(edorConfig, accessToken, sentMessageEntity.getMessageId());
        return Objects.requireNonNull(evidences.getEvidences()).stream().filter(evidence -> evidence.getType() != null).filter(evidence -> evidence.getType().equals((Object)evidenceTypeToDownload)).findFirst();
    }

    private String getStatusDescription(MessageControlData messageControlData) {
        try {
            String status = Objects.requireNonNull(messageControlData.getStatus()).getValue();
            if (StringUtils.isNotBlank((CharSequence)messageControlData.getStatusDescription())) {
                status = status + ": " + messageControlData.getStatusDescription();
            }
            return status;
        }
        catch (Exception e) {
            log.error("Could not extract status message", (Throwable)e);
            return "";
        }
    }

    private void setContextMapVariable(Map<String, Object> contextMap, Map<String, Variable> activityContextVariableMap, String variableId, Object value) {
        Variable variable;
        if (StringUtils.isNotBlank((CharSequence)variableId) && value != null && (variable = activityContextVariableMap.get(variableId)) != null) {
            Object valueToSet = variable.getType() instanceof DateType && value instanceof Timestamp ? variable.getType().convert(((Timestamp)value).toLocalDateTime().format(DateTimeFormatter.ISO_LOCAL_DATE)).toString() : (variable.getType() instanceof DateTimeType && value instanceof Timestamp ? value : variable.getType().convert(value.toString()));
            contextMap.put(variableId, valueToSet);
        }
    }

    private boolean checkIfErrorOccurred(Message message) {
        return Objects.requireNonNull(message.getEvidences()).stream().anyMatch(evidence -> {
            EvidenceTypeEnum type = evidence.getType();
            if (type != null) {
                return type.equals((Object)EvidenceTypeEnum.A_2) || type.equals((Object)EvidenceTypeEnum.D_2) || type.equals((Object)EvidenceTypeEnum.E_2);
            }
            return false;
        });
    }

    private void addTextMessageAsAttachmentToArchive(EdorConfig edorConfig, Map<String, String> messageIndexesAndParams, Message newMessage, DocumentClass messageDocClass, List<DocumentClassIndex> indexes) throws IOException {
        String filename = Objects.requireNonNull(newMessage.getMessageMetadata()).getMessageId() + ".txt";
        byte[] textBody = Objects.requireNonNull(newMessage.getTextBody()).getBytes(StandardCharsets.UTF_8);
        InputStream inputStream = ByteSource.wrap((byte[])textBody).openStream();
        DocumentDefinition attachmentDocumentDefinition = this.createAttachmentDocumentDefinition(edorConfig, newMessage, filename, null, inputStream, messageIndexesAndParams, messageDocClass, indexes);
        WfDocument document = this.documentService.addDocument(attachmentDocumentDefinition);
        this.documentClassActionService.executeArchiveActions(document, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
    }

    private void addAttachmentsToArchive(EdorConfig edorConfig, Map<String, String> attachmentIndexesAndParams, Message newMessage, List<Attachment> attachments, DocumentClass documentClass, List<DocumentClassIndex> attachmentIndexes) throws IOException {
        if (attachments != null) {
            for (Attachment attachment : attachments) {
                DocumentDefinition attachmentDocumentDefinition = this.createAttachmentDocumentDefinition(edorConfig, newMessage, attachment, attachmentIndexesAndParams, documentClass, attachmentIndexes);
                WfDocument document = this.documentService.addDocument(attachmentDocumentDefinition);
                this.documentClassActionService.executeArchiveActions(document, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
            }
        }
    }

    @NotNull
    private DocumentDefinition createAttachmentDocumentDefinition(EdorConfig edorConfig, Message newMessage, Attachment attachment, Map<String, String> attachmentIndexesAndParams, DocumentClass documentClass, List<DocumentClassIndex> indexes) throws IOException {
        String filename = Objects.requireNonNull(Objects.requireNonNull(attachment.getFile()).getFileMetadata()).getFilename();
        String file = attachment.getFile().getFile();
        FileMetadata fileMetadata = attachment.getFile().getFileMetadata();
        String description = null;
        if (fileMetadata != null) {
            description = fileMetadata.getDescription();
        }
        byte[] decoded = Base64.getMimeDecoder().decode(file);
        InputStream inputStream = ByteSource.wrap((byte[])decoded).openStream();
        return this.createAttachmentDocumentDefinition(edorConfig, newMessage, filename, description, inputStream, attachmentIndexesAndParams, documentClass, indexes);
    }

    @NotNull
    private DocumentDefinition createAttachmentDocumentDefinition(EdorConfig edorConfig, Message newMessage, String fileName, String description, InputStream fileInputStream, Map<String, String> attachmentIndexesAndParams, DocumentClass documentClass, List<DocumentClassIndex> indexes) {
        HashMap<Long, Object> idx = new HashMap<Long, Object>();
        for (Map.Entry<String, String> entry : attachmentIndexesAndParams.entrySet()) {
            DocumentClassIndex documentClassIndex;
            Object value = null;
            Enum keyParam = EdorKeysImpl.getByKey(entry.getValue());
            if (keyParam != null) {
                keyParam = EdorKeysImpl.getByKey(entry.getValue());
                value = keyParam.getValue(newMessage);
            } else {
                keyParam = PcmKeysImpl.getByKey(entry.getValue());
                if (keyParam == null) {
                    throw new IllegalArgumentException("Could not find index \"" + entry.getValue() + "\".");
                }
                value = keyParam.getValue(edorConfig);
            }
            if ((documentClassIndex = indexes.stream().filter(index -> index.getName().equals(entry.getKey())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Could not find index \"%s\" in document class \"%s\"", entry.getKey(), documentClass.getName())))) == null) continue;
            if (documentClassIndex.getType().equals((Object)IndexType.DATETIME) && value instanceof OffsetDateTime) {
                String timestamp = Timestamp.from(((OffsetDateTime)value).toInstant()).toString();
                idx.put(documentClassIndex.getId(), timestamp);
                continue;
            }
            if (keyParam.getType().equals((Object)Types.STRING_ARRAY) && value instanceof String[]) {
                idx.put(documentClassIndex.getId(), StringUtils.join((Object[])((String[])value), (String)ARRAY_VALUES_SEPARATOR));
                continue;
            }
            idx.put(documentClassIndex.getId(), value);
        }
        DocumentDefinition definition = new DocumentDefinition();
        definition.setDocumentClassId(documentClass.getId());
        definition.setFileName(fileName);
        if (description != null) {
            definition.setDescription(description);
        }
        definition.setUserName(ADMIN_USERNAME);
        definition.setIndexes(idx);
        definition.setInputStream(fileInputStream);
        return definition;
    }

    private void acceptActivity(String processId, String activityId, Map<String, Object> activityContextMap, String actionName) {
        String executorLogin = SystemProperties.getString((String)"Bufor.username");
        AcceptationDefinition acceptationDefinition = new AcceptationDefinition(processId, activityId, executorLogin, actionName);
        acceptationDefinition.setIgnoreValidators(Boolean.valueOf(false));
        if (MapUtils.isNotEmpty(activityContextMap)) {
            acceptationDefinition.setContextMap(activityContextMap);
        }
        acceptationDefinition.setIgnoreOwnerShip(Boolean.valueOf(true));
        this.activityService.acceptActivity(acceptationDefinition);
    }

    private String getExceptionMessage(Throwable throwable) {
        String message = throwable.getMessage();
        while (throwable.getCause() != null && StringUtils.isEmpty((CharSequence)message)) {
            throwable = throwable.getCause();
            message = throwable.getMessage();
        }
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = throwable.getClass().getSimpleName();
        }
        return message;
    }

    private boolean checkIfSuccessCriteriaMet(Message message, SuccessCriteria successCriteria) {
        switch (successCriteria) {
            case ACCEPTANCE: {
                return Objects.requireNonNull(message.getEvidences()).stream().anyMatch(evidence -> evidence.getType() != null && evidence.getType().equals((Object)EvidenceTypeEnum.A_1));
            }
            case NOTICE: {
                return Objects.requireNonNull(message.getEvidences()).stream().anyMatch(evidence -> evidence.getType() != null && evidence.getType().equals((Object)EvidenceTypeEnum.D_1));
            }
            case RECEIPT: {
                return Objects.requireNonNull(message.getMessageMetadata()).getReceiptDate() != null;
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)successCriteria));
    }

    @Override
    public DownloadedMessagesDto downloadNewMessages(EdorConfig edorConfig, String accessToken, OffsetDateTime readFromDate) throws EDeliveryException {
        List<String> messageIds = this.getNewMessageIds(edorConfig, accessToken, readFromDate);
        log.info("Found " + messageIds.size() + " new messages.");
        return this.downloadSelectedMessages(edorConfig, accessToken, messageIds);
    }

    @Override
    public DownloadedMessagesDto downloadSelectedMessages(EdorConfig edorConfig, String accessToken, List<String> messageIds) {
        Set<String> alreadyProcessedMessages = this.messageService.findAlreadyProcessedMessages(messageIds);
        ArrayList<String> messageIdsToDownload = new ArrayList<String>();
        ArrayList<String> failedMessageIds = new ArrayList<String>();
        ArrayList<String> skippedMessageIds = new ArrayList<String>();
        for (String messageId : messageIds) {
            if (alreadyProcessedMessages.contains(messageId)) {
                log.debug(MessageFormat.format("Skipping message with id=\"{0}\". Reason: already processed", messageId));
                skippedMessageIds.add(messageId);
                continue;
            }
            messageIdsToDownload.add(messageId);
        }
        List<Message> downloadedMessages = this.downloadMessages(edorConfig, accessToken, messageIdsToDownload, failedMessageIds);
        downloadedMessages = this.redownloadMessagesWithIncompleteData(edorConfig, accessToken, downloadedMessages);
        this.removeIncompleteMessages(downloadedMessages, failedMessageIds);
        return DownloadedMessagesDto.builder().messages(downloadedMessages).failedMessageIds(failedMessageIds).skippedMessageIds(skippedMessageIds).build();
    }

    private List<Message> downloadMessages(EdorConfig config, String token, List<String> messageIds, List<String> failedMessageIds) {
        ArrayList<Message> result = new ArrayList<Message>();
        for (String messageId : messageIds) {
            try {
                log.debug(MessageFormat.format("Downloading message with id=\"{0}\"", messageId));
                List<Message> downloaded = this.eDeliveryService.getMessageWithAttachments(config, token, messageId);
                if (downloaded == null) continue;
                result.addAll(downloaded);
            }
            catch (EDeliveryException e) {
                log.error(MessageFormat.format("Error occurred during downloading message with id=\"{0}\"", messageId), (Throwable)e);
                failedMessageIds.add(messageId);
            }
        }
        return result;
    }

    private void removeIncompleteMessages(List<Message> messages, List<String> failedIds) {
        Iterator<Message> iterator = messages.iterator();
        while (iterator.hasNext()) {
            Message message = iterator.next();
            if (this.isMessageProcessed(message)) continue;
            String messageId = Objects.requireNonNull(message.getMessageMetadata()).getMessageId();
            log.error(MessageFormat.format("Message with id=\"{0}\" has not been fully processed by the e-Delivery system yet.", messageId));
            failedIds.add(messageId);
            iterator.remove();
        }
    }

    @Override
    public List<String> getNewMessageIds(EdorConfig edorConfig, String accessToken, OffsetDateTime readFromDate) throws EDeliveryException {
        log.debug(MessageFormat.format("Downloading new messages from date {0}.", readFromDate));
        List<MessagesWrapper> allMessages = this.fetchAllNewMessages(edorConfig, accessToken, readFromDate);
        return allMessages.stream().flatMap(wrapper -> wrapper.getMessages().stream()).map(Message::getMessageMetadata).filter(metadata -> metadata != null && metadata.getTimestamp() != null && metadata.getTimestamp().isAfter(readFromDate)).map(MessageMetadata::getMessageId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private List<MessagesWrapper> fetchAllNewMessages(EdorConfig config, String token, OffsetDateTime readFromDate) throws EDeliveryException {
        ArrayList<MessagesWrapper> allMessages = new ArrayList<MessagesWrapper>();
        MessagesWrapper firstPage = this.eDeliveryService.getNewMessages(config, token);
        allMessages.add(firstPage);
        if (firstPage.getMessages().isEmpty()) {
            log.info("No messages in inbox.");
            return allMessages;
        }
        int offset = 100;
        Integer total = firstPage.getTotal();
        Message lastMessage = this.getLastMessage(firstPage);
        OffsetDateTime lastTimestamp = this.getTimestamp(lastMessage);
        while (this.shouldFetchMore(total, offset, readFromDate, lastTimestamp)) {
            MessagesWrapper nextPage = this.eDeliveryService.getNewMessages(config, token, offset);
            allMessages.add(nextPage);
            total = nextPage.getTotal();
            lastMessage = this.getLastMessage(nextPage);
            lastTimestamp = this.getTimestamp(lastMessage);
            offset += 100;
        }
        return allMessages;
    }

    private Message getLastMessage(MessagesWrapper wrapper) {
        List<Message> messages = wrapper.getMessages();
        return messages.isEmpty() ? null : messages.get(messages.size() - 1);
    }

    private OffsetDateTime getTimestamp(Message message) {
        return message != null && message.getMessageMetadata() != null ? message.getMessageMetadata().getTimestamp() : null;
    }

    private boolean shouldFetchMore(Integer total, int offset, OffsetDateTime readFrom, OffsetDateTime lastTimestamp) {
        boolean morePages = total != null && total > offset;
        boolean olderMessages = lastTimestamp != null && readFrom.isBefore(lastTimestamp);
        return morePages && olderMessages;
    }

    private List<Message> redownloadMessagesWithIncompleteData(EdorConfig config, String token, List<Message> messages) {
        if (messages.stream().allMatch(this::isMessageMetadataComplete)) {
            return messages;
        }
        Map<Boolean, List<Message>> partitionedMessages = messages.stream().collect(Collectors.partitioningBy(this::isMessageMetadataComplete));
        List<Message> complete = partitionedMessages.get(true);
        List<Message> incomplete = partitionedMessages.get(false);
        log.info(MessageFormat.format("Incomplete data found in {0} out of {1} messages. Redownloading selected messages...", incomplete.size(), messages.size()));
        List<Message> redownloaded = this.redownloadWithRetries(config, token, incomplete);
        return Stream.concat(complete.stream(), redownloaded.stream()).collect(Collectors.toList());
    }

    private List<Message> redownloadWithRetries(EdorConfig config, String token, List<Message> incompleteMessages) {
        int MAX_RETRIES = 5;
        long INITIAL_WAIT_SECONDS = 2L;
        for (int retry = 1; retry <= 5; ++retry) {
            try {
                TimeUnit.SECONDS.sleep((long)Math.pow(2.0, retry));
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            log.debug(MessageFormat.format("Retry #{0}", retry));
            incompleteMessages = incompleteMessages.stream().map(message -> this.isMessageMetadataComplete((Message)message) ? message : this.redownloadSingleMessage(config, token, (Message)message)).filter(Objects::nonNull).collect(Collectors.toList());
            boolean allDataAcquired = incompleteMessages.stream().allMatch(this::isMessageMetadataComplete);
            if (allDataAcquired) {
                log.debug("All required data has been successfully acquired. Continuing with the execution...");
                break;
            }
            if (retry != 5) continue;
            log.warn("Could not retrieve receipt dates for the following messages: " + incompleteMessages.stream().filter(message -> !this.isMessageMetadataComplete((Message)message)).map(message -> Objects.requireNonNull(message.getMessageMetadata()).getMessageId()).collect(Collectors.toList()));
        }
        return incompleteMessages;
    }

    private Message redownloadSingleMessage(EdorConfig config, String token, Message message) {
        try {
            String messageId = Objects.requireNonNull(message.getMessageMetadata()).getMessageId();
            log.info(MessageFormat.format("Redownloading message with id=\"{0}\"", messageId));
            return this.eDeliveryService.getMessageWithAttachments(config, token, messageId).get(0);
        }
        catch (Exception e) {
            String messageId = message.getMessageMetadata() != null ? message.getMessageMetadata().getMessageId() : null;
            log.error(MessageFormat.format("Error redownloading message with id=\"{0}\"", messageId), (Throwable)e);
            return message;
        }
    }

    @Override
    public List<Message> downloadUnopenedMessages(EdorConfig config, String token) throws EDeliveryException {
        List<MessagesWrapper> allMessagePages = this.fetchAllUnopenedMessages(config, token);
        List<Message> allMessages = allMessagePages.stream().flatMap(wrapper -> wrapper.getMessages().stream()).filter(Objects::nonNull).distinct().filter(message -> {
            MessageControlData controlData = message.getMessageControlData();
            return controlData != null && controlData.getMessageType() != null && ObjectUtils.notEqual((Object)((Object)controlData.getMessageType()), (Object)((Object)MessageTypeEnum.EVIDENCE));
        }).collect(Collectors.toList());
        return this.filterAlreadyProcessedMessages(allMessages);
    }

    private List<MessagesWrapper> fetchAllUnopenedMessages(EdorConfig config, String token) throws EDeliveryException {
        boolean morePages;
        ArrayList<MessagesWrapper> allMessages = new ArrayList<MessagesWrapper>();
        MessagesWrapper firstPage = this.eDeliveryService.getUnopenedMessages(config, token);
        allMessages.add(firstPage);
        if (firstPage.getMessages().isEmpty()) {
            log.info("No messages in inbox.");
            return allMessages;
        }
        int offset = 100;
        Integer total = firstPage.getTotal();
        boolean bl = morePages = total != null && total > offset;
        while (morePages) {
            MessagesWrapper nextPage = this.eDeliveryService.getUnopenedMessages(config, token, offset);
            allMessages.add(nextPage);
            total = nextPage.getTotal();
            morePages = total != null && total > (offset += 100);
        }
        return allMessages;
    }

    private List<Message> filterAlreadyProcessedMessages(List<Message> messages) {
        List<String> messageIds = messages.stream().map(message -> Objects.requireNonNull(message.getMessageMetadata()).getMessageId()).collect(Collectors.toList());
        Set<String> alreadyProcessed = this.messageHeaderService.findAlreadyDownloadedMessages(messageIds);
        return messages.stream().filter(message -> !alreadyProcessed.contains(Objects.requireNonNull(message.getMessageMetadata()).getMessageId())).collect(Collectors.toList());
    }

    @Override
    public void processMessageHeader(EdorConfig edorConfig, String processDefId, Map<String, String> variableIdsParametersMap, Message messageHeader) throws ProcessingException {
        try {
            ProcessBuilderDefinition definition = new ProcessBuilderDefinition();
            Package pack = XpdlPackageManager.getInstance().getPackageByProcessDefinitionId(processDefId);
            if (pack == null) {
                throw new ProcessingException(MessageFormat.format("Could not find package for processDefId=\"{0}\".", processDefId));
            }
            definition.setPackageId(pack.getId());
            definition.setCreator(ADMIN_USERNAME);
            definition.setProcessDefId(processDefId);
            Map<String, Object> variables = this.createMapOfVariables(edorConfig, variableIdsParametersMap, messageHeader);
            definition.setVariables(variables);
            String processId = this.processService.createProcess(definition);
            this.messageHeaderService.save(messageHeader, processId, edorConfig);
        }
        catch (Exception e) {
            ProcessingException processingException = new ProcessingException(this.getExceptionMessage(e), e);
            log.error(e.getMessage(), (Throwable)e);
            throw processingException;
        }
    }

    private Map<String, Object> createMapOfVariables(EdorConfig edorConfig, Map<String, String> variableIdsParametersMap, Message message) {
        HashMap<String, Object> processVariables = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : variableIdsParametersMap.entrySet()) {
            Object value;
            String variableId = entry.getKey();
            String parameterKey = entry.getValue();
            Enum edorKey = EdorKeysImpl.getByKey(parameterKey);
            if (edorKey != null) {
                value = edorKey.getValue(message);
                if (value instanceof OffsetDateTime) {
                    value = Timestamp.from(((OffsetDateTime)value).toInstant());
                }
            } else {
                edorKey = PcmKeysImpl.getByKey(entry.getValue());
                if (edorKey == null) {
                    throw new IllegalArgumentException("Could not find key \"" + entry.getValue() + "\".");
                }
                value = edorKey.getValue(edorConfig);
            }
            processVariables.put(variableId, value);
        }
        return processVariables;
    }

    private boolean isMessageMetadataComplete(Message message) {
        return message.getMessageMetadata() != null && message.getMessageMetadata().getReceiptDate() != null;
    }

    private boolean isMessageProcessed(Message message) {
        return message.getMessageMetadata() != null && message.getMessageMetadata().getTimestamp() != null;
    }

    @Override
    public MessageReceiptDateUpdateResult updateMessageReceiptDate(String messageId, String receiptDateVariableId, Map<String, String> documentClassIndexMap, String successActionName, String errorActionName, Activity activity, org.apache.log4j.Logger taskLog) throws ProcessingException {
        try {
            taskLog.info((Object)("Processing message: " + messageId));
            Optional<MessageEntity> message = this.messageService.findByMessageId(messageId);
            if (!message.isPresent()) {
                taskLog.error((Object)MessageFormat.format("Message \"{0}\" was not found in database. Executing error action...", messageId));
                this.acceptActivity(activity.getProcessId(), activity.getActivityId(), new HashMap<String, Object>(), errorActionName);
                return MessageReceiptDateUpdateResult.ERROR;
            }
            MessageEntity messageEntity = message.get();
            if (messageEntity.getReceiptDate() != null) {
                taskLog.error((Object)MessageFormat.format("Message \"{0}\" already contains receipt date. Executing success action...", messageId));
                this.acceptActivity(activity.getProcessId(), activity.getActivityId(), new HashMap<String, Object>(), successActionName);
                return MessageReceiptDateUpdateResult.SUCCESS;
            }
            EdorConfig config = this.findConfigurationForMessage(messageEntity, taskLog);
            if (config == null) {
                taskLog.error((Object)MessageFormat.format("No configuration found for message \"{0}\"", messageId));
                return MessageReceiptDateUpdateResult.ERROR;
            }
            String accessToken = this.eDeliveryService.getAccessToken(config);
            List<Message> messages = this.eDeliveryService.getMessage(config, accessToken, messageId);
            if (CollectionUtils.isEmpty(messages)) {
                taskLog.error((Object)MessageFormat.format("Message \"{0}\" no longer exists on the server. Executing error action...", messageId));
                this.acceptActivity(activity.getProcessId(), activity.getActivityId(), new HashMap<String, Object>(), errorActionName);
                return MessageReceiptDateUpdateResult.ERROR;
            }
            Message downloadedMessage = messages.get(0);
            if (downloadedMessage.getMessageMetadata() == null || downloadedMessage.getMessageMetadata().getReceiptDate() == null) {
                taskLog.info((Object)MessageFormat.format("Receipt date has not been generated yet for message \"{0}\"", messageId));
                return MessageReceiptDateUpdateResult.PENDING;
            }
            OffsetDateTime receiptDate = downloadedMessage.getMessageMetadata().getReceiptDate();
            taskLog.info((Object)MessageFormat.format("Found receipt date for message \"{0}\": {1}", messageId, receiptDate));
            for (Map.Entry<String, String> entry : documentClassIndexMap.entrySet()) {
                String documentClass = entry.getKey();
                String indexName = entry.getValue();
                this.updateDocumentIndex(activity, documentClass, indexName, receiptDate, taskLog);
            }
            messageEntity.setReceiptDate(this.offsetDateTimeToTimestamp(receiptDate));
            this.messageService.save(messageEntity);
            Map<String, Variable> activityContextVariablesMap = this.getActivityContextVariableMap(activity);
            HashMap<String, Object> contextMap = new HashMap<String, Object>();
            this.setContextMapVariable(contextMap, activityContextVariablesMap, receiptDateVariableId, this.offsetDateTimeToTimestamp(receiptDate));
            this.acceptActivity(activity.getProcessId(), activity.getActivityId(), contextMap, successActionName);
            taskLog.info((Object)("Successfully processed receipt date for message: " + messageId));
            return MessageReceiptDateUpdateResult.SUCCESS;
        }
        catch (Exception e) {
            throw new ProcessingException("Error updating message receipt date: " + e.getMessage(), e);
        }
    }

    private void updateDocumentIndex(Activity activity, String documentClassName, String indexName, OffsetDateTime receiptDate, org.apache.log4j.Logger taskLog) throws ProcessingException {
        try {
            DocumentClass docClass = this.documentClassService.getDocumentClass(documentClassName, new String[0]);
            List documentClassIndexList = this.documentClassIndexFinder.findByDocumentClass(docClass.getId());
            DocumentClassIndex documentClassIndex = this.findDocumentClassIndex(indexName, docClass, documentClassIndexList);
            List documentsFromProcess = this.documentFinder.getDocumentsFromProcess(activity.getProcessId(), new String[]{"documentClass"});
            List documentsOfClass = documentsFromProcess.stream().filter(doc -> doc.getDocumentClassId().equals(docClass.getId())).collect(Collectors.toList());
            if (documentsOfClass.isEmpty()) {
                taskLog.info((Object)MessageFormat.format("No documents found in process {0} for class {1}", activity.getProcessId(), documentClassName));
                return;
            }
            int updatedCount = 0;
            for (WfDocument document : documentsOfClass) {
                IndexInfo indexInfo = document.getIndexById(documentClassIndex.getId());
                if (indexInfo == null) {
                    taskLog.warn((Object)MessageFormat.format("Index {0} not found in document Id {1}", indexName, document.getId()));
                    continue;
                }
                Object formattedValue = this.formatValueForIndexType(documentClassIndex, receiptDate);
                indexInfo.setValue(formattedValue);
                this.documentService.updateDocument(document);
                ++updatedCount;
                taskLog.info((Object)MessageFormat.format("Updated document index: Class={0}, Index={1}, Value={2}, DocumentId={3}", documentClassName, indexName, formattedValue, document.getId()));
            }
            taskLog.info((Object)MessageFormat.format("Updated {0} document(s) of class {1}", updatedCount, documentClassName));
        }
        catch (Exception e) {
            throw new ProcessingException("Error updating document index: " + e.getMessage(), e);
        }
    }

    private EdorConfig findConfigurationForMessage(MessageEntity messageEntity, org.apache.log4j.Logger taskLog) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)messageEntity.getPcmConfigId())) {
            return this.configurationService.readConfigurationFromPCM(messageEntity.getPcmConfigId());
        }
        if (StringUtils.isNotBlank((CharSequence)messageEntity.getRecipientsEDeliveryAddresses())) {
            taskLog.info((Object)MessageFormat.format("No pcm_config_id found, trying fallback search for message \"{0}\"", messageEntity.getMessageId()));
            List<String> configIds = this.configurationService.getAllConfigurationIds();
            for (String configId : configIds) {
                try {
                    EdorConfig config = this.configurationService.readConfigurationFromPCM(configId);
                    if (config == null || !StringUtils.contains((CharSequence)messageEntity.getRecipientsEDeliveryAddresses(), (CharSequence)config.getEDeliveryAddress())) continue;
                    taskLog.info((Object)("Found matching config by address: " + configId));
                    return config;
                }
                catch (Exception e) {
                    taskLog.error((Object)("Error reading config " + configId + ": " + e.getMessage()));
                }
            }
        }
        return null;
    }

    private Object formatValueForIndexType(DocumentClassIndex documentClassIndex, Object value) {
        if (documentClassIndex != null) {
            if (documentClassIndex.getType().equals((Object)IndexType.DATETIME) && value instanceof OffsetDateTime) {
                return Timestamp.from(((OffsetDateTime)value).toInstant()).toString();
            }
            if (value instanceof String[]) {
                return StringUtils.join((Object[])((String[])value), (String)ARRAY_VALUES_SEPARATOR);
            }
            return value;
        }
        return null;
    }

    private Timestamp offsetDateTimeToTimestamp(OffsetDateTime value) {
        return Timestamp.from(value.toInstant());
    }
}

