/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.scheduledtasks;

import com.google.gson.Gson;
import com.suncode.plugin.plusedoreczenia.Categories;
import com.suncode.plugin.plusedoreczenia.dto.Message;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.service.ConfigurationService;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.ProcessingResultDto;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.summary.ProcessingSummaryDto;
import com.suncode.plugin.plusedoreczenia.scheduledtasks.dto.summary.SummaryDto;
import com.suncode.plugin.plusedoreczenia.service.EDeliveryService;
import com.suncode.plugin.plusedoreczenia.service.ProcessingException;
import com.suncode.plugin.plusedoreczenia.service.ProcessingService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
@ScheduledTaskScript(value="dist/plusedoreczenia/scheduledtasks/ImportMessageHeaders/pwe_dynamic_form.js")
public class ImportMessageHeaders {
    private static final Logger log = LoggerFactory.getLogger(ImportMessageHeaders.class);
    private static final String GLOBAL_SUMMARY_DELIMITER = ". ";
    private final Gson gson = new Gson();
    @Autowired
    private EDeliveryService eDeliveryService;
    @Autowired
    private ProcessingService processingService;
    @Autowired
    private ConfigurationService configService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("plusedoreczenia.scheduledtasks.ImportMessageHeaders")).name("plusedoreczenia.scheduledtasks.ImportMessageHeaders.name")).description("plusedoreczenia.scheduledtasks.ImportMessageHeaders.desc")).category(new Category[]{Categories.PLUS_E_DORECZENIA})).parameter().id("pcmConfigIds").name("plusedoreczenia.scheduledtasks.ImportMessageHeaders.param.pcmConfigIds.name").description("plusedoreczenia.scheduledtasks.ImportMessageHeaders.param.pcmConfigIds.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("processDefId").name("plusedoreczenia.scheduledtasks.ImportMessageHeaders.param.processDefId.name").type((Type)Types.STRING).create()).parameter().id("variableIds").name("plusedoreczenia.scheduledtasks.ImportMessageHeaders.param.variableIds.name").description("plusedoreczenia.scheduledtasks.ImportMessageHeaders.param.variableIds.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("parameters").name("plusedoreczenia.scheduledtasks.ImportMessageHeaders.param.parameters.name").description("plusedoreczenia.scheduledtasks.ImportMessageHeaders.param.parameters.desc").type((Type)Types.STRING_ARRAY).create();
    }

    public String execute(@Param String[] pcmConfigIds, @Param String processDefId, @PairedParam(key="variableIds", value="parameters") Map<String, String> variableIdsParametersMap, org.apache.log4j.Logger taskLog) {
        try {
            ArrayList<String> globalSummary = new ArrayList<String>();
            for (String configId : pcmConfigIds) {
                taskLog.info((Object)MessageFormat.format("Downloading message headers for config=\"{0}\".", configId));
                EdorConfig edorConfig = this.configService.readConfigurationFromPCM(configId);
                String accessToken = this.eDeliveryService.getAccessToken(edorConfig);
                List<Message> messageHeaders = this.processingService.downloadUnopenedMessages(edorConfig, accessToken);
                ProcessingResultDto processingResult = this.processMessageHeaders(edorConfig, processDefId, variableIdsParametersMap, messageHeaders, taskLog);
                String summary = MessageFormat.format("Summary for config \"{0}\": '{' Processed: {1}, Failed: {2} '}'", edorConfig.getConfigId(), processingResult.getProcessedMessages().size(), processingResult.getFailedMessageIds().size());
                globalSummary.add(summary);
                taskLog.info((Object)("Summary: " + this.createDetailedSummary(configId, processingResult)));
            }
            return String.join((CharSequence)GLOBAL_SUMMARY_DELIMITER, globalSummary);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private ProcessingResultDto processMessageHeaders(EdorConfig edorConfig, String processDefId, Map<String, String> parametersVariableIdsMap, List<Message> messageHeaders, org.apache.log4j.Logger taskLog) {
        ProcessingResultDto processingResult = new ProcessingResultDto();
        for (Message message : messageHeaders) {
            try {
                this.processingService.processMessageHeader(edorConfig, processDefId, parametersVariableIdsMap, message);
                taskLog.debug((Object)MessageFormat.format("Successfully processed message with id=\"{0}\"", Objects.requireNonNull(message.getMessageMetadata()).getMessageId()));
                processingResult.getProcessedMessages().add(message);
            }
            catch (ProcessingException e) {
                String messageId = Objects.requireNonNull(message.getMessageMetadata()).getMessageId();
                taskLog.error((Object)MessageFormat.format("Failed to process message with id=\"{0}\"", messageId));
                taskLog.error((Object)e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
                processingResult.getFailedMessageIds().add(messageId);
            }
        }
        return processingResult;
    }

    private String createDetailedSummary(String configId, ProcessingResultDto processingResult) {
        SummaryDto summaryDto = SummaryDto.builder().config(configId).processing(ProcessingSummaryDto.builder().processed(processingResult.getProcessedMessages().size()).failed(processingResult.getFailedMessageIds().size()).failedIds(processingResult.getFailedMessageIds()).build()).build();
        return this.gson.toJson((Object)summaryDto);
    }
}

