/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.controller;

import com.suncode.plugin.plusedoreczenia.controller.dto.DocumentClassDto;
import com.suncode.plugin.plusedoreczenia.controller.dto.DocumentClassIndexDto;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Sorter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
public class DocumentClassController {
    private static final Logger log = LoggerFactory.getLogger(DocumentClassController.class);
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentClassIndexFinder documentClassIndexFinder;

    @RequestMapping(value={"/document/classes"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DocumentClassDto> getDocumentClasses(@RequestParam(required=false) String query, @RequestParam(required=false, defaultValue="0") Integer start, @RequestParam(required=false, defaultValue="25") Integer limit) {
        List documentClasses = this.documentClassService.getAll(new String[0]).stream().filter(documentClass -> StringUtils.containsIgnoreCase((CharSequence)documentClass.getName(), (CharSequence)query)).sorted(Comparator.comparing(DocumentClass::getName)).collect(Collectors.toList());
        List<Object> filteredData = documentClasses.size() >= start ? documentClasses.subList(start, Integer.min(start + limit, documentClasses.size())) : Collections.emptyList();
        List<DocumentClassDto> documentClassDtos = this.convertDocClassToDto(filteredData);
        return new CountedResult((long)documentClassDtos.size(), documentClassDtos);
    }

    @RequestMapping(value={"document/docClassIndexes/{className}"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DocumentClassIndexDto> getDocumentClassIndexes(@PathVariable(value="className") String className, @RequestParam(required=false) String query, @RequestParam(required=false, defaultValue="0") Integer start, @RequestParam(required=false, defaultValue="25") Integer limit) {
        Long docClassId = this.getDocumentClassID(className);
        List data = this.documentClassIndexFinder.findByDocumentClass(docClassId, new Sorter("name")).stream().filter(documentClassIndex -> StringUtils.containsIgnoreCase((CharSequence)documentClassIndex.getName(), (CharSequence)query)).collect(Collectors.toList());
        List<Object> filteredData = data.size() >= start ? data.subList(start, Integer.min(start + limit, data.size())) : Collections.emptyList();
        List<DocumentClassIndexDto> documentClassIndexes = this.convertDocIndexToDto(filteredData);
        return new CountedResult((long)data.size(), documentClassIndexes);
    }

    private List<DocumentClassIndexDto> convertDocIndexToDto(List<DocumentClassIndex> data) {
        return data.stream().map(DocumentClassIndexDto::fromEntity).collect(Collectors.toList());
    }

    private List<DocumentClassDto> convertDocClassToDto(List<DocumentClass> documentClasses) {
        return documentClasses.stream().map(DocumentClassDto::fromEntity).collect(Collectors.toList());
    }

    public Long getDocumentClassID(String classNameOrID) {
        DocumentClass documentClass = this.documentClassService.getDocumentClass(classNameOrID, new String[0]);
        return documentClass == null ? Long.parseLong(classNameOrID) : documentClass.getId();
    }
}

