/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.autotasks;

import com.google.common.base.Strings;
import com.suncode.plugin.plusedoreczenia.Categories;
import com.suncode.plugin.plusedoreczenia.dto.Contributor;
import com.suncode.plugin.plusedoreczenia.dto.Message;
import com.suncode.plugin.plusedoreczenia.dto.MessageAddressData;
import com.suncode.plugin.plusedoreczenia.dto.MessageMetadata;
import com.suncode.plugin.plusedoreczenia.dto.ShippingServiceEnum;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczenia.pluginconfigurationmanager.service.ConfigurationService;
import com.suncode.plugin.plusedoreczenia.service.ProcessingService;
import com.suncode.pwfl.archive.FileFinder;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/plusedoreczenia/autotasks/SendMessage/pwe_dynamic_form.js")
public class SendMessage {
    private static final Logger log = LoggerFactory.getLogger(SendMessage.class);
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private ProcessingService processingService;
    @Autowired
    private FileFinder fileFinder;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusedoreczenia.autotasks.SendMessage")).name("plusedoreczenia.autotasks.SendMessage.name")).description("plusedoreczenia.autotasks.SendMessage.desc")).category(new Category[]{Categories.PLUS_E_DORECZENIA})).icon((Icon)DivanteIcon.MAIL2)).parameter().id("pcmConfigId").name("plusedoreczenia.autotasks.SendMessage.param.pcmConfigId.name").description("plusedoreczenia.autotasks.SendMessage.param.pcmConfigId.desc").type((Type)Types.STRING).create()).parameter().id("recipientAddress").name("plusedoreczenia.autotasks.SendMessage.param.recipientAddress.name").description("plusedoreczenia.autotasks.SendMessage.param.recipientAddress.desc").type((Type)Types.STRING).create()).parameter().id("recipientName").name("plusedoreczenia.autotasks.SendMessage.param.recipientName.name").description("plusedoreczenia.autotasks.SendMessage.param.recipientName.desc").type((Type)Types.STRING).optional().create()).parameter().id("threadId").name("plusedoreczenia.autotasks.SendMessage.param.threadId.name").description("plusedoreczenia.autotasks.SendMessage.param.threadId.desc").type((Type)Types.STRING).optional().create()).parameter().id("subject").name("plusedoreczenia.autotasks.SendMessage.param.subject.name").description("plusedoreczenia.autotasks.SendMessage.param.subject.desc").type((Type)Types.STRING).create()).parameter().id("textBody").name("plusedoreczenia.autotasks.SendMessage.param.textBody.name").description("plusedoreczenia.autotasks.SendMessage.param.textBody.desc").optional().type((Type)Types.STRING).create()).parameter().id("attachmentFileIds").name("plusedoreczenia.autotasks.SendMessage.param.attachmentFileIds.name").description("plusedoreczenia.autotasks.SendMessage.param.attachmentFileIds.desc").type((Type)Types.INTEGER_ARRAY).create()).parameter().id("attachMessageContext").name("plusedoreczenia.autotasks.SendMessage.param.attachMessageContext.name").description("plusedoreczenia.autotasks.SendMessage.param.attachMessageContext.desc").type((Type)Types.BOOLEAN).create()).parameter().id("messageIdForContext").name("plusedoreczenia.autotasks.SendMessage.param.messageIdForContext.name").description("plusedoreczenia.autotasks.SendMessage.param.messageIdForContext.desc").optional().type((Type)Types.STRING).create();
    }

    public void execute(@Param String pcmConfigId, @Param String recipientAddress, @Param String recipientName, @Param String threadId, @Param String subject, @Param String textBody, @Param Integer[] attachmentFileIds, @Param Boolean attachMessageContext, @Param String messageIdForContext, WorkflowContext context) throws AcceptanceException {
        try {
            EdorConfig edorConfig = this.configService.readConfigurationFromPCM(pcmConfigId);
            List<WfFile> attachments = Arrays.stream(attachmentFileIds).filter(Objects::nonNull).map(fileId -> (WfFile)this.fileFinder.get((Serializable)Long.valueOf(fileId.intValue()))).collect(Collectors.toList());
            MessageAddressData senderAddressData = MessageAddressData.builder().eDeliveryAddress(edorConfig.getEDeliveryAddress()).build();
            Contributor recipientContributor = Contributor.builder().companyName(recipientName).build();
            MessageAddressData recipientAddressData = MessageAddressData.builder().eDeliveryAddress(recipientAddress).contributor(recipientContributor).build();
            Message message = Message.builder().messageMetadata(MessageMetadata.builder().from(senderAddressData).to(Collections.singletonList(recipientAddressData)).threadId(threadId).subject(subject).shippingService(ShippingServiceEnum.ELECTRONIC).build()).textBody(Strings.nullToEmpty((String)textBody)).build();
            this.processingService.sendNewMessage(edorConfig, message, attachMessageContext, messageIdForContext, context.getProcessId(), attachments);
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }
}

