/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia;

import com.suncode.plugin.plusedoreczenia.EdorKeys;
import com.suncode.plugin.plusedoreczenia.dto.Address;
import com.suncode.plugin.plusedoreczenia.dto.Contributor;
import com.suncode.plugin.plusedoreczenia.dto.Label;
import com.suncode.plugin.plusedoreczenia.dto.Message;
import com.suncode.plugin.plusedoreczenia.dto.MessageAddressData;
import com.suncode.plugin.plusedoreczenia.dto.MessageControlData;
import com.suncode.plugin.plusedoreczenia.dto.MessageMetadata;
import com.suncode.plugin.plusedoreczenia.utils.MessageParserUtils;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public enum EdorKeysImpl implements EdorKeys<Message>
{
    LABELS("labels", (Type)Types.STRING_ARRAY){

        public String[] getValue(Message message) {
            List<Label> labels;
            MessageControlData messageControlData = message.getMessageControlData();
            if (messageControlData != null && (labels = messageControlData.getLabels()) != null) {
                return (String[])labels.stream().map(Label::getLabel).toArray(String[]::new);
            }
            return EMPTY_ARRAY;
        }
    }
    ,
    SENDER_E_DELIVERY_ADDRESS("senderEDeliveryAddress", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            MessageAddressData from;
            MessageMetadata messageMetadata = message.getMessageMetadata();
            if (messageMetadata != null && (from = messageMetadata.getFrom()) != null) {
                return from.getEDeliveryAddress();
            }
            return null;
        }
    }
    ,
    SENDER_ADDRESS_COUNTRY("senderAddressCountry", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            Address address;
            MessageAddressData from;
            MessageMetadata messageMetadata = message.getMessageMetadata();
            if (messageMetadata != null && (from = messageMetadata.getFrom()) != null && (address = from.getAddress()) != null) {
                return address.getCountry();
            }
            return null;
        }
    }
    ,
    SENDER_ADDRESS_STREET("senderAddressStreet", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            Address address;
            MessageAddressData from;
            MessageMetadata messageMetadata = message.getMessageMetadata();
            if (messageMetadata != null && (from = messageMetadata.getFrom()) != null && (address = from.getAddress()) != null) {
                return address.getStreet();
            }
            return null;
        }
    }
    ,
    SENDER_ADDRESS_POSTAL_CODE("senderAddressPostalCode", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            Address address;
            MessageAddressData from;
            MessageMetadata messageMetadata = message.getMessageMetadata();
            if (messageMetadata != null && (from = messageMetadata.getFrom()) != null && (address = from.getAddress()) != null) {
                return address.getPostalCode();
            }
            return null;
        }
    }
    ,
    SENDER_ADDRESS_CITY("senderAddressCity", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            Address address;
            MessageAddressData from;
            MessageMetadata messageMetadata = message.getMessageMetadata();
            if (messageMetadata != null && (from = messageMetadata.getFrom()) != null && (address = from.getAddress()) != null) {
                return address.getCity();
            }
            return null;
        }
    }
    ,
    SENDER_ADDRESS_BUILDING_NUMBER("senderAddressBuildingNumber", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            Address address;
            MessageAddressData from;
            MessageMetadata messageMetadata = message.getMessageMetadata();
            if (messageMetadata != null && (from = messageMetadata.getFrom()) != null && (address = from.getAddress()) != null) {
                return address.getBuildingNumber();
            }
            return null;
        }
    }
    ,
    SENDER_ADDRESS_HOUSE_NUMBER("senderAddressHouseNumber", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            Address address;
            MessageAddressData from;
            MessageMetadata messageMetadata = message.getMessageMetadata();
            if (messageMetadata != null && (from = messageMetadata.getFrom()) != null && (address = from.getAddress()) != null) {
                return address.getHouseNumber();
            }
            return null;
        }
    }
    ,
    SENDER_FIRST_NAME("senderFirstName", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            Contributor contributor;
            MessageAddressData from;
            MessageMetadata messageMetadata = message.getMessageMetadata();
            if (messageMetadata != null && (from = messageMetadata.getFrom()) != null && (contributor = from.getContributor()) != null) {
                return contributor.getFirstName();
            }
            return null;
        }
    }
    ,
    SENDER_LAST_NAME("senderLastName", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            Contributor contributor;
            MessageAddressData from;
            MessageMetadata messageMetadata = message.getMessageMetadata();
            if (messageMetadata != null && (from = messageMetadata.getFrom()) != null && (contributor = from.getContributor()) != null) {
                return contributor.getLastName();
            }
            return null;
        }
    }
    ,
    SENDER_COMPANY_NAME("senderCompanyName", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            Contributor contributor;
            MessageAddressData from;
            MessageMetadata messageMetadata = message.getMessageMetadata();
            if (messageMetadata != null && (from = messageMetadata.getFrom()) != null && (contributor = from.getContributor()) != null) {
                return contributor.getCompanyName();
            }
            return null;
        }
    }
    ,
    SENDER_COMPANY_NAME_CONTINUED("senderCompanyNameContinued", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            Contributor contributor;
            MessageAddressData from;
            MessageMetadata messageMetadata = message.getMessageMetadata();
            if (messageMetadata != null && (from = messageMetadata.getFrom()) != null && (contributor = from.getContributor()) != null) {
                return contributor.getCompanyNameContinued();
            }
            return null;
        }
    }
    ,
    RECIPIENTS_E_DELIVERY_ADDRESSES("recipientsEDeliveryAddresses", (Type)Types.STRING_ARRAY){

        public String[] getValue(Message message) {
            List<MessageAddressData> to;
            MessageMetadata messageMetadata = message.getMessageMetadata();
            if (messageMetadata != null && (to = messageMetadata.getTo()) != null) {
                return (String[])to.stream().map(MessageAddressData::getEDeliveryAddress).toArray(String[]::new);
            }
            return EMPTY_ARRAY;
        }
    }
    ,
    SUBJECT("subject", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            return message.getMessageMetadata() != null ? message.getMessageMetadata().getSubject() : null;
        }
    }
    ,
    REF_TO_MESSAGE_ID("refToMessageId", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            return message.getMessageMetadata() != null ? message.getMessageMetadata().getRefToMessageId() : null;
        }
    }
    ,
    MESSAGE_ID("messageId", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            return message.getMessageMetadata() != null ? message.getMessageMetadata().getMessageId() : null;
        }
    }
    ,
    THREAD_ID("threadId", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            return message.getMessageMetadata() != null ? message.getMessageMetadata().getThreadId() : null;
        }
    }
    ,
    CASE_ID("caseId", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            return message.getMessageMetadata() != null ? message.getMessageMetadata().getCaseId() : null;
        }
    }
    ,
    SHIPPING_SERVICE("shippingService", (Type)Types.STRING){

        @Override
        public String getValue(Message message) {
            if (message.getMessageMetadata() != null && message.getMessageMetadata().getShippingService() != null) {
                return message.getMessageMetadata().getShippingService().getValue();
            }
            return null;
        }
    }
    ,
    TIMESTAMP("timestamp", (Type)Types.DATETIME){

        @Override
        public OffsetDateTime getValue(Message message) {
            MessageMetadata messageMetadata = message.getMessageMetadata();
            if (messageMetadata != null) {
                return messageMetadata.getTimestamp();
            }
            return null;
        }
    }
    ,
    RECEIPT_DATE("receiptDate", (Type)Types.DATETIME){

        @Override
        public OffsetDateTime getValue(Message message) {
            return MessageParserUtils.getReceiptDate(message);
        }
    }
    ,
    SUBMISSION_DATE("submissionDate", (Type)Types.DATETIME){

        @Override
        public OffsetDateTime getValue(Message message) {
            MessageMetadata messageMetadata = message.getMessageMetadata();
            if (messageMetadata != null) {
                return messageMetadata.getSubmissionDate();
            }
            return null;
        }
    }
    ,
    EVENT_DATE("eventDate", (Type)Types.DATETIME){

        @Override
        public OffsetDateTime getValue(Message message) {
            MessageMetadata messageMetadata = message.getMessageMetadata();
            if (messageMetadata != null) {
                return messageMetadata.getEventDate();
            }
            return null;
        }
    }
    ,
    TEXT_BODY("textBody", (Type)Types.STRING, true){

        @Override
        public String getValue(Message message) {
            return message.getTextBody();
        }
    };

    private static final String[] EMPTY_ARRAY;
    private final String key;
    private final Type<?> type;
    private final boolean openingMessageRequired;
    private final Translator t = Translators.get((String)"com.suncode.plugin-plus-edoreczenia");

    private EdorKeysImpl(String key, Type<?> type) {
        this(key, type, false);
    }

    private EdorKeysImpl(String key, Type<?> type, boolean openingMessageRequired) {
        this.key = key;
        this.type = type;
        this.openingMessageRequired = openingMessageRequired;
    }

    public static Stream<EdorKeysImpl> stream() {
        return Stream.of(EdorKeysImpl.values());
    }

    @Override
    public abstract Object getValue(Message var1);

    public static EdorKeysImpl getByKey(String key) {
        Optional<EdorKeysImpl> first = EdorKeysImpl.stream().filter(edorKeys -> edorKeys.getKey().equals(key)).findFirst();
        return first.orElse(null);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Type<?> getType() {
        return this.type;
    }

    public boolean isOpeningMessageRequired() {
        return this.openingMessageRequired;
    }

    public String toString() {
        return this.key;
    }

    @Override
    public String getDescription() {
        return this.t.getMessage("plusedoreczenia.scheduledtasks.ImportMessagesFromEdor.context.desc." + this.key);
    }

    static {
        EMPTY_ARRAY = new String[0];
    }
}

