/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczeniaasseco.service;

import com.google.common.io.ByteSource;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.plusedoreczeniaasseco.EdorKeysImpl;
import com.suncode.plugin.plusedoreczeniaasseco.PcmKeysImpl;
import com.suncode.plugin.plusedoreczeniaasseco.db.entity.SentMessageEntity;
import com.suncode.plugin.plusedoreczeniaasseco.db.service.MessageService;
import com.suncode.plugin.plusedoreczeniaasseco.db.service.SentMessageService;
import com.suncode.plugin.plusedoreczeniaasseco.dto.AttachmentVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.ConsignmentPostageGetResVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.ConsignmentRes;
import com.suncode.plugin.plusedoreczeniaasseco.dto.EvidenceRes;
import com.suncode.plugin.plusedoreczeniaasseco.dto.EvidenceTypeEnum;
import com.suncode.plugin.plusedoreczeniaasseco.dto.LocationResVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.MediaDataModel;
import com.suncode.plugin.plusedoreczeniaasseco.dto.ModeEnum;
import com.suncode.plugin.plusedoreczeniaasseco.dto.OptionsEnum;
import com.suncode.plugin.plusedoreczeniaasseco.dto.Postage;
import com.suncode.plugin.plusedoreczeniaasseco.dto.ShippingServiceEnum;
import com.suncode.plugin.plusedoreczeniaasseco.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczeniaasseco.pluginconfigurationmanager.service.ConfigurationService;
import com.suncode.plugin.plusedoreczeniaasseco.scheduledtasks.DocumentsOrder;
import com.suncode.plugin.plusedoreczeniaasseco.scheduledtasks.SuccessCriteria;
import com.suncode.plugin.plusedoreczeniaasseco.scheduledtasks.UpoFormat;
import com.suncode.plugin.plusedoreczeniaasseco.scheduledtasks.UpoType;
import com.suncode.plugin.plusedoreczeniaasseco.scheduledtasks.dto.sending.SentMessageStatus;
import com.suncode.plugin.plusedoreczeniaasseco.scheduledtasks.dto.upo.UpoStatus;
import com.suncode.plugin.plusedoreczeniaasseco.service.EDeliveryException;
import com.suncode.plugin.plusedoreczeniaasseco.service.EDeliveryService;
import com.suncode.plugin.plusedoreczeniaasseco.service.ProcessingException;
import com.suncode.plugin.plusedoreczeniaasseco.service.ProcessingService;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.core.type.DateTimeType;
import com.suncode.pwfl.core.type.DateType;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.TempFile;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.exception.ActivityAlreadyCompletedException;
import com.suncode.pwfl.workflow.activity.exception.ActivityIsSuspendedException;
import com.suncode.pwfl.workflow.activity.exception.UserIsNotAssignedToActivityException;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.variable.Variable;
import com.suncode.pwfl.workflow.variable.VariableFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProcessingServiceImpl
implements ProcessingService {
    private static final Logger log = LoggerFactory.getLogger(ProcessingServiceImpl.class);
    public static final String ARRAY_VALUES_SEPARATOR = ";";
    private static final String UPO_ALREADY_EXISTS = "The UPO document has already been downloaded.";
    private static final String UPO_NOT_GENERATED_YET = "The UPO document has not been generated yet.";
    private static final String ADMIN_USERNAME = "admin";
    @Autowired
    private MessageService messageService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private SentMessageService sentMessageService;
    @Autowired
    private EDeliveryService eDeliveryService;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentClassActionService documentClassActionService;
    @Autowired
    private DocumentClassIndexFinder documentClassIndexFinder;
    @Autowired
    private VariableFactory variableFactory;
    private static final Map<SuccessCriteria, EvidenceTypeEnum> successCriteriaEvidenceMap = Map.of(SuccessCriteria.ACCEPTANCE, EvidenceTypeEnum.SUBMISSION_ACCEPTANCE, SuccessCriteria.NOTICE, EvidenceTypeEnum.CONTENT_CONSIGNMENT, SuccessCriteria.RECEIPT, EvidenceTypeEnum.CONTENT_HANDOVER);
    private static final Set<EvidenceTypeEnum> errorEvidences = Set.of(EvidenceTypeEnum.SUBMISSION_REJECTION, EvidenceTypeEnum.CONTENT_HANDOVER_FAILURE);

    @Override
    public void sendNewMessage(EdorConfig edorConfig, String recipient, String subject, String threadId, String textBody, List<WfFile> attachments, String processId) throws ProcessingException {
        try {
            ConsignmentPostageGetResVo consignmentPostage = this.eDeliveryService.getConsignmentPostage(edorConfig, Set.of(recipient));
            if (consignmentPostage.getPostages() == null) {
                throw new ProcessingException("Could not find postage data. Aborting.");
            }
            Set<Postage> postages = consignmentPostage.getPostages().stream().map(postageRes -> new Postage(postageRes.getRecipient(), postageRes.getPostage())).collect(Collectors.toSet());
            MediaDataModel mediaDataModel = MediaDataModel.builder().options(Set.of(OptionsEnum.ROUTINE)).mode(ModeEnum.BASIC).sender(edorConfig.getEDeliveryAddress()).shippingService(ShippingServiceEnum.ELECTRONIC).recipients(Set.of(recipient)).subject(subject).threadId(threadId).postages(postages).build();
            try (TempFile textBodyFile = new TempFile();){
                Files.writeString(textBodyFile.getFile().toPath(), (CharSequence)textBody, StandardCharsets.UTF_8, new OpenOption[0]);
                LocationResVo sentMessageResponse = this.eDeliveryService.sendNewMessage(edorConfig, mediaDataModel, textBodyFile.getFile(), attachments);
                if (CollectionUtils.isEmpty(sentMessageResponse.getIds())) {
                    throw new ProcessingException("Could not find message identifier. Aborting.");
                }
                String messageId = sentMessageResponse.getIds().get(0);
                this.sentMessageService.save(mediaDataModel, textBody, messageId, processId, edorConfig.getConfigId());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    @Override
    public SentMessageStatus checkMessageStatus(String successActionName, String errorActionName, String messageIdOutputVariable, String statusOutputVariable, SuccessCriteria criteria, Activity activity, org.apache.log4j.Logger taskLog) throws ProcessingException {
        try {
            taskLog.debug((Object)MessageFormat.format("Analysing activity \"{0}\".", activity.getActivityId()));
            SentMessageEntity sentMessageEntity = this.sentMessageService.findByProcessId(activity.getProcessId());
            EdorConfig edorConfig = this.configurationService.readConfigurationFromPCM(sentMessageEntity.getPcmConfigId());
            List<EvidenceRes> evidences = this.eDeliveryService.getEvidences(edorConfig, OffsetDateTime.ofInstant(sentMessageEntity.getCreatedAt(), ZoneId.systemDefault()), sentMessageEntity.getMessageId());
            if (this.checkIfSuccessCriteriaMet(criteria, evidences)) {
                taskLog.debug((Object)"Success criteria have been met.");
                HashMap<String, Object> contextMap = new HashMap<String, Object>();
                Map<String, Variable> activityContextVariableMap = this.getActivityContextVariableMap(activity);
                this.setContextMapVariable(contextMap, activityContextVariableMap, messageIdOutputVariable, sentMessageEntity.getMessageId());
                this.acceptActivity(activity.getProcessId(), activity.getActivityId(), contextMap, successActionName);
                return SentMessageStatus.COMPLETED;
            }
            if (this.hasErrorEvidence(evidences)) {
                String status = this.getErrorStatusMessage(evidences);
                HashMap<String, Object> contextMap = new HashMap<String, Object>();
                Map<String, Variable> activityContextVariableMap = this.getActivityContextVariableMap(activity);
                this.setContextMapVariable(contextMap, activityContextVariableMap, statusOutputVariable, status);
                this.setContextMapVariable(contextMap, activityContextVariableMap, messageIdOutputVariable, sentMessageEntity.getMessageId());
                this.acceptActivity(activity.getProcessId(), activity.getActivityId(), contextMap, errorActionName);
                String errorDescription = MessageFormat.format("Error occurred after the message \"{0}\" was created. Details: {1}", sentMessageEntity.getMessageId(), status);
                taskLog.error((Object)errorDescription);
                log.error(errorDescription);
                return SentMessageStatus.ERROR;
            }
            taskLog.debug((Object)MessageFormat.format("Message \"{0}\" has not reached the required success/error criteria yet.", sentMessageEntity.getMessageId()));
            return SentMessageStatus.PENDING;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ProcessingException(e);
        }
    }

    @Override
    public UpoStatus downloadUpo(Activity activity, UpoType upoType, UpoFormat upoFormat, String actionId, String documentClass, String documentClassIndexForEvidenceType, String documentClassIndexForMessageId, Boolean executeDocumentClassActions, org.apache.log4j.Logger taskLog) throws ProcessingException {
        try {
            taskLog.debug((Object)MessageFormat.format("Analysing process \"{0}\" and activity \"{1}\".", activity.getProcessId(), activity.getActivityId()));
            SentMessageEntity sentMessageEntity = this.sentMessageService.findByProcessId(activity.getProcessId());
            taskLog.debug((Object)MessageFormat.format("Analysing message \"{0}\".", sentMessageEntity.getMessageId()));
            EdorConfig edorConfig = this.configurationService.readConfigurationFromPCM(sentMessageEntity.getPcmConfigId());
            List<EvidenceRes> evidences = this.eDeliveryService.getEvidences(edorConfig, OffsetDateTime.ofInstant(sentMessageEntity.getCreatedAt(), ZoneId.systemDefault()), sentMessageEntity.getMessageId());
            if (upoType.equals((Object)UpoType.SUBMISSION) && upoFormat.equals((Object)UpoFormat.PDF)) {
                if (sentMessageEntity.getSubmissionUpoPdfId() != null) {
                    log.error(UPO_ALREADY_EXISTS);
                    taskLog.error((Object)UPO_ALREADY_EXISTS);
                    return UpoStatus.ERROR;
                }
                EvidenceTypeEnum evidenceTypeToDownload = EvidenceTypeEnum.POTWIERDZENIE_WYSLANIA;
                Optional<EvidenceRes> evidence = this.findEvidence(evidences, evidenceTypeToDownload);
                if (evidence.isEmpty()) {
                    taskLog.debug((Object)UPO_NOT_GENERATED_YET);
                    return UpoStatus.PENDING;
                }
                WfDocument addedDocument = this.importUpoDocument(activity, edorConfig, documentClassIndexForMessageId, executeDocumentClassActions, evidence.get(), upoFormat, documentClass, documentClassIndexForEvidenceType);
                sentMessageEntity.setSubmissionUpoPdfId(evidence.get().getEvidenceId());
                sentMessageEntity.setSubmissionUpoPdfFileId(addedDocument.getFile().getId());
                this.sentMessageService.update(sentMessageEntity);
                Map activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
                this.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, actionId);
                return UpoStatus.SUCCESS;
            }
            if (upoType.equals((Object)UpoType.SUBMISSION) && upoFormat.equals((Object)UpoFormat.XML)) {
                if (sentMessageEntity.getSubmissionUpoXmlId() != null) {
                    log.error(UPO_ALREADY_EXISTS);
                    taskLog.error((Object)UPO_ALREADY_EXISTS);
                    return UpoStatus.ERROR;
                }
                EvidenceTypeEnum evidenceTypeToDownload = EvidenceTypeEnum.POTWIERDZENIE_WYSLANIA;
                Optional<EvidenceRes> evidence = this.findEvidence(evidences, evidenceTypeToDownload);
                if (evidence.isEmpty()) {
                    taskLog.debug((Object)UPO_NOT_GENERATED_YET);
                    return UpoStatus.PENDING;
                }
                WfDocument addedDocument = this.importUpoDocument(activity, edorConfig, documentClassIndexForMessageId, executeDocumentClassActions, evidence.get(), upoFormat, documentClass, documentClassIndexForEvidenceType);
                sentMessageEntity.setSubmissionUpoXmlId(evidence.get().getEvidenceId());
                sentMessageEntity.setSubmissionUpoXmlFileId(addedDocument.getFile().getId());
                this.sentMessageService.update(sentMessageEntity);
                Map activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
                this.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, actionId);
                return UpoStatus.SUCCESS;
            }
            if (upoType.equals((Object)UpoType.DELIVERY) && upoFormat.equals((Object)UpoFormat.PDF)) {
                if (sentMessageEntity.getDeliveryUpoPdfId() != null) {
                    log.error(UPO_ALREADY_EXISTS);
                    taskLog.error((Object)UPO_ALREADY_EXISTS);
                    return UpoStatus.ERROR;
                }
                EvidenceTypeEnum evidenceTypeToDownload = EvidenceTypeEnum.POTWIERDZENIE_OTRZYMANIA;
                Optional<EvidenceRes> evidence = this.findEvidence(evidences, evidenceTypeToDownload);
                if (evidence.isEmpty()) {
                    taskLog.debug((Object)UPO_NOT_GENERATED_YET);
                    return UpoStatus.PENDING;
                }
                WfDocument addedDocument = this.importUpoDocument(activity, edorConfig, documentClassIndexForMessageId, executeDocumentClassActions, evidence.get(), upoFormat, documentClass, documentClassIndexForEvidenceType);
                sentMessageEntity.setDeliveryUpoPdfId(evidence.get().getEvidenceId());
                sentMessageEntity.setDeliveryUpoPdfFileId(addedDocument.getFile().getId());
                this.sentMessageService.update(sentMessageEntity);
                Map activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
                this.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, actionId);
                return UpoStatus.SUCCESS;
            }
            if (upoType.equals((Object)UpoType.DELIVERY) && upoFormat.equals((Object)UpoFormat.XML)) {
                if (sentMessageEntity.getDeliveryUpoXmlId() != null) {
                    log.error(UPO_ALREADY_EXISTS);
                    taskLog.error((Object)UPO_ALREADY_EXISTS);
                    return UpoStatus.ERROR;
                }
                EvidenceTypeEnum evidenceTypeToDownload = EvidenceTypeEnum.POTWIERDZENIE_OTRZYMANIA;
                Optional<EvidenceRes> evidence = this.findEvidence(evidences, evidenceTypeToDownload);
                if (evidence.isEmpty()) {
                    taskLog.debug((Object)UPO_NOT_GENERATED_YET);
                    return UpoStatus.PENDING;
                }
                WfDocument addedDocument = this.importUpoDocument(activity, edorConfig, documentClassIndexForMessageId, executeDocumentClassActions, evidence.get(), upoFormat, documentClass, documentClassIndexForEvidenceType);
                sentMessageEntity.setDeliveryUpoXmlId(evidence.get().getEvidenceId());
                sentMessageEntity.setDeliveryUpoXmlFileId(addedDocument.getFile().getId());
                this.sentMessageService.update(sentMessageEntity);
                Map activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
                this.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, actionId);
                return UpoStatus.SUCCESS;
            }
            String message = "Unknown type and format criteria.";
            log.error(message);
            taskLog.error((Object)message);
            return UpoStatus.ERROR;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ProcessingException(e);
        }
    }

    @Override
    public void processMessage(EdorConfig edorConfig, String attachmentsDocumentClass, Map<String, String> attachmentIndexesAndParams, String messageDocumentClass, Map<String, String> messageIndexesAndParams, DocumentsOrder orderOfAddingDocuments, ConsignmentRes message) throws ProcessingException {
        try {
            List<AttachmentVo> attachments = message.getAttachments();
            DocumentClass attachmentDocClass = this.documentClassService.getDocumentClass(attachmentsDocumentClass, new String[0]);
            List attachmentIndexes = this.documentClassIndexFinder.findByDocumentClass(attachmentDocClass.getId());
            DocumentClass messageDocClass = this.documentClassService.getDocumentClass(messageDocumentClass, new String[0]);
            List messageDocClassIndexes = this.documentClassIndexFinder.findByDocumentClass(messageDocClass.getId());
            AttachmentVo bodyAttachment = null;
            ArrayList<AttachmentVo> otherAttachments = new ArrayList<AttachmentVo>();
            for (AttachmentVo attachment : Objects.requireNonNull(attachments)) {
                if (Objects.equals(attachment.getName(), "body")) {
                    bodyAttachment = attachment;
                    continue;
                }
                otherAttachments.add(attachment);
            }
            if (orderOfAddingDocuments == DocumentsOrder.ATTACHMENTS_FIRST) {
                this.addAttachmentsToArchive(edorConfig, attachmentIndexesAndParams, message, otherAttachments, attachmentDocClass, attachmentIndexes);
                this.addTextMessageAsAttachmentToArchive(edorConfig, messageIndexesAndParams, message, Objects.requireNonNull(bodyAttachment), messageDocClass, messageDocClassIndexes);
            } else {
                this.addTextMessageAsAttachmentToArchive(edorConfig, messageIndexesAndParams, message, Objects.requireNonNull(bodyAttachment), messageDocClass, messageDocClassIndexes);
                this.addAttachmentsToArchive(edorConfig, attachmentIndexesAndParams, message, otherAttachments, attachmentDocClass, attachmentIndexes);
            }
            this.messageService.save(message, edorConfig);
        }
        catch (Exception e) {
            ProcessingException processingException = new ProcessingException(e.getMessage(), e);
            log.error(e.getMessage(), (Throwable)e);
            throw processingException;
        }
    }

    private void addTextMessageAsAttachmentToArchive(EdorConfig edorConfig, Map<String, String> messageIndexesAndParams, ConsignmentRes newMessage, AttachmentVo body, DocumentClass messageDocClass, List<DocumentClassIndex> indexes) throws IOException, EDeliveryException {
        String filename = body.getFilename();
        byte[] bytes = this.eDeliveryService.downloadAttachment(edorConfig, body);
        InputStream inputStream = ByteSource.wrap((byte[])bytes).openStream();
        DocumentDefinition attachmentDocumentDefinition = this.createAttachmentDocumentDefinition(edorConfig, newMessage, filename, inputStream, messageIndexesAndParams, messageDocClass, indexes);
        WfDocument document = this.documentService.addDocument(attachmentDocumentDefinition);
        this.documentClassActionService.executeArchiveActions(document, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
    }

    private void addAttachmentsToArchive(EdorConfig edorConfig, Map<String, String> attachmentIndexesAndParams, ConsignmentRes newMessage, List<AttachmentVo> attachments, DocumentClass documentClass, List<DocumentClassIndex> attachmentIndexes) throws IOException, EDeliveryException {
        if (attachments != null) {
            for (AttachmentVo attachment : attachments) {
                DocumentDefinition attachmentDocumentDefinition = this.createAttachmentDocumentDefinition(edorConfig, newMessage, attachment, attachmentIndexesAndParams, documentClass, attachmentIndexes);
                if (StringUtils.isNotBlank((CharSequence)attachment.getDescription())) {
                    attachmentDocumentDefinition.setDescription(attachment.getDescription());
                }
                WfDocument document = this.documentService.addDocument(attachmentDocumentDefinition);
                this.documentClassActionService.executeArchiveActions(document, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
            }
        }
    }

    @NotNull
    private DocumentDefinition createAttachmentDocumentDefinition(EdorConfig edorConfig, ConsignmentRes newMessage, AttachmentVo attachment, Map<String, String> attachmentIndexesAndParams, DocumentClass documentClass, List<DocumentClassIndex> indexes) throws IOException, EDeliveryException {
        String filename = attachment.getFilename();
        byte[] bytes = this.eDeliveryService.downloadAttachment(edorConfig, attachment);
        InputStream inputStream = ByteSource.wrap((byte[])bytes).openStream();
        return this.createAttachmentDocumentDefinition(edorConfig, newMessage, filename, inputStream, attachmentIndexesAndParams, documentClass, indexes);
    }

    @NotNull
    private DocumentDefinition createAttachmentDocumentDefinition(EdorConfig edorConfig, ConsignmentRes newMessage, String fileName, InputStream fileInputStream, Map<String, String> attachmentIndexesAndParams, DocumentClass documentClass, List<DocumentClassIndex> indexes) {
        HashMap<Long, Object> idx = new HashMap<Long, Object>();
        for (Map.Entry<String, String> entry : attachmentIndexesAndParams.entrySet()) {
            DocumentClassIndex documentClassIndex;
            Object value;
            Enum keyParam = EdorKeysImpl.getByKey(entry.getValue());
            if (keyParam != null) {
                EdorKeysImpl messageKeys = keyParam;
                value = messageKeys.getValue(newMessage);
            } else {
                keyParam = PcmKeysImpl.getByKey(entry.getValue());
                if (keyParam == null) {
                    throw new IllegalArgumentException("Could not find index \"" + entry.getValue() + "\".");
                }
                Enum pcmConfigKeys = keyParam;
                value = pcmConfigKeys.getValue(edorConfig);
            }
            if ((documentClassIndex = indexes.stream().filter(index -> index.getName().equals(entry.getKey())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Could not find index \"%s\" in document class \"%s\"", entry.getKey(), documentClass.getName())))) == null) continue;
            if (documentClassIndex.getType().equals((Object)IndexType.DATETIME) && value instanceof OffsetDateTime) {
                OffsetDateTime offsetDateTime = (OffsetDateTime)value;
                String timestamp = Timestamp.from(offsetDateTime.toInstant()).toString();
                idx.put(documentClassIndex.getId(), timestamp);
                continue;
            }
            if (keyParam.getType().equals((Object)Types.STRING_ARRAY) && value instanceof String[]) {
                Object[] strings = (String[])value;
                idx.put(documentClassIndex.getId(), StringUtils.join((Object[])strings, (String)ARRAY_VALUES_SEPARATOR));
                continue;
            }
            idx.put(documentClassIndex.getId(), value);
        }
        DocumentDefinition definition = new DocumentDefinition();
        definition.setDocumentClassId(documentClass.getId());
        definition.setFileName(fileName);
        definition.setUserName(ADMIN_USERNAME);
        definition.setIndexes(idx);
        definition.setInputStream(fileInputStream);
        return definition;
    }

    private Optional<EvidenceRes> findEvidence(List<EvidenceRes> evidences, EvidenceTypeEnum evidenceTypeToDownload) {
        return evidences.stream().filter(evidenceRes -> StringUtils.isNotEmpty((CharSequence)evidenceRes.getEvidenceType())).filter(evidenceRes -> evidenceRes.getEvidenceType().equals(evidenceTypeToDownload.getValue())).findAny();
    }

    private boolean checkIfSuccessCriteriaMet(SuccessCriteria criteria, List<EvidenceRes> evidences) {
        EvidenceTypeEnum evidenceType = successCriteriaEvidenceMap.get((Object)criteria);
        return evidences.stream().map(EvidenceRes::getEvidenceType).filter(Objects::nonNull).anyMatch(type -> type.equals(evidenceType.getValue()));
    }

    private boolean hasErrorEvidence(List<EvidenceRes> evidences) {
        return evidences.stream().map(EvidenceRes::getEvidenceType).filter(Objects::nonNull).map(EvidenceTypeEnum::fromValue).anyMatch(errorEvidences::contains);
    }

    private void acceptActivity(String processId, String activityId, Map<String, Object> activityContextMap, String actionName) throws ActivityIsSuspendedException, UserIsNotAssignedToActivityException, ActivityAlreadyCompletedException {
        String executorLogin = SystemProperties.getString((String)"Bufor.username");
        this.activityService.openActivity(executorLogin, processId, activityId);
        AcceptationDefinition acceptationDef = new AcceptationDefinition(processId, activityId, executorLogin, actionName);
        acceptationDef.setIgnoreValidators(Boolean.valueOf(false));
        acceptationDef.setContextMap(activityContextMap);
        this.activityService.acceptActivity(acceptationDef);
    }

    private Map<String, Variable> getActivityContextVariableMap(Activity activity) {
        Map activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
        return this.variableFactory.createVariables(activity.getProcessId(), activity.getActivityId(), activityContext, true);
    }

    private String getErrorStatusMessage(List<EvidenceRes> evidences) {
        List reasons = evidences.stream().map(EvidenceRes::getEvidenceType).filter(Objects::nonNull).map(EvidenceTypeEnum::fromValue).filter(errorEvidences::contains).flatMap(errorType -> evidences.stream().filter(e -> EvidenceTypeEnum.fromValue(e.getEvidenceType()) == errorType).flatMap(e -> e.getEventReasons() != null ? e.getEventReasons().stream() : Stream.empty())).distinct().toList();
        return "Errors occurred: " + reasons;
    }

    private void setContextMapVariable(Map<String, Object> contextMap, Map<String, Variable> activityContextVariableMap, String variableId, Object value) {
        Variable variable;
        if (StringUtils.isNotBlank((CharSequence)variableId) && value != null && (variable = activityContextVariableMap.get(variableId)) != null) {
            Object valueToSet = variable.getType() instanceof DateType && value instanceof Timestamp ? variable.getType().convert(((Timestamp)value).toLocalDateTime().format(DateTimeFormatter.ISO_LOCAL_DATE)).toString() : (variable.getType() instanceof DateTimeType && value instanceof Timestamp ? value : variable.getType().convert(value.toString()));
            contextMap.put(variableId, valueToSet);
        }
    }

    private WfDocument importUpoDocument(Activity activity, EdorConfig edorConfig, String documentClassIndexForMessageId, Boolean executeDocumentClassActions, EvidenceRes evidence, UpoFormat upoFormat, String documentClass, String documentClassIndexForEvidenceType) throws IOException, EDeliveryException {
        DocumentClassIndex documentClassIndex;
        DocumentClass docClass = this.documentClassService.getDocumentClass(documentClass, new String[0]);
        List documentClassIndexList = this.documentClassIndexFinder.findByDocumentClass(docClass.getId());
        HashMap<Long, String> indexes = new HashMap<Long, String>();
        if (StringUtils.isNotBlank((CharSequence)documentClassIndexForEvidenceType)) {
            documentClassIndex = this.findDocumentClassIndex(documentClassIndexForEvidenceType, docClass, documentClassIndexList);
            indexes.put(documentClassIndex.getId(), Objects.requireNonNull(evidence.getEvidenceType()));
        }
        if (StringUtils.isNotBlank((CharSequence)documentClassIndexForMessageId)) {
            documentClassIndex = this.findDocumentClassIndex(documentClassIndexForMessageId, docClass, documentClassIndexList);
            indexes.put(documentClassIndex.getId(), evidence.getEvidenceId());
        }
        String filename = MessageFormat.format("{0}.{1}", evidence.getEvidenceId(), upoFormat.toString().toLowerCase(Locale.ROOT));
        byte[] fileContent = this.eDeliveryService.getEvidence(edorConfig, evidence.getEvidenceId(), upoFormat.name());
        try (InputStream inputStream = ByteSource.wrap((byte[])fileContent).openStream();){
            DocumentDefinition definition = new DocumentDefinition();
            definition.setDocumentClassId(docClass.getId());
            definition.setFileName(filename);
            definition.setUserName(ADMIN_USERNAME);
            definition.setIndexes(indexes);
            definition.setInputStream(inputStream);
            WfDocument addedDocument = this.documentService.addDocument(definition);
            this.documentService.attachDocumentToProcess(addedDocument, ADMIN_USERNAME, activity.getProcessId(), activity.getActivityId());
            if (Boolean.TRUE.equals(executeDocumentClassActions)) {
                this.documentClassActionService.executeArchiveActions(addedDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
            }
            WfDocument wfDocument = addedDocument;
            return wfDocument;
        }
    }

    private DocumentClassIndex findDocumentClassIndex(String documentClassIndexForEvidenceType, DocumentClass docClass, List<DocumentClassIndex> documentClassIndexList) {
        return documentClassIndexList.stream().filter(index -> index.getName().equals(documentClassIndexForEvidenceType)).findFirst().orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("Could not find index \"{0}\" in document class \"{1}\".", documentClassIndexForEvidenceType, docClass.getName())));
    }
}

