/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczeniaasseco.service;

import com.suncode.plugin.plusedoreczeniaasseco.dto.AttachmentVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.ConsignmentPostageGetResVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.ConsignmentRes;
import com.suncode.plugin.plusedoreczeniaasseco.dto.ConsignmentsGetResVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.EZDADESearchReqVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.EZDADESearchResVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.EvidenceRes;
import com.suncode.plugin.plusedoreczeniaasseco.dto.EvidencesGetResVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.LocationResVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.MediaDataModel;
import com.suncode.plugin.plusedoreczeniaasseco.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczeniaasseco.service.ApiClient;
import com.suncode.plugin.plusedoreczeniaasseco.service.EDeliveryException;
import com.suncode.plugin.plusedoreczeniaasseco.service.EDeliveryService;
import com.suncode.pwfl.administration.email.oauth.OAuth2Service;
import com.suncode.pwfl.administration.email.oauth.connection.OAuth2Connection;
import com.suncode.pwfl.administration.email.oauth.connection.OAuth2ConnectionService;
import com.suncode.pwfl.archive.WfFile;
import java.io.File;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EDeliveryServiceImpl
implements EDeliveryService {
    private static final Logger log = LoggerFactory.getLogger(EDeliveryServiceImpl.class);
    public static final int MESSAGES_AMOUNT_LIMIT = 100;
    private static final int SAFE_FROM_DATE_OFFSET_MINUTES = 5;
    @Autowired
    private OAuth2Service oAuth2Service;
    @Autowired
    private OAuth2ConnectionService oAuth2ConnectionService;
    @Autowired
    private ApiClient apiClient;

    @Override
    public List<ConsignmentRes> getNewMessages(EdorConfig edorConfig, OffsetDateTime from) throws EDeliveryException {
        ArrayList<ConsignmentsGetResVo> messagesList = new ArrayList<ConsignmentsGetResVo>();
        int page = 0;
        while (true) {
            ConsignmentsGetResVo pageOfMessages = this.getNewMessages(edorConfig, from, page, 100, edorConfig.getEDeliveryAddress(), null);
            messagesList.add(pageOfMessages);
            if (CollectionUtils.isEmpty(pageOfMessages.getConsignments())) break;
            ++page;
        }
        return messagesList.stream().filter(vo -> vo.getConsignments() != null).flatMap(vo -> vo.getConsignments().stream()).filter(consignmentRes -> Objects.equals(consignmentRes.getRecipientAddress(), edorConfig.getEDeliveryAddress())).toList();
    }

    @Override
    public ConsignmentsGetResVo getNewMessages(EdorConfig edorConfig, OffsetDateTime from, int page, int size, String mailbox, Boolean archive) throws EDeliveryException {
        try {
            return this.apiClient.getConsignments(edorConfig, this.getAccessToken(edorConfig), from.minusMinutes(5L), page, size, mailbox, archive);
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public LocationResVo sendNewMessage(EdorConfig edorConfig, MediaDataModel metadata, File body, List<WfFile> attachments) throws EDeliveryException {
        try {
            return this.apiClient.postConsignment(edorConfig, this.getAccessToken(edorConfig), metadata, body, attachments);
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public ConsignmentPostageGetResVo getConsignmentPostage(EdorConfig edorConfig, Set<String> recipients) throws EDeliveryException {
        try {
            return this.apiClient.getConsignmentPostage(edorConfig, this.getAccessToken(edorConfig), recipients);
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public List<EvidenceRes> getEvidences(EdorConfig edorConfig, OffsetDateTime from, String messageId) throws EDeliveryException {
        try {
            ArrayList<EvidencesGetResVo> allPagesOfEvidences = new ArrayList<EvidencesGetResVo>();
            int page = 0;
            while (true) {
                EvidencesGetResVo singlePageOfEvidences = this.apiClient.getEvidences(edorConfig, this.getAccessToken(edorConfig), from.minusMinutes(5L), page, 100, edorConfig.getEDeliveryAddress(), null);
                allPagesOfEvidences.add(singlePageOfEvidences);
                if (CollectionUtils.isEmpty(singlePageOfEvidences.getEvidences())) break;
                ++page;
            }
            return allPagesOfEvidences.stream().filter(vo -> vo.getEvidences() != null).flatMap(vo -> vo.getEvidences().stream()).filter(evidenceRes -> Objects.equals(evidenceRes.getMessageId(), messageId)).filter(evidenceRes -> StringUtils.isNotEmpty((CharSequence)evidenceRes.getEvidenceType())).toList();
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public byte[] getEvidence(EdorConfig edorConfig, String evidenceId, String format) throws EDeliveryException {
        try {
            return this.apiClient.getEvidence(edorConfig, this.getAccessToken(edorConfig), edorConfig.getEDeliveryAddress(), evidenceId, format);
        }
        catch (Exception e) {
            throw new EDeliveryException(e);
        }
    }

    @Override
    public List<EZDADESearchResVo> searchForAddress(EdorConfig edorConfig, EZDADESearchReqVo searchRequest) throws EDeliveryException {
        try {
            return this.apiClient.searchForAddress(edorConfig, this.getAccessToken(edorConfig), searchRequest);
        }
        catch (Exception e) {
            throw new EDeliveryException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] downloadAttachment(EdorConfig edorConfig, AttachmentVo attachmentVo) throws EDeliveryException {
        try {
            return this.apiClient.downloadAttachment(this.getAccessToken(edorConfig), attachmentVo);
        }
        catch (Exception e) {
            throw new EDeliveryException(e.getMessage(), e);
        }
    }

    @Override
    public String getAccessToken(EdorConfig edorConfig) {
        String connectionId = edorConfig.getOAuth2Connection();
        OAuth2Connection connection = (OAuth2Connection)this.oAuth2ConnectionService.get((Serializable)Long.valueOf(connectionId));
        return this.oAuth2Service.getActiveConnection(connection).getAccessToken();
    }

    public OAuth2Service getOAuth2Service() {
        return this.oAuth2Service;
    }

    public OAuth2ConnectionService getOAuth2ConnectionService() {
        return this.oAuth2ConnectionService;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }
}

