/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczeniaasseco.scheduledtasks;

import com.suncode.plugin.plusedoreczeniaasseco.Categories;
import com.suncode.plugin.plusedoreczeniaasseco.scheduledtasks.UpoFormat;
import com.suncode.plugin.plusedoreczeniaasseco.scheduledtasks.UpoType;
import com.suncode.plugin.plusedoreczeniaasseco.scheduledtasks.dto.upo.UpoProcessingResultDto;
import com.suncode.plugin.plusedoreczeniaasseco.scheduledtasks.dto.upo.UpoStatus;
import com.suncode.plugin.plusedoreczeniaasseco.service.ProcessingService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityState;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
@ScheduledTaskScript(value="dist/plusedoreczeniaasseco/scheduledtasks/ImportUpo/pwe_dynamic_form.js")
public class ImportUpo {
    private static final Logger log = LoggerFactory.getLogger(ImportUpo.class);
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private ProcessingService processingService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("plusedoreczeniaasseco.scheduledtasks.ImportUpo")).name("plusedoreczeniaasseco.scheduledtasks.ImportUpo.name")).description("plusedoreczeniaasseco.scheduledtasks.ImportUpo.desc")).category(new Category[]{Categories.PLUS_E_DORECZENIA_ASSECO})).parameter().id("upoType").name("plusedoreczeniaasseco.scheduledtasks.ImportUpo.param.upoType.name").description("plusedoreczeniaasseco.scheduledtasks.ImportUpo.param.upoType.desc").type((Type)Types.STRING).create()).parameter().id("upoFormat").name("plusedoreczeniaasseco.scheduledtasks.ImportUpo.param.upoFormat.name").description("plusedoreczeniaasseco.scheduledtasks.ImportUpo.param.upoFormat.desc").type((Type)Types.STRING).create()).parameter().id("processDefId").name("plusedoreczeniaasseco.scheduledtasks.ImportUpo.param.processDefId.name").type((Type)Types.STRING).create()).parameter().id("activityDefId").name("plusedoreczeniaasseco.scheduledtasks.ImportUpo.param.activityDefId.name").type((Type)Types.STRING).create()).parameter().id("actionId").name("plusedoreczeniaasseco.scheduledtasks.ImportUpo.param.actionId.name").description("plusedoreczeniaasseco.scheduledtasks.ImportUpo.param.actionId.desc").type((Type)Types.STRING).create()).parameter().id("documentClass").name("plusedoreczeniaasseco.scheduledtasks.ImportUpo.param.documentClass.name").type((Type)Types.STRING).create()).parameter().id("documentClassIndexForEvidenceType").name("plusedoreczeniaasseco.scheduledtasks.ImportUpo.param.documentClassIndexForEvidenceType.name").type((Type)Types.STRING).create()).parameter().id("documentClassIndexForMessageId").name("plusedoreczeniaasseco.scheduledtasks.ImportUpo.param.documentClassIndexForMessageId.name").type((Type)Types.STRING).create()).parameter().id("executeDocumentClassActions").name("plusedoreczeniaasseco.scheduledtasks.ImportUpo.param.executeDocumentClassActions.name").type((Type)Types.BOOLEAN).create();
    }

    public String execute(@Param String upoType, @Param String upoFormat, @Param String processDefId, @Param String activityDefId, @Param String actionId, @Param String documentClass, @Param String documentClassIndexForEvidenceType, @Param String documentClassIndexForMessageId, @Param Boolean executeDocumentClassActions, org.apache.log4j.Logger taskLog) {
        try {
            List activities = this.activityFinder.findActivities(processDefId, activityDefId, Arrays.asList(ActivityState.RUNNING, ActivityState.NOT_STARTED), new String[0]);
            if (activities.isEmpty()) {
                String noActivitiesFoundMessage = "No activities found.";
                taskLog.info((Object)noActivitiesFoundMessage);
                return noActivitiesFoundMessage;
            }
            taskLog.debug((Object)MessageFormat.format("Found {0} activities.", activities.size()));
            UpoProcessingResultDto upoProcessingResultDto = new UpoProcessingResultDto();
            for (Activity activity : activities) {
                try {
                    UpoStatus upoStatus = this.processingService.downloadUpo(activity, UpoType.valueOf(upoType), UpoFormat.valueOf(upoFormat), actionId, documentClass, documentClassIndexForEvidenceType, documentClassIndexForMessageId, executeDocumentClassActions, taskLog);
                    switch (upoStatus) {
                        case SUCCESS: {
                            upoProcessingResultDto.increaseSuccessesCount();
                            break;
                        }
                        case PENDING: {
                            upoProcessingResultDto.increasePendingCount();
                            break;
                        }
                        case ERROR: {
                            upoProcessingResultDto.increaseFailuresCount();
                        }
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    taskLog.error((Object)e.getMessage());
                    upoProcessingResultDto.increaseFailuresCount();
                }
            }
            String summary = MessageFormat.format("Success: {0}, Pending: {1}, Errors: {2}", upoProcessingResultDto.getSuccessesCount(), upoProcessingResultDto.getPendingCount(), upoProcessingResultDto.getFailuresCount());
            taskLog.info((Object)summary);
            return summary;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

