/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczeniaasseco.scheduledtasks;

import com.suncode.plugin.plusedoreczeniaasseco.Categories;
import com.suncode.plugin.plusedoreczeniaasseco.db.service.MessageService;
import com.suncode.plugin.plusedoreczeniaasseco.db.service.MessagesImportLogService;
import com.suncode.plugin.plusedoreczeniaasseco.dto.ConsignmentRes;
import com.suncode.plugin.plusedoreczeniaasseco.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczeniaasseco.pluginconfigurationmanager.service.ConfigurationService;
import com.suncode.plugin.plusedoreczeniaasseco.scheduledtasks.DocumentsOrder;
import com.suncode.plugin.plusedoreczeniaasseco.scheduledtasks.dto.ProcessingResultDto;
import com.suncode.plugin.plusedoreczeniaasseco.service.EDeliveryService;
import com.suncode.plugin.plusedoreczeniaasseco.service.ProcessingException;
import com.suncode.plugin.plusedoreczeniaasseco.service.ProcessingService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
@ScheduledTaskScript(value="dist/plusedoreczeniaasseco/scheduledtasks/ImportMessages/pwe_dynamic_form.js")
public class ImportMessages {
    private static final Logger log = LoggerFactory.getLogger(ImportMessages.class);
    private static final String LAST_PROCESSED_MESSAGE_DATE = "LAST_PROCESSED_MESSAGE_DATE";
    private static final int DEFAULT_LOOKUP_DAYS = 30;
    private static final String GLOBAL_SUMMARY_DELIMITER = ". ";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
    @Autowired
    private EDeliveryService eDeliveryService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private MessagesImportLogService messagesImportLogService;
    @Autowired
    private ProcessingService processingService;
    @Autowired
    private ConfigurationService configService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("plusedoreczeniaasseco.scheduledtasks.ImportMessages")).name("plusedoreczeniaasseco.scheduledtasks.ImportMessages.name")).description("plusedoreczeniaasseco.scheduledtasks.ImportMessages.desc")).category(new Category[]{Categories.PLUS_E_DORECZENIA_ASSECO})).parameter().id("pcmConfigIds").name("plusedoreczeniaasseco.scheduledtasks.ImportMessages.param.pcmConfigIds.name").description("plusedoreczeniaasseco.scheduledtasks.ImportMessages.param.pcmConfigIds.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("readFromDate").name("plusedoreczeniaasseco.scheduledtasks.ImportMessages.param.readFromDate.name").description("plusedoreczeniaasseco.scheduledtasks.ImportMessages.param.readFromDate.desc").type((Type)Types.STRING).create()).parameter().id("attachmentsDocumentClass").name("plusedoreczeniaasseco.scheduledtasks.ImportMessages.param.attachmentsDocumentClass.name").description("plusedoreczeniaasseco.scheduledtasks.ImportMessages.param.attachmentsDocumentClass.desc").type((Type)Types.STRING).create()).parameter().id("attachmentsDocumentClassIndex").name("plusedoreczeniaasseco.scheduledtasks.ImportMessages.param.attachmentsDocumentClassIndex.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("attachmentsDocumentClassParameter").name("plusedoreczeniaasseco.scheduledtasks.ImportMessages.param.attachmentsDocumentClassParameter.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("messageDocumentClass").name("plusedoreczeniaasseco.scheduledtasks.ImportMessages.param.messageDocumentClass.name").description("plusedoreczeniaasseco.scheduledtasks.ImportMessages.param.messageDocumentClass.desc").type((Type)Types.STRING).optional().create()).parameter().id("messageDocumentClassIndex").name("plusedoreczeniaasseco.scheduledtasks.ImportMessages.param.messageDocumentClassIndex.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("messageDocumentClassParameter").name("plusedoreczeniaasseco.scheduledtasks.ImportMessages.param.messageDocumentClassParameter.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("orderOfAddingDocuments").name("plusedoreczeniaasseco.scheduledtasks.ImportMessages.param.orderOfAddingDocuments.name").description("plusedoreczeniaasseco.scheduledtasks.ImportMessages.param.orderOfAddingDocuments.desc").type((Type)Types.STRING).defaultValue((Object)DocumentsOrder.MESSAGE_FILE_FIRST.name()).create();
    }

    public String execute(@Param String[] pcmConfigIds, @Param String readFromDate, @Param String attachmentsDocumentClass, @PairedParam(key="attachmentsDocumentClassIndex", value="attachmentsDocumentClassParameter") Map<String, String> attachmentIndexesAndParams, @Param String messageDocumentClass, @PairedParam(key="messageDocumentClassIndex", value="messageDocumentClassParameter") Map<String, String> messageIndexesAndParams, @Param String orderOfAddingDocuments, org.apache.log4j.Logger taskLog) {
        try {
            ArrayList<String> globalSummary = new ArrayList<String>();
            for (String configId : pcmConfigIds) {
                taskLog.debug((Object)MessageFormat.format("########## {0} ##########", configId));
                taskLog.info((Object)MessageFormat.format("Downloading messages for config=\"{0}\".", configId));
                EdorConfig edorConfig = this.configService.readConfigurationFromPCM(configId);
                Instant lastProcessedMessageTime = this.messagesImportLogService.getLastProcessedMessageDate(edorConfig.getEDeliveryAddress(), edorConfig.getSystemType());
                OffsetDateTime readFrom = this.parseReadFromDate(lastProcessedMessageTime, readFromDate);
                List<ConsignmentRes> newMessages = this.eDeliveryService.getNewMessages(edorConfig, readFrom);
                ProcessingResultDto processingResult = new ProcessingResultDto();
                Set<String> alreadyProcessedMessages = this.messageService.findAlreadyProcessedMessages(newMessages.stream().map(ConsignmentRes::getMessageId).toList());
                ArrayList<ConsignmentRes> filteredMessages = new ArrayList<ConsignmentRes>();
                for (ConsignmentRes message : newMessages) {
                    String messageId = message.getMessageId();
                    if (alreadyProcessedMessages.contains(messageId)) {
                        processingResult.getSkippedMessages().add(messageId);
                        log.info("Skipping already processed message with ID: {}", (Object)messageId);
                        continue;
                    }
                    filteredMessages.add(message);
                }
                for (ConsignmentRes message : filteredMessages) {
                    this.processMessage(edorConfig, attachmentsDocumentClass, attachmentIndexesAndParams, messageDocumentClass, messageIndexesAndParams, orderOfAddingDocuments, processingResult, message, taskLog);
                }
                int failedMessagesCount = processingResult.getFailedMessageIds().size();
                String summary = MessageFormat.format("Summary for config \"{0}\": '{' Processed: {1}, Failed: {2} '}'", edorConfig.getConfigId(), processingResult.getProcessedMessages().size(), failedMessagesCount);
                Timestamp latestMessageTimestamp = this.getLatestMessageTimestamp(processingResult);
                if (failedMessagesCount == 0 && latestMessageTimestamp != null) {
                    this.messagesImportLogService.save(edorConfig.getSystemType().toString(), latestMessageTimestamp, edorConfig.getEDeliveryAddress(), summary);
                }
                globalSummary.add(summary);
                taskLog.debug((Object)MessageFormat.format("########## {0} ##########", configId));
            }
            return String.join((CharSequence)GLOBAL_SUMMARY_DELIMITER, globalSummary);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void processMessage(EdorConfig edorConfig, String attachmentsDocumentClass, Map<String, String> attachmentIndexesAndParams, String messageDocumentClass, Map<String, String> messageIndexesAndParams, String orderOfAddingDocuments, ProcessingResultDto processingResultDto, ConsignmentRes message, org.apache.log4j.Logger taskLog) {
        try {
            this.processingService.processMessage(edorConfig, attachmentsDocumentClass, attachmentIndexesAndParams, messageDocumentClass, messageIndexesAndParams, DocumentsOrder.valueOf(orderOfAddingDocuments), message);
            taskLog.debug((Object)MessageFormat.format("Processed message with id=\"{0}\"", message.getMessageId()));
            processingResultDto.getProcessedMessages().add(message);
        }
        catch (ProcessingException e) {
            String messageId = message.getMessageId();
            taskLog.error((Object)MessageFormat.format("Could not process message with id=\"{0}\"", messageId));
            taskLog.error((Object)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            processingResultDto.getFailedMessageIds().add(messageId);
        }
    }

    private Timestamp getLatestMessageTimestamp(ProcessingResultDto processingResultDto) {
        Optional<ConsignmentRes> latestMessage;
        Timestamp latestMessageTimestamp = null;
        List<ConsignmentRes> processedMessages = processingResultDto.getProcessedMessages();
        if (!processedMessages.isEmpty() && (latestMessage = processedMessages.stream().filter(message -> message.getCreateTime() != null).max(Comparator.comparing(ConsignmentRes::getCreateTime, Comparator.nullsLast(Comparator.naturalOrder())))).isPresent()) {
            OffsetDateTime latestMessageTimestampDate = latestMessage.get().getCreateTime();
            latestMessageTimestamp = latestMessageTimestampDate != null ? Timestamp.from(latestMessageTimestampDate.toInstant()) : null;
        }
        return latestMessageTimestamp;
    }

    private OffsetDateTime parseReadFromDate(Instant lastProcessedMessageTime, String readFromDate) throws ParseException {
        OffsetDateTime from;
        if (readFromDate.equals(LAST_PROCESSED_MESSAGE_DATE)) {
            boolean firstTimeExecution;
            boolean bl = firstTimeExecution = lastProcessedMessageTime == null;
            from = firstTimeExecution ? OffsetDateTime.now().minusDays(30L) : lastProcessedMessageTime.atOffset(ZoneOffset.UTC);
        } else {
            from = this.dateFormat.parse(readFromDate).toInstant().atOffset(ZoneOffset.UTC);
        }
        return from;
    }
}

