/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczeniaasseco.pluginconfigurationmanager.service;

import com.google.gson.Gson;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.plusedoreczeniaasseco.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczeniaasseco.pluginconfigurationmanager.service.ConfigurationService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ConfigurationServiceImpl
implements ConfigurationService {
    private final Gson gson = new Gson();
    @Autowired
    private ConfigurationFileService configurationFileService;
    @Autowired
    private Plugin plugin;

    @Override
    public EdorConfig readConfigurationFromPCM(String configId) throws IOException {
        Assert.isTrue((boolean)this.configExists(configId), (String)MessageFormat.format("Config \"{0}\" does not exist", configId));
        try (InputStream stream = this.configurationFileService.readFile(this.plugin.getKey(), configId);){
            String content = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            EdorConfig edorConfig = (EdorConfig)this.gson.fromJson(content, EdorConfig.class);
            this.validateConfig(edorConfig, configId);
            edorConfig.setConfigId(configId);
            EdorConfig edorConfig2 = edorConfig;
            return edorConfig2;
        }
    }

    private void validateConfig(EdorConfig edorConfig, String configId) {
        try {
            Assert.notNull((Object)edorConfig, (String)"Configuration must not be empty");
            Assert.notNull((Object)((Object)edorConfig.getSystemType()), (String)"System type must not be empty");
            Assert.hasText((String)edorConfig.getEDeliveryAddress(), (String)"e-Delivery Address must not be empty");
            Assert.hasText((String)edorConfig.getOAuth2Client(), (String)"OAuth2 client must not be empty");
            Assert.hasText((String)edorConfig.getOAuth2Connection(), (String)"OAuth2 connection must not be empty");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("PCM Config validation failed for config \"" + configId + "\". Reason: " + e.getMessage(), e);
        }
    }

    private boolean configExists(String configId) {
        return this.configurationFileService.doesFileExist(this.plugin.getKey(), configId);
    }
}

