/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczeniaasseco.db.service;

import com.suncode.plugin.plusedoreczeniaasseco.EdorSystemType;
import com.suncode.plugin.plusedoreczeniaasseco.db.dao.MessagesImportLogDao;
import com.suncode.plugin.plusedoreczeniaasseco.db.entity.MessagesImportLogEntity;
import com.suncode.plugin.plusedoreczeniaasseco.db.service.MessagesImportLogService;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Order;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import java.sql.Timestamp;
import java.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MessagesImportLogServiceImpl
implements MessagesImportLogService {
    @Autowired
    private MessagesImportLogDao dao;

    @Override
    public void save(String systemType, Timestamp lastProcessedMessageTimestamp, String eDeliveryAddress, String summary) {
        MessagesImportLogEntity entity = MessagesImportLogEntity.builder().systemType(systemType).lastProcessedMessageTimestamp(lastProcessedMessageTimestamp).eDeliveryAddress(eDeliveryAddress).summary(summary).build();
        this.dao.save(entity);
    }

    @Override
    public Instant getLastProcessedMessageDate(String eDeliveryAddress, EdorSystemType systemType) {
        HibernateCriteria lastCallDateCriteria = HibernateCriteria.forClass(MessagesImportLogEntity.class).add(Restrictions.eq((String)"eDeliveryAddress", (Object)eDeliveryAddress)).add(Restrictions.eq((String)"systemType", (Object)systemType.toString())).addOrder(Order.desc((String)"lastProcessedMessageTimestamp"));
        MessagesImportLogEntity found = (MessagesImportLogEntity)this.dao.findOne(lastCallDateCriteria);
        return found == null ? null : found.getLastProcessedMessageTimestamp().toInstant();
    }
}

