/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczeniaasseco.db.service;

import com.google.common.collect.Lists;
import com.plusmpm.database.dbspecific.NativeDatabase;
import com.suncode.plugin.plusedoreczeniaasseco.db.dao.MessageDao;
import com.suncode.plugin.plusedoreczeniaasseco.db.entity.MessageEntity;
import com.suncode.plugin.plusedoreczeniaasseco.db.service.MessageService;
import com.suncode.plugin.plusedoreczeniaasseco.dto.ConsignmentRes;
import com.suncode.plugin.plusedoreczeniaasseco.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MessageServiceImpl
implements MessageService {
    @Autowired
    private MessageDao messageDao;

    @Override
    public void save(ConsignmentRes message, EdorConfig edorConfig) {
        MessageEntity messageEntity = MessageEntity.builder().senderEDeliveryAddress(message.getSenderAddress()).recipientEDeliveryAddress(message.getRecipientAddress()).subject(message.getSubject()).messageId(message.getMessageId()).threadId(message.getThreadId()).shippingService(message.getShippingService()).createTime(message.getCreateTime() != null ? Timestamp.from(message.getCreateTime().toInstant()) : null).postTime(message.getPostTime() != null ? Timestamp.from(message.getPostTime().toInstant()) : null).receiptTime(message.getReceiptTime() != null ? Timestamp.from(message.getReceiptTime().toInstant()) : null).expirationTime(message.getExpirationTime() != null ? Timestamp.from(message.getExpirationTime().toInstant()) : null).configId(edorConfig.getConfigId()).build();
        this.messageDao.save(messageEntity);
    }

    @Override
    public Set<String> findAlreadyProcessedMessages(List<String> messageIds) {
        if (messageIds.isEmpty()) {
            return Collections.emptySet();
        }
        int maxNumberOfInClauseParameters = NativeDatabase.getImplementation().getMaxNumberOfInClauseParameters();
        if (messageIds.size() > maxNumberOfInClauseParameters) {
            List partitions = Lists.partition(messageIds, (int)maxNumberOfInClauseParameters);
            return partitions.stream().map(partition -> {
                HibernateCriteria criteria = HibernateCriteria.forClass(MessageEntity.class);
                criteria.add(Restrictions.in((String)"messageId", (Collection)partition));
                return this.messageDao.findByCriteria(criteria);
            }).flatMap(Collection::stream).map(MessageEntity::getMessageId).collect(Collectors.toSet());
        }
        HibernateCriteria criteria = HibernateCriteria.forClass(MessageEntity.class);
        criteria.add(Restrictions.in((String)"messageId", messageIds));
        return this.messageDao.findByCriteria(criteria).stream().map(MessageEntity::getMessageId).collect(Collectors.toSet());
    }
}

