/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczeniaasseco.controllers;

import com.suncode.plugin.plusedoreczeniaasseco.EdorKeys;
import com.suncode.plugin.plusedoreczeniaasseco.EdorKeysImpl;
import com.suncode.plugin.plusedoreczeniaasseco.PcmKeysImpl;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
public class EdorKeysController {
    private static final Logger log = LoggerFactory.getLogger(EdorKeysController.class);

    @ResponseBody
    @RequestMapping(value={"edorKeys"}, method={RequestMethod.GET})
    public List<Map<String, String>> getEdorKeys() {
        Stream<PcmKeysImpl> allKeys = Stream.concat(Arrays.stream(EdorKeysImpl.values()), Arrays.stream(PcmKeysImpl.values()));
        return allKeys.sorted(Comparator.comparing(EdorKeys::getDescription)).map(this::keyToMap).toList();
    }

    private Map<String, String> keyToMap(EdorKeys<?> key) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("key", key.getKey());
        map.put("type", key.getType().name().toUpperCase());
        map.put("desc", key.getDescription());
        return map;
    }
}

