/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczeniaasseco.controllers;

import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.plusedoreczeniaasseco.EdorSystemType;
import com.suncode.pwfl.search.CountedResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/config"})
public class ConfigurationController {
    private static final String PLUGIN_ID = "com.suncode.plugin-plus-edoreczenia-asseco";
    @Autowired
    private ConfigurationFileService configurationFileService;

    @RequestMapping(value={"systemTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getEdorSystemTypes() {
        return EdorSystemType.stream().collect(Collectors.toMap(Enum::toString, EdorSystemType::getTranslation, (e1, e2) -> e1, LinkedHashMap::new));
    }

    @RequestMapping(value={"configurationIds"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getConfigurationIds(@RequestParam(required=false) String query) {
        List<Map> configList = Arrays.stream(this.configurationFileService.getAllReadableFilesIds(PLUGIN_ID)).filter(configId -> StringUtils.containsIgnoreCase((CharSequence)configId, (CharSequence)query)).sorted().map(configId -> Collections.singletonMap("configId", configId)).toList();
        return new CountedResult((long)configList.size(), configList);
    }
}

