﻿window.vfgFileSchema = {
    fields: [
        {
            type: "select",
            inputType: "text",
            label: "plusedoreczeniaasseco.pcm.schema.params.systemType.name",
            help: "plusedoreczeniaasseco.pcm.schema.params.systemType.desc",
            model: "systemType",
            required: true,
            values: function () {
                let data;
                jQuery.ajax({
                        url: 'plugin/com.suncode.plugin-plus-edoreczenia-asseco/config/systemTypes', success: function (result) {
                            data = Object.entries(result).map(row => ({id: row[0], name: row[1]}));
                        },
                        async: false
                    }
                );
                return data;
            }
        },
        {
            type: "input",
            inputType: "text",
            label: "plusedoreczeniaasseco.pcm.schema.params.eDeliveryAddress.name",
            help: "plusedoreczeniaasseco.pcm.schema.params.eDeliveryAddress.desc",
            model: "eDeliveryAddress",
            required: true
        },
        {
            type: "select",
            inputType: "text",
            label: "plusedoreczeniaasseco.pcm.schema.params.oAuth2Client.name",
            help: "plusedoreczeniaasseco.pcm.schema.params.oAuth2Client.desc",
            model: "oAuth2Client",
            required: true,
            values: function () {
                let data;
                jQuery.ajax({
                        url: PW.getAbsolutePath('/api/oauth/clients'), success: function (result) {
                            data = result.map(row => ({id: row.id, name: row.name}));
                        },
                        async: false
                    }
                );
                return data;
            }
        },
        {
            type: "select",
            inputType: "text",
            label: "plusedoreczeniaasseco.pcm.schema.params.oAuth2Connection.name",
            help: "plusedoreczeniaasseco.pcm.schema.params.oAuth2Connection.desc",
            model: "oAuth2Connection",
            required: true,
            values: function (model) {
                let data = [];
                if (model.oAuth2Client) {
                    jQuery.ajax({
                        url: PW.getAbsolutePath('/api/oauth/clients/' + model.oAuth2Client), success: function (result) {
                            data = result.connections.map(row => ({id: row.id, name: row.email}));
                        },
                        async: false
                    });
                }
                return data;
            }
        },
    ]
};
