/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczeniaasseco.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.suncode.plugin.plusedoreczeniaasseco.dto.AttachmentVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.ConsignmentPostageGetResVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.ConsignmentsGetResVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.EZDADESearchReqVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.EZDADESearchResVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.EvidencesGetResVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.LocationResVo;
import com.suncode.plugin.plusedoreczeniaasseco.dto.MediaDataModel;
import com.suncode.plugin.plusedoreczeniaasseco.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczeniaasseco.service.ApiResponseException;
import com.suncode.pwfl.administration.email.oauth.OAuth2Service;
import com.suncode.pwfl.archive.WfFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiClient {
    private static final Logger log = LoggerFactory.getLogger(ApiClient.class);
    private static final Pattern INVALID_FILENAME_CHARACTERS_PATTERN = Pattern.compile("[~\"#%&*:<>?!/\\\\{}| ]");
    private static final String INVALID_FILENAME_CHARACTERS_REPLACEMENT = Pattern.quote("_");
    private static final String DEFAULT_BODY_FILENAME = "body.txt";
    private final ObjectMapper objectMapper;
    private final OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    @Autowired
    OAuth2Service oAuth2Service;

    public ApiClient() {
        this.objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).setDefaultSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SKIP)).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public ConsignmentsGetResVo getConsignments(EdorConfig edorConfig, String accessToken, OffsetDateTime from, int page, int size, String mailbox, Boolean archive) throws ApiResponseException, IOException {
        String path = "/consignments";
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getPathUrl() + path))).newBuilder();
        this.addQueryParameter(urlBuilder, "from", this.formatDateToIso(from));
        this.addQueryParameter(urlBuilder, "page", page);
        this.addQueryParameter(urlBuilder, "size", size);
        this.addQueryParameter(urlBuilder, "mailbox", mailbox);
        this.addQueryParameter(urlBuilder, "archive", archive);
        String url = urlBuilder.build().toString();
        Request request = this.createGetRequest(url, accessToken);
        return this.send(request, new TypeReference<ConsignmentsGetResVo>(){});
    }

    public LocationResVo postConsignment(EdorConfig edorConfig, String accessToken, MediaDataModel metadata, File body, List<WfFile> attachments) throws ApiResponseException, IOException {
        String path = "/consignment";
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getPathUrl() + path))).newBuilder();
        RequestBody multipartBody = this.buildMultipartConsignmentBody(metadata, body, attachments);
        String url = urlBuilder.build().toString();
        Request request = this.createPostRequest(url, multipartBody, accessToken);
        return this.send(request, new TypeReference<LocationResVo>(){});
    }

    public ConsignmentPostageGetResVo getConsignmentPostage(EdorConfig edorConfig, String accessToken, Set<String> recipients) throws ApiResponseException, IOException {
        String path = "/consignment/postage";
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getPathUrl() + path))).newBuilder();
        for (String recipient : recipients) {
            this.addQueryParameter(urlBuilder, "recipient", recipient);
        }
        String url = urlBuilder.build().toString();
        Request request = this.createGetRequest(url, accessToken);
        return this.send(request, new TypeReference<ConsignmentPostageGetResVo>(){});
    }

    public EvidencesGetResVo getEvidences(EdorConfig edorConfig, String accessToken, OffsetDateTime from, Integer page, Integer size, String mailbox, Boolean archive) throws ApiResponseException, IOException {
        String path = "/evidences";
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getPathUrl() + path))).newBuilder();
        this.addQueryParameter(urlBuilder, "from", this.formatDateToIso(from));
        this.addQueryParameter(urlBuilder, "page", page);
        this.addQueryParameter(urlBuilder, "size", size);
        this.addQueryParameter(urlBuilder, "mailbox", mailbox);
        this.addQueryParameter(urlBuilder, "archive", archive);
        String url = urlBuilder.build().toString();
        Request request = this.createGetRequest(url, accessToken);
        return this.send(request, new TypeReference<EvidencesGetResVo>(){});
    }

    public byte[] getEvidence(EdorConfig edorConfig, String accessToken, String mailbox, String evidenceId, String format) throws ApiResponseException, IOException {
        String path = "/evidence";
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getPathUrl() + path))).newBuilder();
        this.addQueryParameter(urlBuilder, "mailbox", mailbox);
        this.addQueryParameter(urlBuilder, "evidenceId", evidenceId);
        this.addQueryParameter(urlBuilder, "format", format);
        String url = urlBuilder.build().toString();
        Request request = this.createGetRequest(url, accessToken);
        byte[] evidenceZipArchive = this.send(request, new TypeReference<byte[]>(){});
        return this.extractFirstFileByExtensionFromZipArchive(evidenceZipArchive, format);
    }

    public List<EZDADESearchResVo> searchForAddress(EdorConfig edorConfig, String accessToken, EZDADESearchReqVo searchRequest) throws ApiResponseException, IOException {
        String path = "/v1/ezd/{ade}/search".replace("{ade}", edorConfig.getEDeliveryAddress());
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(edorConfig.getSystemType().getPathUrl() + path))).newBuilder();
        String url = urlBuilder.build().toString();
        String jsonBody = this.objectMapper.writeValueAsString((Object)searchRequest);
        RequestBody body = RequestBody.create((String)jsonBody, (MediaType)MediaType.parse((String)"application/json"));
        Request request = this.createPostRequest(url, body, accessToken);
        return this.send(request, new TypeReference<List<EZDADESearchResVo>>(){});
    }

    public byte[] downloadAttachment(String accessToken, AttachmentVo attachment) throws IOException, ApiResponseException {
        String fileUrl = attachment.getUrl();
        Request request = this.createGetRequest(fileUrl, accessToken);
        return this.send(request, new TypeReference<byte[]>(){});
    }

    private <T> T send(Request request, TypeReference<T> clazz) throws IOException, ApiResponseException {
        try (Response response = this.httpClient.newCall(request).execute();){
            log.info("Request: {}", (Object)request);
            log.info("Response: {}", (Object)response);
            if (!response.isSuccessful()) {
                String responseBody = Objects.requireNonNull(response.body()).string();
                String errorDetails = StringUtils.isNotBlank((CharSequence)responseBody) ? responseBody : MessageFormat.format("{0}: {1}", response.code(), response.message());
                throw new ApiResponseException(errorDetails);
            }
            ResponseBody responseBody = Objects.requireNonNull(response.body());
            if (clazz.getType().equals(byte[].class)) {
                byte[] byArray = responseBody.bytes();
                return (T)byArray;
            }
            Object object = this.objectMapper.readValue(responseBody.string(), clazz);
            return (T)object;
        }
    }

    private void addQueryParameter(HttpUrl.Builder urlBuilder, String key, Object object) {
        if (object != null) {
            urlBuilder.addQueryParameter(key, String.valueOf(object));
        }
    }

    private Request createGetRequest(String url, String accessToken) {
        return new Request.Builder().url(url).addHeader("Authorization", "Bearer " + accessToken).addHeader("Accept-Language", "pl,en-US;q=0.7,en;q=0.3").build();
    }

    private Request createPostRequest(String url, RequestBody body, String accessToken) {
        return new Request.Builder().post(body).url(url).addHeader("Authorization", "Bearer " + accessToken).addHeader("Accept-Language", "pl,en-US;q=0.7,en;q=0.3").build();
    }

    private String formatDateToIso(OffsetDateTime offsetDateTime) {
        return offsetDateTime != null ? offsetDateTime.withOffsetSameInstant(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) : null;
    }

    private RequestBody buildMultipartConsignmentBody(MediaDataModel metadata, File bodyTextFile, List<WfFile> attachments) throws IOException {
        MultipartBody.Builder multiPartBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        String metadataJson = this.objectMapper.writeValueAsString((Object)metadata);
        multiPartBodyBuilder.addFormDataPart("metadata", metadataJson);
        if (bodyTextFile != null) {
            multiPartBodyBuilder.addFormDataPart("body", DEFAULT_BODY_FILENAME, RequestBody.create((File)bodyTextFile, (MediaType)MediaType.parse((String)"text/plain")));
        }
        if (attachments != null) {
            for (int i = 0; i < attachments.size(); ++i) {
                WfFile attachment = attachments.get(i);
                File file = new File(attachment.getFullPath());
                int attachmentIndex = i + 1;
                multiPartBodyBuilder.addFormDataPart("attachment" + attachmentIndex, this.sanitizeFileName(attachment.getFileName()), RequestBody.create((File)file, (MediaType)MediaType.parse((String)Files.probeContentType(file.toPath()))));
            }
        }
        return multiPartBodyBuilder.build();
    }

    private String sanitizeFileName(String fileName) {
        String sanitizedFileName = INVALID_FILENAME_CHARACTERS_PATTERN.matcher(fileName).replaceAll(INVALID_FILENAME_CHARACTERS_REPLACEMENT);
        return sanitizedFileName.replaceAll(INVALID_FILENAME_CHARACTERS_REPLACEMENT + "+", INVALID_FILENAME_CHARACTERS_REPLACEMENT);
    }

    /*
     * Loose catch block
     */
    private byte[] extractFirstFileByExtensionFromZipArchive(byte[] zipArchiveBytes, String extension) throws IOException {
        try (ByteArrayInputStream zipByteArrayInputStream = new ByteArrayInputStream(zipArchiveBytes);
             ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream((InputStream)zipByteArrayInputStream);){
            ZipArchiveEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                byte[] byArray;
                if (zipEntry.isDirectory() || !FilenameUtils.getExtension((String)zipEntry.getName()).equalsIgnoreCase(extension)) continue;
                try (ByteArrayOutputStream extractedFileOutputStream = new ByteArrayOutputStream();){
                    int bytesRead;
                    byte[] readBuffer = new byte[8192];
                    while ((bytesRead = zipInputStream.read(readBuffer)) != -1) {
                        extractedFileOutputStream.write(readBuffer, 0, bytesRead);
                    }
                    byArray = extractedFileOutputStream.toByteArray();
                }
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public OAuth2Service getOAuth2Service() {
        return this.oAuth2Service;
    }
}

