/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczeniaasseco.db.service;

import com.suncode.plugin.plusedoreczeniaasseco.db.dao.SentMessageDao;
import com.suncode.plugin.plusedoreczeniaasseco.db.entity.SentMessageEntity;
import com.suncode.plugin.plusedoreczeniaasseco.db.service.SentMessageService;
import com.suncode.plugin.plusedoreczeniaasseco.dto.MediaDataModel;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Order;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SentMessageServiceImpl
implements SentMessageService {
    @Autowired
    private SentMessageDao sentMessageDao;

    @Override
    public SentMessageEntity findByProcessId(String processId) {
        HibernateCriteria criteria = HibernateCriteria.forClass(SentMessageEntity.class);
        criteria.add(Restrictions.eq((String)"processId", (Object)processId));
        criteria.addOrder(Order.desc((String)"createdAt"));
        return (SentMessageEntity)this.sentMessageDao.findOne(criteria);
    }

    @Override
    public void save(MediaDataModel mediaDataModel, String textBody, String messageId, String processId, String pcmConfigId) {
        SentMessageEntity sentMessageEntity = SentMessageEntity.builder().messageId(messageId).senderEDeliveryAddress(mediaDataModel.getSender()).recipientEDeliveryAddress(mediaDataModel.getRecipients() != null ? String.join((CharSequence)",", mediaDataModel.getRecipients()) : null).threadId(mediaDataModel.getThreadId()).subject(mediaDataModel.getSubject()).textBody(textBody).pcmConfigId(pcmConfigId).processId(processId).build();
        this.sentMessageDao.save(sentMessageEntity);
    }

    @Override
    public void update(SentMessageEntity sentMessageEntity) {
        this.sentMessageDao.update(sentMessageEntity);
    }
}

