/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczeniaasseco.controllers;

import com.suncode.plugin.plusedoreczeniaasseco.controllers.dto.EzdAddressSearchDto;
import com.suncode.plugin.plusedoreczeniaasseco.dto.EZDADESearchResVo;
import com.suncode.plugin.plusedoreczeniaasseco.pluginconfigurationmanager.dto.EdorConfig;
import com.suncode.plugin.plusedoreczeniaasseco.pluginconfigurationmanager.service.ConfigurationService;
import com.suncode.plugin.plusedoreczeniaasseco.service.EDeliveryService;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/"})
public class EzdAddressSearchController {
    private static final Logger log = LoggerFactory.getLogger(EzdAddressSearchController.class);
    @Autowired
    private EDeliveryService eDeliveryService;
    @Autowired
    private ConfigurationService configService;

    @ResponseBody
    @RequestMapping(value={"/ezd-address-search"}, method={RequestMethod.POST})
    public ResponseEntity<Object> search(@RequestBody EzdAddressSearchDto searchDto) throws IOException {
        try {
            EdorConfig edorConfig = this.configService.readConfigurationFromPCM(searchDto.getPcmConfigId());
            List<EZDADESearchResVo> searchResult = this.eDeliveryService.searchForAddress(edorConfig, searchDto.getSearchRequest());
            return ResponseEntity.ok(searchResult);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
    }
}

