/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.ini;

import com.plusmpm.ini.ConfigSource;
import com.plusmpm.ini.FileConfigSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;

public final class INIFile {
    private String mstrDateFmt = "yyyy-MM-dd";
    private String mstrTimeStampFmt = "yyyy-MM-dd HH:mm:ss";
    private boolean mblnLoaded = false;
    private ConfigSource configSource;
    private LinkedHashMap mhmapSections;
    private Properties mpropEnv = this.getEnvVars();

    public INIFile(String pstrPathAndName) {
        this(new FileConfigSource(pstrPathAndName));
    }

    public INIFile(ConfigSource configSource) {
        this.mhmapSections = new LinkedHashMap();
        this.configSource = configSource;
        if (configSource.exists()) {
            this.loadConfig();
        }
    }

    public String getFileName() {
        return this.configSource.getSourcePath();
    }

    public String getStringProperty(String pstrSection, String pstrProp) {
        String strRet = null;
        INIProperty objProp = null;
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec != null) {
            objProp = objSec.getProperty(pstrProp);
            if (objProp != null) {
                strRet = objProp.getPropValue();
                objProp = null;
            }
            objSec = null;
        }
        return strRet;
    }

    public Boolean getBooleanProperty(String pstrSection, String pstrProp) {
        boolean blnRet = false;
        String strVal = null;
        INIProperty objProp = null;
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec != null) {
            objProp = objSec.getProperty(pstrProp);
            if (objProp != null) {
                strVal = objProp.getPropValue().toUpperCase();
                if (strVal.equals("YES") || strVal.equals("TRUE") || strVal.equals("1")) {
                    blnRet = true;
                }
                objProp = null;
            }
            objSec = null;
        }
        return new Boolean(blnRet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getIntegerProperty(String pstrSection, String pstrProp) {
        Integer intRet = null;
        String strVal = null;
        INIProperty objProp = null;
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec != null) {
            objProp = objSec.getProperty(pstrProp);
            try {
                if (objProp != null && (strVal = objProp.getPropValue()) != null) {
                    intRet = new Integer(strVal);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            finally {
                if (objProp != null) {
                    objProp = null;
                }
            }
            objSec = null;
        }
        return intRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getLongProperty(String pstrSection, String pstrProp) {
        Long lngRet = null;
        String strVal = null;
        INIProperty objProp = null;
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec != null) {
            objProp = objSec.getProperty(pstrProp);
            try {
                if (objProp != null && (strVal = objProp.getPropValue()) != null) {
                    lngRet = new Long(strVal);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            finally {
                if (objProp != null) {
                    objProp = null;
                }
            }
            objSec = null;
        }
        return lngRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getDoubleProperty(String pstrSection, String pstrProp) {
        Double dblRet = null;
        String strVal = null;
        INIProperty objProp = null;
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec != null) {
            objProp = objSec.getProperty(pstrProp);
            try {
                if (objProp != null && (strVal = objProp.getPropValue()) != null) {
                    dblRet = new Double(strVal);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            finally {
                if (objProp != null) {
                    objProp = null;
                }
            }
            objSec = null;
        }
        return dblRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDateProperty(String pstrSection, String pstrProp) {
        Date dtRet = null;
        String strVal = null;
        SimpleDateFormat dtFmt = null;
        INIProperty objProp = null;
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec != null) {
            objProp = objSec.getProperty(pstrProp);
            try {
                if (objProp != null) {
                    strVal = objProp.getPropValue();
                }
                if (strVal != null) {
                    dtFmt = new SimpleDateFormat(this.mstrDateFmt);
                    dtRet = dtFmt.parse(strVal);
                }
            }
            catch (ParseException parseException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                if (objProp != null) {
                    objProp = null;
                }
            }
            objSec = null;
        }
        return dtRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getTimestampProperty(String pstrSection, String pstrProp) {
        Timestamp tsRet = null;
        Date dtTmp = null;
        String strVal = null;
        SimpleDateFormat dtFmt = null;
        INIProperty objProp = null;
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec != null) {
            objProp = objSec.getProperty(pstrProp);
            try {
                if (objProp != null) {
                    strVal = objProp.getPropValue();
                }
                if (strVal != null) {
                    dtFmt = new SimpleDateFormat(this.mstrDateFmt);
                    dtTmp = dtFmt.parse(strVal);
                    tsRet = new Timestamp(dtTmp.getTime());
                }
            }
            catch (ParseException parseException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                if (objProp != null) {
                    objProp = null;
                }
            }
            objSec = null;
        }
        return tsRet;
    }

    public void addSection(String pstrSection, String pstrComments) {
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this.mhmapSections.put(pstrSection, objSec);
        }
        if (pstrComments != null) {
            objSec.setSecComments(this.delRemChars(pstrComments));
        }
        objSec = null;
    }

    public void setStringProperty(String pstrSection, String pstrProp, String pstrVal, String pstrComments) {
        INIProperty objProp;
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this.mhmapSections.put(pstrSection, objSec);
        }
        if ((objProp = objSec.getProperty(pstrProp)) == null) {
            objSec.setProperty(pstrProp, pstrVal, pstrComments);
        } else {
            objProp.setPropValue(pstrVal);
            if (pstrComments != null) {
                objProp.setPropComments(pstrComments);
            }
        }
    }

    public void setBooleanProperty(String pstrSection, String pstrProp, boolean pblnVal, String pstrComments) {
        INIProperty objProp;
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this.mhmapSections.put(pstrSection, objSec);
        }
        if ((objProp = objSec.getProperty(pstrProp)) == null) {
            if (pblnVal) {
                objSec.setProperty(pstrProp, "TRUE", pstrComments);
            } else {
                objSec.setProperty(pstrProp, "FALSE", pstrComments);
            }
        } else {
            if (pblnVal) {
                objProp.setPropValue("TRUE");
            } else {
                objProp.setPropValue("FALSE");
            }
            if (pstrComments != null) {
                objProp.setPropComments(pstrComments);
            }
        }
    }

    public void setIntegerProperty(String pstrSection, String pstrProp, int pintVal, String pstrComments) {
        INIProperty objProp;
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this.mhmapSections.put(pstrSection, objSec);
        }
        if ((objProp = objSec.getProperty(pstrProp)) == null) {
            objSec.setProperty(pstrProp, Integer.toString(pintVal), pstrComments);
        } else {
            objProp.setPropValue(Integer.toString(pintVal));
            if (pstrComments != null) {
                objProp.setPropComments(pstrComments);
            }
        }
    }

    public void setLongProperty(String pstrSection, String pstrProp, long plngVal, String pstrComments) {
        INIProperty objProp;
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this.mhmapSections.put(pstrSection, objSec);
        }
        if ((objProp = objSec.getProperty(pstrProp)) == null) {
            objSec.setProperty(pstrProp, Long.toString(plngVal), pstrComments);
        } else {
            objProp.setPropValue(Long.toString(plngVal));
            if (pstrComments != null) {
                objProp.setPropComments(pstrComments);
            }
        }
    }

    public void setDoubleProperty(String pstrSection, String pstrProp, double pdblVal, String pstrComments) {
        INIProperty objProp;
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this.mhmapSections.put(pstrSection, objSec);
        }
        if ((objProp = objSec.getProperty(pstrProp)) == null) {
            objSec.setProperty(pstrProp, Double.toString(pdblVal), pstrComments);
        } else {
            objProp.setPropValue(Double.toString(pdblVal));
            if (pstrComments != null) {
                objProp.setPropComments(pstrComments);
            }
        }
    }

    public void setDateProperty(String pstrSection, String pstrProp, Date pdtVal, String pstrComments) {
        INIProperty objProp;
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this.mhmapSections.put(pstrSection, objSec);
        }
        if ((objProp = objSec.getProperty(pstrProp)) == null) {
            objSec.setProperty(pstrProp, this.utilDateToStr(pdtVal, this.mstrDateFmt), pstrComments);
        } else {
            objProp.setPropValue(this.utilDateToStr(pdtVal, this.mstrDateFmt));
            if (pstrComments != null) {
                objProp.setPropComments(pstrComments);
            }
        }
    }

    public void setTimestampProperty(String pstrSection, String pstrProp, Timestamp ptsVal, String pstrComments) {
        INIProperty objProp;
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this.mhmapSections.put(pstrSection, objSec);
        }
        if ((objProp = objSec.getProperty(pstrProp)) == null) {
            objSec.setProperty(pstrProp, this.timeToStr(ptsVal, this.mstrTimeStampFmt), pstrComments);
        } else {
            objProp.setPropValue(this.timeToStr(ptsVal, this.mstrTimeStampFmt));
            if (pstrComments != null) {
                objProp.setPropComments(pstrComments);
            }
        }
    }

    public void setDateFormat(String pstrDtFmt) throws IllegalArgumentException {
        if (!this.checkDateTimeFormat(pstrDtFmt)) {
            throw new IllegalArgumentException("The specified date pattern is invalid!");
        }
        this.mstrDateFmt = pstrDtFmt;
    }

    public void setTimeStampFormat(String pstrTSFmt) {
        if (!this.checkDateTimeFormat(pstrTSFmt)) {
            throw new IllegalArgumentException("The specified timestamp pattern is invalid!");
        }
        this.mstrTimeStampFmt = pstrTSFmt;
    }

    public int getTotalSections() {
        return this.mhmapSections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllSectionNames() {
        int iCntr = 0;
        Iterator iter = null;
        String[] arrRet = null;
        try {
            if (this.mhmapSections.size() > 0) {
                arrRet = new String[this.mhmapSections.size()];
                iter = this.mhmapSections.keySet().iterator();
                while (true) {
                    arrRet[iCntr] = (String)iter.next();
                    ++iCntr;
                    iter.hasNext();
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            if (iter != null) {
                iter = null;
            }
        }
        return arrRet;
    }

    public String[] getPropertyNames(String pstrSection) {
        String[] arrRet = null;
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec != null) {
            arrRet = objSec.getPropNames();
            objSec = null;
        }
        return arrRet;
    }

    public Map getProperties(String pstrSection) {
        Map hmRet = null;
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec != null) {
            hmRet = objSec.getProperties();
            objSec = null;
        }
        return hmRet;
    }

    public void removeProperty(String pstrSection, String pstrProp) {
        INISection objSec = null;
        objSec = (INISection)this.mhmapSections.get(pstrSection);
        if (objSec != null) {
            objSec.removeProperty(pstrProp);
            objSec = null;
        }
    }

    public void removeSection(String pstrSection) {
        if (this.mhmapSections.containsKey(pstrSection)) {
            this.mhmapSections.remove(pstrSection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        if (this.mhmapSections.size() == 0) {
            return false;
        }
        boolean blnRet = false;
        String strName2 = null;
        String strTemp = null;
        Iterator itrSec = null;
        INISection objSec = null;
        OutputStreamWriter objWriter = null;
        ByteArrayOutputStream byteArrOutputStream = new ByteArrayOutputStream();
        try {
            objWriter = new OutputStreamWriter((OutputStream)byteArrOutputStream, "UTF-8");
            for (String strName2 : this.mhmapSections.keySet()) {
                objSec = (INISection)this.mhmapSections.get(strName2);
                strTemp = objSec.toString();
                objWriter.write(strTemp);
                objWriter.write("\r\n");
                objSec = null;
            }
            objWriter.flush();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrOutputStream.toByteArray());
            this.configSource.save(inputStream);
            blnRet = true;
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
        }
        finally {
            if (objWriter != null) {
                this.closeWriter(objWriter);
                objWriter = null;
            }
            if (itrSec != null) {
                itrSec = null;
            }
        }
        return blnRet;
    }

    private Properties getEnvVars() {
        Properties envVars = new Properties();
        System.getenv().forEach((key, value) -> envVars.setProperty((String)key, (String)value));
        return envVars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDateTimeFormat(String pstrDtFmt) {
        boolean blnRet = false;
        SimpleDateFormat objFmt = null;
        try {
            objFmt = new SimpleDateFormat(pstrDtFmt);
            blnRet = true;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            if (objFmt != null) {
                objFmt = null;
            }
        }
        return blnRet;
    }

    /*
     * Exception decompiling
     */
    private void loadConfig() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void closeReader(Reader pobjRdr) {
        if (pobjRdr == null) {
            return;
        }
        try {
            pobjRdr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeWriter(Writer pobjWriter) {
        if (pobjWriter == null) {
            return;
        }
        try {
            pobjWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String utilDateToStr(Date pdt, String pstrFmt) {
        String strRet = null;
        SimpleDateFormat dtFmt = null;
        try {
            dtFmt = new SimpleDateFormat(pstrFmt);
            strRet = dtFmt.format(pdt);
        }
        catch (Exception e) {
            strRet = null;
        }
        finally {
            if (dtFmt != null) {
                dtFmt = null;
            }
        }
        return strRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String timeToStr(Timestamp pobjTS, String pstrFmt) {
        String strRet = null;
        SimpleDateFormat dtFmt = null;
        try {
            dtFmt = new SimpleDateFormat(pstrFmt);
            strRet = dtFmt.format(pobjTS);
        }
        catch (IllegalArgumentException iae) {
            strRet = "";
        }
        catch (NullPointerException npe) {
            strRet = "";
        }
        finally {
            if (dtFmt != null) {
                dtFmt = null;
            }
        }
        return strRet;
    }

    private String delRemChars(String pstrSrc) {
        int intPos = 0;
        if (pstrSrc == null) {
            return null;
        }
        while ((intPos = ((String)pstrSrc).indexOf(";")) >= 0) {
            if (intPos == 0) {
                pstrSrc = ((String)pstrSrc).substring(intPos + 1);
                continue;
            }
            if (intPos <= 0) continue;
            pstrSrc = ((String)pstrSrc).substring(0, intPos) + ((String)pstrSrc).substring(intPos + 1);
        }
        return pstrSrc;
    }

    private String addRemChars(String pstrSrc) {
        int intLen = 2;
        int intPos = 0;
        int intPrev = 0;
        String strLeft = null;
        String strRight = null;
        if (pstrSrc == null) {
            return null;
        }
        while (intPos >= 0) {
            intLen = 2;
            intPos = ((String)pstrSrc).indexOf("\r\n", intPrev);
            if (intPos < 0) {
                intLen = 1;
                intPos = ((String)pstrSrc).indexOf("\n", intPrev);
                if (intPos < 0) {
                    intPos = ((String)pstrSrc).indexOf("\r", intPrev);
                }
            }
            if (intPos == 0) {
                pstrSrc = ";\r\n" + ((String)pstrSrc).substring(intPos + intLen);
                intPrev = intPos + intLen + 1;
                continue;
            }
            if (intPos <= 0) continue;
            strLeft = ((String)pstrSrc).substring(0, intPos);
            strRight = ((String)pstrSrc).substring(intPos + intLen);
            pstrSrc = strRight == null ? strLeft : (strRight.length() == 0 ? strLeft : strLeft + "\r\n;" + strRight);
            intPrev = intPos + intLen + 1;
        }
        if (!((String)pstrSrc).substring(0, 1).equals(";")) {
            pstrSrc = ";" + (String)pstrSrc;
        }
        pstrSrc = (String)pstrSrc + "\r\n";
        return pstrSrc;
    }

    public static void main(String[] pstrArgs) {
        INIFile objINI = null;
        String strFile = null;
        strFile = "aa.ini";
        objINI = new INIFile(strFile);
        objINI.save();
        objINI = null;
    }

    private class INISection {
        private String mstrComment;
        private String mstrName;
        private LinkedHashMap mhmapProps;

        public INISection(String pstrSection) {
            this.mstrName = pstrSection;
            this.mhmapProps = new LinkedHashMap();
        }

        public INISection(String pstrSection, String pstrComments) {
            this.mstrName = pstrSection;
            this.mstrComment = INIFile.this.delRemChars(pstrComments);
            this.mhmapProps = new LinkedHashMap();
        }

        public String getSecComments() {
            return this.mstrComment;
        }

        public String getSecName() {
            return this.mstrName;
        }

        public void setSecComments(String pstrComments) {
            this.mstrComment = INIFile.this.delRemChars(pstrComments);
        }

        public void setSecName(String pstrName) {
            this.mstrName = pstrName;
        }

        public void removeProperty(String pstrProp) {
            if (this.mhmapProps.containsKey(pstrProp)) {
                this.mhmapProps.remove(pstrProp);
            }
        }

        public void setProperty(String pstrProp, String pstrValue, String pstrComments) {
            this.mhmapProps.put(pstrProp, new INIProperty(pstrProp, pstrValue, pstrComments));
        }

        public Map getProperties() {
            return Collections.unmodifiableMap(this.mhmapProps);
        }

        public String[] getPropNames() {
            int iCntr = 0;
            String[] arrRet = null;
            Iterator iter = null;
            try {
                if (this.mhmapProps.size() > 0) {
                    arrRet = new String[this.mhmapProps.size()];
                    iter = this.mhmapProps.keySet().iterator();
                    while (iter.hasNext()) {
                        arrRet[iCntr] = (String)iter.next();
                        ++iCntr;
                    }
                }
            }
            catch (NoSuchElementException NSEExIgnore) {
                arrRet = null;
            }
            return arrRet;
        }

        public INIProperty getProperty(String pstrProp) {
            INIProperty objRet = null;
            if (this.mhmapProps.containsKey(pstrProp)) {
                objRet = (INIProperty)this.mhmapProps.get(pstrProp);
            }
            return objRet;
        }

        public String toString() {
            Set colKeys = null;
            String strRet = "";
            Iterator iter = null;
            INIProperty objProp = null;
            StringBuffer objBuf = new StringBuffer();
            if (this.mstrComment != null) {
                objBuf.append(INIFile.this.addRemChars(this.mstrComment));
            }
            objBuf.append("[" + this.mstrName + "]\r\n");
            colKeys = this.mhmapProps.keySet();
            if (colKeys != null && (iter = colKeys.iterator()) != null) {
                while (iter.hasNext()) {
                    objProp = (INIProperty)this.mhmapProps.get(iter.next());
                    objBuf.append(objProp.toString());
                    objBuf.append("\r\n");
                    objProp = null;
                }
            }
            strRet = objBuf.toString();
            objBuf = null;
            iter = null;
            colKeys = null;
            return strRet;
        }
    }

    private class INIProperty {
        private String mstrName;
        private String mstrValue;
        private String mstrComments;

        public INIProperty(String pstrName, String pstrValue) {
            this.mstrName = pstrName;
            this.mstrValue = pstrValue;
        }

        public INIProperty(String pstrName, String pstrValue, String pstrComments) {
            this.mstrName = pstrName;
            this.mstrValue = pstrValue;
            this.mstrComments = INIFile.this.delRemChars(pstrComments);
        }

        public String getPropName() {
            return this.mstrName;
        }

        public String getPropValue() {
            boolean intStart = false;
            boolean intEnd = false;
            Object strVal = null;
            Object strVar = null;
            String strRet = null;
            strRet = this.mstrValue;
            return strRet;
        }

        public String getPropComments() {
            return this.mstrComments;
        }

        public void setPropName(String pstrName) {
            this.mstrName = pstrName;
        }

        public void setPropValue(String pstrValue) {
            this.mstrValue = pstrValue;
        }

        public void setPropComments(String pstrComments) {
            this.mstrComments = INIFile.this.delRemChars(pstrComments);
        }

        public String toString() {
            Object strRet = "";
            if (this.mstrComments != null) {
                strRet = INIFile.this.addRemChars(this.mstrComments);
            }
            strRet = (String)strRet + this.mstrName + " = " + this.mstrValue;
            return strRet;
        }
    }
}

