/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.directorymonitor;

import com.plusmpm.directorymonitor.ws.ArrayOfString;
import com.plusmpm.directorymonitor.ws.ReleaseService;
import com.plusmpm.directorymonitor.ws.ReleaseServicePortType;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.wrapper.DirectoryMonitorPluginContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.AddDocumentResultMeta;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.util.ServiceFactory;
import jakarta.xml.ws.BindingProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;

public class ArchiveTools {
    private static Logger log = Logger.getLogger(ArchiveTools.class);
    private String sUser;
    public static String wsdlURL = "http://localhost:8080/PlusWorkflow/services/ReleaseService?wsdl";
    public static String wsdlURL2 = "http://localhost:8080/PlusWorkflow/services/ReleaseService";
    public static String namespace = "http://services.plusmpm.com";
    public static String serviceName = "ReleaseService";
    private final DirectoryMonitorPluginContext nullablePluginContext;
    private boolean accessWithWebService;
    private ReleaseServicePortType releaseServicePortType = null;

    public ArchiveTools(DirectoryMonitorPluginContext nullablePluginContext, boolean accessWithWebService) {
        this.nullablePluginContext = nullablePluginContext;
        this.accessWithWebService = accessWithWebService;
        if (accessWithWebService) {
            QName serviceQN = new QName(namespace, serviceName);
            try {
                this.doInPluginContextClassLoader(() -> {
                    ReleaseService releaseService = new ReleaseService(new URL(wsdlURL), serviceQN);
                    this.releaseServicePortType = releaseService.getReleaseServiceHttpPort();
                    BindingProvider bindingProvider = (BindingProvider)this.releaseServicePortType;
                    bindingProvider.getRequestContext().put("com.sun.xml.ws.request.timeout", 3600000);
                    bindingProvider.getRequestContext().put("com.sun.xml.ws.connect.timeout", 3600000);
                    return null;
                });
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create web service", e);
            }
        }
    }

    public String[] GetClasses() {
        try {
            return this.releaseServicePortType.getArchiveDocClass(this.sUser).getString().toArray(new String[0]);
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public String[] GetIndexes(String sClass) {
        try {
            return this.releaseServicePortType.getArchiveDocClassIndecies(this.sUser, sClass).getString().toArray(new String[0]);
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean IfFileExist(String sClass, Map<String, String> mIndexesValue) {
        return sClass.compareToIgnoreCase("Klasa 1") == 0 ? mIndexesValue.get("Index 1").compareToIgnoreCase("1.tif") == 0 : sClass.compareToIgnoreCase("Klasa 2") == 0 && mIndexesValue.get("Index 1").compareToIgnoreCase("1.tif") == 0;
    }

    public boolean LoginToArchive(String sUser, String sPassword) {
        try {
            if (this.accessWithWebService) {
                log.info((Object)("LoginToArchive with webservices: " + wsdlURL + " 2: " + wsdlURL2));
                boolean bResult = this.releaseServicePortType.loginInSystem(sUser, sPassword);
                this.sUser = bResult ? sUser : null;
                return bResult;
            }
            log.info((Object)"LoginToArchive with API");
            UserService us = ServiceFactory.getUserService();
            if (us.getUser(sUser, new String[0]) != null) {
                this.sUser = sUser;
                return true;
            }
            this.sUser = null;
            return false;
        }
        catch (Exception e) {
            log.error((Object)("Nieudane logowanie do systemu na u\u017cytkownika: " + sUser), (Throwable)e);
            this.sUser = null;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int AddFileToArchiveApi(String sClass, String[] asIndexes, File fFile, String sSaveAsNewVersion) {
        try (FileInputStream oFileStream = new FileInputStream(fFile);){
            log.info((Object)"AddFileToArchiveApi");
            log.info((Object)("Klasa: " + sClass + " User: " + this.sUser + " SaveAsNewVersion: " + sSaveAsNewVersion + " File: " + fFile.getName()));
            if (sSaveAsNewVersion == null) {
                sSaveAsNewVersion = "false";
            }
            Boolean bSaveAsNewVersion = Boolean.parseBoolean(sSaveAsNewVersion);
            DocumentService documentService = ServiceFactory.getDocumentService();
            long nClassID = Long.parseLong(sClass);
            HashMap<Long, String> idx = new HashMap<Long, String>();
            for (String sIndex : asIndexes) {
                int separatorIndex = sIndex.indexOf(";");
                if (separatorIndex != -1) {
                    long nIndexId = Long.parseLong(sIndex.substring(0, separatorIndex));
                    String sIndexValue = sIndex.substring(separatorIndex + 1);
                    idx.put(nIndexId, sIndexValue);
                    continue;
                }
                idx.put(Long.parseLong(sIndex), "");
            }
            DocumentDefinition definition = new DocumentDefinition();
            definition.setDocumentClassId(Long.valueOf(nClassID));
            definition.setFileName(fFile.getName());
            definition.setUserName(this.sUser);
            definition.setIndexes(idx);
            definition.setInputStream((InputStream)oFileStream);
            definition.setSaveAsNewVersion(bSaveAsNewVersion.booleanValue());
            definition.setExactIndexesCheck(false);
            if (this.nullablePluginContext != null) {
                this.nullablePluginContext.getDocumentUploadListenerRegistry().getDocumentUploadListener().ifPresent(documentUploadListener -> {
                    log.info((Object)"Wywo\u0142ywanie modu\u0142u listenera na wysy\u0142any dokument");
                    documentUploadListener.onDocumentUpload(definition);
                });
            }
            log.info((Object)"Dodawanie dokumentu");
            AddDocumentResultMeta oMetaResult = documentService.addDocumentWithMetaResult(definition);
            WfDocument oWfDocument = oMetaResult.getDocument();
            bSaveAsNewVersion = oMetaResult.getSavedAsNewVersion();
            if (oWfDocument == null) {
                log.error((Object)"B\u0142\u0105d przy dodawaniu dokumentu");
                int sIndex = -1;
                return sIndex;
            }
            log.info((Object)("Udane dodawanie dokumentu " + (bSaveAsNewVersion != false ? "jako nowa wersja" : "jako nowy dokument")));
            DocumentClassActionService documentClassActionService = ServiceFactory.getDocumentClassActionService();
            try {
                documentClassActionService.executeArchiveActions(oWfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE, bSaveAsNewVersion);
            }
            catch (Exception e) {
                try {
                    documentService.deleteDocument(oWfDocument);
                    throw e;
                }
                catch (Exception suppressing) {
                    suppressing.addSuppressed(e);
                    log.error((Object)"Wyst\u0105pi\u0142 b\u0142\u0105d przy usuwaniu pliku po b\u0142\u0119dnym wywo\u0142aniu akcji na klasie dokument\u00f3w", (Throwable)suppressing);
                    throw suppressing;
                }
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return -1;
        }
    }

    public int AddFileToArchive(String sClass, String[] asIndexes, File fFile, String sSaveAsNewVersion) {
        if (this.accessWithWebService) {
            return this.AddFileToArchiveWS(sClass, asIndexes, fFile, sSaveAsNewVersion);
        }
        return this.AddFileToArchiveApi(sClass, asIndexes, fFile, sSaveAsNewVersion);
    }

    public int AddFileToArchiveWS(String sClass, String[] asIndexes, File fFile, String sSaveAsNewVersion) {
        Integer nResult = -1;
        try {
            String sFile = fFile.getName();
            sFile = sFile.replace("'", "_");
            FileInputStream inStream = new FileInputStream(fFile);
            Long nStreamSize = inStream.available();
            String sSize = nStreamSize.toString();
            byte[] aFile = new byte[nStreamSize.intValue()];
            int i = 0;
            while ((long)i < nStreamSize) {
                aFile[i] = (byte)inStream.read();
                ++i;
            }
            inStream.close();
            log.info((Object)("Invoke SaveDocumentInArchive: User=" + this.sUser + "; Class=" + sClass + "; File=" + sFile + "; sSize=" + sSize + ";"));
            Integer nFileId = this.releaseServicePortType.saveDocumentInArchive(this.sUser, sClass, sFile, sSize, null, null, null, aFile);
            if (nFileId > 0) {
                boolean saveAsNewVersion = true;
                if (sSaveAsNewVersion == null || sSaveAsNewVersion.compareToIgnoreCase("true") != 0) {
                    saveAsNewVersion = false;
                }
                log.info((Object)("******** sUser: " + this.sUser + " sClass: " + sClass + " FileId: " + nFileId + " NewVersion: " + saveAsNewVersion));
                for (int i2 = 0; i2 < asIndexes.length; ++i2) {
                    log.info((Object)asIndexes[i2]);
                }
                ArrayOfString indexes = new ArrayOfString();
                indexes.getString().addAll(Arrays.asList(asIndexes));
                nResult = this.releaseServicePortType.saveIndeciesInArchive1(this.sUser, sClass, nFileId.toString(), indexes, saveAsNewVersion);
            }
            return nResult;
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doInPluginContextClassLoader(Callable<T> supplier) throws Exception {
        ClassLoader prevContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            T t = supplier.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevContextClassLoader);
        }
    }
}

