/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.ini;

import com.plusmpm.ini.ConfigSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class FileConfigSource
implements ConfigSource {
    private String fileName;

    public FileConfigSource(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getSourcePath() {
        return this.fileName;
    }

    @Override
    public boolean exists() {
        File file = new File(this.fileName);
        return file.exists() && file.isFile();
    }

    @Override
    public boolean canWrite() {
        File file = new File(this.fileName);
        return file.canWrite();
    }

    @Override
    public InputStream load() throws Exception {
        return new FileInputStream(this.fileName);
    }

    @Override
    public void save(InputStream inputStream) throws Exception {
        try (FileOutputStream outputStream = new FileOutputStream(this.fileName);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }
}

