/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.directorymonitor;

import com.plusmpm.directorymonitor.DirectoryMonitorTools;
import com.plusmpm.ini.INIFile;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class Index {
    private static Logger log = Logger.getLogger(Index.class);
    protected String sIndexId;
    protected String sName;
    protected String sType;
    protected boolean bAllowEmpty;
    protected static String sPATH_SEGMENT = "PathSegment";
    protected static String sFILE_SEGMENT = "FileSegment";
    protected static String sDATE = "Date";
    protected static String sFILE_DATE = "FileDate";
    protected static String sSTRING = "ConstantString";
    protected static String sFILE_NAME = "FileName";
    protected static String sEXTENTION = "Extention";
    protected static String sVOID = "Void";
    protected static String sSQL = "SQL";
    protected static String sINI = "INI";
    protected static String sBarcode2D = "Barcode2D";
    protected static String sINI_File = "INIFile";
    protected static String sXML_FILE = "XMLFile";
    protected File fFile;
    protected File fXMLFile;
    protected String sIndexString;
    protected int nPathSegment;
    protected int nFileSegment;
    protected String sRegExp;
    protected String sFileSeparator;
    protected String sMask;
    protected String sSQLName;
    protected String sSQLScheme;
    protected String sEncoding;
    protected String sDecoding;
    protected String sMustBeEqual;
    protected String sBarcode_XML_Path;
    protected String sBarcode_Nr;
    protected String sBarcode_XML_FileDelete;
    protected String sBarcode_XML_FileBackup;
    protected String sBarcode_XML_BackupPath;
    protected String sXMLValueTag;
    protected String sXMLValueDelimiterTag;
    protected String sXMLDefaultDelimitedValue;
    protected String sXMLValueAttribute;
    protected String sXMLValueIgnoreNamespaces;
    protected boolean bMultiValue;
    protected String sINISection;
    protected String sINIParameter;
    protected String sIndexValue;
    protected String sIndexValue2;
    protected String sIndexSQLValue;
    protected Boolean bIndexEqual = true;

    public String getSType() {
        return this.sType;
    }

    public void setSType(String type) {
        this.sType = type;
    }

    public int getNPathSegment() {
        return this.nPathSegment;
    }

    public void setNPathSegment(int pathSegment) {
        this.nPathSegment = pathSegment;
    }

    public int getNFileSegment() {
        return this.nFileSegment;
    }

    public void setNFileSegment(int fileSegment) {
        this.nFileSegment = fileSegment;
    }

    public String getSFileSeparator() {
        return this.sFileSeparator;
    }

    public void setSFileSeparator(String fileSeparator) {
        this.sFileSeparator = fileSeparator;
    }

    public String getSMask() {
        return this.sMask;
    }

    public void setSMask(String mask) {
        this.sMask = mask;
    }

    public static String decodeJavaUTF8String(String sText) {
        sText = sText.replaceAll("[/][2][6][1]", "\u0105");
        sText = sText.replaceAll("[/][2][6][3]", "\u0107");
        sText = sText.replaceAll("[/][2][8][1]", "\u0119");
        sText = sText.replaceAll("[/][3][2][2]", "\u0142");
        sText = sText.replaceAll("[/][3][2][4]", "\u0144");
        sText = sText.replaceAll("[/][2][4][3]", "\u00f3");
        sText = sText.replaceAll("[/][3][4][7]", "\u015b");
        sText = sText.replaceAll("[/][3][7][8]", "\u017a");
        sText = sText.replaceAll("[/][3][8][0]", "\u017c");
        sText = sText.replaceAll("[/][2][6][0]", "\u0104");
        sText = sText.replaceAll("[/][2][6][2]", "\u0106");
        sText = sText.replaceAll("[/][2][8][0]", "\u0118");
        sText = sText.replaceAll("[/][3][2][1]", "\u0141");
        sText = sText.replaceAll("[/][3][2][3]", "\u0143");
        sText = sText.replaceAll("[/][2][1][1]", "\u00d3");
        sText = sText.replaceAll("[/][3][4][6]", "\u015a");
        sText = sText.replaceAll("[/][3][7][7]", "\u0179");
        sText = sText.replaceAll("[/][3][7][9]", "\u017b");
        return sText;
    }

    public static String encodeJavaUTF8String(String sText) {
        sText = sText.replaceAll("\u0105", "/261");
        sText = sText.replaceAll("\u0107", "/263");
        sText = sText.replaceAll("\u0119", "/281");
        sText = sText.replaceAll("\u0142", "/322");
        sText = sText.replaceAll("\u0144", "/324");
        sText = sText.replaceAll("\u00f3", "/243");
        sText = sText.replaceAll("\u015b", "/347");
        sText = sText.replaceAll("\u017a", "/378");
        sText = sText.replaceAll("\u017c", "/380");
        sText = sText.replaceAll("\u0104", "/260");
        sText = sText.replaceAll("\u0106", "/262");
        sText = sText.replaceAll("\u0118", "/280");
        sText = sText.replaceAll("\u0141", "/321");
        sText = sText.replaceAll("\u0143", "/323");
        sText = sText.replaceAll("\u00d3", "/211");
        sText = sText.replaceAll("\u015a", "/346");
        sText = sText.replaceAll("\u0179", "/377");
        sText = sText.replaceAll("\u017b", "/379");
        return sText;
    }

    private Map ReadINIFile(String sINIFile, Map mmINIFile) {
        log.info((Object)"*** Loading INI File ***");
        try {
            File f = new File(sINIFile);
            INIFile oINIFile = null;
            if (f.exists()) {
                oINIFile = new INIFile(sINIFile);
                String[] asSections = oINIFile.getAllSectionNames();
                for (int i = 0; i < asSections.length; ++i) {
                    String[] asProp = oINIFile.getPropertyNames(asSections[i]);
                    LinkedHashMap<String, String> mSection = new LinkedHashMap<String, String>();
                    for (int j = 0; j < asProp.length; ++j) {
                        mSection.put(asProp[j], oINIFile.getStringProperty(asSections[i], asProp[j]));
                    }
                    mmINIFile.put(asSections[i], mSection);
                }
            } else {
                log.error((Object)("!!! Can not find INI file: " + sINIFile + " !!!"));
            }
        }
        catch (Exception e) {
            log.error((Object)"! ! Error while loading INI file ! !");
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        log.info((Object)("*** File " + sINIFile + " loaded ***"));
        return mmINIFile;
    }

    public void SetIndexValue() {
        block61: {
            try {
                block63: {
                    this.sIndexValue = "";
                    if (this.sType == null) break block61;
                    if (this.fFile != null && this.sType.compareToIgnoreCase(sPATH_SEGMENT) == 0) {
                        String sFile = this.fFile.getAbsolutePath();
                        String[] asFileMembers = sFile.split("\\".concat(File.separator));
                        if (this.nPathSegment > 0 && this.nPathSegment <= asFileMembers.length - 1) {
                            this.sIndexValue = asFileMembers[this.nPathSegment - 1];
                        }
                    } else if (this.fFile != null && this.sType.compareToIgnoreCase(sFILE_SEGMENT) == 0) {
                        sTemp = this.fFile.getName();
                        asTemp = sTemp.split("\\.");
                        Object sFile = "";
                        for (int i = 0; i < asTemp.length - 1; ++i) {
                            sFile = (String)sFile + asTemp[i];
                        }
                        String[] asFileMembers = ((String)sFile).split(this.sFileSeparator);
                        if (this.nFileSegment > 0 && this.nFileSegment <= asFileMembers.length) {
                            this.sIndexValue = asFileMembers[this.nFileSegment - 1];
                        }
                    } else if (this.sType.compareToIgnoreCase(sDATE) == 0) {
                        Calendar oNow = Calendar.getInstance();
                        Date oDate = new Date();
                        oNow.setTime(oDate);
                        String sDate = oNow.get(5) < 10 ? "0" + oNow.get(5) : "" + oNow.get(5);
                        int nMonth = oNow.get(2) + 1;
                        String sMonth = nMonth < 10 ? "0" + nMonth : "" + nMonth;
                        Object sYear = "" + oNow.get(1);
                        sYear = ((String)sYear).substring(2);
                        this.sIndexValue = (String)sYear + "/" + sMonth + "/" + sDate;
                    } else if (this.fFile != null && this.sType.compareToIgnoreCase(sFILE_DATE) == 0) {
                        Date oDate = new Date(this.fFile.lastModified());
                        this.sIndexValue = oDate.getYear() + 1900 + "/" + (oDate.getMonth() + 1) + "/" + oDate.getDate();
                    } else if (this.sType.compareToIgnoreCase(sSTRING) == 0) {
                        this.sIndexValue = this.sIndexString;
                    } else if (this.fFile != null && this.sType.compareToIgnoreCase(sFILE_NAME) == 0) {
                        sTemp = this.fFile.getName();
                        asTemp = sTemp.split("\\.");
                        this.sIndexValue = "";
                        for (int i = 0; i < asTemp.length - 1; ++i) {
                            this.sIndexValue = this.sIndexValue + asTemp[i] + ".";
                        }
                        this.sIndexValue = this.sIndexValue.substring(0, this.sIndexValue.length() - 1);
                    } else if (this.fFile != null && this.sType.compareToIgnoreCase(sEXTENTION) == 0) {
                        sTemp = this.fFile.getName();
                        asTemp = sTemp.split("\\.");
                        this.sIndexValue = asTemp.length > 1 ? asTemp[asTemp.length - 1] : "";
                    } else if (this.sType.compareToIgnoreCase(sVOID) == 0) {
                        this.sIndexValue = "";
                    } else if (this.sType.compareToIgnoreCase(sBarcode2D) == 0) {
                        if (!this.sBarcode_XML_Path.endsWith(File.separator)) {
                            this.sBarcode_XML_Path = this.sBarcode_XML_Path.concat(File.separator);
                        }
                        if (this.sBarcode_Nr == null || Integer.parseInt(this.sBarcode_Nr) < 1) {
                            this.sBarcode_Nr = "1";
                        }
                        Integer nBarcode_Nr = Integer.parseInt(this.sBarcode_Nr);
                        String sFileName = this.fFile.getName();
                        File fBarcodeXMLFile = new File(this.sBarcode_XML_Path.concat((sFileName = sFileName.substring(0, sFileName.length() - 3)).concat("xml")));
                        if (fBarcodeXMLFile.exists()) {
                            try {
                                Map codesMap;
                                XMLDecoder xmlDecoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(fBarcodeXMLFile.getAbsolutePath())));
                                Object codesMapObject = xmlDecoder.readObject();
                                if (codesMapObject instanceof Map && (codesMap = (Map)codesMapObject).containsKey(nBarcode_Nr)) {
                                    this.sIndexValue = (String)codesMap.get(nBarcode_Nr);
                                }
                                if (this.sBarcode_XML_FileBackup.compareToIgnoreCase("true") == 0) {
                                    AbstractInterruptibleChannel in = null;
                                    AbstractInterruptibleChannel out = null;
                                    ByteBuffer byteBuffer = null;
                                    try {
                                        File fXMLBackupDir = new File(this.sBarcode_XML_BackupPath);
                                        if (fXMLBackupDir.exists() && fXMLBackupDir.isDirectory()) {
                                            File fXMLBackupFile = new File(fXMLBackupDir.getAbsolutePath().concat(File.separator).concat(fBarcodeXMLFile.getName()));
                                            in = new FileInputStream(fBarcodeXMLFile.getAbsolutePath()).getChannel();
                                            out = new FileOutputStream(fXMLBackupFile.getAbsolutePath()).getChannel();
                                            byteBuffer = ByteBuffer.allocate(1024);
                                            while (((FileChannel)in).read(byteBuffer) != -1) {
                                                byteBuffer.flip();
                                                ((FileChannel)out).write(byteBuffer);
                                                byteBuffer.clear();
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                        throw e;
                                    }
                                    finally {
                                        if (in != null) {
                                            in.close();
                                        }
                                        if (out != null) {
                                            out.close();
                                        }
                                    }
                                }
                                if (this.sBarcode_XML_FileDelete.compareToIgnoreCase("true") != 0) break block63;
                                try {
                                    fBarcodeXMLFile.delete();
                                }
                                catch (Exception e) {
                                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                    throw e;
                                }
                            }
                            catch (Exception e) {
                                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                    } else if (this.fFile != null && this.sType.compareToIgnoreCase(sINI_File) == 0) {
                        log.info((Object)"Typ indeksu: INI");
                        Object sFilePath = this.fFile.getAbsolutePath();
                        sFilePath = (String)sFilePath + this.fFile.getName();
                        Object sINIFile = "";
                        String[] asTemp = ((String)sFilePath).split("\\.");
                        for (int i = 0; i < asTemp.length - 1; ++i) {
                            sINIFile = (String)sINIFile + asTemp[i];
                        }
                        sINIFile = (String)sINIFile + "\\.txt";
                        Map mmINIFile = null;
                        mmINIFile = this.ReadINIFile((String)sINIFile, mmINIFile);
                        LinkedHashMap mIndex = new LinkedHashMap();
                        mIndex = (LinkedHashMap)mmINIFile.get("wlasnosci");
                        this.sIndexValue = (String)mIndex.get(this.sIndexId);
                    } else if (this.sType.compareToIgnoreCase(sSQL) == 0) {
                        this.sIndexValue = this.sIndexValue2;
                    } else if (this.sType.compareToIgnoreCase(sXML_FILE) == 0) {
                        log.trace((Object)("Plik xml: " + this.fXMLFile.getAbsolutePath() + " Tag: " + this.sXMLValueTag + " Attribute: " + this.sXMLValueAttribute));
                        Vector<String> xmlValuesCandidates = this.getIndexValueCandidatesFromXmlFile();
                        this.sIndexValue = !xmlValuesCandidates.isEmpty() ? xmlValuesCandidates.get(0) : "";
                        if (this.sRegExp == null || this.sRegExp.compareToIgnoreCase("") == 0) {
                            this.sRegExp = "(.*)(?:.*)";
                        }
                        log.trace((Object)("MultiValue RegExp: " + this.sRegExp));
                        log.trace((Object)("PartIndexValue: " + this.sIndexValue));
                        Pattern myPattern = Pattern.compile(this.sRegExp, 160);
                        Matcher myMatcher = myPattern.matcher(this.sIndexValue);
                        this.sIndexValue = myMatcher.find() ? (myMatcher.groupCount() > 0 ? myMatcher.group(1) : myMatcher.group()) : "";
                        if (this.sMask != null && this.sRegExp.compareToIgnoreCase("") != 0) {
                            this.sIndexValue = myMatcher.replaceAll(this.sMask);
                        }
                        if (this.bMultiValue) {
                            for (int i = 1; i < xmlValuesCandidates.size(); ++i) {
                                String sTempValue = xmlValuesCandidates.get(i);
                                log.trace((Object)("PartIndexValue: " + sTempValue));
                                myPattern = Pattern.compile(this.sRegExp, 160);
                                myMatcher = myPattern.matcher(sTempValue);
                                sTempValue = myMatcher.find() ? (myMatcher.groupCount() > 0 ? myMatcher.group(1) : myMatcher.group()) : "";
                                if (this.sMask != null && this.sRegExp.compareToIgnoreCase("") != 0) {
                                    sTempValue = myMatcher.replaceAll(this.sMask);
                                }
                                this.sIndexValue = this.sIndexValue + ";" + sTempValue;
                            }
                        }
                        log.trace((Object)("sIndexValue after RegExp: " + this.sIndexValue));
                    }
                }
                log.trace((Object)("Encoding: " + this.sEncoding + " Decoding: " + this.sDecoding));
                if (this.sEncoding != null && !this.sEncoding.isEmpty() && this.sDecoding != null && !this.sDecoding.isEmpty()) {
                    Charset charsetEncoding = Charset.forName(this.sEncoding);
                    Charset charsetDecoding = Charset.forName(this.sDecoding);
                    CharsetDecoder decoder = charsetDecoding.newDecoder();
                    CharsetEncoder encoder = charsetEncoding.newEncoder();
                    try {
                        ByteBuffer bbuf = encoder.encode(CharBuffer.wrap(this.sIndexValue));
                        CharBuffer cbuf = decoder.decode(bbuf);
                        this.sIndexValue = cbuf.toString();
                    }
                    catch (Exception e) {
                        log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    log.trace((Object)("Decoding: " + this.sDecoding + " Value: " + this.sIndexValue));
                }
                if (!this.sType.equalsIgnoreCase(sXML_FILE)) {
                    if (this.sRegExp == null || this.sRegExp.compareToIgnoreCase("") == 0) {
                        this.sRegExp = "(.*)(?:.*)";
                    }
                    log.trace((Object)("RegExp: " + this.sRegExp + " sIndexValue: " + this.sIndexValue));
                    Pattern myPattern = Pattern.compile(this.sRegExp, 160);
                    Matcher myMatcher = myPattern.matcher(this.sIndexValue);
                    this.sIndexValue = myMatcher.find() ? (myMatcher.groupCount() > 0 ? myMatcher.group(1) : myMatcher.group()) : "";
                    if (this.sMask != null && this.sRegExp.compareToIgnoreCase("") != 0) {
                        this.sIndexValue = myMatcher.replaceAll(this.sMask);
                    }
                    log.trace((Object)("sIndexValue after RegExp: " + this.sIndexValue));
                }
                if (this.sMustBeEqual != null && !this.sMustBeEqual.isEmpty() && !this.sMustBeEqual.equalsIgnoreCase(this.sIndexValue)) {
                    log.info((Object)("Index: " + this.sIndexValue + " nie pasuje do wymaganej wartosci: " + this.sMustBeEqual + " Plik pomijany."));
                    this.bIndexEqual = false;
                }
                this.sIndexValue2 = this.sIndexValue = this.sIndexValue.replace("'", "_");
                if (this.sIndexId != null) {
                    this.sIndexValue = this.sIndexId + ";" + this.sIndexValue;
                }
                log.info((Object)("Index: " + this.sIndexValue));
            }
            catch (Exception e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private Vector<String> getIndexValueCandidatesFromXmlFile() {
        DirectoryMonitorTools oDirMT = new DirectoryMonitorTools();
        boolean ignoredNamespaces = Boolean.parseBoolean(this.sXMLValueIgnoreNamespaces);
        if (StringUtils.isNotBlank((CharSequence)this.sXMLValueDelimiterTag)) {
            String defaultValue = StringUtils.defaultString((String)this.sXMLDefaultDelimitedValue);
            if (StringUtils.isNotBlank((CharSequence)this.sXMLValueAttribute)) {
                return oDirMT.GetXMLAttributesWithDelimiter(this.fXMLFile.getAbsolutePath(), ignoredNamespaces, this.sXMLValueDelimiterTag, this.sXMLValueTag, this.sXMLValueAttribute, defaultValue);
            }
            return oDirMT.GetXMLTagsWithDelimiter(this.fXMLFile.getAbsolutePath(), ignoredNamespaces, this.sXMLValueDelimiterTag, this.sXMLValueTag, defaultValue);
        }
        if (StringUtils.isNotBlank((CharSequence)this.sXMLValueAttribute)) {
            return oDirMT.GetXMLAttributes(this.fXMLFile.getAbsolutePath(), ignoredNamespaces, this.sXMLValueTag, this.sXMLValueAttribute);
        }
        return oDirMT.GetXMLTags(this.fXMLFile.getAbsolutePath(), ignoredNamespaces, this.sXMLValueTag);
    }

    public Index(String indexId, String name, String type, boolean AllowEmpty, int pathMember, int fileMember, String separator, String indexString, String regExp, String mask, String SQLName, String SQLScheme, String sXML_Path, String sBarcode_Nr, String sXML_BackupPath, String sXML_FileBackup, String sXML_FileDelete, String sXMLValueTag, String sXMLValueAttribute, String sXMLValueIgnoreNamespaces, String sXMLValueDelimiterTag, String sXMLDefaultDelimitedValue, String sINISection, String sINIParameter, boolean MultiValue, String sEncoding, String sDecoding, String sMustBeEqual) {
        log.trace((Object)"Starting Index constructor");
        this.sIndexId = indexId;
        this.sName = name;
        this.sType = type;
        this.bAllowEmpty = AllowEmpty;
        this.nPathSegment = pathMember;
        this.nFileSegment = fileMember;
        this.sFileSeparator = separator;
        this.sIndexString = indexString;
        this.sRegExp = regExp;
        this.sMask = mask;
        this.sSQLName = SQLName;
        this.sSQLScheme = SQLScheme;
        this.sBarcode_XML_Path = sXML_Path;
        this.sBarcode_Nr = sBarcode_Nr;
        this.sBarcode_XML_BackupPath = sXML_BackupPath;
        this.sBarcode_XML_FileBackup = sXML_FileBackup;
        this.sBarcode_XML_FileDelete = sXML_FileDelete;
        this.sXMLValueTag = sXMLValueTag;
        this.sXMLValueAttribute = sXMLValueAttribute;
        this.sXMLValueIgnoreNamespaces = sXMLValueIgnoreNamespaces;
        this.sXMLValueDelimiterTag = sXMLValueDelimiterTag;
        this.sXMLDefaultDelimitedValue = sXMLDefaultDelimitedValue;
        this.sINISection = sINISection;
        this.sINIParameter = sINIParameter;
        this.bMultiValue = MultiValue;
        this.sEncoding = sEncoding;
        this.sDecoding = sDecoding;
        this.sMustBeEqual = sMustBeEqual;
    }

    public String GetIndexValue() {
        this.fFile = null;
        this.fXMLFile = null;
        this.SetIndexValue();
        return this.sIndexValue;
    }

    public String GetIndexValue(File f) {
        this.fFile = f;
        this.fXMLFile = null;
        this.SetIndexValue();
        return this.sIndexValue;
    }

    public String GetIndexValue(File f, File fXML) {
        this.fFile = f;
        this.fXMLFile = fXML;
        this.SetIndexValue();
        return this.sIndexValue;
    }

    public String getSIndexId() {
        return this.sIndexId;
    }

    public void setSIndexId(String indexId) {
        this.sIndexId = indexId;
    }

    public File getFFile() {
        return this.fFile;
    }

    public void setFFile(File file) {
        this.fFile = file;
    }

    public String getSIndexString() {
        return this.sIndexString;
    }

    public void setSIndexString(String indexString) {
        this.sIndexString = indexString;
    }

    public String getSRegExp() {
        return this.sRegExp;
    }

    public void setSRegExp(String regExp) {
        this.sRegExp = regExp;
    }

    public String getSName() {
        return this.sName;
    }

    public void setSName(String name) {
        this.sName = name;
    }

    public Boolean getIndexEqual() {
        return this.bIndexEqual;
    }

    public void resetIndexEqual() {
        this.bIndexEqual = true;
    }
}

