/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.directorymonitor.xml;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlValueExtractor
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(XmlValueExtractor.class);
    private List<Element> capturedXMLElements = new ArrayList<Element>(1);
    private final boolean ignoreNamespaces;

    private XmlValueExtractor(Element startingElement, boolean ignoreNamespaces) {
        this.capturedXMLElements.add(startingElement);
        this.ignoreNamespaces = ignoreNamespaces;
    }

    public static Vector<String> getValuesByXmlTagPathWithDelimiter(Element startingElement, boolean ignoreNamespaces, String xmlTagDelimiterPath, String xmlTagPath, String defaultValue) {
        log.info("Getting values by delimiter xml tag path [{}] with xml tag path [{}] and default value placeholder [{}]", new Object[]{xmlTagDelimiterPath, xmlTagPath, defaultValue});
        List<Element> capturedXMLElementsByDelimiter = XmlValueExtractor.getCapturedElementsByXmlTagPath(startingElement, ignoreNamespaces, xmlTagDelimiterPath);
        Vector<String> values = new Vector<String>();
        for (Element xmlDelimitedElement : capturedXMLElementsByDelimiter) {
            Vector<String> valuesByDelimiter = XmlValueExtractor.getValuesByXmlTagPath(xmlDelimitedElement, ignoreNamespaces, xmlTagPath);
            if (!valuesByDelimiter.isEmpty()) {
                if (valuesByDelimiter.size() >= 2) {
                    log.warn("Found more than one value by xml tag path [{}] - getting first value from {}", (Object)xmlTagPath, valuesByDelimiter);
                }
                values.add((String)valuesByDelimiter.get(0));
                continue;
            }
            values.add(defaultValue);
        }
        log.info("Resolved values: {}", values);
        return values;
    }

    public static Vector<String> getValuesByXmlTagPath(Element startingElement, boolean ignoreNamespaces, String xmlTagPath) {
        log.info("Getting values by xml tag path [{}]", (Object)xmlTagPath);
        List<Element> capturedXMLElements = XmlValueExtractor.getCapturedElementsByXmlTagPath(startingElement, ignoreNamespaces, xmlTagPath);
        Vector<String> values = new Vector<String>();
        for (Element xmlElement : capturedXMLElements) {
            Node childNode = xmlElement.getFirstChild();
            if (childNode != null) {
                values.add(childNode.getNodeValue());
                continue;
            }
            values.add("");
        }
        log.info("Resolved values: {}", values);
        return values;
    }

    public static Vector<String> getValuesByXmlAttributePathWithDelimiter(Element startingElement, boolean ignoreNamespaces, String xmlTagDelimiterPath, String xmlTagPath, String xmlAttribute, String defaultValue) {
        log.info("Getting values by delimiter xml tag path [{}] with xml tag path [{}] and attribute [{}]and default value placeholder [{}]", new Object[]{xmlTagDelimiterPath, xmlTagPath, xmlAttribute, defaultValue});
        List<Element> capturedXMLElementsByDelimiter = XmlValueExtractor.getCapturedElementsByXmlTagPath(startingElement, ignoreNamespaces, xmlTagDelimiterPath);
        Vector<String> values = new Vector<String>();
        for (Element xmlDelimitedElement : capturedXMLElementsByDelimiter) {
            Vector<String> valuesByDelimiter = XmlValueExtractor.getValuesByXmlAttributePath(xmlDelimitedElement, ignoreNamespaces, xmlTagPath, xmlAttribute);
            if (!valuesByDelimiter.isEmpty()) {
                if (valuesByDelimiter.size() >= 2) {
                    log.warn("Found more than one value by xml tag path [{}] and attribute [{}] - getting first value from {}", new Object[]{xmlTagPath, xmlAttribute, valuesByDelimiter});
                }
                values.add((String)valuesByDelimiter.get(0));
                continue;
            }
            values.add(defaultValue);
        }
        log.info("Resolved values: {}", values);
        return values;
    }

    public static Vector<String> getValuesByXmlAttributePath(Element startingElement, boolean ignoreNamespaces, String xmlTagPath, String xmlAttribute) {
        log.info("Getting values by xml tag path [{}] and attribute [{}]", (Object)xmlTagPath, (Object)xmlAttribute);
        List<Element> capturedXMLElements = XmlValueExtractor.getCapturedElementsByXmlTagPath(startingElement, ignoreNamespaces, xmlTagPath);
        Vector<String> values = new Vector<String>();
        for (Element xmlElement : capturedXMLElements) {
            String value = ignoreNamespaces ? XmlValueExtractor.getUnboundAttributeValue(xmlElement, XmlValueExtractor.unbound(xmlAttribute)) : xmlElement.getAttribute(xmlAttribute);
            if (value == null) continue;
            values.add(value);
        }
        log.info("Resolved values: {}", values);
        return values;
    }

    public static List<Element> getCapturedElementsByXmlTagPath(Element startingElement, boolean ignoreNamespaces, String xmlTagPath) {
        log.info("Getting captured elements by xml tag path [{}]", (Object)xmlTagPath);
        XmlValueExtractor extractor = new XmlValueExtractor(startingElement, ignoreNamespaces);
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(extractor);
            parser.setErrorHandler(extractor);
            parser.setFeature("http://xml.org/sax/features/namespaces", false);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            parser.parse(new InputSource(new StringReader(xmlTagPath)));
        }
        catch (SAXParseException e) {
            return extractor.getCapturedXMLElements();
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return new ArrayList<Element>();
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String namespaceURL, String localName, String qName, Attributes attributes) {
        if (this.ignoreNamespaces) {
            this.parseWithoutNamespaces(qName, attributes);
        } else {
            this.parseWithNamespaces(qName, attributes);
        }
    }

    private void parseWithoutNamespaces(String qName, Attributes attributes) {
        String unboundTagName = XmlValueExtractor.unbound(qName);
        ArrayList<Element> newXMLElements = new ArrayList<Element>();
        for (Element vXMLElement : this.capturedXMLElements) {
            NodeList nodeList = vXMLElement.getElementsByTagName("*");
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Element element = (Element)nodeList.item(j);
                String elementTagName = element.getTagName();
                String unboundElementTagName = XmlValueExtractor.unbound(elementTagName);
                if (!unboundElementTagName.equals(unboundTagName) || !this.areUnboundAttributesMatched(element, attributes)) continue;
                newXMLElements.add(element);
            }
        }
        this.capturedXMLElements.clear();
        this.capturedXMLElements = newXMLElements;
    }

    private boolean areUnboundAttributesMatched(Element element, Attributes attributes) {
        boolean attributesMatched = true;
        for (int k = 0; k < attributes.getLength(); ++k) {
            String attributeQualifiedName = attributes.getQName(k);
            if (attributeQualifiedName.startsWith("xmlns:")) continue;
            String unboundAttributeName = XmlValueExtractor.unbound(attributeQualifiedName);
            String unboundAttributeValue = attributes.getValue(k);
            String elementAttributeValue = XmlValueExtractor.getUnboundAttributeValue(element, unboundAttributeName);
            if (elementAttributeValue.equals(unboundAttributeValue)) continue;
            attributesMatched = false;
            break;
        }
        return attributesMatched;
    }

    private void parseWithNamespaces(String qName, Attributes attributes) {
        ArrayList<Element> newXMLElements = new ArrayList<Element>();
        for (Element vXMLElement : this.capturedXMLElements) {
            NodeList nodeList = vXMLElement.getElementsByTagName(qName);
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Element element = (Element)nodeList.item(j);
                if (!this.areAttributesMatched(element, attributes)) continue;
                newXMLElements.add(element);
            }
        }
        this.capturedXMLElements.clear();
        this.capturedXMLElements = newXMLElements;
    }

    private boolean areAttributesMatched(Element element, Attributes attributes) {
        boolean attributesMatched = true;
        for (int k = 0; k < attributes.getLength(); ++k) {
            String elementAttributeValue;
            String attributeQualifiedName = attributes.getQName(k);
            String attributeValue = attributes.getValue(k);
            if (attributeQualifiedName.startsWith("xmlns:") || (elementAttributeValue = element.getAttribute(attributeQualifiedName)).equals(attributeValue)) continue;
            attributesMatched = false;
            break;
        }
        return attributesMatched;
    }

    private static String getUnboundAttributeValue(Element element, String unboundAttributeName) {
        NamedNodeMap elementAttributes = element.getAttributes();
        String elementAttributeValue = "";
        for (int i = 0; i < elementAttributes.getLength(); ++i) {
            Node elementAttributeNode = elementAttributes.item(i);
            String unboundElementAttributeName = XmlValueExtractor.unbound(elementAttributeNode.getNodeName());
            String unboundElementAttributeValue = elementAttributeNode.getNodeValue();
            if (!unboundElementAttributeName.equals(unboundAttributeName)) continue;
            elementAttributeValue = unboundElementAttributeValue;
            break;
        }
        return elementAttributeValue;
    }

    private static String unbound(String tagOrAttributeName) {
        return tagOrAttributeName.substring(tagOrAttributeName.indexOf(":") + 1);
    }

    @Override
    public void endElement(String namespaceURL, String localName, String qName) {
        int i = 0;
        while (this.capturedXMLElements.size() > i + 1) {
            Element oEl = this.capturedXMLElements.get(i);
            if ((oEl = (Element)oEl.getParentNode()) == null) {
                this.capturedXMLElements.remove(i);
                continue;
            }
            this.capturedXMLElements.set(i, oEl);
            ++i;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        int i = 0;
        while (this.capturedXMLElements.size() > i + 1) {
            String sValue = null;
            for (int j = start; j < start + length; ++j) {
                sValue = "" + sValue + ch[j];
            }
            Element oEl = this.capturedXMLElements.get(i);
            if (oEl.getNodeValue().compareToIgnoreCase(sValue) != 0) {
                this.capturedXMLElements.remove(i);
                continue;
            }
            ++i;
        }
    }

    public List<Element> getCapturedXMLElements() {
        return this.capturedXMLElements;
    }
}

