/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.directorymonitor.document;

import com.plusmpm.directorymonitor.module.DocumentUploadListener;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DocumentUploadListenerRegistry {
    private static final Logger log = LoggerFactory.getLogger(DocumentUploadListenerRegistry.class);
    private String registeringPluginKey;
    private String registeringKey;
    private DocumentUploadListener documentUploadListener;

    public void registerListener(String pluginKey, String key, DocumentUploadListener documentUploadListener) {
        if (this.documentUploadListener != null) {
            log.warn("Plugin {} tried to register document upload listener while {} has already done it.", (Object)pluginKey, (Object)this.registeringPluginKey);
            return;
        }
        this.registeringPluginKey = pluginKey;
        this.registeringKey = key;
        this.documentUploadListener = documentUploadListener;
    }

    public void unregisterListener(String pluginKey, String key) {
        if (this.registeringPluginKey.equals(pluginKey) && this.registeringKey.equals(key)) {
            this.registeringPluginKey = null;
            this.registeringKey = null;
            this.documentUploadListener = null;
        }
    }

    public Optional<DocumentUploadListener> getDocumentUploadListener() {
        return Optional.ofNullable(this.documentUploadListener);
    }
}

