/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.directorymonitor;

import com.plusmpm.directorymonitor.ArchiveTools;
import com.plusmpm.directorymonitor.DirectoryMonitorTools;
import com.plusmpm.directorymonitor.DirectoryShare;
import com.plusmpm.directorymonitor.MainWindow;
import com.plusmpm.directorymonitor.exceptions.DuplicateShareIdException;
import com.plusmpm.ini.ConfigSource;
import com.plusmpm.ini.FileConfigSource;
import com.plusmpm.ini.INIFile;
import com.suncode.plugin.wrapper.DirectoryMonitorPluginContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.util.ServiceFactory;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DirectoryMonitor {
    private static Logger log = Logger.getLogger(DirectoryMonitor.class);
    private TrayIcon trayIcon = null;
    private static String sMonitorIcon = "/images/com/plusmpm/images/Find16.gif";
    private static String sConfigDirectory = File.separator.concat("PlusMPM");
    private static String sConfigFile = File.separator.concat("DirectoryMonitor.ini");
    private static String sArchPrefix = "Arch";
    private static String sSettingsKey = "Settings";
    private static String sProcessOnce = "ProcessOnce";
    private static String sProcessAtStartup = "ProcessAtStartup";
    private static String sShowInfoMessages = "ShowInfoMessages";
    private static String sUserProp = "Login";
    private static String sPasswordProp = "Password";
    private static String sActive = "Active";
    private static String sTrue = "true";
    private static String sFalse = "false";
    private static String sAccessWithWebService = "AccessWithWebService";
    private Boolean bAccessWithWebService;
    private Boolean bIsStandaloneApp;
    private String sUser;
    private String sPassword;
    private static String sWebServiceKey = "WebService";
    private static String sWSDLURL = "WSDL_URL";
    private static String sNamespace = "Namespace";
    private static String sServiceName = "ServiceName";
    private Map<String, Map<String, String>> mmINIFile = null;
    private Map<String, DirectoryShare> mDirectoryShares = null;
    private final DirectoryMonitorPluginContext nullablePluginContext;

    public DirectoryMonitor() {
        this(false);
    }

    public DirectoryMonitor(Boolean bIsStandaloneApp) {
        this(bIsStandaloneApp, null);
    }

    public DirectoryMonitor(Boolean bIsStandaloneApp, DirectoryMonitorPluginContext nullablePluginContext) {
        this.bIsStandaloneApp = bIsStandaloneApp;
        this.nullablePluginContext = nullablePluginContext;
    }

    private void SettingWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainWindow application = new MainWindow();
                application.getJFrame().setVisible(true);
            }
        });
    }

    private Map<String, Map<String, String>> SetDefaultSetting() {
        LinkedHashMap<String, Map<String, String>> mmConfig = null;
        try {
            log.info((Object)"Starting SetDefaultSetting");
            mmConfig = new LinkedHashMap<String, Map<String, String>>();
            LinkedHashMap<String, String> mSetting = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> mWebService = new LinkedHashMap<String, String>();
            mSetting.put(sProcessAtStartup, sFalse);
            mSetting.put(sShowInfoMessages, sTrue);
            mSetting.put(this.sUser, "");
            mSetting.put(this.sPassword, "");
            mmConfig.put(sSettingsKey, mSetting);
            mWebService.put("WSDL_URL", "http://localhost:8080/PlusWorkflow/services/");
            mWebService.put("Namespace", "http://services.plusmpm.com");
            mWebService.put("ServiceName", "ReleaseService");
            return mmConfig;
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return mmConfig;
        }
    }

    private File GetINIFile(String sFile) {
        File fFile = null;
        try {
            fFile = new File(sFile);
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (fFile.exists()) {
            return fFile;
        }
        return null;
    }

    private File GetINIFile() {
        File fFile = null;
        String sFile = null;
        try {
            log.info((Object)"Starting GetINIFIle");
            sFile = System.getenv("LOCALAPPDATA");
            sFile = sFile + sConfigDirectory + sConfigFile;
            fFile = new File(sFile);
            if (!fFile.exists()) {
                sFile = System.getenv("ProgramData");
                sFile = sFile + sConfigDirectory + sConfigFile;
                fFile = new File(sFile);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (fFile.exists()) {
            log.info((Object)("INIFile: " + sFile));
            return fFile;
        }
        log.warn((Object)"INIFile not found!");
        return null;
    }

    private Map<String, Map<String, String>> ReadINIFile(ConfigSource configSource, Map<String, Map<String, String>> mmINIFile) {
        log.info((Object)"Starting ReadINIFile");
        String sourcePath = configSource.getSourcePath();
        try {
            INIFile oINIFile = null;
            if (configSource.exists()) {
                oINIFile = new INIFile(configSource);
                String[] asSections = oINIFile.getAllSectionNames();
                for (int i = 0; i < asSections.length; ++i) {
                    String[] asProp = oINIFile.getPropertyNames(asSections[i]);
                    LinkedHashMap<String, String> mSection = new LinkedHashMap<String, String>();
                    for (int j = 0; j < asProp.length; ++j) {
                        mSection.put(asProp[j], oINIFile.getStringProperty(asSections[i], asProp[j]));
                    }
                    mmINIFile.put(asSections[i], mSection);
                    log.trace((Object)(asSections[i] + " - " + mSection));
                }
            } else {
                log.fatal((Object)("!!! Can not find INI file: " + sourcePath + " !!!"));
            }
        }
        catch (Exception e) {
            log.error((Object)"! ! Error while loading INI file ! !", (Throwable)e);
        }
        log.info((Object)("*** File " + sourcePath + " loaded ***"));
        return mmINIFile;
    }

    private File WriteINIFile(Map<String, Map<String, String>> mmINIFile) {
        File fFile;
        block15: {
            log.info((Object)"Starting WriteINIFile");
            fFile = null;
            try {
                String sFile = null;
                sFile = System.getenv("LOCALAPPDATA");
                sFile = sFile + sConfigDirectory;
                fFile = new File(sFile);
                if (!fFile.exists()) {
                    fFile.mkdir();
                    sFile = sFile + sConfigFile;
                    fFile = new File(sFile);
                    try {
                        fFile.createNewFile();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    return this.WriteINIFile(mmINIFile, new FileConfigSource(fFile.getAbsolutePath())) != null ? fFile : null;
                }
                fFile = new File(sFile = sFile + sConfigFile);
                if (fFile.exists()) {
                    return this.WriteINIFile(mmINIFile, new FileConfigSource(fFile.getAbsolutePath())) != null ? fFile : null;
                }
                if (fFile.canWrite()) {
                    try {
                        fFile.createNewFile();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    return this.WriteINIFile(mmINIFile, new FileConfigSource(fFile.getAbsolutePath())) != null ? fFile : null;
                }
                sFile = System.getenv("ProgramData");
                fFile = new File(sFile = sFile + sConfigDirectory);
                if (!fFile.exists()) {
                    fFile.mkdir();
                    sFile = sFile + sConfigFile;
                    fFile = new File(sFile);
                    try {
                        fFile.createNewFile();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    return this.WriteINIFile(mmINIFile, new FileConfigSource(fFile.getAbsolutePath())) != null ? fFile : null;
                }
                fFile = new File(sFile = sFile + sConfigFile);
                if (fFile.exists()) {
                    return this.WriteINIFile(mmINIFile, new FileConfigSource(fFile.getAbsolutePath())) != null ? fFile : null;
                }
                if (!fFile.canWrite()) break block15;
                try {
                    fFile.createNewFile();
                }
                catch (IOException e) {
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                return this.WriteINIFile(mmINIFile, new FileConfigSource(fFile.getAbsolutePath())) != null ? fFile : null;
            }
            catch (Exception e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return fFile;
    }

    private ConfigSource WriteINIFile(Map<String, Map<String, String>> mmINIFile, ConfigSource configSource) {
        log.info((Object)("Write INI File: " + configSource.getSourcePath()));
        try {
            if (configSource.exists() && configSource.canWrite()) {
                INIFile oINIFile = new INIFile(configSource);
                for (Map.Entry<String, Map<String, String>> oPairs : mmINIFile.entrySet()) {
                    String sSection = oPairs.getKey();
                    oINIFile.addSection(sSection, null);
                    LinkedHashMap mSection = new LinkedHashMap((LinkedHashMap)oPairs.getValue());
                    for (Map.Entry oPairs2 : mSection.entrySet()) {
                        oINIFile.setStringProperty(sSection, (String)oPairs2.getKey(), (String)oPairs2.getValue(), null);
                    }
                }
                oINIFile.save();
                return configSource;
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private Map<String, DirectoryShare> CreateDirectoryShares(Map<String, Map<String, String>> mmConfig, TrayIcon trayIcon, boolean bDisplayTrayIcon) {
        log.info((Object)"Starting CreateDirectoryShares");
        LinkedHashMap<String, DirectoryShare> mDirectoryShares = null;
        try {
            mDirectoryShares = new LinkedHashMap<String, DirectoryShare>();
            Iterator<Map.Entry<String, Map<String, String>>> oIt = mmConfig.entrySet().iterator();
            DirectoryShare oDir = null;
            boolean bSetTimer = false;
            if (this.mmINIFile.get(sSettingsKey).get(sProcessOnce).compareToIgnoreCase(sFalse) == 0) {
                bSetTimer = true;
            }
            while (oIt.hasNext()) {
                Map.Entry<String, Map<String, String>> oPairs = oIt.next();
                if (!oPairs.getKey().startsWith(sArchPrefix) || oPairs.getValue().get(sActive).compareToIgnoreCase(sTrue) != 0) continue;
                oDir = new DirectoryShare(oPairs.getValue(), this.sUser, this.sPassword, bDisplayTrayIcon, bSetTimer, this.bAccessWithWebService, this.nullablePluginContext);
                oDir.setOTrayIcon(trayIcon);
                if (mmConfig.get(sSettingsKey).get(sShowInfoMessages).compareToIgnoreCase(sTrue) == 0) {
                    oDir.setBShowInfo(true);
                } else {
                    oDir.setBShowInfo(false);
                }
                if (mDirectoryShares.containsKey(oDir.getSShareId())) {
                    throw new DuplicateShareIdException(String.format("Duplicate ShareID param: %s. Skipping directory: %s", oDir.getSShareId(), oDir.getSSharePath()));
                }
                mDirectoryShares.put(oDir.getSShareId(), oDir);
                log.info((Object)("DirectoryShare " + oDir.getSShareId() + " has been initialized"));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return mDirectoryShares;
    }

    private void ProcessDirectoryShares(Map<String, DirectoryShare> mDirectoryShares) {
        log.info((Object)"Starting ProcessDirectoryShares");
        try {
            Iterator<Map.Entry<String, DirectoryShare>> oIt = mDirectoryShares.entrySet().iterator();
            DirectoryShare oDir = null;
            while (oIt.hasNext()) {
                Map.Entry<String, DirectoryShare> oPairs = oIt.next();
                oDir = oPairs.getValue();
                oDir.ProcessDirectory();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private boolean CheckAndSetLogin(ConfigSource configSource) {
        log.info((Object)"Starting CheckAndSetLogin");
        try {
            if (this.bAccessWithWebService.booleanValue()) {
                log.info((Object)"Check with webservice");
                ArchiveTools oArchTools = new ArchiveTools(this.nullablePluginContext);
                String sKey = "ihwkcnwoa;chowH^";
                byte[] bRawKey = sKey.getBytes();
                this.sUser = this.mmINIFile.get(sSettingsKey).get(sUserProp);
                this.sPassword = this.mmINIFile.get(sSettingsKey).get(sPasswordProp);
                if (oArchTools.LoginToArchive(this.sUser, this.sPassword, this.bAccessWithWebService)) {
                    log.info((Object)"Login successful with raw data");
                    String sRawUser = "";
                    sRawUser = DirectoryMonitorTools.Encrypt(this.sUser, bRawKey);
                    String sRawPassword = "";
                    sRawPassword = DirectoryMonitorTools.Encrypt(this.sPassword, bRawKey);
                    LinkedHashMap<String, String> mSet = new LinkedHashMap<String, String>(this.mmINIFile.get(sSettingsKey));
                    mSet.put(sUserProp, sRawUser);
                    mSet.put(sPasswordProp, sRawPassword);
                    this.mmINIFile.put(sSettingsKey, mSet);
                    this.WriteINIFile(this.mmINIFile, configSource);
                    return true;
                }
                String sTempUser = null;
                String sTempPassword = null;
                sTempUser = DirectoryMonitorTools.Decrypt(this.sUser, bRawKey);
                if (oArchTools.LoginToArchive(sTempUser, sTempPassword = DirectoryMonitorTools.Decrypt(this.sPassword, bRawKey), this.bAccessWithWebService)) {
                    log.info((Object)"Login succesful with encrypted data");
                    this.sUser = sTempUser;
                    this.sPassword = sTempPassword;
                    return true;
                }
                log.warn((Object)"Login unsuccesful");
                return false;
            }
            log.info((Object)"Check with API");
            UserService us = ServiceFactory.getUserService();
            String sKey = "ihwkcnwoa;chowH^";
            byte[] bRawKey = sKey.getBytes();
            this.sUser = this.mmINIFile.get(sSettingsKey).get(sUserProp);
            if (us.getUser(this.sUser, new String[0]) != null) {
                log.info((Object)"User check successful with raw data");
                return true;
            }
            String sTempUser = null;
            sTempUser = DirectoryMonitorTools.Decrypt(this.sUser, bRawKey);
            if (us.getUser(sTempUser, new String[0]) != null) {
                log.info((Object)"User check succesful with encrypted data");
                this.sUser = sTempUser;
                return true;
            }
            log.warn((Object)"User check unsuccesful");
            return false;
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    private void SetWebServiceParam() {
        log.info((Object)"Starting SetWebServiceParam");
        try {
            LinkedHashMap<String, String> mWebService = new LinkedHashMap<String, String>(this.mmINIFile.get(sWebServiceKey));
            ArchiveTools.wsdlURL = (String)mWebService.get(sWSDLURL) + (String)mWebService.get(sServiceName) + "?wsdl";
            ArchiveTools.wsdlURL2 = (String)mWebService.get(sWSDLURL) + (String)mWebService.get(sServiceName);
            ArchiveTools.serviceName = (String)mWebService.get(sServiceName);
            ArchiveTools.namespace = (String)mWebService.get(sNamespace);
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            log.info((Object)"PlusDirectoryMonitor - starting program");
            DirectoryMonitor oDirectoryMonitor = new DirectoryMonitor(true);
            if (args.length > 1) {
                if (args[1].compareToIgnoreCase("true") == 0) {
                    log.info((Object)"DisplayTrayIcon = true");
                    oDirectoryMonitor.startup(args[0], true);
                } else {
                    log.info((Object)"DisplayTrayIcon = false");
                    oDirectoryMonitor.startup(args[0], false);
                }
            } else if (args.length > 0) {
                log.info((Object)("INIFile: " + args[0]));
                oDirectoryMonitor.startup(args[0], true);
            } else {
                log.info((Object)"Nie podano pliku ini");
                oDirectoryMonitor.startup((String)null, true);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void startup(String sIniFilePath) {
        this.startup(sIniFilePath, false);
    }

    public void startup(String sIniFilePath, boolean bDisplayTrayIcon) {
        this.startup(new FileConfigSource(sIniFilePath), bDisplayTrayIcon);
    }

    public void startup(ConfigSource configSource, boolean bDisplayTrayIcon) {
        try {
            System.setProperty("sun.rmi.transport.tcp.responseTimeout", "3600000");
            System.setProperty("sun.rmi.transport.connectionTimeout", "3600000");
            System.setProperty("sun.net.client.defaultConnectTimeout", "3600000");
            System.setProperty("sun.net.client.defaultReadTimeout", "3600000");
            this.mmINIFile = new LinkedHashMap<String, Map<String, String>>();
            if (configSource instanceof FileConfigSource) {
                File fINIFile = null;
                String configSourcePath = configSource.getSourcePath();
                if (configSourcePath != null && configSourcePath.length() > 0) {
                    fINIFile = this.GetINIFile(configSourcePath);
                    if (fINIFile == null) {
                        fINIFile = this.GetINIFile();
                    }
                } else {
                    fINIFile = this.GetINIFile();
                }
                if (fINIFile == null) {
                    this.mmINIFile = this.SetDefaultSetting();
                    fINIFile = this.WriteINIFile(this.mmINIFile);
                }
                configSource = new FileConfigSource(fINIFile.getAbsolutePath());
            }
            log.info((Object)"***** Strarting PlusDirectoryMonitor *****");
            this.mmINIFile = this.ReadINIFile(configSource, this.mmINIFile);
            this.SetWebServiceParam();
            if (SystemTray.isSupported() && bDisplayTrayIcon) {
                log.info((Object)"Tray initialization");
                SystemTray tray = SystemTray.getSystemTray();
                URL imageURL = DirectoryMonitor.class.getResource(sMonitorIcon);
                Image image = null;
                if (imageURL != null) {
                    image = new ImageIcon(imageURL, "").getImage();
                } else {
                    log.error((Object)("Resource not found: " + sMonitorIcon));
                }
                ActionListener exitListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                };
                ActionListener SettingListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DirectoryMonitor.this.SettingWindow();
                    }
                };
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DirectoryMonitor.this.ProcessDirectoryShares(DirectoryMonitor.this.mDirectoryShares);
                    }
                };
                PopupMenu popup = new PopupMenu();
                MenuItem ActionItem = new MenuItem("Wykonaj przetwarzanie");
                ActionItem.addActionListener(actionListener);
                popup.add(ActionItem);
                MenuItem SettingItem = new MenuItem("Ustawienia...");
                SettingItem.addActionListener(SettingListener);
                popup.addSeparator();
                MenuItem defaultItem = new MenuItem("Zako\u0144cz");
                defaultItem.addActionListener(exitListener);
                popup.add(defaultItem);
                this.trayIcon = new TrayIcon(image, "PlusDirectoryMonitor", popup);
                this.trayIcon.setImageAutoSize(true);
                this.trayIcon.addActionListener(actionListener);
                try {
                    tray.add(this.trayIcon);
                }
                catch (AWTException e) {
                    log.error((Object)"TrayIcon could not be added.", (Throwable)e);
                }
            } else if (!SystemTray.isSupported()) {
                log.warn((Object)"System Tray is not supported");
            }
            this.bAccessWithWebService = false;
            if (this.bIsStandaloneApp.booleanValue()) {
                this.bAccessWithWebService = true;
            } else if (this.mmINIFile.get(sSettingsKey).containsKey(sAccessWithWebService)) {
                this.bAccessWithWebService = this.mmINIFile.get(sSettingsKey).get(sAccessWithWebService).compareToIgnoreCase(sTrue) == 0;
            }
            if (this.CheckAndSetLogin(configSource)) {
                this.mDirectoryShares = this.CreateDirectoryShares(this.mmINIFile, this.trayIcon, bDisplayTrayIcon);
                if (this.mmINIFile.get(sSettingsKey).get(sProcessAtStartup).compareToIgnoreCase(sTrue) == 0) {
                    this.ProcessDirectoryShares(this.mDirectoryShares);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

