/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.directorymonitor;

import com.plusmpm.directorymonitor.SyncUtils;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.wrapper.DirectoryMonitorPluginContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.AddDocumentResultMeta;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import org.apache.log4j.Logger;

public class ArchiveTools {
    private static Logger log = Logger.getLogger(ArchiveTools.class);
    private String sUser;
    public static String wsdlURL = "http://localhost:8080/PlusWorkflow/services/ReleaseService?wsdl";
    public static String wsdlURL2 = "http://localhost:8080/PlusWorkflow/services/ReleaseService";
    public static String namespace = "http://services.plusmpm.com";
    public static String serviceName = "ReleaseService";
    private String sLoginInSystem = "LoginInSystem";
    private String sGetArchiveDocClass = "GetArchiveDocClass";
    private String sGetArchiveDocClassIndecies = "GetArchiveDocClassIndecies";
    private String sSaveIndeciesInArchive = "SaveIndeciesInArchive1";
    private String sSaveDocumentInArchive = "SaveDocumentInArchive";
    private final DirectoryMonitorPluginContext nullablePluginContext;

    public ArchiveTools(DirectoryMonitorPluginContext nullablePluginContext) {
        this.nullablePluginContext = nullablePluginContext;
    }

    public String[] GetClasses() {
        try {
            return this.doInPluginContextClassLoader(() -> {
                QName serviceQN = new QName(namespace, serviceName);
                Service service = SyncUtils.createService(new URL(wsdlURL), serviceQN);
                Call call = service.createCall();
                call.setOperationName(new QName(this.sGetArchiveDocClass));
                call.setTargetEndpointAddress(wsdlURL2);
                Object[] params = new String[]{this.sUser};
                return (String[])call.invoke(params);
            });
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public String[] GetIndexes(String sClass) {
        try {
            return this.doInPluginContextClassLoader(() -> {
                QName serviceQN = new QName(namespace, serviceName);
                Service service = SyncUtils.createService(new URL(wsdlURL), serviceQN);
                Call call = service.createCall();
                call.setOperationName(new QName(this.sGetArchiveDocClassIndecies));
                call.setTargetEndpointAddress(wsdlURL2);
                Object[] params = new String[]{this.sUser, sClass};
                return (String[])call.invoke(params);
            });
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean IfFileExist(String sClass, Map<String, String> mIndexesValue) {
        return sClass.compareToIgnoreCase("Klasa 1") == 0 ? mIndexesValue.get("Index 1").compareToIgnoreCase("1.tif") == 0 : sClass.compareToIgnoreCase("Klasa 2") == 0 && mIndexesValue.get("Index 1").compareToIgnoreCase("1.tif") == 0;
    }

    public boolean LoginToArchive(String sUser, String sPassword, Boolean bAccessWithWebService) {
        Boolean bResult = false;
        try {
            if (bAccessWithWebService.booleanValue()) {
                log.info((Object)("LoginToArchive with webservices: " + wsdlURL + " 2: " + wsdlURL2));
                QName serviceQN = new QName(namespace, serviceName);
                String sResult = this.doInPluginContextClassLoader(() -> {
                    Service service = SyncUtils.createService(new URL(wsdlURL), serviceQN);
                    Call call = service.createCall();
                    call.setOperationName(new QName(this.sLoginInSystem));
                    call.setTargetEndpointAddress(wsdlURL2);
                    Object[] params = new String[]{sUser, sPassword};
                    return (String)call.invoke(params);
                });
                bResult = sResult.compareToIgnoreCase("true") == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                this.sUser = bResult != false ? sUser : null;
                return bResult;
            }
            log.info((Object)"LoginToArchive with API");
            UserService us = ServiceFactory.getUserService();
            if (us.getUser(sUser, new String[0]) != null) {
                this.sUser = sUser;
                return true;
            }
            this.sUser = null;
            return false;
        }
        catch (Exception e) {
            log.error((Object)("Nieudane logowanie do systemu na u\u017cytkownika: " + sUser), (Throwable)e);
            this.sUser = null;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int AddFileToArchiveApi(String sClass, String[] asIndexes, File fFile, String sSaveAsNewVersion) {
        try (FileInputStream oFileStream = new FileInputStream(fFile);){
            log.info((Object)"AddFileToArchiveApi");
            log.info((Object)("Klasa: " + sClass + " User: " + this.sUser + " SaveAsNewVersion: " + sSaveAsNewVersion + " File: " + fFile.getName()));
            if (sSaveAsNewVersion == null) {
                sSaveAsNewVersion = "false";
            }
            Boolean bSaveAsNewVersion = Boolean.parseBoolean(sSaveAsNewVersion);
            DocumentService documentService = ServiceFactory.getDocumentService();
            long nClassID = Long.parseLong(sClass);
            HashMap<Long, String> idx = new HashMap<Long, String>();
            for (String sIndex222 : asIndexes) {
                int separatorIndex = sIndex222.indexOf(";");
                if (separatorIndex != -1) {
                    long nIndexId = Long.parseLong(sIndex222.substring(0, separatorIndex));
                    String sIndexValue = sIndex222.substring(separatorIndex + 1);
                    idx.put(nIndexId, sIndexValue);
                    continue;
                }
                idx.put(Long.parseLong(sIndex222), "");
            }
            DocumentDefinition definition = new DocumentDefinition();
            definition.setDocumentClassId(Long.valueOf(nClassID));
            definition.setFileName(fFile.getName());
            definition.setUserName(this.sUser);
            definition.setIndexes(idx);
            definition.setInputStream((InputStream)oFileStream);
            definition.setSaveAsNewVersion(bSaveAsNewVersion.booleanValue());
            definition.setExactIndexesCheck(false);
            if (this.nullablePluginContext != null) {
                this.nullablePluginContext.getDocumentUploadListenerRegistry().getDocumentUploadListener().ifPresent(documentUploadListener -> {
                    log.info((Object)"Wywo\u0142ywanie modu\u0142u listenera na wysy\u0142any dokument");
                    documentUploadListener.onDocumentUpload(definition);
                });
            }
            log.info((Object)"Dodawanie dokumentu");
            AddDocumentResultMeta oMetaResult = documentService.addDocumentWithMetaResult(definition);
            WfDocument oWfDocument = oMetaResult.getDocument();
            bSaveAsNewVersion = oMetaResult.getSavedAsNewVersion();
            if (oWfDocument == null) {
                log.error((Object)"B\u0142\u0105d przy dodawaniu dokumentu");
                int sIndex222 = -1;
                return sIndex222;
            }
            log.info((Object)("Udane dodawanie dokumentu " + (bSaveAsNewVersion != false ? "jako nowa wersja" : "jako nowy dokument")));
            DocumentClassActionService documentClassActionService = ServiceFactory.getDocumentClassActionService();
            try {
                documentClassActionService.executeArchiveActions(oWfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE, bSaveAsNewVersion);
            }
            catch (Exception e) {
                documentService.deleteDocument(oWfDocument);
                throw e;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return -1;
        }
    }

    public int AddFileToArchive(String sClass, String[] asIndexes, File fFile, String sSaveAsNewVersion, Boolean bAccessWithWebService) {
        if (bAccessWithWebService.booleanValue()) {
            return this.AddFileToArchive(sClass, asIndexes, fFile, sSaveAsNewVersion);
        }
        return this.AddFileToArchiveApi(sClass, asIndexes, fFile, sSaveAsNewVersion);
    }

    public int AddFileToArchive(String sClass, String[] asIndexes, File fFile, String sSaveAsNewVersion) {
        Integer nResult = -1;
        try {
            String sRes = this.doInPluginContextClassLoader(() -> {
                QName serviceQN = new QName(namespace, serviceName);
                Service service = SyncUtils.createService(new URL(wsdlURL), serviceQN);
                Call call = service.createCall();
                call.setProperty("axis.connection.timeout", (Object)new Integer(3600000));
                call.setOperationName(new QName(this.sSaveDocumentInArchive));
                call.setTargetEndpointAddress(wsdlURL2);
                String sFile = fFile.getName();
                sFile = sFile.replace("'", "_");
                FileInputStream inStream = new FileInputStream(fFile);
                Long nStreamSize = new Long(inStream.available());
                String sSize = nStreamSize.toString();
                byte[] aFile = new byte[nStreamSize.intValue()];
                int i = 0;
                while ((long)i < nStreamSize) {
                    aFile[i] = (byte)inStream.read();
                    ++i;
                }
                inStream.close();
                log.info((Object)("Invoke SaveDocumentInArchive: User=" + this.sUser + "; Class=" + sClass + "; File=" + sFile + "; sSize=" + sSize + ";"));
                Object[] params = new Object[]{this.sUser, sClass, sFile, sSize, null, null, null, aFile};
                return (String)call.invoke(params);
            });
            Integer nFileId = new Integer(sRes);
            if (nFileId > 0) {
                sRes = this.doInPluginContextClassLoader(() -> {
                    QName serviceQN = new QName(namespace, serviceName);
                    Service service = SyncUtils.createService(new URL(wsdlURL), serviceQN);
                    Call call = service.createCall();
                    call.setOperationName(new QName(this.sSaveIndeciesInArchive));
                    call.setTargetEndpointAddress(wsdlURL2);
                    call.setProperty("axis.connect.timeout", (Object)new Integer(3600000));
                    String saveAsNewVersion = sSaveAsNewVersion;
                    if (saveAsNewVersion == null || saveAsNewVersion.compareToIgnoreCase("true") != 0) {
                        saveAsNewVersion = "false";
                    }
                    log.info((Object)("******** sUser: " + this.sUser + " sClass: " + sClass + " FileId: " + nFileId.toString() + " NewVersion: " + saveAsNewVersion));
                    for (int i = 0; i < asIndexes.length; ++i) {
                        log.info((Object)asIndexes[i]);
                    }
                    Object[] params2 = new Object[]{this.sUser, sClass, nFileId.toString(), asIndexes, saveAsNewVersion};
                    return (String)call.invoke(params2);
                });
                nResult = new Integer(sRes);
            }
            return nResult;
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doInPluginContextClassLoader(Callable<T> supplier) throws Exception {
        ClassLoader prevContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            T t = supplier.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevContextClassLoader);
        }
    }
}

