/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.directorymonitor.module;

import com.plusmpm.directorymonitor.document.DocumentUploadListenerRegistry;
import com.plusmpm.directorymonitor.module.DocumentUploadListener;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.plugin.framework.config.ModuleDefinition;
import com.suncode.plugin.framework.support.module.ModuleHelper;
import com.suncode.plugin.framework.support.module.ModuleSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class DirectoryMonitorRegisterModule
extends ModuleSupport<Void> {
    private String documentUploadListenerClassName;
    @Autowired
    private DocumentUploadListenerRegistry documentUploadListenerRegistry;

    protected void initModule() throws PluginsException {
        ModuleDefinition definition = this.getDefinition();
        this.documentUploadListenerClassName = ModuleHelper.getAttribute((String)"document-upload-listener", (ModuleDefinition)definition, (boolean)true);
    }

    public void enable() throws PluginsException {
        Plugin plugin = this.getPlugin();
        ModuleDefinition definition = this.getDefinition();
        if (this.documentUploadListenerClassName != null) {
            DocumentUploadListener documentUploadListener = this.instantiateImplementation(DocumentUploadListener.class, this.documentUploadListenerClassName);
            this.documentUploadListenerRegistry.registerListener(plugin.getKey(), definition.getKey(), documentUploadListener);
        }
    }

    public void disable() throws PluginsException {
        Plugin plugin = this.getPlugin();
        ModuleDefinition definition = this.getDefinition();
        if (this.documentUploadListenerClassName != null) {
            this.documentUploadListenerRegistry.unregisterListener(plugin.getKey(), definition.getKey());
        }
    }

    private <T> T instantiateImplementation(Class<T> targetClass, String implClassName) throws PluginsException {
        if (StringUtils.isEmpty((Object)implClassName)) {
            return null;
        }
        try {
            Class<?> clazz = this.getPlugin().getClassLoader().loadClass(implClassName);
            if (!targetClass.isAssignableFrom(clazz)) {
                throw new PluginsException("Class " + implClassName + " must implement " + clazz.getName() + " interface");
            }
            return (T)this.getPlugin().getContext().getAutowireCapableBeanFactory().createBean(clazz);
        }
        catch (ClassNotFoundException ex) {
            throw new PluginsException("Can't load class: " + implClassName, (Throwable)ex);
        }
    }
}

