/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.directorymonitor;

import com.plusmpm.directorymonitor.ArchiveTools;
import com.plusmpm.directorymonitor.DirectoryMonitorTools;
import com.plusmpm.directorymonitor.Index;
import com.suncode.plugin.wrapper.DirectoryMonitorPluginContext;
import java.awt.TrayIcon;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class DirectoryShare
extends TimerTask {
    private static Logger log = Logger.getLogger(DirectoryShare.class);
    private String sShareId;
    private String sSharePath;
    private String sSortFilesBy;
    private String sSortFilesDirection;
    private boolean bSearchSubDirectory;
    private String sRawFileDestinationPath;
    private boolean bDeleteRawFiles;
    private boolean bCopyRawFiles;
    private String sXMLFileDestinationPath;
    private boolean bDeleteXMLFiles;
    private boolean bCopyXMLFiles;
    private boolean bCheckAtTime;
    private boolean bCheckPeriodic;
    private boolean bShowInfo;
    private boolean bShowErr;
    private boolean bAccessWithWebService;
    private Calendar oProcessTime;
    private int nPeriod;
    private int nProcessFilesUnmodifiedBy;
    private String sArchiveClass;
    private Vector vIndexes;
    private Vector vDB;
    private ArchiveTools oArchiveTools;
    private TrayIcon oTrayIcon;
    private Timer oTimer;
    private String sFileType;
    private String sFileRegExp;
    private String sFileNameRegExp;
    private String sRawFileRegExp;
    private String sRawFileMask;
    private String sXMLRawFileTag;
    private String sXMLRawFileAttribute;
    private String sXMLRawFileIgnoreNamespaces;
    private String sSaveAsNewVersion;
    private String sRawFileOnError;
    private String sRawFileErrorDirectory;
    private String sXMLFileOnError;
    private String sXMLFileErrorDirectory;
    private int nReDel = 10;
    private static String sShareIdKey = "ShareId";
    private static String sSharePathKey = "SharePath";
    private static String sSortFilesByKey = "SortFilesBy";
    private static String sSortFilesDirectionKey = "SortFilesDirection";
    private static String sRawFileDestinationPathKey = "RawFileDestinationPath";
    private static String sRawFileOnErrorKey = "RawFileOnError";
    private static String sRawFileErrorDirectoryKey = "RawFileErrorDirectory";
    private static String sXMLFileOnErrorKey = "XMLFileOnError";
    private static String sXMLFileErrorDirectoryKey = "XMLFileErrorDirectory";
    private static String sSearchSubDirectoryKey = "SearchSubDirectory";
    private static String sDeleteRawFilesKey = "DeleteRawFiles";
    private static String sCopyRawFilesKey = "CopyRawFiles";
    private static String sXMLRawFileTagKey = "XMLRawFileTag";
    private static String sXMLRawFileAttributeKey = "XMLRawFileAttribute";
    private static String sXMLRawFileIgnoreNamespacesKey = "XMLRawFileIgnoreNamespaces";
    private static String sXMLFileDestinationPathKey = "XMLFileDestinationPath";
    private static String sDeleteXMLFilesKey = "DeleteXMLFiles";
    private static String sCopyXMLFilesKey = "CopyXMLFiles";
    private static String sINIRawFileSectionKey = "INIRawFileSection";
    private static String sINIRawFileParameterKey = "INIRawFileParameter";
    private static String sINIFileDestinationPathKey = "XMLFileDestinationPath";
    private static String sDeleteINIFilesKey = "DeleteXMLFiles";
    private static String sCopyINIFilesKey = "CopyXMLFiles";
    private static String sCheckAtTimeKey = "CheckAtTime";
    private static String sCheckPeriodicKey = "CheckPeriodic";
    private static String sProcessTimeKey = "ProcessTime";
    private static String sPeriodKey = "Period";
    private static String sArchiveClassKey = "ArchiveClass";
    private static String sProcessFilesUnmodifiedByKey = "ProcessFilesUnmodifiedBy";
    private static String sSQLQueryKey = "SQLQuery";
    private static String sDBUserKey = "DBUser";
    private static String sDBPasswordKey = "DBPassword";
    private static String sDBURLKey = "DBURL";
    private static String sJDBCDriverKey = "JDBCDriver";
    private static String sAllOccurenceKey = "AllOccurence";
    private static String sFileTypeKey = "FileType";
    private static String sFileRegExpKey = "FileRegExp";
    private static String sFileNameRegExpKey = "FileNameRegExp";
    private static String sRawFileRegExpKey = "RawFileRegExp";
    private static String sRawFileMaskKey = "RawFileMask";
    private static String sSaveAsNewVersionKey = "SaveAsNewVersion";
    private static String sIndexKey = "Index";
    private static String sIndexId = "Id";
    private static String sIndexName = "Name";
    private static String sIndexType = "Type";
    private static String sIndexMustBeEqual = "MustBeEqual";
    private static String sIndexAllowEmpty = "AllowEmpty";
    private static String sIndexMultiValue = "MultiValue";
    private static String sIndexRegExp = "RegExp";
    private static String sIndexMask = "Mask";
    private static String sIndexString = "ConstantString";
    private static String sIndexPathSegment = "PathSegment";
    private static String sIndexFileSegment = "FileSegment";
    private static String sIndexFileSeparator = "FileSeparator";
    private static String sIndexEncoding = "Encoding";
    private static String sIndexDecoding = "Decoding";
    private static String sIndexBarcodeXMLPath = "XMLPath";
    private static String sIndexBarcodeNr = "BarcodeNr";
    private static String sIndexBarcodeXMLFileDelete = "XMLFileDelete";
    private static String sIndexBarcodeXMLFileCopy = "XMLFileCopy";
    private static String sIndexBarcodeXMLDestinationPath = "XMLDestinationPath";
    private static String sIndexSQLName = "SQLName";
    private static String sIndexSQLScheme = "SQLScheme";
    private static String sIndexXMLValueTag = "ValueTag";
    private static String sIndexXMLValueAttribute = "ValueAttribute";
    private static String sIndexXMLValueIgnoreNamespaces = "ValueIgnoreNamespaces";
    private static String sIndexXMLValueDelimiterTag = "ValueDelimiterTag";
    private static String sIndexXMLDefaultDelimitedValue = "DefaultDelimitedValue";
    private static String sIndexINISection = "INISection";
    private static String sIndexINIParameter = "INIParameter";
    private static String sInfoMessageTitle = "Udane przetwarzanie";
    private static String sInfoMessagePrefix = "Plik:\n";
    private static String sInfoMessageSufix = "\nzosta\u0142\u201a dodany do archiwum";
    private static String sErrMessageCopyTitle = "Nieudane kopiowanie";
    private static String sErrMessageCopyPrefix = "B\u0142\u0105d przy kopiowaniu pliku:\n";
    private static String sErrMessageCopySufix = "";
    private static String sErrMessageDeleteTitle = "Nieudane usuwanie";
    private static String sErrMessageDeletePrefix = "B\u0142\u0105d przy usuwaniu pliku:\n";
    private static String sErrMessageDeleteSufix = "";
    private static String sErrMessageTitle = "Nieudane przetwarzanie";
    private static String sErrMessagePrefix = "B\u0142\u0105d przy przetwarzaniu pliku:\n";
    private static String sErrMessageSufix = "";
    private static String sErrMessageMkDirTitle = "Nieudane tworzenie katalogu";
    private static String sErrMessageMkDirPrefix = "B\u0142\u0105d przy tworzeniu katalogu:\n";
    private static String sErrMessageMkDirSufix = "";
    private static String sErrMessageAddFileTitle = "Nieudane dodanie pliku do archiwum";
    private static String sErrMessageAddFilePrefix = "B\u0142\u0105d przy dodawaniu pliku do archiwum:\n";
    private static String sErrMessageAddFileSufix = "";
    private static int nSUCCEED = 0;
    private static int nERR_WHILE_DELETE = 1;
    private static int nERR_WHILE_COPY = 2;
    private static int nERR_WHILE_MKDIR = 3;
    private static int nUNKNOWN_ERR = 10;

    public DirectoryShare(String sUser, String sPassword, DirectoryMonitorPluginContext nullablePluginContext) {
        log.info((Object)"DirectoryShare constuctor");
        this.InitVar(sUser, sPassword, true, true, nullablePluginContext);
    }

    public DirectoryShare(Map mConfig, String sUser, String sPassword, boolean bDisplayTrayIcon, boolean bSetTimer, boolean AccessWithWebService, DirectoryMonitorPluginContext nullablePluginContext) {
        log.trace((Object)"DirectoryShare constuctor with config");
        this.InitVar(sUser, sPassword, bDisplayTrayIcon, AccessWithWebService, nullablePluginContext);
        this.SetVar(mConfig);
        if (bSetTimer) {
            this.SetTimer();
        }
    }

    public String getSShareId() {
        return this.sShareId;
    }

    public void setSShareId(String shareId) {
        this.sShareId = shareId;
    }

    public String getSSharePath() {
        return this.sSharePath;
    }

    public void setSSharePath(String sharePath) {
        this.sSharePath = sharePath;
    }

    public String getSSortFilesBy() {
        return this.sSortFilesBy;
    }

    public void setSSortFilesBy(String sortFilesBy) {
        this.sSortFilesBy = sortFilesBy;
    }

    public String getSSortFilesDirection() {
        return this.sSortFilesDirection;
    }

    public void setSSortFilesDirection(String sortFilesDirection) {
        this.sSortFilesDirection = sortFilesDirection;
    }

    public boolean isBSearchSubDirectory() {
        return this.bSearchSubDirectory;
    }

    public void setBSearchSubDirectory(boolean searchSubDirectory) {
        this.bSearchSubDirectory = searchSubDirectory;
    }

    public boolean isBDeleteRawFiles() {
        return this.bDeleteRawFiles;
    }

    public void setBDeleteRawFiles(boolean deleteFiles) {
        this.bDeleteRawFiles = deleteFiles;
    }

    public boolean isBCheckAtTime() {
        return this.bCheckAtTime;
    }

    public void setBCheckAtTime(boolean checkAtTime) {
        this.bCheckAtTime = checkAtTime;
    }

    public boolean isBCheckPeriodic() {
        return this.bCheckPeriodic;
    }

    public void setBCheckPeriodic(boolean checkPeriodic) {
        this.bCheckPeriodic = checkPeriodic;
    }

    public Calendar getOProcessTime() {
        return this.oProcessTime;
    }

    public void setOProcessTime(Calendar time) {
        this.oProcessTime = time;
    }

    public int getNPeriod() {
        return this.nPeriod;
    }

    public void setNPeriod(int period) {
        this.nPeriod = period;
    }

    public String getSArchiveClass() {
        return this.sArchiveClass;
    }

    public void setSArchiveClass(String archiveClass) {
        this.sArchiveClass = archiveClass;
    }

    public ArchiveTools getOArchiveTools() {
        return this.oArchiveTools;
    }

    public void setOArchiveTools(ArchiveTools archiveTools) {
        this.oArchiveTools = archiveTools;
    }

    public String getSRawFileOnError() {
        return this.sRawFileOnError;
    }

    public void setSRawFileErrorDirectory(String Path2) {
        this.sRawFileErrorDirectory = Path2;
    }

    public String getSRawFileErrorDirectory() {
        return this.sRawFileErrorDirectory;
    }

    public void setSRawFileOnError(String sOnError) {
        this.sRawFileOnError = sOnError;
    }

    public String getSXMLFileOnError() {
        return this.sXMLFileOnError;
    }

    public void setSXMLFileOnError(String sOnError) {
        this.sXMLFileOnError = sOnError;
    }

    public String getSXMLFileErrorDirectory() {
        return this.sXMLFileErrorDirectory;
    }

    public void setSXMLFileErrorDirectory(String sErrorDirectory) {
        this.sXMLFileErrorDirectory = sErrorDirectory;
    }

    public String getSRawFileDestinationPath() {
        return this.sRawFileDestinationPath;
    }

    public void setSRawFileDestinationPath(String destinationPath) {
        this.sRawFileDestinationPath = destinationPath;
    }

    public boolean isBCopyRawFiles() {
        return this.bCopyRawFiles;
    }

    public void setBCopyRawFiles(boolean copyRawFiles) {
        this.bCopyRawFiles = copyRawFiles;
    }

    public TrayIcon getOTrayIcon() {
        return this.oTrayIcon;
    }

    public void setOTrayIcon(TrayIcon trayIcon) {
        this.oTrayIcon = trayIcon;
    }

    public boolean isBShowInfo() {
        return this.bShowInfo;
    }

    public void setBShowInfo(boolean showInfo) {
        this.bShowInfo = showInfo;
    }

    public boolean isBShowErr() {
        return this.bShowErr;
    }

    public void setBShowErr(boolean showErr) {
        this.bShowErr = showErr;
    }

    public void setBAccessWithWebService(boolean accessWithWebService) {
        this.bAccessWithWebService = accessWithWebService;
    }

    public void InitVar(String sUser, String sPassword, boolean bDisplayTrayIcon, boolean AccessWithWebService, DirectoryMonitorPluginContext nullablePluginContext) {
        log.trace((Object)"Starting InitVar");
        try {
            this.sShareId = null;
            this.sSharePath = null;
            this.sSortFilesBy = null;
            this.sSortFilesDirection = null;
            this.sArchiveClass = null;
            this.sRawFileDestinationPath = null;
            this.sRawFileOnError = "";
            this.sRawFileErrorDirectory = "";
            this.sXMLFileOnError = "";
            this.sXMLFileErrorDirectory = "";
            this.bSearchSubDirectory = false;
            this.bDeleteRawFiles = false;
            this.bCheckAtTime = false;
            this.bCheckPeriodic = false;
            this.bCopyRawFiles = false;
            this.bShowInfo = bDisplayTrayIcon;
            this.bShowErr = bDisplayTrayIcon;
            this.nPeriod = 0;
            this.nProcessFilesUnmodifiedBy = 0;
            this.oProcessTime = null;
            this.sFileType = null;
            this.sFileRegExp = null;
            this.sFileNameRegExp = null;
            this.sRawFileRegExp = null;
            this.sRawFileMask = null;
            this.sXMLRawFileTag = null;
            this.sXMLRawFileAttribute = null;
            this.sSaveAsNewVersion = null;
            this.sXMLFileDestinationPath = null;
            this.bCopyXMLFiles = false;
            this.bDeleteXMLFiles = false;
            this.bAccessWithWebService = AccessWithWebService;
            this.oArchiveTools = new ArchiveTools(nullablePluginContext, this.bAccessWithWebService);
            this.oArchiveTools.LoginToArchive(sUser, sPassword);
            this.vIndexes = new Vector();
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void SetVar(Map mConfig) {
        try {
            log.trace((Object)"Starting SetVar");
            if (mConfig.containsKey(sShareIdKey)) {
                this.sShareId = (String)mConfig.get(sShareIdKey);
            }
            if (mConfig.containsKey(sSharePathKey)) {
                this.sSharePath = (String)mConfig.get(sSharePathKey);
            }
            if (mConfig.containsKey(sSortFilesByKey)) {
                this.sSortFilesBy = (String)mConfig.get(sSortFilesByKey);
            }
            if (mConfig.containsKey(sSortFilesDirectionKey)) {
                this.sSortFilesDirection = (String)mConfig.get(sSortFilesDirectionKey);
            }
            if (mConfig.containsKey(sArchiveClassKey)) {
                this.sArchiveClass = (String)mConfig.get(sArchiveClassKey);
            }
            if (mConfig.containsKey(sFileTypeKey)) {
                this.sFileType = (String)mConfig.get(sFileTypeKey);
            }
            if (mConfig.containsKey(sFileRegExpKey)) {
                this.sFileRegExp = (String)mConfig.get(sFileRegExpKey);
            }
            if (mConfig.containsKey(sFileNameRegExpKey)) {
                this.sFileNameRegExp = (String)mConfig.get(sFileNameRegExpKey);
            }
            if (mConfig.containsKey(sRawFileRegExpKey)) {
                this.sRawFileRegExp = (String)mConfig.get(sRawFileRegExpKey);
            }
            if (mConfig.containsKey(sRawFileOnErrorKey)) {
                this.sRawFileOnError = (String)mConfig.get(sRawFileOnErrorKey);
            }
            if (mConfig.containsKey(sRawFileErrorDirectoryKey)) {
                this.sRawFileErrorDirectory = (String)mConfig.get(sRawFileErrorDirectoryKey);
            }
            if (mConfig.containsKey(sXMLFileOnErrorKey)) {
                this.sXMLFileOnError = (String)mConfig.get(sXMLFileOnErrorKey);
            }
            if (mConfig.containsKey(sXMLFileErrorDirectoryKey)) {
                this.sXMLFileErrorDirectory = (String)mConfig.get(sXMLFileErrorDirectoryKey);
            }
            if (mConfig.containsKey(sRawFileMaskKey)) {
                this.sRawFileMask = (String)mConfig.get(sRawFileMaskKey);
            }
            if (mConfig.containsKey(sRawFileDestinationPathKey)) {
                this.sRawFileDestinationPath = (String)mConfig.get(sRawFileDestinationPathKey);
            }
            if (mConfig.containsKey(sSearchSubDirectoryKey)) {
                this.bSearchSubDirectory = ((String)mConfig.get(sSearchSubDirectoryKey)).compareToIgnoreCase("true") == 0;
            }
            if (mConfig.containsKey(sXMLRawFileTagKey)) {
                this.sXMLRawFileTag = (String)mConfig.get(sXMLRawFileTagKey);
            }
            if (mConfig.containsKey(sXMLRawFileAttributeKey)) {
                this.sXMLRawFileAttribute = (String)mConfig.get(sXMLRawFileAttributeKey);
            }
            if (mConfig.containsKey(sXMLRawFileIgnoreNamespacesKey)) {
                this.sXMLRawFileIgnoreNamespaces = (String)mConfig.get(sXMLRawFileIgnoreNamespacesKey);
            }
            if (mConfig.containsKey(sDeleteRawFilesKey)) {
                this.bDeleteRawFiles = ((String)mConfig.get(sDeleteRawFilesKey)).compareToIgnoreCase("true") == 0;
            }
            if (mConfig.containsKey(sCheckAtTimeKey)) {
                this.bCheckAtTime = ((String)mConfig.get(sCheckAtTimeKey)).compareToIgnoreCase("true") == 0;
            }
            if (mConfig.containsKey(sCheckPeriodicKey)) {
                this.bCheckPeriodic = ((String)mConfig.get(sCheckPeriodicKey)).compareToIgnoreCase("true") == 0;
            }
            if (mConfig.containsKey(sCopyRawFilesKey)) {
                this.bCopyRawFiles = ((String)mConfig.get(sCopyRawFilesKey)).compareToIgnoreCase("true") == 0;
            }
            if (mConfig.containsKey(sXMLFileDestinationPathKey)) {
                this.sXMLFileDestinationPath = (String)mConfig.get(sXMLFileDestinationPathKey);
            }
            if (mConfig.containsKey(sCopyXMLFilesKey)) {
                this.bCopyXMLFiles = ((String)mConfig.get(sCopyXMLFilesKey)).compareToIgnoreCase("true") == 0;
            }
            if (mConfig.containsKey(sDeleteXMLFilesKey)) {
                this.bDeleteXMLFiles = ((String)mConfig.get(sDeleteXMLFilesKey)).compareToIgnoreCase("true") == 0;
            }
            if (mConfig.containsKey(sPeriodKey)) {
                this.nPeriod = new Integer((String)mConfig.get(sPeriodKey));
            }
            this.nProcessFilesUnmodifiedBy = mConfig.containsKey(sProcessFilesUnmodifiedByKey) ? new Integer((String)mConfig.get(sProcessFilesUnmodifiedByKey)) : 0;
            if (mConfig.containsKey(sSaveAsNewVersionKey)) {
                this.sSaveAsNewVersion = (String)mConfig.get(sSaveAsNewVersionKey);
            }
            if (mConfig.containsKey(sProcessTimeKey)) {
                String[] saDTime;
                String sProcessTime = (String)mConfig.get(sProcessTimeKey);
                Calendar oNow = Calendar.getInstance();
                this.oProcessTime = Calendar.getInstance();
                if (sProcessTime != null && (saDTime = sProcessTime.split(":")).length == 2) {
                    Integer nHour = new Integer(saDTime[0]);
                    Integer nMinutes = new Integer(saDTime[1]);
                    this.oProcessTime.set(11, nHour);
                    this.oProcessTime.set(12, nMinutes);
                    if (this.oProcessTime.before(oNow)) {
                        this.oProcessTime.add(5, 1);
                    }
                }
            }
            int nDBIndex = 1;
            this.vDB = new Vector();
            while (mConfig.containsKey(sDBURLKey + nDBIndex)) {
                LinkedHashMap<String, Object> mDBMap = new LinkedHashMap<String, Object>();
                Vector vSQLNames = new Vector();
                mDBMap.put("SQLNames", vSQLNames);
                Vector vIndexNumbers = new Vector();
                mDBMap.put("IndexNumbers", vIndexNumbers);
                mDBMap.put(sDBURLKey, (String)mConfig.get(sDBURLKey + nDBIndex));
                if (!mConfig.containsKey(sSQLQueryKey + nDBIndex)) {
                    ++nDBIndex;
                    break;
                }
                mDBMap.put(sSQLQueryKey, (String)mConfig.get(sSQLQueryKey + nDBIndex));
                if (!mConfig.containsKey(sDBUserKey + nDBIndex)) {
                    ++nDBIndex;
                    break;
                }
                mDBMap.put(sDBUserKey, (String)mConfig.get(sDBUserKey + nDBIndex));
                if (!mConfig.containsKey(sDBPasswordKey + nDBIndex)) {
                    ++nDBIndex;
                    break;
                }
                mDBMap.put(sDBPasswordKey, (String)mConfig.get(sDBPasswordKey + nDBIndex));
                if (mConfig.containsKey(sJDBCDriverKey + nDBIndex)) {
                    mDBMap.put(sJDBCDriverKey, (String)mConfig.get(sJDBCDriverKey + nDBIndex));
                }
                if (mConfig.containsKey(sAllOccurenceKey + nDBIndex)) {
                    mDBMap.put(sAllOccurenceKey, (String)mConfig.get(sAllOccurenceKey + nDBIndex));
                } else {
                    mDBMap.put(sAllOccurenceKey, "false");
                }
                this.vDB.add(mDBMap);
                ++nDBIndex;
            }
            int nIndex = 1;
            this.vIndexes = new Vector();
            while (mConfig.containsKey(sIndexKey + nIndex + "_" + sIndexType)) {
                String sRegExp = null;
                String sMask = null;
                String sConst = null;
                String sSeparator = null;
                String sEncoding = null;
                String sDecoding = null;
                String sSQLName = null;
                String sSQLScheme = null;
                String sBarcode_Nr = null;
                String sBarcode_XML_Path = null;
                String sBarcode_XML_BackupPath = null;
                String sBarcode_XML_FileBackup = null;
                String sBarcode_XML_FileDelete = null;
                String sXMLValueTag = null;
                String sXMLValueAttribute = null;
                String sXMLValueIgnoreNamespaces = null;
                String sXMLValueDelimiterTag = null;
                String sXMLDefaultDelimitedValue = null;
                String sINISection = null;
                String sINIParameter = null;
                String sId = null;
                String sName = null;
                boolean bAllowEmpty = true;
                boolean bMultiValue = true;
                int nPathSegment = -1;
                int nFileSegment = -1;
                String sMustBeEqual = null;
                String sIndexPrefix = sIndexKey + nIndex + "_";
                if (mConfig.containsKey(sIndexPrefix + sIndexRegExp)) {
                    sRegExp = (String)mConfig.get(sIndexPrefix + sIndexRegExp);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexMask)) {
                    sMask = (String)mConfig.get(sIndexPrefix + sIndexMask);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexString)) {
                    sConst = (String)mConfig.get(sIndexPrefix + sIndexString);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexPathSegment)) {
                    nPathSegment = new Integer((String)mConfig.get(sIndexPrefix + sIndexPathSegment));
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexFileSegment)) {
                    nFileSegment = new Integer((String)mConfig.get(sIndexPrefix + sIndexFileSegment));
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexFileSeparator)) {
                    sSeparator = (String)mConfig.get(sIndexPrefix + sIndexFileSeparator);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexSQLName)) {
                    sSQLName = (String)mConfig.get(sIndexPrefix + sIndexSQLName);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexSQLScheme)) {
                    sSQLScheme = (String)mConfig.get(sIndexPrefix + sIndexSQLScheme);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexBarcodeXMLPath)) {
                    sBarcode_XML_Path = (String)mConfig.get(sIndexPrefix + sIndexBarcodeXMLPath);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexBarcodeNr)) {
                    sBarcode_Nr = (String)mConfig.get(sIndexPrefix + sIndexBarcodeNr);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexBarcodeXMLDestinationPath)) {
                    sBarcode_XML_BackupPath = (String)mConfig.get(sIndexPrefix + sIndexBarcodeXMLDestinationPath);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexBarcodeXMLFileCopy)) {
                    sBarcode_XML_FileBackup = (String)mConfig.get(sIndexPrefix + sIndexBarcodeXMLFileCopy);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexBarcodeXMLFileDelete)) {
                    sBarcode_XML_FileDelete = (String)mConfig.get(sIndexPrefix + sIndexBarcodeXMLFileDelete);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexXMLValueTag)) {
                    sXMLValueTag = (String)mConfig.get(sIndexPrefix + sIndexXMLValueTag);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexXMLValueAttribute)) {
                    sXMLValueAttribute = (String)mConfig.get(sIndexPrefix + sIndexXMLValueAttribute);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexXMLValueIgnoreNamespaces)) {
                    sXMLValueIgnoreNamespaces = (String)mConfig.get(sIndexPrefix + sIndexXMLValueIgnoreNamespaces);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexXMLValueDelimiterTag)) {
                    sXMLValueDelimiterTag = (String)mConfig.get(sIndexPrefix + sIndexXMLValueDelimiterTag);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexXMLDefaultDelimitedValue)) {
                    sXMLDefaultDelimitedValue = (String)mConfig.get(sIndexPrefix + sIndexXMLDefaultDelimitedValue);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexINISection)) {
                    sINISection = (String)mConfig.get(sIndexPrefix + sIndexINISection);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexINIParameter)) {
                    sINIParameter = (String)mConfig.get(sIndexPrefix + sIndexINIParameter);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexEncoding)) {
                    sEncoding = (String)mConfig.get(sIndexPrefix + sIndexEncoding);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexDecoding)) {
                    sDecoding = (String)mConfig.get(sIndexPrefix + sIndexDecoding);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexAllowEmpty)) {
                    String sAllowEmpty = (String)mConfig.get(sIndexPrefix + sIndexAllowEmpty);
                    bAllowEmpty = sAllowEmpty.compareToIgnoreCase("false") != 0;
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexMultiValue)) {
                    String sMultiValue = (String)mConfig.get(sIndexPrefix + sIndexMultiValue);
                    bMultiValue = sMultiValue.compareToIgnoreCase("true") == 0;
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexMustBeEqual)) {
                    sMustBeEqual = (String)mConfig.get(sIndexPrefix + sIndexMustBeEqual);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexId)) {
                    sId = (String)mConfig.get(sIndexPrefix + sIndexId);
                }
                if (mConfig.containsKey(sIndexPrefix + sIndexName)) {
                    sName = (String)mConfig.get(sIndexPrefix + sIndexName);
                }
                Index oIndex = new Index(sId, sName, (String)mConfig.get(sIndexPrefix + sIndexType), bAllowEmpty, nPathSegment, nFileSegment, sSeparator, sConst, sRegExp, sMask, sSQLName, sSQLScheme, sBarcode_XML_Path, sBarcode_Nr, sBarcode_XML_BackupPath, sBarcode_XML_FileBackup, sBarcode_XML_FileDelete, sXMLValueTag, sXMLValueAttribute, sXMLValueIgnoreNamespaces, sXMLValueDelimiterTag, sXMLDefaultDelimitedValue, sINISection, sINIParameter, bMultiValue, sEncoding, sDecoding, sMustBeEqual);
                this.vIndexes.add(oIndex);
                ++nIndex;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public Map GetVar() {
        LinkedHashMap<Object, Object> mConfig = null;
        try {
            mConfig = new LinkedHashMap<Object, Object>();
            mConfig.put(sShareIdKey, this.sShareId);
            mConfig.put(sSharePathKey, this.sSharePath);
            mConfig.put(sSortFilesByKey, this.sSortFilesBy);
            mConfig.put(sSortFilesDirectionKey, this.sSortFilesDirection);
            mConfig.put(sRawFileDestinationPathKey, this.sRawFileDestinationPath);
            mConfig.put(sSearchSubDirectoryKey, this.bSearchSubDirectory);
            mConfig.put(sDeleteRawFilesKey, this.bDeleteRawFiles);
            mConfig.put(sCopyRawFilesKey, this.bCopyRawFiles);
            mConfig.put(sCheckAtTimeKey, this.bCheckAtTime);
            mConfig.put(sXMLFileDestinationPathKey, this.sXMLFileDestinationPath);
            mConfig.put(sDeleteXMLFilesKey, this.bDeleteXMLFiles);
            mConfig.put(sCopyXMLFilesKey, this.bCopyXMLFiles);
            mConfig.put(sCheckPeriodicKey, this.bCheckPeriodic);
            mConfig.put(sProcessTimeKey, this.oProcessTime);
            mConfig.put(sPeriodKey, this.nPeriod);
            mConfig.put(sArchiveClassKey, this.sArchiveClass);
            mConfig.put(sRawFileOnErrorKey, this.sRawFileOnError);
            mConfig.put(sRawFileErrorDirectoryKey, this.sRawFileErrorDirectory);
            mConfig.put(sXMLFileOnErrorKey, this.sXMLFileOnError);
            mConfig.put(sXMLFileErrorDirectoryKey, this.sXMLFileErrorDirectory);
            for (int i = 0; i < this.vIndexes.size(); ++i) {
                Index oIndex = (Index)this.vIndexes.get(i);
                String sIndexPrefix = sIndexKey + i + "_";
                if (oIndex.getSIndexId() == null || oIndex.getSType() == null) continue;
                mConfig.put(sIndexPrefix + sIndexId, oIndex.getSIndexId());
                mConfig.put(sIndexPrefix + sIndexType, oIndex.getSType());
                if (oIndex.getSName() != null) {
                    mConfig.put(sIndexPrefix + sIndexName, oIndex.getSName());
                }
                if (oIndex.getNPathSegment() > 0) {
                    mConfig.put(sIndexPrefix + sIndexPathSegment, oIndex.getNPathSegment());
                }
                if (oIndex.getSIndexString() != null) {
                    mConfig.put(sIndexPrefix + sIndexString, oIndex.getSIndexString());
                }
                if (oIndex.getSRegExp() != null) {
                    mConfig.put(sIndexPrefix + sIndexRegExp, oIndex.getSRegExp());
                }
                if (oIndex.getSFileSeparator() != null) {
                    mConfig.put(sIndexPrefix + sIndexFileSeparator, oIndex.getSFileSeparator());
                }
                if (oIndex.getNFileSegment() > 0) {
                    mConfig.put(sIndexPrefix + sIndexFileSegment, oIndex.getNFileSegment());
                }
                if (oIndex.getSMask() == null) continue;
                mConfig.put(sIndexPrefix + sIndexMask, oIndex.getSMask());
            }
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return mConfig;
    }

    public void SetTimer() {
        try {
            this.oTimer = new Timer();
            if (this.bCheckAtTime) {
                this.oTimer.scheduleAtFixedRate((TimerTask)this, this.oProcessTime.getTime(), 86400000L);
            }
            if (this.bCheckPeriodic) {
                this.oTimer.schedule((TimerTask)this, this.nPeriod, (long)this.nPeriod);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public int AddFileToArchive(File fRawFile, File fXMLFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [26[FORLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    private Map ProcessDirectory(File fFile, Map mResult, String sRawDestination, String sXMLDestination) {
        block118: {
            try {
                if (!fFile.exists()) break block118;
                String[] asFiles = fFile.list();
                ArrayList<String> fileList = new ArrayList<String>(Arrays.asList(asFiles));
                if (this.getSSortFilesBy() != null) {
                    if (this.getSSortFilesBy().equals("name")) {
                        if (this.getSSortFilesDirection() != null && this.getSSortFilesDirection().equals("desc")) {
                            Collections.sort(fileList, Collections.reverseOrder());
                        } else {
                            fileList.sort(null);
                        }
                    } else if (this.getSSortFilesBy().equals("date")) {
                        Object[] files = fFile.listFiles();
                        Arrays.sort(files);
                        if (this.getSSortFilesDirection() != null && this.getSSortFilesDirection().equals("desc")) {
                            DirectoryShare.sortFilesByDateCreated((File[])files, this.getSSortFilesDirection().toString());
                        } else {
                            DirectoryShare.sortFilesByDateCreated((File[])files, "asc");
                        }
                        fileList.clear();
                        for (Object file : files) {
                            try {
                                if (!((File)file).isFile() && !((File)file).isDirectory()) continue;
                                fileList.add(((File)file).getName());
                            }
                            catch (Exception ex) {
                                log.error((Object)ex.getMessage(), (Throwable)ex);
                            }
                        }
                    }
                }
                for (String listEl : fileList) {
                    File fDir;
                    File fDir2;
                    String sTempFile = fFile.getAbsolutePath() + File.separator + listEl.toString();
                    log.info((Object)("Processing: " + sTempFile));
                    File fTempFile = new File(sTempFile);
                    Vector<Object> vsRawFiles = new Vector<CallSite>();
                    if (fTempFile.isFile()) {
                        Pattern myPattern;
                        Matcher myMatcher;
                        try {
                            Date time = new Date(fTempFile.lastModified());
                            log.info((Object)("Data ostatniej modyfikacji pliku: " + String.valueOf(time)));
                            Calendar filecal = Calendar.getInstance();
                            filecal.setTime(time);
                            Calendar cal = Calendar.getInstance();
                            cal.getTime();
                            cal.add(12, -this.nProcessFilesUnmodifiedBy);
                            if (cal.before(filecal)) {
                                log.warn((Object)("Plik modyfikowany mniej niz " + this.nProcessFilesUnmodifiedBy + " minut temu. Przetwarzanie pomijane."));
                                continue;
                            }
                        }
                        catch (Exception ex) {
                            log.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                        if (this.sFileRegExp != null && this.sFileRegExp.compareToIgnoreCase("") != 0 && !(myMatcher = (myPattern = Pattern.compile(this.sFileRegExp, 128)).matcher(sTempFile)).find()) {
                            log.info((Object)"Plik nie dopasowany do wzorca");
                            continue;
                        }
                        if (this.sFileNameRegExp != null && this.sFileNameRegExp.compareToIgnoreCase("") != 0 && !(myMatcher = (myPattern = Pattern.compile(this.sFileNameRegExp, 128)).matcher(fTempFile.getName())).find()) {
                            log.info((Object)"Plik nie dopasowany do wzorca");
                            continue;
                        }
                        if (this.sFileType == null || this.sFileType.compareToIgnoreCase("") == 0) {
                            this.sFileType = "RAW";
                        }
                        if (this.sFileType.compareToIgnoreCase("RAW") == 0) {
                            vsRawFiles.add(sTempFile);
                            log.info((Object)"Typ pliku: RAW");
                        }
                        if (this.sFileType.compareToIgnoreCase("XML") == 0) {
                            log.info((Object)"Typ pliku: XML");
                            if (this.sXMLRawFileTag != null && this.sXMLRawFileTag.compareToIgnoreCase("") != 0) {
                                boolean ignoreNamespaces = Boolean.parseBoolean(this.sXMLRawFileIgnoreNamespaces);
                                if (this.sXMLRawFileAttribute != null && this.sXMLRawFileAttribute.compareToIgnoreCase("") != 0) {
                                    oDirMT = new DirectoryMonitorTools();
                                    vsRawFiles = oDirMT.GetXMLAttributes(sTempFile, ignoreNamespaces, this.sXMLRawFileTag, this.sXMLRawFileAttribute);
                                } else {
                                    oDirMT = new DirectoryMonitorTools();
                                    vsRawFiles = oDirMT.GetXMLTags(sTempFile, ignoreNamespaces, this.sXMLRawFileTag);
                                }
                            } else {
                                vsRawFiles.add(sTempFile);
                                log.info((Object)"Raw plik z nazwy pliku xml");
                            }
                        }
                        if (this.sFileType.compareToIgnoreCase("INI") == 0) {
                            // empty if block
                        }
                        if (this.sRawFileRegExp != null && this.sRawFileRegExp.compareToIgnoreCase("") != 0 && vsRawFiles != null) {
                            int j = 0;
                            while (vsRawFiles.size() > j) {
                                Pattern myPattern2 = Pattern.compile(this.sRawFileRegExp, 128);
                                Matcher myMatcher2 = myPattern2.matcher((CharSequence)vsRawFiles.get(j));
                                if (myMatcher2.find()) {
                                    if (myMatcher2.groupCount() > 0) {
                                        vsRawFiles.set(j, myMatcher2.group(1));
                                    } else {
                                        vsRawFiles.set(j, myMatcher2.group());
                                    }
                                    if (this.sRawFileMask != null && this.sRawFileMask.compareToIgnoreCase("") != 0) {
                                        vsRawFiles.set(j, myMatcher2.replaceAll(this.sRawFileMask));
                                    }
                                    ++j;
                                    continue;
                                }
                                vsRawFiles.remove(j);
                            }
                        }
                        boolean bOneError = false;
                        boolean bLeaveXML = false;
                        for (String sRawFile : vsRawFiles) {
                            File fRawFile = new File(sRawFile);
                            log.info((Object)("Processing file: " + fRawFile.getAbsolutePath()));
                            int nAddFileResult = this.AddFileToArchive(fRawFile, fTempFile);
                            if (nAddFileResult == 0) {
                                mResult.put(fRawFile.getAbsolutePath(), nSUCCEED);
                                if (this.bShowInfo) {
                                    this.oTrayIcon.displayMessage(sInfoMessageTitle, sInfoMessagePrefix + fRawFile.getAbsolutePath() + sInfoMessageSufix, TrayIcon.MessageType.INFO);
                                }
                                log.info((Object)("*** " + sInfoMessageTitle + " *** " + sInfoMessagePrefix + fRawFile.getAbsolutePath() + sInfoMessageSufix));
                                boolean bCopySucc = true;
                                if (this.bCopyRawFiles && sRawDestination != null) {
                                    AbstractInterruptibleChannel inChannel = null;
                                    AbstractInterruptibleChannel outChannel = null;
                                    try {
                                        File fTempOutFile = new File(sRawDestination + File.separator + fRawFile.getName());
                                        inChannel = new FileInputStream(fRawFile).getChannel();
                                        outChannel = new FileOutputStream(fTempOutFile).getChannel();
                                        int maxCount = 67076096;
                                        long size = ((FileChannel)inChannel).size();
                                        for (long position = 0L; position < size; position += ((FileChannel)inChannel).transferTo(position, maxCount, (WritableByteChannel)((Object)outChannel))) {
                                        }
                                        ((FileChannel)outChannel).force(true);
                                        log.info((Object)("Skopiowano plik z " + fTempFile.getAbsolutePath() + " do " + fTempOutFile.getAbsolutePath()));
                                    }
                                    catch (IOException e) {
                                        bCopySucc = false;
                                        mResult.put(fRawFile.getAbsolutePath(), nERR_WHILE_COPY);
                                        if (this.bShowErr) {
                                            this.oTrayIcon.displayMessage(sErrMessageCopyTitle, sErrMessageCopyPrefix + fRawFile.getAbsolutePath() + sErrMessageCopySufix, TrayIcon.MessageType.ERROR);
                                        }
                                        log.error((Object)("*** " + sErrMessageCopyTitle + " *** " + sErrMessageCopyPrefix + fRawFile.getAbsolutePath() + sErrMessageCopySufix));
                                    }
                                    finally {
                                        try {
                                            if (inChannel != null) {
                                                inChannel.close();
                                            }
                                            if (outChannel != null) {
                                                outChannel.close();
                                            }
                                        }
                                        catch (IOException e) {
                                            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                        }
                                    }
                                }
                                if (!this.bDeleteRawFiles || !bCopySucc) continue;
                                if (!fRawFile.delete()) {
                                    int nCount = 1;
                                    boolean bSucceed = false;
                                    while (nCount <= this.nReDel && !bSucceed) {
                                        try {
                                            Thread.sleep(nCount * 100);
                                        }
                                        catch (InterruptedException e) {
                                            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                        }
                                        ++nCount;
                                        try {
                                            Files.delete(fRawFile.toPath());
                                            bSucceed = true;
                                        }
                                        catch (Exception e) {
                                            log.warn((Object)("Failed to delete file " + String.valueOf(fRawFile)), (Throwable)e);
                                        }
                                    }
                                    if (!bSucceed) {
                                        mResult.put(fRawFile.getAbsolutePath(), nERR_WHILE_DELETE);
                                        if (this.bShowErr) {
                                            this.oTrayIcon.displayMessage(sErrMessageDeleteTitle, sErrMessageDeletePrefix + fRawFile.getAbsolutePath() + sErrMessageDeleteSufix, TrayIcon.MessageType.ERROR);
                                        }
                                        log.error((Object)("*** " + sErrMessageDeleteTitle + " *** " + sErrMessageDeletePrefix + fRawFile.getAbsolutePath() + sErrMessageDeleteSufix));
                                    }
                                }
                                log.info((Object)("Udane usuwanie pliku: " + fRawFile.getAbsolutePath()));
                                continue;
                            }
                            if (nAddFileResult == -2) {
                                log.info((Object)"Plik niedopasowany, pozostawiony na miejscu");
                                bLeaveXML = true;
                                continue;
                            }
                            bOneError = true;
                            if (this.bShowErr) {
                                this.oTrayIcon.displayMessage(sErrMessageAddFileTitle, sErrMessageAddFilePrefix + fRawFile.getAbsolutePath() + sErrMessageAddFileSufix, TrayIcon.MessageType.ERROR);
                            }
                            log.error((Object)("*** " + sErrMessageAddFileTitle + " *** " + sErrMessageAddFilePrefix + fRawFile.getAbsolutePath() + sErrMessageAddFileSufix));
                            if (this.sRawFileOnError.equalsIgnoreCase("Copy") || this.sRawFileOnError.equalsIgnoreCase("Move")) {
                                if (fRawFile.exists()) {
                                    try {
                                        File fDir3;
                                        FileChannel source = null;
                                        FileChannel destination = null;
                                        Object sDir = this.sRawFileErrorDirectory;
                                        sDir = ((String)sDir).replace("\\", "/");
                                        if (!((String)sDir).endsWith("/")) {
                                            sDir = (String)sDir + "/";
                                        }
                                        if (!(fDir3 = new File((String)sDir)).exists()) {
                                            fDir3.mkdirs();
                                        }
                                        String sDestFile = (String)sDir + fRawFile.getName();
                                        File fDest = new File(sDestFile);
                                        boolean shouldCopy = true;
                                        if (fDest.exists()) {
                                            Object sTempDestFile = sDestFile;
                                            Integer nIndexOfDot = 0;
                                            while (((String)sTempDestFile).contains(".")) {
                                                nIndexOfDot = nIndexOfDot + (((String)sTempDestFile).indexOf(".") + 1);
                                                sTempDestFile = ((String)sTempDestFile).substring(((String)sTempDestFile).indexOf(".") + 1);
                                            }
                                            sTempDestFile = sDestFile.substring(0, nIndexOfDot - 1);
                                            int nFileInd = 0;
                                            String sExt = sDestFile.substring(nIndexOfDot - 1);
                                            do {
                                                if (!FileUtils.contentEquals((File)fRawFile, (File)fDest)) continue;
                                                log.info((Object)("Raw file " + String.valueOf(fRawFile) + " exists and is identical to source. Skipping save."));
                                                shouldCopy = false;
                                                break;
                                            } while ((fDest = new File(sDestFile = (String)sTempDestFile + "_" + ++nFileInd + sExt)).exists());
                                        }
                                        if (shouldCopy) {
                                            FileInputStream fileInputStream = new FileInputStream(fRawFile);
                                            source = fileInputStream.getChannel();
                                            destination = new FileOutputStream(fDest).getChannel();
                                            destination.transferFrom(source, 0L, source.size());
                                            log.error((Object)("Skopiowano plik: " + fRawFile.getAbsolutePath() + " do: " + sDestFile));
                                            destination.force(true);
                                            destination.close();
                                            source.close();
                                        }
                                    }
                                    catch (Exception e) {
                                        log.error((Object)"Blad przy kopiowaniu pliku", (Throwable)e);
                                    }
                                } else {
                                    log.error((Object)("Blad przy kopiowaniu pliku. Plik " + fRawFile.getAbsolutePath() + " nie istnieje!"));
                                }
                            }
                            if (!this.sRawFileOnError.equalsIgnoreCase("Move") && !this.sRawFileOnError.equalsIgnoreCase("Delete") || !fRawFile.exists()) continue;
                            boolean bSucceed = true;
                            if (!fRawFile.delete()) {
                                bSucceed = false;
                                for (int nCount = 1; nCount <= this.nReDel && !bSucceed; ++nCount) {
                                    try {
                                        Thread.sleep(nCount * 100);
                                        continue;
                                    }
                                    catch (InterruptedException e) {
                                        log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                    }
                                    if (!fRawFile.delete()) continue;
                                    bSucceed = true;
                                }
                            }
                            if (!bSucceed) {
                                log.error((Object)("Nieudane usuwanie pliku " + sRawFile));
                                continue;
                            }
                            log.info((Object)("Usunieto plik: " + sRawFile));
                        }
                        if (this.sFileType.compareToIgnoreCase("XML") != 0) continue;
                        if (bLeaveXML) {
                            log.info((Object)"Niepasujacy indeks - pominiecie pliku xml");
                            continue;
                        }
                        if (bOneError) {
                            if (this.sXMLFileOnError.equalsIgnoreCase("Copy") || this.sXMLFileOnError.equalsIgnoreCase("Move")) {
                                if (fTempFile.exists()) {
                                    File fDir4;
                                    FileChannel source = null;
                                    FileChannel destination = null;
                                    Object sDir = this.sXMLFileErrorDirectory;
                                    if (!((String)(sDir = ((String)sDir).replace("\\", "/"))).endsWith("/")) {
                                        sDir = (String)sDir + "/";
                                    }
                                    if (!(fDir4 = new File((String)sDir)).exists()) {
                                        fDir4.mkdirs();
                                    }
                                    String sDestFile = (String)sDir + fTempFile.getName();
                                    File fDest = new File(sDestFile);
                                    boolean shouldCopy = true;
                                    if (fDest.exists()) {
                                        Object sTempDestFile = sDestFile;
                                        Integer nIndexOfDot = 0;
                                        while (((String)sTempDestFile).contains(".")) {
                                            nIndexOfDot = nIndexOfDot + (((String)sTempDestFile).indexOf(".") + 1);
                                            sTempDestFile = ((String)sTempDestFile).substring(((String)sTempDestFile).indexOf(".") + 1);
                                        }
                                        sTempDestFile = sDestFile.substring(0, nIndexOfDot - 1);
                                        int nFileInd = 0;
                                        String sExt = sDestFile.substring(nIndexOfDot - 1);
                                        do {
                                            if (!FileUtils.contentEquals((File)fTempFile, (File)fDest)) continue;
                                            log.info((Object)("Xml file " + String.valueOf(fTempFile) + " exists and is identical to source. Skipping save."));
                                            shouldCopy = false;
                                            break;
                                        } while ((fDest = new File(sDestFile = (String)sTempDestFile + "_" + ++nFileInd + sExt)).exists());
                                    }
                                    if (shouldCopy) {
                                        FileInputStream fileInputStream = new FileInputStream(fTempFile);
                                        source = fileInputStream.getChannel();
                                        destination = new FileOutputStream(fDest).getChannel();
                                        destination.transferFrom(source, 0L, source.size());
                                        log.error((Object)("Skopiowano plik: " + fTempFile.getAbsolutePath() + " do: " + sDestFile));
                                        destination.force(true);
                                        destination.close();
                                        source.close();
                                    }
                                } else {
                                    log.error((Object)("Blad przy kopiowaniu pliku. Plik " + fTempFile.getAbsolutePath() + " nie istnieje!"));
                                }
                            }
                            if (!this.sXMLFileOnError.equalsIgnoreCase("Move") && !this.sXMLFileOnError.equalsIgnoreCase("Delete") || !fTempFile.exists()) continue;
                            String sXMLFile = fTempFile.getAbsolutePath();
                            fTempFile.delete();
                            log.info((Object)("Usunieto plik: " + sXMLFile));
                            continue;
                        }
                        boolean bCopySucc = true;
                        boolean bSucceed = true;
                        if (this.bCopyXMLFiles && sXMLDestination != null) {
                            AbstractInterruptibleChannel inChannel = null;
                            AbstractInterruptibleChannel outChannel = null;
                            try {
                                File fTempOutFile = new File(sXMLDestination + File.separator + fTempFile.getName());
                                inChannel = new FileInputStream(fTempFile).getChannel();
                                outChannel = new FileOutputStream(fTempOutFile).getChannel();
                                int maxCount = 67076096;
                                long size = ((FileChannel)inChannel).size();
                                for (long position = 0L; position < size; position += ((FileChannel)inChannel).transferTo(position, maxCount, (WritableByteChannel)((Object)outChannel))) {
                                }
                                ((FileChannel)outChannel).force(true);
                                log.info((Object)("Skopiowano plik z " + fTempFile.getAbsolutePath() + " do " + fTempOutFile.getAbsolutePath()));
                            }
                            catch (IOException e) {
                                bCopySucc = false;
                                mResult.put(fTempFile.getAbsolutePath(), nERR_WHILE_COPY);
                                if (this.bShowErr) {
                                    this.oTrayIcon.displayMessage(sErrMessageCopyTitle, sErrMessageCopyPrefix + fTempFile.getAbsolutePath() + sErrMessageCopySufix, TrayIcon.MessageType.ERROR);
                                }
                                log.error((Object)("*** " + sErrMessageCopyTitle + " *** " + sErrMessageCopyPrefix + fTempFile.getAbsolutePath() + sErrMessageCopySufix));
                            }
                            finally {
                                try {
                                    if (inChannel != null) {
                                        inChannel.close();
                                    }
                                    if (outChannel != null) {
                                        outChannel.close();
                                    }
                                }
                                catch (IOException e) {
                                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                }
                            }
                        }
                        if (!this.bDeleteXMLFiles || !bCopySucc) continue;
                        if (!fTempFile.delete()) {
                            bSucceed = false;
                            for (int nCount = 1; nCount <= this.nReDel && !bSucceed; ++nCount) {
                                log.warn((Object)("Nieudane usuwanie pliku: " + fTempFile.getAbsolutePath() + " - proba: " + nCount));
                                try {
                                    Thread.sleep(nCount * 100);
                                    continue;
                                }
                                catch (InterruptedException e) {
                                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                }
                                if (!fTempFile.delete()) continue;
                                bSucceed = true;
                            }
                            if (!bSucceed) {
                                mResult.put(fTempFile.getAbsolutePath(), nERR_WHILE_DELETE);
                                if (this.bShowErr) {
                                    this.oTrayIcon.displayMessage(sErrMessageDeleteTitle, sErrMessageDeletePrefix + fTempFile.getAbsolutePath() + sErrMessageDeleteSufix, TrayIcon.MessageType.ERROR);
                                }
                                log.error((Object)("*** " + sErrMessageDeleteTitle + " *** " + sErrMessageDeletePrefix + fTempFile.getAbsolutePath() + sErrMessageDeleteSufix));
                            }
                        }
                        log.info((Object)("Udane usuwanie pliku: " + fTempFile.getAbsolutePath()));
                        continue;
                    }
                    if (!fTempFile.isDirectory() || !this.bSearchSubDirectory) continue;
                    if (this.bCopyRawFiles && !(fDir2 = new File(sRawDestination + File.separator + fTempFile.getName())).exists() && !fDir2.mkdir()) {
                        mResult.put(fDir2.getAbsoluteFile(), nERR_WHILE_MKDIR);
                        if (this.bShowErr) {
                            this.oTrayIcon.displayMessage(sErrMessageMkDirTitle, sErrMessageMkDirPrefix + fTempFile.getAbsolutePath() + sErrMessageMkDirSufix, TrayIcon.MessageType.ERROR);
                            log.error((Object)("*** " + sErrMessageMkDirTitle + " *** " + sErrMessageMkDirPrefix + fTempFile.getAbsolutePath() + sErrMessageMkDirSufix));
                        }
                    }
                    if (this.bCopyXMLFiles && !(fDir = new File(sXMLDestination + File.separator + fTempFile.getName())).exists() && !fDir.mkdir()) {
                        mResult.put(fDir.getAbsoluteFile(), nERR_WHILE_MKDIR);
                        if (this.bShowErr) {
                            this.oTrayIcon.displayMessage(sErrMessageMkDirTitle, sErrMessageMkDirPrefix + fTempFile.getAbsolutePath() + sErrMessageMkDirSufix, TrayIcon.MessageType.ERROR);
                            log.info((Object)("*** " + sErrMessageMkDirTitle + " *** " + sErrMessageMkDirPrefix + fTempFile.getAbsolutePath() + sErrMessageMkDirSufix));
                        }
                    }
                    mResult = this.ProcessDirectory(fTempFile, mResult, sRawDestination + File.separator + fTempFile.getName(), sXMLDestination + File.separator + fTempFile.getName());
                }
            }
            catch (Exception e) {
                try {
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (Exception e1) {
                    log.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
                }
            }
        }
        return mResult;
    }

    public Map ProcessDirectory() {
        log.info((Object)("Processing ShareID: " + this.sShareId));
        Map<File, Integer> mResult = null;
        try {
            String sXMLDest;
            File fRawDestFile;
            mResult = new LinkedHashMap<File, Integer>();
            File fFile = new File(this.sSharePath);
            String sRawDest = this.sRawFileDestinationPath;
            if (this.bCopyRawFiles && !(fRawDestFile = new File(sRawDest)).exists() && !fRawDestFile.mkdirs()) {
                mResult.put(fRawDestFile.getAbsoluteFile(), nERR_WHILE_MKDIR);
                if (this.bShowErr) {
                    this.oTrayIcon.displayMessage(sErrMessageMkDirTitle, sErrMessageMkDirPrefix + fRawDestFile.getAbsolutePath() + sErrMessageMkDirSufix, TrayIcon.MessageType.ERROR);
                }
                log.error((Object)("*** " + sErrMessageMkDirTitle + " *** " + sErrMessageMkDirPrefix + fRawDestFile.getAbsolutePath() + sErrMessageMkDirSufix));
                sRawDest = null;
            }
            if ((sXMLDest = this.sXMLFileDestinationPath) != null) {
                File fXMLDestFile = new File(sXMLDest);
                if (this.bCopyXMLFiles && !fXMLDestFile.exists() && !fXMLDestFile.mkdirs()) {
                    mResult.put(fXMLDestFile.getAbsoluteFile(), nERR_WHILE_MKDIR);
                    if (this.bShowErr) {
                        this.oTrayIcon.displayMessage(sErrMessageMkDirTitle, sErrMessageMkDirPrefix + fXMLDestFile.getAbsolutePath() + sErrMessageMkDirSufix, TrayIcon.MessageType.ERROR);
                    }
                    log.error((Object)("*** " + sErrMessageMkDirTitle + " *** " + sErrMessageMkDirPrefix + fXMLDestFile.getAbsolutePath() + sErrMessageMkDirSufix));
                    sXMLDest = null;
                }
            }
            mResult = this.ProcessDirectory(fFile, mResult, sRawDest, sXMLDest);
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return mResult;
    }

    @Override
    public void run() {
        this.ProcessDirectory();
    }

    public static void sortFilesByDateCreated(File[] files, final String sortDirecion) {
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                long l1 = DirectoryShare.getFileCreationEpoch(f1);
                long l2 = DirectoryShare.getFileCreationEpoch(f2);
                if (sortDirecion.equals("asc")) {
                    return Long.valueOf(l1).compareTo(l2);
                }
                return Long.valueOf(l2).compareTo(l1);
            }
        });
    }

    public static long getFileCreationEpoch(File file) {
        try {
            BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return attr.creationTime().toInstant().toEpochMilli();
        }
        catch (IOException e) {
            throw new RuntimeException(file.getAbsolutePath(), e);
        }
    }
}

