package com.suncode.plugin.wrapper;

import com.plusmpm.directorymonitor.document.DocumentUploadListenerRegistry;
import org.springframework.beans.factory.annotation.Autowired;

import com.plusmpm.directorymonitor.DirectoryMonitor;
import com.plusmpm.ini.PCMConfigSource;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Types;

@ScheduledTask
public class DirectoryMonitorPCMTask
{
    
    @Autowired
    private ConfigurationFileService configFileService;

    @Autowired
    private DocumentUploadListenerRegistry documentUploadListenerRegistry;
    
    @Define
    public void definition( ScheduledTaskDefinitionBuilder builder )
    {
        // @formatter:off
        builder
            .id( "plus.directory.monitor.taskpcm" )
            .name( "plus.directory.monitor.taskpcm.name" )
            .description( "plus.directory.monitor.taskpcm.desc" )
            .parameter()
                .id( "plus.directory.monitor.fileId.param" )
                .name( "plus.directory.monitor.fileId.param.name" )
                .description( "plus.directory.monitor.fileId.param.desc" )
                .type( Types.STRING )
                .create()
            .parameter()
                .id( "plus.directory.monitor.showTray.param" )
                .name( "plus.directory.monitor.showTray.param.name" )
                .description( "plus.directory.monitor.showTray.param.desc" )
                .type( Types.BOOLEAN )
                .create();
            
        // @formatter:on
    }

    public void execute( @Param( value = "plus.directory.monitor.fileId.param" ) String fileId,
                         @Param( value = "plus.directory.monitor.showTray.param" ) Boolean showTray )
    {
        DirectoryMonitorPluginContext pluginContext = new DirectoryMonitorPluginContext(
            documentUploadListenerRegistry
        );

        DirectoryMonitor monitor = new DirectoryMonitor( false, pluginContext );
        monitor.startup( new PCMConfigSource(configFileService, fileId), showTray );
    }
}
